﻿using Firebase;
using UnityEngine;

public class Test : MonoBehaviour
{
	private int updatesBeforeException;
	private bool ready = false;

	// Start is called before the first frame update
	private void Start()
	{
		Firebase.FirebaseApp.LogLevel = LogLevel.Verbose;
		Firebase.FirebaseApp.CheckAndFixDependenciesAsync().ContinueWith(task => {
			var dependencyStatus = task.Result;
			if (dependencyStatus == Firebase.DependencyStatus.Available) {
				// Create and hold a reference to your FirebaseApp,
				// where app is a Firebase.FirebaseApp property of your application class.
				var app = Firebase.FirebaseApp.DefaultInstance;
				this.ready = true;
				// Set a flag here to indicate whether Firebase is ready to use by your app.
			} else {
				Debug.LogError($"Could not resolve all Firebase dependencies: {dependencyStatus}");
				// Firebase Unity SDK is not safe to use here.
			}
		});

		this.updatesBeforeException = 0;
	}

	// Update is called once per frame
	private void Update()
	{
		if (this.ready == false) {
			return;
		}

		if (this.updatesBeforeException > 0) {
			this.updatesBeforeException--;
		} else {
			// Set the counter to 60 updates
			this.updatesBeforeException = 60;

			// Throw an exception to test your Crashlytics implementation
			throw new System.Exception("test exception please ignore");
		}
	}
}