# 1 "<built-in>"
# 1 "../../sdk/lib/ld/test/filter-view-tests.cc"
// Copyright 2023 The Fuchsia Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__CLANG_REWRITTEN_INCLUDES) /* link-map-list.h expanded by -frewrite-includes */
#include <lib/elfldltl/link-map-list.h>
#else /* link-map-list.h expanded by -frewrite-includes */
# 5 "../../sdk/lib/ld/test/filter-view-tests.cc"
# 1 "../../src/lib/elfldltl/include/lib/elfldltl/link-map-list.h" 1
// Copyright 2023 The Fuchsia Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SRC_LIB_ELFLDLTL_INCLUDE_LIB_ELFLDLTL_LINK_MAP_LIST_H_
#define SRC_LIB_ELFLDLTL_INCLUDE_LIB_ELFLDLTL_LINK_MAP_LIST_H_

#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* iterator expanded by -frewrite-includes */
#include <iterator>
#else /* iterator expanded by -frewrite-includes */
# 8 "../../src/lib/elfldltl/include/lib/elfldltl/link-map-list.h"
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/iterator" 1 3
// -*- C++ -*-
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP_ITERATOR
#define _LIBCPP_ITERATOR

/*
    iterator synopsis

#include <concepts>

namespace std
{
template<class> struct incrementable_traits;       // since C++20
template<class T>
  using iter_difference_t = see below;             // since C++20

template<class> struct indirectly_readable_traits; // since C++20
template<class T>
  using iter_value_t = see below;                  // since C++20

template<class Iterator>
struct iterator_traits;

template<class T>
  requires is_object_v<T>                    // since C++20
struct iterator_traits<T*>;

template<dereferenceable T>
  using iter_reference_t = decltype(*declval<T&>());

namespace ranges::inline unspecified {
    inline constexpr unspecified iter_move = unspecified; // since C++20, nodiscard as an extension
}}

template<dereferenceable T>
  requires ...
using iter_rvalue_reference_t = decltype(ranges::iter_move(declval<T&>())); // since C++20

// [iterator.concepts], iterator concepts
// [iterator.concept.readable], concept indirectly_readable
template<class In>
  concept indirectly_readable = see below;                      // since C++20

template<indirectly_readable T>
  using iter_common_reference_t =
    common_reference_t<iter_reference_t<T>, iter_value_t<T>&>;  // since C++20

// [iterator.concept.writable], concept indirectly_writable
template<class Out, class T>
  concept indirectly_writable = see below;                // since C++20

// [iterator.concept.winc], concept weakly_incrementable
template<class I>
  concept weakly_incrementable = see below;                // since C++20

// [iterator.concept.inc], concept incrementable
template<class I>
  concept incrementable = see below;                       // since C++20

// [iterator.concept.iterator], concept input_or_output_iterator
  template<class I>
    concept input_or_output_iterator = see below;          // since C++20

// [iterator.concept.sentinel], concept sentinel_for
template<class S, class I>
  concept sentinel_for = see below;                        // since C++20

// [iterator.concept.sizedsentinel], concept sized_sentinel_for
template<class S, class I>
  inline constexpr bool disable_sized_sentinel_for = false;

template<class S, class I>
  concept sized_sentinel_for = see below;

// [iterator.concept.input], concept input_iterator
template<class I>
  concept input_iterator = see below;                      // since C++20

// [iterator.concept.output], concept output_iterator
template<class I, class T>
  concept output_iterator = see below;                     // since C++20

// [iterator.concept.forward], concept forward_iterator
template<class I>
  concept forward_iterator = see below;                    // since C++20

// [iterator.concept.bidir], concept bidirectional_iterator
template<class I>
  concept bidirectional_iterator = see below;              // since C++20

// [iterator.concept.random.access], concept random_access_iterator
template<class I>
  concept random_access_iterator = see below;              // since C++20

// [indirectcallable]
// [indirectcallable.indirectinvocable]
template<class F, class I>
  concept indirectly_unary_invocable = see below;          // since C++20

template<class F, class I>
  concept indirectly_regular_unary_invocable = see below;  // since C++20

template<class F, class I>
  concept indirect_unary_predicate = see below;            // since C++20

template<class F, class I1, class I2>
  concept indirect_binary_predicate = see below;           // since C++20

template<class F, class I1, class I2 = I1>
  concept indirect_equivalence_relation = see below;       // since C++20

template<class F, class I1, class I2 = I1>
  concept indirect_strict_weak_order = see below;          // since C++20

template<class F, class... Is>
  using indirect_result_t = see below;                     // since C++20

// [projected], projected
template<indirectly_readable I, indirectly_regular_unary_invocable<I> Proj>
  struct projected;                                        // since C++20

template<weakly_incrementable I, indirectly_regular_unary_invocable<I> Proj>
  struct incrementable_traits<projected<I, Proj>>;         // since C++20

// [alg.req.ind.move], concept indirectly_movable
template<class In, class Out>
  concept indirectly_movable = see below;                  // since C++20

template<class In, class Out>
  concept indirectly_movable_storable = see below;         // since C++20

// [alg.req.ind.copy], concept indirectly_copyable
template<class In, class Out>
  concept indirectly_copyable = see below;                 // since C++20

template<class In, class Out>
  concept indirectly_copyable_storable = see below;        // since C++20

// [alg.req.ind.swap], concept indirectly_swappable
template<class I1, class I2 = I1>
  concept indirectly_swappable = see below;                // since C++20

template<class I1, class I2, class R, class P1 = identity,
         class P2 = identity>
  concept indirectly_comparable =
    indirect_binary_predicate<R, projected<I1, P1>, projected<I2, P2>>; // since C++20

// [alg.req.permutable], concept permutable
template<class I>
  concept permutable = see below;                          // since C++20

 // [alg.req.mergeable], concept mergeable
template<class I1, class I2, class Out,
    class R = ranges::less, class P1 = identity, class P2 = identity>
  concept mergeable = see below;                           // since C++20

// [alg.req.sortable], concept sortable
template<class I, class R = ranges::less, class P = identity>
  concept sortable = see below;                            // since C++20

template<input_or_output_iterator I, sentinel_for<I> S>
  requires (!same_as<I, S> && copyable<I>)
class common_iterator;                                     // since C++20

template<class Category, class T, class Distance = ptrdiff_t,
         class Pointer = T*, class Reference = T&>
struct iterator                                            // deprecated in C++17
{
    typedef T         value_type;
    typedef Distance  difference_type;
    typedef Pointer   pointer;
    typedef Reference reference;
    typedef Category  iterator_category;
};

struct input_iterator_tag  {};
struct output_iterator_tag {};
struct forward_iterator_tag       : public input_iterator_tag         {};
struct bidirectional_iterator_tag : public forward_iterator_tag       {};
struct random_access_iterator_tag : public bidirectional_iterator_tag {};
struct contiguous_iterator_tag    : public random_access_iterator_tag {};

// 27.4.3, iterator operations
template <class InputIterator, class Distance>  // constexpr in C++17
  constexpr void advance(InputIterator& i, Distance n);

template <class InputIterator>  // constexpr in C++17
  constexpr typename iterator_traits<InputIterator>::difference_type
    distance(InputIterator first, InputIterator last);

template <class InputIterator>  // constexpr in C++17
  constexpr InputIterator next(InputIterator x,
typename iterator_traits<InputIterator>::difference_type n = 1);

template <class BidirectionalIterator>  // constexpr in C++17
  constexpr BidirectionalIterator prev(BidirectionalIterator x,
    typename iterator_traits<BidirectionalIterator>::difference_type n = 1);

// [range.iter.ops], range iterator operations
namespace ranges {
  // [range.iter.op.advance], ranges::advance
  template<input_or_output_iterator I>
    constexpr void advance(I& i, iter_difference_t<I> n);                          // since C++20
  template<input_or_output_iterator I, sentinel_for<I> S>
    constexpr void advance(I& i, S bound);                                         // since C++20
  template<input_or_output_iterator I, sentinel_for<I> S>
    constexpr iter_difference_t<I> advance(I& i, iter_difference_t<I> n, S bound); // since C++20
}

template <class Iterator>
class reverse_iterator
    : public iterator<typename iterator_traits<Iterator>::iterator_category, // until C++17
                      typename iterator_traits<Iterator>::value_type,
                      typename iterator_traits<Iterator>::difference_type,
                      typename iterator_traits<Iterator>::pointer,
                      typename iterator_traits<Iterator>::reference>
{
protected:
    Iterator current;
public:
    using iterator_type     = Iterator;
    using iterator_concept  = see below; // since C++20
    using iterator_category = typename iterator_traits<Iterator>::iterator_category; // since C++17, until C++20
    using iterator_category = see below; // since C++20
    using value_type        = typename iterator_traits<Iterator>::value_type; // since C++17, until C++20
    using value_type        = iter_value_t<Iterator>; // since C++20
    using difference_type   = typename iterator_traits<Iterator>::difference_type; // until C++20
    using difference_type   = iter_difference_t<Iterator>; // since C++20
    using pointer           = typename iterator_traits<Iterator>::pointer;
    using reference         = typename iterator_traits<Iterator>::reference; // until C++20
    using reference         = iter_reference_t<Iterator>; // since C++20

    constexpr reverse_iterator();
    constexpr explicit reverse_iterator(Iterator x);
    template <class U> constexpr reverse_iterator(const reverse_iterator<U>& u);
    template <class U> constexpr reverse_iterator& operator=(const reverse_iterator<U>& u);
    constexpr Iterator base() const;
    constexpr reference operator*() const;
    constexpr pointer   operator->() const; // until C++20
    constexpr pointer   operator->() const requires see below; // since C++20
    constexpr reverse_iterator& operator++();
    constexpr reverse_iterator  operator++(int);
    constexpr reverse_iterator& operator--();
    constexpr reverse_iterator  operator--(int);
    constexpr reverse_iterator  operator+ (difference_type n) const;
    constexpr reverse_iterator& operator+=(difference_type n);
    constexpr reverse_iterator  operator- (difference_type n) const;
    constexpr reverse_iterator& operator-=(difference_type n);
    constexpr unspecified       operator[](difference_type n) const;

    friend constexpr iter_rvalue_reference_t<Iterator>
      iter_move(const reverse_iterator& i) noexcept(see below);
    template<indirectly_swappable<Iterator> Iterator2>
      friend constexpr void
        iter_swap(const reverse_iterator& x,
                  const reverse_iterator<Iterator2>& y) noexcept(see below);
};

template <class Iterator1, class Iterator2>
constexpr bool                          // constexpr in C++17
operator==(const reverse_iterator<Iterator1>& x, const reverse_iterator<Iterator2>& y);

template <class Iterator1, class Iterator2>
constexpr bool                          // constexpr in C++17
operator!=(const reverse_iterator<Iterator1>& x, const reverse_iterator<Iterator2>& y);

template <class Iterator1, class Iterator2>
constexpr bool                          // constexpr in C++17
operator<(const reverse_iterator<Iterator1>& x, const reverse_iterator<Iterator2>& y);

template <class Iterator1, class Iterator2>
constexpr bool                          // constexpr in C++17
operator>(const reverse_iterator<Iterator1>& x, const reverse_iterator<Iterator2>& y);

template <class Iterator1, class Iterator2>
constexpr bool                          // constexpr in C++17
operator<=(const reverse_iterator<Iterator1>& x, const reverse_iterator<Iterator2>& y);

template <class Iterator1, class Iterator2>
constexpr bool                          // constexpr in C++17
operator>=(const reverse_iterator<Iterator1>& x, const reverse_iterator<Iterator2>& y);

template<class Iterator1, three_way_comparable_with<Iterator1> Iterator2>
  constexpr compare_three_way_result_t<Iterator1, Iterator2>
    operator<=>(const reverse_iterator<Iterator1>& x,
                const reverse_iterator<Iterator2>& y);

template <class Iterator1, class Iterator2>
constexpr auto
operator-(const reverse_iterator<Iterator1>& x, const reverse_iterator<Iterator2>& y)
-> decltype(__y.base() - __x.base());   // constexpr in C++17

template <class Iterator>
constexpr reverse_iterator<Iterator>
operator+(typename reverse_iterator<Iterator>::difference_type n,
          const reverse_iterator<Iterator>& x);   // constexpr in C++17

template <class Iterator>
constexpr reverse_iterator<Iterator> make_reverse_iterator(Iterator i); // C++14, constexpr in C++17

template<class Iterator1, class Iterator2>
    requires (!sized_sentinel_for<Iterator1, Iterator2>)
  inline constexpr bool disable_sized_sentinel_for<reverse_iterator<Iterator1>,
                                                   reverse_iterator<Iterator2>> = true;

template <class Container>
class back_insert_iterator
    : public iterator<output_iterator_tag, void, void, void, void> // until C++17
{
protected:
    Container* container;
public:
    typedef Container                   container_type;
    typedef void                        value_type;
    typedef void                        difference_type; // until C++20
    typedef ptrdiff_t                   difference_type; // since C++20
    typedef void                        reference;
    typedef void                        pointer;

    explicit back_insert_iterator(Container& x);  // constexpr in C++20
    back_insert_iterator& operator=(const typename Container::value_type& value);  // constexpr in C++20
    back_insert_iterator& operator*();  // constexpr in C++20
    back_insert_iterator& operator++();  // constexpr in C++20
    back_insert_iterator  operator++(int);  // constexpr in C++20
};

template <class Container> back_insert_iterator<Container> back_inserter(Container& x);  // constexpr in C++20

template <class Container>
class front_insert_iterator
    : public iterator<output_iterator_tag, void, void, void, void> // until C++17
{
protected:
    Container* container;
public:
    typedef Container                    container_type;
    typedef void                         value_type;
    typedef void                         difference_type; // until C++20
    typedef ptrdiff_t                    difference_type; // since C++20
    typedef void                         reference;
    typedef void                         pointer;

    explicit front_insert_iterator(Container& x);  // constexpr in C++20
    front_insert_iterator& operator=(const typename Container::value_type& value);  // constexpr in C++20
    front_insert_iterator& operator*();  // constexpr in C++20
    front_insert_iterator& operator++();  // constexpr in C++20
    front_insert_iterator  operator++(int);  // constexpr in C++20
};

template <class Container> front_insert_iterator<Container> front_inserter(Container& x);  // constexpr in C++20

template <class Container>
class insert_iterator
    : public iterator<output_iterator_tag, void, void, void, void> // until C++17
{
protected:
    Container* container;
    typename Container::iterator iter;
public:
    typedef Container              container_type;
    typedef void                   value_type;
    typedef void                   difference_type; // until C++20
    typedef ptrdiff_t              difference_type; // since C++20
    typedef void                   reference;
    typedef void                   pointer;

    insert_iterator(Container& x, typename Container::iterator i);  // constexpr in C++20
    insert_iterator& operator=(const typename Container::value_type& value);  // constexpr in C++20
    insert_iterator& operator*();  // constexpr in C++20
    insert_iterator& operator++();  // constexpr in C++20
    insert_iterator& operator++(int);  // constexpr in C++20
};

template <class Container>
insert_iterator<Container> inserter(Container& x, typename Container::iterator i);  // until C++20
template <class Container>
constexpr insert_iterator<Container> inserter(Container& x, ranges::iterator_t<Container> i);  // since C++20

template <class Iterator>
class move_iterator {
public:
    using iterator_type     = Iterator;
    using iterator_concept  = see below; // From C++20
    using iterator_category = see below; // not always present starting from C++20
    using value_type        = iter_value_t<Iterator>; // Until C++20, iterator_traits<Iterator>::value_type
    using difference_type   = iter_difference_t<Iterator>; // Until C++20, iterator_traits<Iterator>::difference_type;
    using pointer           = Iterator;
    using reference         = iter_rvalue_reference_t<Iterator>; // Until C++20, value_type&&

    constexpr move_iterator();  // all the constexprs are in C++17
    constexpr explicit move_iterator(Iterator i);
    template <class U>
      constexpr move_iterator(const move_iterator<U>& u);
    template <class U>
      constexpr move_iterator& operator=(const move_iterator<U>& u);

    constexpr iterator_type base() const; // Until C++20
    constexpr const Iterator& base() const & noexcept; // From C++20
    constexpr Iterator base() &&; // From C++20

    constexpr reference operator*() const;
    constexpr pointer operator->() const; // Deprecated in C++20
    constexpr move_iterator& operator++();
    constexpr auto operator++(int); // Return type was move_iterator until C++20
    constexpr move_iterator& operator--();
    constexpr move_iterator operator--(int);
    constexpr move_iterator operator+(difference_type n) const;
    constexpr move_iterator& operator+=(difference_type n);
    constexpr move_iterator operator-(difference_type n) const;
    constexpr move_iterator& operator-=(difference_type n);
    constexpr reference operator[](difference_type n) const; // Return type unspecified until C++20

    template<sentinel_for<Iterator> S>
      friend constexpr bool
        operator==(const move_iterator& x, const move_sentinel<S>& y); // Since C++20
    template<sized_sentinel_for<Iterator> S>
      friend constexpr iter_difference_t<Iterator>
        operator-(const move_sentinel<S>& x, const move_iterator& y); // Since C++20
    template<sized_sentinel_for<Iterator> S>
      friend constexpr iter_difference_t<Iterator>
        operator-(const move_iterator& x, const move_sentinel<S>& y); // Since C++20
    friend constexpr iter_rvalue_reference_t<Iterator>
      iter_move(const move_iterator& i)
        noexcept(noexcept(ranges::iter_move(i.current))); // Since C++20
    template<indirectly_swappable<Iterator> Iterator2>
      friend constexpr void
        iter_swap(const move_iterator& x, const move_iterator<Iterator2>& y)
          noexcept(noexcept(ranges::iter_swap(x.current, y.current))); // Since C++20

private:
    Iterator current; // exposition only
};

template <class Iterator1, class Iterator2>
constexpr bool   // constexpr in C++17
operator==(const move_iterator<Iterator1>& x, const move_iterator<Iterator2>& y);

template <class Iterator1, class Iterator2>
constexpr bool   // constexpr in C++17
operator!=(const move_iterator<Iterator1>& x, const move_iterator<Iterator2>& y);

template <class Iterator1, class Iterator2>
constexpr bool   // constexpr in C++17
operator<(const move_iterator<Iterator1>& x, const move_iterator<Iterator2>& y);

template <class Iterator1, class Iterator2>
constexpr bool   // constexpr in C++17
operator<=(const move_iterator<Iterator1>& x, const move_iterator<Iterator2>& y);

template <class Iterator1, class Iterator2>
constexpr bool   // constexpr in C++17
operator>(const move_iterator<Iterator1>& x, const move_iterator<Iterator2>& y);

template <class Iterator1, class Iterator2>
constexpr bool   // constexpr in C++17
operator>=(const move_iterator<Iterator1>& x, const move_iterator<Iterator2>& y);

template <class Iterator1, class Iterator2>
constexpr auto   // constexpr in C++17
operator-(const move_iterator<Iterator1>& x,
          const move_iterator<Iterator2>& y) -> decltype(x.base() - y.base());

template <class Iterator>
constexpr move_iterator<Iterator> operator+(   // constexpr in C++17
            typename move_iterator<Iterator>::difference_type n,
            const move_iterator<Iterator>& x);

template <class Iterator>   // constexpr in C++17
constexpr  move_iterator<Iterator> make_move_iterator(const Iterator& i);

template<semiregular S>
class move_sentinel {
public:
  constexpr move_sentinel();
  constexpr explicit move_sentinel(S s);
  template<class S2>
    requires convertible_to<const S2&, S>
      constexpr move_sentinel(const move_sentinel<S2>& s);
  template<class S2>
    requires assignable_from<S&, const S2&>
      constexpr move_sentinel& operator=(const move_sentinel<S2>& s);

  constexpr S base() const;
private:
  S last;     // exposition only
};

// [default.sentinel], default sentinel
struct default_sentinel_t;
inline constexpr default_sentinel_t default_sentinel{};

// [iterators.counted], counted iterators
template<input_or_output_iterator I> class counted_iterator;

template<input_iterator I>
  requires see below
  struct iterator_traits<counted_iterator<I>>;

// [unreachable.sentinel], unreachable sentinel
struct unreachable_sentinel_t;
inline constexpr unreachable_sentinel_t unreachable_sentinel{};

template <class T, class charT = char, class traits = char_traits<charT>, class Distance = ptrdiff_t>
class istream_iterator
    : public iterator<input_iterator_tag, T, Distance, const T*, const T&> // until C++17
{
public:
    typedef input_iterator_tag           iterator_category;
    typedef T                            value_type;
    typedef Distance                     difference_type;
    typedef const T*                     pointer;
    typedef const T&                     reference;

    typedef charT                        char_type;
    typedef traits                       traits_type;
    typedef basic_istream<charT, traits> istream_type;

    istream_iterator(); // constexpr since C++11
    constexpr istream_iterator(default_sentinel_t); // since C++20
    istream_iterator(istream_type& s);
    istream_iterator(const istream_iterator& x);
    ~istream_iterator();

    const T& operator*() const;
    const T* operator->() const;
    istream_iterator& operator++();
    istream_iterator  operator++(int);
    friend bool operator==(const istream_iterator& i, default_sentinel_t); // since C++20
};

template <class T, class charT, class traits, class Distance>
bool operator==(const istream_iterator<T,charT,traits,Distance>& x,
                const istream_iterator<T,charT,traits,Distance>& y);
template <class T, class charT, class traits, class Distance>
bool operator!=(const istream_iterator<T,charT,traits,Distance>& x,
                const istream_iterator<T,charT,traits,Distance>& y); // until C++20

template <class T, class charT = char, class traits = char_traits<charT> >
class ostream_iterator
    : public iterator<output_iterator_tag, void, void, void, void> // until C++17
{
public:
    typedef output_iterator_tag         iterator_category;
    typedef void                        value_type;
    typedef void                        difference_type; // until C++20
    typedef ptrdiff_t                   difference_type; // since C++20
    typedef void                        pointer;
    typedef void                        reference;

    typedef charT char_type;
    typedef traits traits_type;
    typedef basic_ostream<charT,traits> ostream_type;

    ostream_iterator(ostream_type& s);
    ostream_iterator(ostream_type& s, const charT* delimiter);
    ostream_iterator(const ostream_iterator& x);
    ~ostream_iterator();
    ostream_iterator& operator=(const T& value);

    ostream_iterator& operator*();
    ostream_iterator& operator++();
    ostream_iterator& operator++(int);
};

template<class charT, class traits = char_traits<charT> >
class istreambuf_iterator
    : public iterator<input_iterator_tag, charT, traits::off_type, unspecified, charT> // until C++17
{
public:
    typedef input_iterator_tag              iterator_category;
    typedef charT                           value_type;
    typedef traits::off_type                difference_type;
    typedef unspecified                     pointer;
    typedef charT                           reference;

    typedef charT                           char_type;
    typedef traits                          traits_type;
    typedef traits::int_type                int_type;
    typedef basic_streambuf<charT, traits>  streambuf_type;
    typedef basic_istream<charT, traits>    istream_type;

    istreambuf_iterator() noexcept; // constexpr since C++11
    constexpr istreambuf_iterator(default_sentinel_t) noexcept; // since C++20
    istreambuf_iterator(istream_type& s) noexcept;
    istreambuf_iterator(streambuf_type* s) noexcept;
    istreambuf_iterator(a-private-type) noexcept;

    charT                operator*() const;
    pointer operator->() const;
    istreambuf_iterator& operator++();
    a-private-type       operator++(int);

    bool equal(const istreambuf_iterator& b) const;
    friend bool operator==(const istreambuf_iterator& i, default_sentinel_t s); // since C++20
};

template <class charT, class traits>
bool operator==(const istreambuf_iterator<charT,traits>& a,
                const istreambuf_iterator<charT,traits>& b);
template <class charT, class traits>
bool operator!=(const istreambuf_iterator<charT,traits>& a,
                const istreambuf_iterator<charT,traits>& b); // until C++20

template <class charT, class traits = char_traits<charT> >
class ostreambuf_iterator
    : public iterator<output_iterator_tag, void, void, void, void> // until C++17
{
public:
    typedef output_iterator_tag            iterator_category;
    typedef void                           value_type;
    typedef void                           difference_type; // until C++20
    typedef ptrdiff_t                      difference_type; // since C++20
    typedef void                           pointer;
    typedef void                           reference;

    typedef charT                          char_type;
    typedef traits                         traits_type;
    typedef basic_streambuf<charT, traits> streambuf_type;
    typedef basic_ostream<charT, traits>   ostream_type;

    ostreambuf_iterator(ostream_type& s) noexcept;
    ostreambuf_iterator(streambuf_type* s) noexcept;
    ostreambuf_iterator& operator=(charT c);
    ostreambuf_iterator& operator*();
    ostreambuf_iterator& operator++();
    ostreambuf_iterator& operator++(int);
    bool failed() const noexcept;
};

template <class C> constexpr auto begin(C& c) -> decltype(c.begin());                   // constexpr since C++17
template <class C> constexpr auto begin(const C& c) -> decltype(c.begin());             // constexpr since C++17
template <class C> constexpr auto end(C& c) -> decltype(c.end());                       // constexpr since C++17
template <class C> constexpr auto end(const C& c) -> decltype(c.end());                 // constexpr since C++17
template <class T, size_t N> constexpr T* begin(T (&array)[N]) noexcept;                // constexpr since C++14
template <class T, size_t N> constexpr T* end(T (&array)[N]) noexcept;                  // constexpr since C++14

template <class C> constexpr auto cbegin(const C& c) -> decltype(std::begin(c));        // C++14
template <class C> constexpr auto cend(const C& c) -> decltype(std::end(c));            // C++14
template <class C> constexpr auto rbegin(C& c) -> decltype(c.rbegin());                 // C++14, constexpr since C++17
template <class C> constexpr auto rbegin(const C& c) -> decltype(c.rbegin());           // C++14, constexpr since C++17
template <class C> constexpr auto rend(C& c) -> decltype(c.rend());                     // C++14, constexpr since C++17
template <class C> constexpr auto rend(const C& c) -> decltype(c.rend());               // C++14, constexpr since C++17
template <class E> constexpr reverse_iterator<const E*> rbegin(initializer_list<E> il); // C++14, constexpr since C++17
template <class E> constexpr reverse_iterator<const E*> rend(initializer_list<E> il);   // C++14, constexpr since C++17
template <class T, size_t N> constexpr reverse_iterator<T*> rbegin(T (&array)[N]);      // C++14, constexpr since C++17
template <class T, size_t N> constexpr reverse_iterator<T*> rend(T (&array)[N]);        // C++14, constexpr since C++17
template <class C> constexpr auto crbegin(const C& c) -> decltype(std::rbegin(c));      // C++14, constexpr since C++17
template <class C> constexpr auto crend(const C& c) -> decltype(std::rend(c));          // C++14, constexpr since C++17

// 24.8, container access:
template <class C> constexpr auto size(const C& c) -> decltype(c.size());         // C++17
template <class T, size_t N> constexpr size_t size(const T (&array)[N]) noexcept; // C++17

template <class C> constexpr auto ssize(const C& c)
    -> common_type_t<ptrdiff_t, make_signed_t<decltype(c.size())>>;                    // C++20
template <class T, ptrdiff_t> constexpr ptrdiff_t ssize(const T (&array)[N]) noexcept; // C++20

template <class C> constexpr auto empty(const C& c) -> decltype(c.empty());       // C++17
template <class T, size_t N> constexpr bool empty(const T (&array)[N]) noexcept;  // C++17
template <class E> constexpr bool empty(initializer_list<E> il) noexcept;         // C++17
template <class C> constexpr auto data(C& c) -> decltype(c.data());               // C++17
template <class C> constexpr auto data(const C& c) -> decltype(c.data());         // C++17
template <class T, size_t N> constexpr T* data(T (&array)[N]) noexcept;           // C++17
template <class E> constexpr const E* data(initializer_list<E> il) noexcept;      // C++17

}  // std

*/

#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* __assert expanded by -frewrite-includes */
#include <__assert> // all public C++ headers provide the assertion handler
#else /* __assert expanded by -frewrite-includes */
# 677 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/iterator" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__assert" 1 3
// -*- C++ -*-
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___ASSERT
#define _LIBCPP___ASSERT

#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* __config expanded by -frewrite-includes */
#include <__config>
#else /* __config expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__assert" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 1 3
// -*- C++ -*-
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___CONFIG
#define _LIBCPP___CONFIG

#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* __config_site expanded by -frewrite-includes */
#include <__config_site>
#else /* __config_site expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/x86_64-unknown-fuchsia/c++/v1/__config_site" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___CONFIG_SITE
#define _LIBCPP___CONFIG_SITE

#define _LIBCPP_ABI_VERSION 2
#define _LIBCPP_ABI_NAMESPACE __2
/* #undef _LIBCPP_ABI_FORCE_ITANIUM */
/* #undef _LIBCPP_ABI_FORCE_MICROSOFT */
/* #undef _LIBCPP_HAS_NO_THREADS */
/* #undef _LIBCPP_HAS_NO_MONOTONIC_CLOCK */
/* #undef _LIBCPP_HAS_MUSL_LIBC */
/* #undef _LIBCPP_HAS_THREAD_API_PTHREAD */
/* #undef _LIBCPP_HAS_THREAD_API_EXTERNAL */
/* #undef _LIBCPP_HAS_THREAD_API_WIN32 */
/* #undef _LIBCPP_DISABLE_VISIBILITY_ANNOTATIONS */
#define _LIBCPP_HAS_NO_VENDOR_AVAILABILITY_ANNOTATIONS
/* #undef _LIBCPP_NO_VCRUNTIME */
/* #undef _LIBCPP_TYPEINFO_COMPARISON_IMPLEMENTATION */
/* #undef _LIBCPP_HAS_NO_FILESYSTEM */
/* #undef _LIBCPP_HAS_NO_RANDOM_DEVICE */
/* #undef _LIBCPP_HAS_NO_LOCALIZATION */
/* #undef _LIBCPP_HAS_NO_WIDE_CHARACTERS */
#define _LIBCPP_HAS_NO_STD_MODULES
#define _LIBCPP_HAS_NO_TIME_ZONE_DATABASE

// PSTL backends
/* #undef _LIBCPP_PSTL_CPU_BACKEND_SERIAL */
#define _LIBCPP_PSTL_CPU_BACKEND_THREAD
/* #undef _LIBCPP_PSTL_CPU_BACKEND_LIBDISPATCH */

// Hardening.
#define _LIBCPP_ENABLE_HARDENED_MODE_DEFAULT 0
#define _LIBCPP_ENABLE_SAFE_MODE_DEFAULT 0
#define _LIBCPP_ENABLE_DEBUG_MODE_DEFAULT 0

// __USE_MINGW_ANSI_STDIO gets redefined on MinGW
#ifdef __clang__
#  pragma clang diagnostic push
#  pragma clang diagnostic ignored "-Wmacro-redefined"
#endif
# 48 "../../prebuilt/third_party/clang/custom/bin/../include/x86_64-unknown-fuchsia/c++/v1/__config_site" 3




#ifdef __clang__
#  pragma clang diagnostic pop
#endif
# 55 "../../prebuilt/third_party/clang/custom/bin/../include/x86_64-unknown-fuchsia/c++/v1/__config_site" 3

#endif // _LIBCPP___CONFIG_SITE
# 57 "../../prebuilt/third_party/clang/custom/bin/../include/x86_64-unknown-fuchsia/c++/v1/__config_site" 3
#endif /* __config_site expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 2 3

#ifndef _LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#endif
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#if 0 /* disabled by -frewrite-includes */
#if defined(__apple_build_version__)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 20 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
// Given AppleClang XX.Y.Z, _LIBCPP_APPLE_CLANG_VER is XXYZ (e.g. AppleClang 14.0.3 => 1403)
#  define _LIBCPP_COMPILER_CLANG_BASED
#  define _LIBCPP_APPLE_CLANG_VER (__apple_build_version__ / 10000)
#if 0 /* disabled by -frewrite-includes */
#if 0
#elif defined(__clang__)
#endif
#endif /* disabled by -frewrite-includes */
#elif 1 /* evaluated by -frewrite-includes */
# 24 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#  define _LIBCPP_COMPILER_CLANG_BASED
#  define _LIBCPP_CLANG_VER (__clang_major__ * 100 + __clang_minor__)
#if 0 /* disabled by -frewrite-includes */
#if 0
#elif defined(__GNUC__)
#endif
#endif /* disabled by -frewrite-includes */
#elif 0 /* evaluated by -frewrite-includes */
# 27 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#  define _LIBCPP_COMPILER_GCC
#  define _LIBCPP_GCC_VER (__GNUC__ * 100 + __GNUC_MINOR__)
#endif
# 30 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#ifdef __cplusplus

// Warn if a compiler version is used that is not supported anymore
// LLVM RELEASE Update the minimum compiler versions
#if 0 /* disabled by -frewrite-includes */
#  if defined(_LIBCPP_CLANG_VER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 36 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#if 0 /* disabled by -frewrite-includes */
#    if _LIBCPP_CLANG_VER < 1500
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 37 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#      warning "Libc++ only supports Clang 15 and later"
#    endif
# 39 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#if 0 /* disabled by -frewrite-includes */
#if 0
#  elif defined(_LIBCPP_APPLE_CLANG_VER)
#endif
#endif /* disabled by -frewrite-includes */
#elif 0 /* evaluated by -frewrite-includes */
# 40 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#if 0 /* disabled by -frewrite-includes */
#    if _LIBCPP_APPLE_CLANG_VER < 1500
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 41 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#      warning "Libc++ only supports AppleClang 15 and later"
#    endif
# 43 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#if 0 /* disabled by -frewrite-includes */
#if 0
#  elif defined(_LIBCPP_GCC_VER)
#endif
#endif /* disabled by -frewrite-includes */
#elif 0 /* evaluated by -frewrite-includes */
# 44 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#if 0 /* disabled by -frewrite-includes */
#    if _LIBCPP_GCC_VER < 1300
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 45 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#      warning "Libc++ only supports GCC 13 and later"
#    endif
# 47 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#  endif
# 48 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

// The attributes supported by clang are documented at https://clang.llvm.org/docs/AttributeReference.html

// _LIBCPP_VERSION represents the version of libc++, which matches the version of LLVM.
// Given a LLVM release LLVM XX.YY.ZZ (e.g. LLVM 17.0.1 == 17.00.01), _LIBCPP_VERSION is
// defined to XXYYZZ.
#  define _LIBCPP_VERSION 180000

#  define _LIBCPP_CONCAT_IMPL(_X, _Y) _X##_Y
#  define _LIBCPP_CONCAT(_X, _Y) _LIBCPP_CONCAT_IMPL(_X, _Y)

// Valid C++ identifier that revs with every libc++ version. This can be used to
// generate identifiers that must be unique for every released libc++ version.
#  define _LIBCPP_VERSIONED_IDENTIFIER _LIBCPP_CONCAT(v, _LIBCPP_VERSION)

#if 0 /* disabled by -frewrite-includes */
#  if __STDC_HOSTED__ == 0
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 64 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_FREESTANDING
#  endif
# 66 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

// NOLINTBEGIN(libcpp-cpp-version-check)
#  ifndef _LIBCPP_STD_VER
#if 0 /* disabled by -frewrite-includes */
#    if __cplusplus <= 201103L
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 70 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#      define _LIBCPP_STD_VER 11
#if 0 /* disabled by -frewrite-includes */
#if 0
#    elif __cplusplus <= 201402L
#endif
#endif /* disabled by -frewrite-includes */
#elif 0 /* evaluated by -frewrite-includes */
# 72 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#      define _LIBCPP_STD_VER 14
#if 0 /* disabled by -frewrite-includes */
#if 0
#    elif __cplusplus <= 201703L
#endif
#endif /* disabled by -frewrite-includes */
#elif 1 /* evaluated by -frewrite-includes */
# 74 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#      define _LIBCPP_STD_VER 17
#if 0 /* disabled by -frewrite-includes */
#if 0
#    elif __cplusplus <= 202002L
#endif
#endif /* disabled by -frewrite-includes */
#elif 0 /* evaluated by -frewrite-includes */
# 76 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#      define _LIBCPP_STD_VER 20
#if 0 /* disabled by -frewrite-includes */
#if 0
#    elif __cplusplus <= 202302L
#endif
#endif /* disabled by -frewrite-includes */
#elif 0 /* evaluated by -frewrite-includes */
# 78 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#      define _LIBCPP_STD_VER 23
#    else
# 80 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
// Expected release year of the next C++ standard
#      define _LIBCPP_STD_VER 26
#    endif
# 83 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#  endif // _LIBCPP_STD_VER
# 84 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
// NOLINTEND(libcpp-cpp-version-check)

#if 0 /* disabled by -frewrite-includes */
#  if defined(__ELF__)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 87 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_OBJECT_FORMAT_ELF 1
#if 0 /* disabled by -frewrite-includes */
#if 0
#  elif defined(__MACH__)
#endif
#endif /* disabled by -frewrite-includes */
#elif 0 /* evaluated by -frewrite-includes */
# 89 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_OBJECT_FORMAT_MACHO 1
#if 0 /* disabled by -frewrite-includes */
#if 0
#  elif defined(_WIN32)
#endif
#endif /* disabled by -frewrite-includes */
#elif 0 /* evaluated by -frewrite-includes */
# 91 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_OBJECT_FORMAT_COFF 1
#if 0 /* disabled by -frewrite-includes */
#if 0
#  elif defined(__wasm__)
#endif
#endif /* disabled by -frewrite-includes */
#elif 0 /* evaluated by -frewrite-includes */
# 93 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_OBJECT_FORMAT_WASM 1
#if 0 /* disabled by -frewrite-includes */
#if 0
#  elif defined(_AIX)
#endif
#endif /* disabled by -frewrite-includes */
#elif 0 /* evaluated by -frewrite-includes */
# 95 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_OBJECT_FORMAT_XCOFF 1
#  else
# 97 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
// ... add new file formats here ...
#  endif
# 99 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

// ABI {

#if 0 /* disabled by -frewrite-includes */
#  if _LIBCPP_ABI_VERSION >= 2
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 103 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
// Change short string representation so that string data starts at offset 0,
// improving its alignment in some cases.
#    define _LIBCPP_ABI_ALTERNATE_STRING_LAYOUT
// Fix deque iterator type in order to support incomplete types.
#    define _LIBCPP_ABI_INCOMPLETE_TYPES_IN_DEQUE
// Fix undefined behavior in how std::list stores its linked nodes.
#    define _LIBCPP_ABI_LIST_REMOVE_NODE_POINTER_UB
// Fix undefined behavior in  how __tree stores its end and parent nodes.
#    define _LIBCPP_ABI_TREE_REMOVE_NODE_POINTER_UB
// Fix undefined behavior in how __hash_table stores its pointer types.
#    define _LIBCPP_ABI_FIX_UNORDERED_NODE_POINTER_UB
#    define _LIBCPP_ABI_FORWARD_LIST_REMOVE_NODE_POINTER_UB
#    define _LIBCPP_ABI_FIX_UNORDERED_CONTAINER_SIZE_TYPE
// Define a key function for `bad_function_call` in the library, to centralize
// its vtable and typeinfo to libc++ rather than having all other libraries
// using that class define their own copies.
#    define _LIBCPP_ABI_BAD_FUNCTION_CALL_KEY_FUNCTION
// Override the default return value of exception::what() for
// bad_function_call::what() with a string that is specific to
// bad_function_call (see http://wg21.link/LWG2233). This is an ABI break
// because it changes the vtable layout of bad_function_call.
#    define _LIBCPP_ABI_BAD_FUNCTION_CALL_GOOD_WHAT_MESSAGE
// Enable optimized version of __do_get_(un)signed which avoids redundant copies.
#    define _LIBCPP_ABI_OPTIMIZED_LOCALE_NUM_GET
// Give reverse_iterator<T> one data member of type T, not two.
// Also, in C++17 and later, don't derive iterator types from std::iterator.
#    define _LIBCPP_ABI_NO_ITERATOR_BASES
// Use the smallest possible integer type to represent the index of the variant.
// Previously libc++ used "unsigned int" exclusively.
#    define _LIBCPP_ABI_VARIANT_INDEX_TYPE_OPTIMIZATION
// Unstable attempt to provide a more optimized std::function
#    define _LIBCPP_ABI_OPTIMIZED_FUNCTION
// All the regex constants must be distinct and nonzero.
#    define _LIBCPP_ABI_REGEX_CONSTANTS_NONZERO
// Re-worked external template instantiations for std::string with a focus on
// performance and fast-path inlining.
#    define _LIBCPP_ABI_STRING_OPTIMIZED_EXTERNAL_INSTANTIATION
// Enable clang::trivial_abi on std::unique_ptr.
#    define _LIBCPP_ABI_ENABLE_UNIQUE_PTR_TRIVIAL_ABI
// Enable clang::trivial_abi on std::shared_ptr and std::weak_ptr
#    define _LIBCPP_ABI_ENABLE_SHARED_PTR_TRIVIAL_ABI
// std::random_device holds some state when it uses an implementation that gets
// entropy from a file (see _LIBCPP_USING_DEV_RANDOM). When switching from this
// implementation to another one on a platform that has already shipped
// std::random_device, one needs to retain the same object layout to remain ABI
// compatible. This switch removes these workarounds for platforms that don't care
// about ABI compatibility.
#    define _LIBCPP_ABI_NO_RANDOM_DEVICE_COMPATIBILITY_LAYOUT
// Don't export the legacy __basic_string_common class and its methods from the built library.
#    define _LIBCPP_ABI_DO_NOT_EXPORT_BASIC_STRING_COMMON
// Don't export the legacy __vector_base_common class and its methods from the built library.
#    define _LIBCPP_ABI_DO_NOT_EXPORT_VECTOR_BASE_COMMON
// According to the Standard, `bitset::operator[] const` returns bool
#    define _LIBCPP_ABI_BITSET_VECTOR_BOOL_CONST_SUBSCRIPT_RETURN_BOOL
// Fix the implementation of CityHash used for std::hash<fundamental-type>.
// This is an ABI break because `std::hash` will return a different result,
// which means that hashing the same object in translation units built against
// different versions of libc++ can return inconsistent results. This is especially
// tricky since std::hash is used in the implementation of unordered containers.
//
// The incorrect implementation of CityHash has the problem that it drops some
// bits on the floor.
#    define _LIBCPP_ABI_FIX_CITYHASH_IMPLEMENTATION
// Remove the base 10 implementation of std::to_chars from the dylib.
// The implementation moved to the header, but we still export the symbols from
// the dylib for backwards compatibility.
#    define _LIBCPP_ABI_DO_NOT_EXPORT_TO_CHARS_BASE_10
// Save memory by providing the allocator more freedom to allocate the most
// efficient size class by dropping the alignment requirements for std::string's
// pointer from 16 to 8. This changes the output of std::string::max_size,
// which makes it ABI breaking
#    define _LIBCPP_ABI_STRING_8_BYTE_ALIGNMENT
#if 0 /* disabled by -frewrite-includes */
#if 0
#  elif _LIBCPP_ABI_VERSION == 1
#endif
#endif /* disabled by -frewrite-includes */
#elif 0 /* evaluated by -frewrite-includes */
# 176 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#if 0 /* disabled by -frewrite-includes */
#    if !(defined(_LIBCPP_OBJECT_FORMAT_COFF) || defined(_LIBCPP_OBJECT_FORMAT_XCOFF))
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 177 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
// Enable compiling copies of now inline methods into the dylib to support
// applications compiled against older libraries. This is unnecessary with
// COFF dllexport semantics, since dllexport forces a non-inline definition
// of inline functions to be emitted anyway. Our own non-inline copy would
// conflict with the dllexport-emitted copy, so we disable it. For XCOFF,
// the linker will take issue with the symbols in the shared object if the
// weak inline methods get visibility (such as from -fvisibility-inlines-hidden),
// so disable it.
#      define _LIBCPP_DEPRECATED_ABI_LEGACY_LIBRARY_DEFINITIONS_FOR_INLINE_FUNCTIONS
#    endif
# 187 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
// Feature macros for disabling pre ABI v1 features. All of these options
// are deprecated.
#if 0 /* disabled by -frewrite-includes */
#    if defined(__FreeBSD__) && __FreeBSD__ < 14
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 190 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#      define _LIBCPP_DEPRECATED_ABI_DISABLE_PAIR_TRIVIAL_COPY_CTOR
#    endif
# 192 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
// For XCOFF linkers, we have problems if we see a weak hidden version of a symbol
// in user code (like you get with -fvisibility-inlines-hidden) and then a strong def
// in the library, so we need to always rely on the library version.
#if 0 /* disabled by -frewrite-includes */
#    if defined(_AIX)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 196 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#      define _LIBCPP_ABI_BAD_FUNCTION_CALL_KEY_FUNCTION
#    endif
# 198 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#  endif
# 199 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#if 0 /* disabled by -frewrite-includes */
#  if defined(_LIBCPP_BUILDING_LIBRARY) || _LIBCPP_ABI_VERSION >= 2
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 201 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
// Define a key function for `bad_function_call` in the library, to centralize
// its vtable and typeinfo to libc++ rather than having all other libraries
// using that class define their own copies.
#    define _LIBCPP_ABI_BAD_FUNCTION_CALL_KEY_FUNCTION
#  endif
# 206 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

// Changes the iterator type of select containers (see below) to a bounded iterator that keeps track of whether it's
// within the bounds of the original container and asserts it on every dereference.
//
// ABI impact: changes the iterator type of the relevant containers.
//
// Supported containers:
// - `span`;
// - `string_view`;
// - `array`.
// #define _LIBCPP_ABI_BOUNDED_ITERATORS

// } ABI

// HARDENING {

// TODO(hardening): deprecate this in LLVM 19.
// This is for backward compatibility -- make enabling `_LIBCPP_ENABLE_ASSERTIONS` (which predates hardening modes)
// equivalent to setting the safe mode.
#  ifdef _LIBCPP_ENABLE_ASSERTIONS
#if 0 /* disabled by -frewrite-includes */
#    if _LIBCPP_ENABLE_ASSERTIONS != 0 && _LIBCPP_ENABLE_ASSERTIONS != 1
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 227 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#      error "_LIBCPP_ENABLE_ASSERTIONS must be set to 0 or 1"
#    endif
# 229 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#if 0 /* disabled by -frewrite-includes */
#    if _LIBCPP_ENABLE_ASSERTIONS
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 230 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#      define _LIBCPP_ENABLE_SAFE_MODE 1
#    endif
# 232 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#  endif
# 233 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

// Enables the hardened mode which consists of all checks intended to be used in production. Hardened mode prioritizes
// security-critical checks that can be done with relatively little overhead in constant time. Mutually exclusive with
// `_LIBCPP_ENABLE_SAFE_MODE` and `_LIBCPP_ENABLE_DEBUG_MODE`.
//
// #define _LIBCPP_ENABLE_HARDENED_MODE 1

// Enables the safe mode which extends the hardened mode with checks that are relatively cheap and prevent common types
// of errors but are not security-critical. Mutually exclusive with `_LIBCPP_ENABLE_HARDENED_MODE` and
// `_LIBCPP_ENABLE_DEBUG_MODE`.
//
// #define _LIBCPP_ENABLE_SAFE_MODE 1

// Enables the debug mode which contains all the checks from the hardened mode and additionally more expensive checks
// that may affect the complexity of algorithms. The debug mode is intended to be used for testing, not in production.
// Mutually exclusive with `_LIBCPP_ENABLE_HARDENED_MODE` and `_LIBCPP_ENABLE_SAFE_MODE`.
//
// #define _LIBCPP_ENABLE_DEBUG_MODE 1

// Inside the library, assertions are categorized so they can be cherry-picked based on the chosen hardening mode. These
// macros are only for internal use -- users should only pick one of the high-level hardening modes described above.
//
// - `_LIBCPP_ASSERT_VALID_INPUT_RANGE` -- checks that ranges (whether expressed as an iterator pair, an iterator and
//   a sentinel, an iterator and a count, or a `std::range`) given as input to library functions are valid:
//   - the sentinel is reachable from the begin iterator;
//   - TODO(hardening): both iterators refer to the same container.
//
// - `_LIBCPP_ASSERT_VALID_ELEMENT_ACCESS` -- checks that any attempts to access a container element, whether through
//   the container object or through an iterator, are valid and do not attempt to go out of bounds or otherwise access
//   a non-existent element. For iterator checks to work, bounded iterators must be enabled in the ABI. Types like
//   `optional` and `function` are considered one-element containers for the purposes of this check.
//
// - `_LIBCPP_ASSERT_NON_OVERLAPPING_RANGES` -- for functions that take several ranges as arguments, checks that the
//   given ranges do not overlap.
//
// - `_LIBCPP_ASSERT_COMPATIBLE_ALLOCATOR` -- checks any operations that exchange nodes between containers to make sure
//   the containers have compatible allocators.
//
// - `_LIBCPP_ASSERT_INTERNAL` -- checks that internal invariants of the library hold. These assertions don't depend on
//   user input.
//
// - `_LIBCPP_ASSERT_UNCATEGORIZED` -- for assertions that haven't been properly classified yet.

#  ifndef _LIBCPP_ENABLE_HARDENED_MODE
#    define _LIBCPP_ENABLE_HARDENED_MODE _LIBCPP_ENABLE_HARDENED_MODE_DEFAULT
#  endif
# 279 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#if 0 /* disabled by -frewrite-includes */
#  if _LIBCPP_ENABLE_HARDENED_MODE != 0 && _LIBCPP_ENABLE_HARDENED_MODE != 1
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 280 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    error "_LIBCPP_ENABLE_HARDENED_MODE must be set to 0 or 1."
#  endif
# 282 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#  ifndef _LIBCPP_ENABLE_SAFE_MODE
#    define _LIBCPP_ENABLE_SAFE_MODE _LIBCPP_ENABLE_SAFE_MODE_DEFAULT
#  endif
# 286 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#if 0 /* disabled by -frewrite-includes */
#  if _LIBCPP_ENABLE_SAFE_MODE != 0 && _LIBCPP_ENABLE_SAFE_MODE != 1
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 287 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    error "_LIBCPP_ENABLE_SAFE_MODE must be set to 0 or 1."
#  endif
# 289 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#  ifndef _LIBCPP_ENABLE_DEBUG_MODE
#    define _LIBCPP_ENABLE_DEBUG_MODE _LIBCPP_ENABLE_DEBUG_MODE_DEFAULT
#  endif
# 293 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#if 0 /* disabled by -frewrite-includes */
#  if _LIBCPP_ENABLE_DEBUG_MODE != 0 && _LIBCPP_ENABLE_DEBUG_MODE != 1
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 294 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    error "_LIBCPP_ENABLE_DEBUG_MODE must be set to 0 or 1."
#  endif
# 296 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#if 0 /* disabled by -frewrite-includes */
#  if (_LIBCPP_ENABLE_HARDENED_MODE && _LIBCPP_ENABLE_SAFE_MODE) ||                                                    \
      (_LIBCPP_ENABLE_HARDENED_MODE && _LIBCPP_ENABLE_DEBUG_MODE) ||                                                   \
      (_LIBCPP_ENABLE_SAFE_MODE && _LIBCPP_ENABLE_DEBUG_MODE)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 300 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    error                                                                                                             \
        "Only one of _LIBCPP_ENABLE_HARDENED_MODE, _LIBCPP_ENABLE_SAFE_MODE and _LIBCPP_ENABLE_DEBUG_MODE can be enabled."
#  endif
# 303 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

// clang-format off
// Hardened mode checks.

#if 0 /* disabled by -frewrite-includes */
#  if _LIBCPP_ENABLE_HARDENED_MODE
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 308 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

// Enabled checks.
#    define _LIBCPP_ASSERT_VALID_INPUT_RANGE(expression, message)        _LIBCPP_ASSERT(expression, message)
#    define _LIBCPP_ASSERT_VALID_ELEMENT_ACCESS(expression, message)     _LIBCPP_ASSERT(expression, message)
// Disabled checks.
// Overlapping ranges will make algorithms produce incorrect results but don't directly lead to a security
// vulnerability.
#    define _LIBCPP_ASSERT_NON_OVERLAPPING_RANGES(expression, message)   _LIBCPP_ASSUME(expression)
#    define _LIBCPP_ASSERT_COMPATIBLE_ALLOCATOR(expression, message)     _LIBCPP_ASSUME(expression)
#    define _LIBCPP_ASSERT_INTERNAL(expression, message)                 _LIBCPP_ASSUME(expression)
#    define _LIBCPP_ASSERT_UNCATEGORIZED(expression, message)            _LIBCPP_ASSUME(expression)

// Safe mode checks.

#if 0 /* disabled by -frewrite-includes */
#if 0
#  elif _LIBCPP_ENABLE_SAFE_MODE
#endif
#endif /* disabled by -frewrite-includes */
#elif 0 /* evaluated by -frewrite-includes */
# 323 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

// Enabled checks.
#    define _LIBCPP_ASSERT_VALID_INPUT_RANGE(expression, message)        _LIBCPP_ASSERT(expression, message)
#    define _LIBCPP_ASSERT_VALID_ELEMENT_ACCESS(expression, message)     _LIBCPP_ASSERT(expression, message)
#    define _LIBCPP_ASSERT_NON_OVERLAPPING_RANGES(expression, message)   _LIBCPP_ASSERT(expression, message)
#    define _LIBCPP_ASSERT_COMPATIBLE_ALLOCATOR(expression, message)     _LIBCPP_ASSERT(expression, message)
#    define _LIBCPP_ASSERT_UNCATEGORIZED(expression, message)            _LIBCPP_ASSERT(expression, message)
// Disabled checks.
#    define _LIBCPP_ASSERT_INTERNAL(expression, message)                 _LIBCPP_ASSUME(expression)

// Debug mode checks.

#if 0 /* disabled by -frewrite-includes */
#if 0
#  elif _LIBCPP_ENABLE_DEBUG_MODE
#endif
#endif /* disabled by -frewrite-includes */
#elif 0 /* evaluated by -frewrite-includes */
# 336 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

// All checks enabled.
#    define _LIBCPP_ASSERT_VALID_INPUT_RANGE(expression, message)         _LIBCPP_ASSERT(expression, message)
#    define _LIBCPP_ASSERT_VALID_ELEMENT_ACCESS(expression, message)      _LIBCPP_ASSERT(expression, message)
#    define _LIBCPP_ASSERT_NON_OVERLAPPING_RANGES(expression, message)    _LIBCPP_ASSERT(expression, message)
#    define _LIBCPP_ASSERT_COMPATIBLE_ALLOCATOR(expression, message)      _LIBCPP_ASSERT(expression, message)
#    define _LIBCPP_ASSERT_INTERNAL(expression, message)                  _LIBCPP_ASSERT(expression, message)
#    define _LIBCPP_ASSERT_UNCATEGORIZED(expression, message)             _LIBCPP_ASSERT(expression, message)

// Disable all checks if hardening is not enabled.

#  else
# 348 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

// All checks disabled.
#    define _LIBCPP_ASSERT_VALID_INPUT_RANGE(expression, message)         _LIBCPP_ASSUME(expression)
#    define _LIBCPP_ASSERT_VALID_ELEMENT_ACCESS(expression, message)      _LIBCPP_ASSUME(expression)
#    define _LIBCPP_ASSERT_NON_OVERLAPPING_RANGES(expression, message)    _LIBCPP_ASSUME(expression)
#    define _LIBCPP_ASSERT_COMPATIBLE_ALLOCATOR(expression, message)      _LIBCPP_ASSUME(expression)
#    define _LIBCPP_ASSERT_INTERNAL(expression, message)                  _LIBCPP_ASSUME(expression)
#    define _LIBCPP_ASSERT_UNCATEGORIZED(expression, message)             _LIBCPP_ASSUME(expression)

#  endif // _LIBCPP_ENABLE_HARDENED_MODE
# 358 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
// clang-format on

// } HARDENING

#  define _LIBCPP_TOSTRING2(x) #x
#  define _LIBCPP_TOSTRING(x) _LIBCPP_TOSTRING2(x)

// NOLINTNEXTLINE(libcpp-cpp-version-check)
#if 0 /* disabled by -frewrite-includes */
#  if __cplusplus < 201103L
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 367 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_CXX03_LANG
#  endif
# 369 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#  ifndef __has_attribute
#    define __has_attribute(__x) 0
#  endif
# 373 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#  ifndef __has_builtin
#    define __has_builtin(__x) 0
#  endif
# 377 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#  ifndef __has_extension
#    define __has_extension(__x) 0
#  endif
# 381 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#  ifndef __has_feature
#    define __has_feature(__x) 0
#  endif
# 385 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#  ifndef __has_cpp_attribute
#    define __has_cpp_attribute(__x) 0
#  endif
# 389 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#  ifndef __has_constexpr_builtin
#    define __has_constexpr_builtin(x) 0
#  endif
# 393 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

// '__is_identifier' returns '0' if '__x' is a reserved identifier provided by
// the compiler and '1' otherwise.
#  ifndef __is_identifier
#    define __is_identifier(__x) 1
#  endif
# 399 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#  ifndef __has_declspec_attribute
#    define __has_declspec_attribute(__x) 0
#  endif
# 403 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#  define __has_keyword(__x) !(__is_identifier(__x))

#  ifndef __has_include
#    define __has_include(...) 0
#  endif
# 409 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#if 0 /* disabled by -frewrite-includes */
#  if !defined(_LIBCPP_COMPILER_CLANG_BASED) && __cplusplus < 201103L
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 411 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    error "libc++ only supports C++03 with Clang-based compilers. Please enable C++11"
#  endif
# 413 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

// FIXME: ABI detection should be done via compiler builtin macros. This
// is just a placeholder until Clang implements such macros. For now assume
// that Windows compilers pretending to be MSVC++ target the Microsoft ABI,
// and allow the user to explicitly specify the ABI to handle cases where this
// heuristic falls short.
#if 0 /* disabled by -frewrite-includes */
#  if defined(_LIBCPP_ABI_FORCE_ITANIUM) && defined(_LIBCPP_ABI_FORCE_MICROSOFT)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 420 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    error "Only one of _LIBCPP_ABI_FORCE_ITANIUM and _LIBCPP_ABI_FORCE_MICROSOFT can be defined"
#if 0 /* disabled by -frewrite-includes */
#if 0
#  elif defined(_LIBCPP_ABI_FORCE_ITANIUM)
#endif
#endif /* disabled by -frewrite-includes */
#elif 0 /* evaluated by -frewrite-includes */
# 422 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_ABI_ITANIUM
#if 0 /* disabled by -frewrite-includes */
#if 0
#  elif defined(_LIBCPP_ABI_FORCE_MICROSOFT)
#endif
#endif /* disabled by -frewrite-includes */
#elif 0 /* evaluated by -frewrite-includes */
# 424 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_ABI_MICROSOFT
#  else
# 426 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#if 0 /* disabled by -frewrite-includes */
#    if defined(_WIN32) && defined(_MSC_VER)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 427 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#      define _LIBCPP_ABI_MICROSOFT
#    else
# 429 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#      define _LIBCPP_ABI_ITANIUM
#    endif
# 431 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#  endif
# 432 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#if 0 /* disabled by -frewrite-includes */
#  if defined(_LIBCPP_ABI_MICROSOFT) && !defined(_LIBCPP_NO_VCRUNTIME)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 434 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_ABI_VCRUNTIME
#  endif
# 436 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#if 0 /* disabled by -frewrite-includes */
#  if __has_feature(experimental_library)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 438 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    ifndef _LIBCPP_ENABLE_EXPERIMENTAL
#      define _LIBCPP_ENABLE_EXPERIMENTAL
#    endif
# 441 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#  endif
# 442 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

// Incomplete features get their own specific disabling flags. This makes it
// easier to grep for target specific flags once the feature is complete.
#if 0 /* disabled by -frewrite-includes */
#  if !defined(_LIBCPP_ENABLE_EXPERIMENTAL) && !defined(_LIBCPP_BUILDING_LIBRARY)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 446 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_HAS_NO_INCOMPLETE_PSTL
#    define _LIBCPP_HAS_NO_EXPERIMENTAL_STOP_TOKEN
#    define _LIBCPP_HAS_NO_INCOMPLETE_TZDB
#  endif
# 450 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

// Need to detect which libc we're using if we're on Linux.
#if 0 /* disabled by -frewrite-includes */
#  if defined(__linux__)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 453 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#if 0 /* expanded by -frewrite-includes */
#    include <features.h>
#endif /* expanded by -frewrite-includes */
# 453 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
# 454 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#if 0 /* disabled by -frewrite-includes */
#    if defined(__GLIBC_PREREQ)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 455 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#      define _LIBCPP_GLIBC_PREREQ(a, b) __GLIBC_PREREQ(a, b)
#    else
# 457 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#      define _LIBCPP_GLIBC_PREREQ(a, b) 0
#    endif // defined(__GLIBC_PREREQ)
# 459 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#  endif   // defined(__linux__)
# 460 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#if 0 /* disabled by -frewrite-includes */
#  if defined(__MVS__)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 462 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#if 0 /* expanded by -frewrite-includes */
#    include <features.h> // for __NATIVE_ASCII_F
#endif /* expanded by -frewrite-includes */
# 462 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
# 463 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#  endif
# 464 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#  ifndef __BYTE_ORDER__
#    error                                                                                                             \
        "Your compiler doesn't seem to define __BYTE_ORDER__, which is required by libc++ to know the endianness of your target platform"
#  endif
# 469 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#if 0 /* disabled by -frewrite-includes */
#  if __BYTE_ORDER__ == __ORDER_LITTLE_ENDIAN__
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 471 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_LITTLE_ENDIAN
#if 0 /* disabled by -frewrite-includes */
#if 0
#  elif __BYTE_ORDER__ == __ORDER_BIG_ENDIAN__
#endif
#endif /* disabled by -frewrite-includes */
#elif 0 /* evaluated by -frewrite-includes */
# 473 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_BIG_ENDIAN
#  endif // __BYTE_ORDER__ == __ORDER_BIG_ENDIAN__
# 475 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#if 0 /* disabled by -frewrite-includes */
#  if defined(_WIN32)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 477 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_WIN32API
#    define _LIBCPP_SHORT_WCHAR 1
// Both MinGW and native MSVC provide a "MSVC"-like environment
#    define _LIBCPP_MSVCRT_LIKE
// If mingw not explicitly detected, assume using MS C runtime only if
// a MS compatibility version is specified.
#if 0 /* disabled by -frewrite-includes */
#    if defined(_MSC_VER) && !defined(__MINGW32__)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 484 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#      define _LIBCPP_MSVCRT // Using Microsoft's C Runtime library
#    endif
# 486 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#if 0 /* disabled by -frewrite-includes */
#    if (defined(_M_AMD64) || defined(__x86_64__)) || (defined(_M_ARM) || defined(__arm__))
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 487 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#      define _LIBCPP_HAS_BITSCAN64
#    endif
# 489 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_HAS_OPEN_WITH_WCHAR
#  endif // defined(_WIN32)
# 491 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#if 0 /* disabled by -frewrite-includes */
#  if defined(_AIX) && !defined(__64BIT__)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 493 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
// The size of wchar is 2 byte on 32-bit mode on AIX.
#    define _LIBCPP_SHORT_WCHAR 1
#  endif
# 496 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

// Libc++ supports various implementations of std::random_device.
//
// _LIBCPP_USING_DEV_RANDOM
//      Read entropy from the given file, by default `/dev/urandom`.
//      If a token is provided, it is assumed to be the path to a file
//      to read entropy from. This is the default behavior if nothing
//      else is specified. This implementation requires storing state
//      inside `std::random_device`.
//
// _LIBCPP_USING_ARC4_RANDOM
//      Use arc4random(). This allows obtaining random data even when
//      using sandboxing mechanisms. On some platforms like Apple, this
//      is the recommended source of entropy for user-space programs.
//      When this option is used, the token passed to `std::random_device`'s
//      constructor *must* be "/dev/urandom" -- anything else is an error.
//
// _LIBCPP_USING_GETENTROPY
//      Use getentropy().
//      When this option is used, the token passed to `std::random_device`'s
//      constructor *must* be "/dev/urandom" -- anything else is an error.
//
// _LIBCPP_USING_FUCHSIA_CPRNG
//      Use Fuchsia's zx_cprng_draw() system call, which is specified to
//      deliver high-quality entropy and cannot fail.
//      When this option is used, the token passed to `std::random_device`'s
//      constructor *must* be "/dev/urandom" -- anything else is an error.
//
// _LIBCPP_USING_NACL_RANDOM
//      NaCl's sandbox (which PNaCl also runs in) doesn't allow filesystem access,
//      including accesses to the special files under `/dev`. This implementation
//      uses the NaCL syscall `nacl_secure_random_init()` to get entropy.
//      When this option is used, the token passed to `std::random_device`'s
//      constructor *must* be "/dev/urandom" -- anything else is an error.
//
// _LIBCPP_USING_WIN32_RANDOM
//      Use rand_s(), for use on Windows.
//      When this option is used, the token passed to `std::random_device`'s
//      constructor *must* be "/dev/urandom" -- anything else is an error.
#if 0 /* disabled by -frewrite-includes */
#  if defined(__APPLE__) || defined(__FreeBSD__) || defined(__NetBSD__) || defined(__OpenBSD__) ||                     \
      defined(__DragonFly__)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 537 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_USING_ARC4_RANDOM
#if 0 /* disabled by -frewrite-includes */
#if 0
#  elif defined(__wasi__) || defined(__EMSCRIPTEN__)
#endif
#endif /* disabled by -frewrite-includes */
#elif 0 /* evaluated by -frewrite-includes */
# 539 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_USING_GETENTROPY
#if 0 /* disabled by -frewrite-includes */
#if 0
#  elif defined(__Fuchsia__)
#endif
#endif /* disabled by -frewrite-includes */
#elif 1 /* evaluated by -frewrite-includes */
# 541 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_USING_FUCHSIA_CPRNG
#if 0 /* disabled by -frewrite-includes */
#if 0
#  elif defined(__native_client__)
#endif
#endif /* disabled by -frewrite-includes */
#elif 0 /* evaluated by -frewrite-includes */
# 543 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_USING_NACL_RANDOM
#if 0 /* disabled by -frewrite-includes */
#if 0
#  elif defined(_LIBCPP_WIN32API)
#endif
#endif /* disabled by -frewrite-includes */
#elif 0 /* evaluated by -frewrite-includes */
# 545 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_USING_WIN32_RANDOM
#  else
# 547 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_USING_DEV_RANDOM
#  endif
# 549 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#if 0 /* disabled by -frewrite-includes */
#  if __has_attribute(__no_sanitize__) && !defined(_LIBCPP_COMPILER_GCC)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 551 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_NO_CFI __attribute__((__no_sanitize__("cfi")))
#  else
# 553 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_NO_CFI
#  endif
# 555 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#  ifndef _LIBCPP_CXX03_LANG

#    define _LIBCPP_ALIGNOF(_Tp) alignof(_Tp)
#    define _ALIGNAS_TYPE(x) alignas(x)
#    define _ALIGNAS(x) alignas(x)
#    define _LIBCPP_NORETURN [[noreturn]]
#    define _NOEXCEPT noexcept
#    define _NOEXCEPT_(x) noexcept(x)
#    define _LIBCPP_CONSTEXPR constexpr

#  else
# 567 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#    define _LIBCPP_ALIGNOF(_Tp) _Alignof(_Tp)
#    define _ALIGNAS_TYPE(x) __attribute__((__aligned__(_LIBCPP_ALIGNOF(x))))
#    define _ALIGNAS(x) __attribute__((__aligned__(x)))
#    define _LIBCPP_NORETURN __attribute__((__noreturn__))
#    define _LIBCPP_HAS_NO_NOEXCEPT
#    define nullptr __nullptr
#    define _NOEXCEPT throw()
#    define _NOEXCEPT_(x)
#    define static_assert(...) _Static_assert(__VA_ARGS__)
#    define decltype(...) __decltype(__VA_ARGS__)
#    define _LIBCPP_CONSTEXPR

typedef __char16_t char16_t;
typedef __char32_t char32_t;

#  endif
# 584 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#if 0 /* disabled by -frewrite-includes */
#  if !defined(__cpp_exceptions) || __cpp_exceptions < 199711L
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 586 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_HAS_NO_EXCEPTIONS
#  endif
# 588 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#  define _LIBCPP_PREFERRED_ALIGNOF(_Tp) __alignof(_Tp)

#if 0 /* disabled by -frewrite-includes */
#  if defined(_LIBCPP_COMPILER_CLANG_BASED)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 592 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#if 0 /* disabled by -frewrite-includes */
#    if defined(__APPLE__)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 594 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#if 0 /* disabled by -frewrite-includes */
#      if defined(__i386__) || defined(__x86_64__)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 595 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
// use old string layout on x86_64 and i386
#if 0 /* disabled by -frewrite-includes */
#if 0
#      elif defined(__arm__)
#endif
#endif /* disabled by -frewrite-includes */
#elif 0 /* evaluated by -frewrite-includes */
# 597 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
// use old string layout on arm (which does not include aarch64/arm64), except on watch ABIs
#if 0 /* disabled by -frewrite-includes */
#        if defined(__ARM_ARCH_7K__) && __ARM_ARCH_7K__ >= 2
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 599 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#          define _LIBCPP_ABI_ALTERNATE_STRING_LAYOUT
#        endif
# 601 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#      else
# 602 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#        define _LIBCPP_ABI_ALTERNATE_STRING_LAYOUT
#      endif
# 604 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    endif
# 605 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

// Objective-C++ features (opt-in)
#if 0 /* disabled by -frewrite-includes */
#    if __has_feature(objc_arc)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 608 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#      define _LIBCPP_HAS_OBJC_ARC
#    endif
# 610 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#if 0 /* disabled by -frewrite-includes */
#    if __has_feature(objc_arc_weak)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 612 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#      define _LIBCPP_HAS_OBJC_ARC_WEAK
#    endif
# 614 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#if 0 /* disabled by -frewrite-includes */
#    if __has_extension(blocks)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 616 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#      define _LIBCPP_HAS_EXTENSION_BLOCKS
#    endif
# 618 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#if 0 /* disabled by -frewrite-includes */
#    if defined(_LIBCPP_HAS_EXTENSION_BLOCKS) && defined(__APPLE__)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 620 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#      define _LIBCPP_HAS_BLOCKS_RUNTIME
#    endif
# 622 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#if 0 /* disabled by -frewrite-includes */
#    if !__has_feature(address_sanitizer)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 624 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#      define _LIBCPP_HAS_NO_ASAN
#    endif
# 626 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

// Allow for build-time disabling of unsigned integer sanitization
#if 0 /* disabled by -frewrite-includes */
#    if __has_attribute(no_sanitize)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 629 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#      define _LIBCPP_DISABLE_UBSAN_UNSIGNED_INTEGER_CHECK __attribute__((__no_sanitize__("unsigned-integer-overflow")))
#    endif
# 631 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#    define _LIBCPP_ALWAYS_INLINE __attribute__((__always_inline__))

#    define _LIBCPP_DISABLE_EXTENSION_WARNING __extension__

#if 0 /* disabled by -frewrite-includes */
#if 0
#  elif defined(_LIBCPP_COMPILER_GCC)
#endif
#endif /* disabled by -frewrite-includes */
#elif 0 /* evaluated by -frewrite-includes */
# 637 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#if 0 /* disabled by -frewrite-includes */
#    if !defined(__SANITIZE_ADDRESS__)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 639 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#      define _LIBCPP_HAS_NO_ASAN
#    endif
# 641 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#    define _LIBCPP_ALWAYS_INLINE __attribute__((__always_inline__))

#    define _LIBCPP_DISABLE_EXTENSION_WARNING __extension__

#  endif // _LIBCPP_COMPILER_[CLANG|GCC]
# 647 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#if 0 /* disabled by -frewrite-includes */
#  if defined(_LIBCPP_OBJECT_FORMAT_COFF)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 649 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#    ifdef _DLL
#      define _LIBCPP_CRT_FUNC __declspec(dllimport)
#    else
# 653 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#      define _LIBCPP_CRT_FUNC
#    endif
# 655 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#if 0 /* disabled by -frewrite-includes */
#    if defined(_LIBCPP_DISABLE_VISIBILITY_ANNOTATIONS) || (defined(__MINGW32__) && !defined(_LIBCPP_BUILDING_LIBRARY))
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 657 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#      define _LIBCPP_DLL_VIS
#      define _LIBCPP_EXTERN_TEMPLATE_TYPE_VIS
#      define _LIBCPP_CLASS_TEMPLATE_INSTANTIATION_VIS
#      define _LIBCPP_OVERRIDABLE_FUNC_VIS
#      define _LIBCPP_EXPORTED_FROM_ABI
#if 0 /* disabled by -frewrite-includes */
#if 0
#    elif defined(_LIBCPP_BUILDING_LIBRARY)
#endif
#endif /* disabled by -frewrite-includes */
#elif 0 /* evaluated by -frewrite-includes */
# 663 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#      define _LIBCPP_DLL_VIS __declspec(dllexport)
#if 0 /* disabled by -frewrite-includes */
#      if defined(__MINGW32__)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 665 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#        define _LIBCPP_EXTERN_TEMPLATE_TYPE_VIS _LIBCPP_DLL_VIS
#        define _LIBCPP_CLASS_TEMPLATE_INSTANTIATION_VIS
#      else
# 668 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#        define _LIBCPP_EXTERN_TEMPLATE_TYPE_VIS
#        define _LIBCPP_CLASS_TEMPLATE_INSTANTIATION_VIS _LIBCPP_DLL_VIS
#      endif
# 671 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#      define _LIBCPP_OVERRIDABLE_FUNC_VIS _LIBCPP_DLL_VIS
#      define _LIBCPP_EXPORTED_FROM_ABI __declspec(dllexport)
#    else
# 674 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#      define _LIBCPP_DLL_VIS __declspec(dllimport)
#      define _LIBCPP_EXTERN_TEMPLATE_TYPE_VIS _LIBCPP_DLL_VIS
#      define _LIBCPP_CLASS_TEMPLATE_INSTANTIATION_VIS
#      define _LIBCPP_OVERRIDABLE_FUNC_VIS
#      define _LIBCPP_EXPORTED_FROM_ABI __declspec(dllimport)
#    endif
# 680 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#    define _LIBCPP_HIDDEN
#    define _LIBCPP_METHOD_TEMPLATE_IMPLICIT_INSTANTIATION_VIS
#    define _LIBCPP_TEMPLATE_VIS
#    define _LIBCPP_TEMPLATE_DATA_VIS
#    define _LIBCPP_TYPE_VISIBILITY_DEFAULT

#  else
# 688 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#if 0 /* disabled by -frewrite-includes */
#    if !defined(_LIBCPP_DISABLE_VISIBILITY_ANNOTATIONS)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 690 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#      define _LIBCPP_VISIBILITY(vis) __attribute__((__visibility__(vis)))
#    else
# 692 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#      define _LIBCPP_VISIBILITY(vis)
#    endif
# 694 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#    define _LIBCPP_HIDDEN _LIBCPP_VISIBILITY("hidden")
#    define _LIBCPP_TEMPLATE_DATA_VIS _LIBCPP_VISIBILITY("default")
#    define _LIBCPP_EXPORTED_FROM_ABI _LIBCPP_VISIBILITY("default")
#    define _LIBCPP_EXTERN_TEMPLATE_TYPE_VIS _LIBCPP_VISIBILITY("default")
#    define _LIBCPP_CLASS_TEMPLATE_INSTANTIATION_VIS

// TODO: Make this a proper customization point or remove the option to override it.
#    ifndef _LIBCPP_OVERRIDABLE_FUNC_VIS
#      define _LIBCPP_OVERRIDABLE_FUNC_VIS _LIBCPP_VISIBILITY("default")
#    endif
# 705 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#if 0 /* disabled by -frewrite-includes */
#    if !defined(_LIBCPP_DISABLE_VISIBILITY_ANNOTATIONS)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 707 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
// The inline should be removed once PR32114 is resolved
#      define _LIBCPP_METHOD_TEMPLATE_IMPLICIT_INSTANTIATION_VIS inline _LIBCPP_HIDDEN
#    else
# 710 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#      define _LIBCPP_METHOD_TEMPLATE_IMPLICIT_INSTANTIATION_VIS
#    endif
# 712 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

// GCC doesn't support the type_visibility attribute, so we have to keep the visibility attribute on templates
#if 0 /* disabled by -frewrite-includes */
#    if !defined(_LIBCPP_DISABLE_VISIBILITY_ANNOTATIONS) && !__has_attribute(__type_visibility__)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 715 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#      define _LIBCPP_TEMPLATE_VIS __attribute__((__visibility__("default")))
#    else
# 717 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#      define _LIBCPP_TEMPLATE_VIS
#    endif
# 719 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#if 0 /* disabled by -frewrite-includes */
#    if !defined(_LIBCPP_DISABLE_VISIBILITY_ANNOTATIONS) && __has_attribute(__type_visibility__)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 721 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#      define _LIBCPP_TYPE_VISIBILITY_DEFAULT __attribute__((__type_visibility__("default")))
#    else
# 723 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#      define _LIBCPP_TYPE_VISIBILITY_DEFAULT
#    endif
# 725 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#  endif // defined(_LIBCPP_OBJECT_FORMAT_COFF)
# 727 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#if 0 /* disabled by -frewrite-includes */
#  if __has_attribute(exclude_from_explicit_instantiation)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 729 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_EXCLUDE_FROM_EXPLICIT_INSTANTIATION __attribute__((__exclude_from_explicit_instantiation__))
#  else
# 731 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
// Try to approximate the effect of exclude_from_explicit_instantiation
// (which is that entities are not assumed to be provided by explicit
// template instantiations in the dylib) by always inlining those entities.
#    define _LIBCPP_EXCLUDE_FROM_EXPLICIT_INSTANTIATION _LIBCPP_ALWAYS_INLINE
#  endif
# 736 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

// This macro marks a symbol as being hidden from libc++'s ABI. This is achieved
// on two levels:
// 1. The symbol is given hidden visibility, which ensures that users won't start exporting
//    symbols from their dynamic library by means of using the libc++ headers. This ensures
//    that those symbols stay private to the dynamic library in which it is defined.
//
// 2. The symbol is given an ABI tag that changes with each version of libc++. This ensures
//    that no ODR violation can arise from mixing two TUs compiled with different versions
//    of libc++ where we would have changed the definition of a symbol. If the symbols shared
//    the same name, the ODR would require that their definitions be token-by-token equivalent,
//    which basically prevents us from being able to make any change to any function in our
//    headers. Using this ABI tag ensures that the symbol name is "bumped" artificially at
//    each release, which lets us change the definition of these symbols at our leisure.
//    Note that historically, this has been achieved in various ways, including force-inlining
//    all functions or giving internal linkage to all functions. Both these (previous) solutions
//    suffer from drawbacks that lead notably to code bloat.
//
// Note that we use _LIBCPP_EXCLUDE_FROM_EXPLICIT_INSTANTIATION to ensure that we don't depend
// on _LIBCPP_HIDE_FROM_ABI methods of classes explicitly instantiated in the dynamic library.
//
// Also note that the _LIBCPP_HIDE_FROM_ABI_VIRTUAL macro should be used on virtual functions
// instead of _LIBCPP_HIDE_FROM_ABI. That macro does not use an ABI tag. Indeed, the mangled
// name of a virtual function is part of its ABI, since some architectures like arm64e can sign
// the virtual function pointer in the vtable based on the mangled name of the function. Since
// we use an ABI tag that changes with each released version, the mangled name of the virtual
// function would change, which is incorrect. Note that it doesn't make much sense to change
// the implementation of a virtual function in an ABI-incompatible way in the first place,
// since that would be an ABI break anyway. Hence, the lack of ABI tag should not be noticeable.
//
// TODO: We provide a escape hatch with _LIBCPP_NO_ABI_TAG for folks who want to avoid increasing
//       the length of symbols with an ABI tag. In practice, we should remove the escape hatch and
//       use compression mangling instead, see https://github.com/itanium-cxx-abi/cxx-abi/issues/70.
#  ifndef _LIBCPP_NO_ABI_TAG
#    define _LIBCPP_HIDE_FROM_ABI                                                                                      \
      _LIBCPP_HIDDEN _LIBCPP_EXCLUDE_FROM_EXPLICIT_INSTANTIATION                                                       \
          __attribute__((__abi_tag__(_LIBCPP_TOSTRING(_LIBCPP_VERSIONED_IDENTIFIER))))
#  else
# 774 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_HIDE_FROM_ABI _LIBCPP_HIDDEN _LIBCPP_EXCLUDE_FROM_EXPLICIT_INSTANTIATION
#  endif
# 776 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#  define _LIBCPP_HIDE_FROM_ABI_VIRTUAL _LIBCPP_HIDDEN _LIBCPP_EXCLUDE_FROM_EXPLICIT_INSTANTIATION

// This macro provides a HIDE_FROM_ABI equivalent that can be applied to extern
// "C" function, as those lack mangling.
#  define _LIBCPP_HIDE_FROM_ABI_C _LIBCPP_HIDDEN _LIBCPP_EXCLUDE_FROM_EXPLICIT_INSTANTIATION

#  ifdef _LIBCPP_BUILDING_LIBRARY
#if 0 /* disabled by -frewrite-includes */
#    if _LIBCPP_ABI_VERSION > 1
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 784 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#      define _LIBCPP_HIDE_FROM_ABI_AFTER_V1 _LIBCPP_HIDE_FROM_ABI
#    else
# 786 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#      define _LIBCPP_HIDE_FROM_ABI_AFTER_V1
#    endif
# 788 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#  else
# 789 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_HIDE_FROM_ABI_AFTER_V1 _LIBCPP_HIDE_FROM_ABI
#  endif
# 791 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

// Just so we can migrate to the new macros gradually.
#  define _LIBCPP_INLINE_VISIBILITY _LIBCPP_HIDE_FROM_ABI

// Inline namespaces are available in Clang/GCC/MSVC regardless of C++ dialect.
// clang-format off
#  define _LIBCPP_BEGIN_NAMESPACE_STD namespace _LIBCPP_TYPE_VISIBILITY_DEFAULT std {                                  \
                               inline namespace _LIBCPP_ABI_NAMESPACE {
#  define _LIBCPP_END_NAMESPACE_STD }}
#  define _VSTD std

_LIBCPP_BEGIN_NAMESPACE_STD _LIBCPP_END_NAMESPACE_STD

#if 0 /* disabled by -frewrite-includes */
#  if _LIBCPP_STD_VER >= 17
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 805 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_BEGIN_NAMESPACE_FILESYSTEM                                                                         \
       _LIBCPP_BEGIN_NAMESPACE_STD inline namespace __fs { namespace filesystem {
#  else
# 808 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_BEGIN_NAMESPACE_FILESYSTEM                                                                         \
      _LIBCPP_BEGIN_NAMESPACE_STD namespace __fs { namespace filesystem {
#  endif
# 811 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#  define _LIBCPP_END_NAMESPACE_FILESYSTEM _LIBCPP_END_NAMESPACE_STD }}
// clang-format on

#  define _VSTD_FS std::__fs::filesystem

#if 0 /* disabled by -frewrite-includes */
#  if __has_attribute(__enable_if__)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 818 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_PREFERRED_OVERLOAD __attribute__((__enable_if__(true, "")))
#  endif
# 820 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#if 0 /* disabled by -frewrite-includes */
#  if !defined(__SIZEOF_INT128__) || defined(_MSC_VER)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 822 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_HAS_NO_INT128
#  endif
# 824 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#if 0 /* disabled by -frewrite-includes */
#  if __has_attribute(__malloc__)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 826 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_NOALIAS __attribute__((__malloc__))
#  else
# 828 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_NOALIAS
#  endif
# 830 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#if 0 /* disabled by -frewrite-includes */
#  if __has_attribute(__using_if_exists__)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 832 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_USING_IF_EXISTS __attribute__((__using_if_exists__))
#  else
# 834 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_USING_IF_EXISTS
#  endif
# 836 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#  ifdef _LIBCPP_CXX03_LANG
#    define _LIBCPP_DECLARE_STRONG_ENUM(x)                                                                             \
      struct _LIBCPP_EXPORTED_FROM_ABI x {                                                                             \
        enum __lx
// clang-format off
#    define _LIBCPP_DECLARE_STRONG_ENUM_EPILOG(x)                                                                      \
      __lx __v_;                                                                                                       \
      _LIBCPP_INLINE_VISIBILITY x(__lx __v) : __v_(__v) {}                                                             \
      _LIBCPP_INLINE_VISIBILITY explicit x(int __v) : __v_(static_cast<__lx>(__v)) {}                                  \
      _LIBCPP_INLINE_VISIBILITY operator int() const { return __v_; }                                                  \
      };
// clang-format on

#  else // _LIBCPP_CXX03_LANG
# 851 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_DECLARE_STRONG_ENUM(x) enum class x
#    define _LIBCPP_DECLARE_STRONG_ENUM_EPILOG(x)
#  endif // _LIBCPP_CXX03_LANG
# 854 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#if 0 /* disabled by -frewrite-includes */
#  if defined(__APPLE__) || defined(__FreeBSD__) || defined(_LIBCPP_MSVCRT_LIKE) || defined(__NetBSD__)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 856 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_LOCALE__L_EXTENSIONS 1
#  endif
# 858 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#  ifdef __FreeBSD__
#    define _DECLARE_C99_LDBL_MATH 1
#  endif
# 862 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

// If we are getting operator new from the MSVC CRT, then allocation overloads
// for align_val_t were added in 19.12, aka VS 2017 version 15.3.
#if 0 /* disabled by -frewrite-includes */
#  if defined(_LIBCPP_MSVCRT) && defined(_MSC_VER) && _MSC_VER < 1912
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 866 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_HAS_NO_LIBRARY_ALIGNED_ALLOCATION
#if 0 /* disabled by -frewrite-includes */
#if 0
#  elif defined(_LIBCPP_ABI_VCRUNTIME) && !defined(__cpp_aligned_new)
#endif
#endif /* disabled by -frewrite-includes */
#elif 0 /* evaluated by -frewrite-includes */
# 868 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
// We're deferring to Microsoft's STL to provide aligned new et al. We don't
// have it unless the language feature test macro is defined.
#    define _LIBCPP_HAS_NO_LIBRARY_ALIGNED_ALLOCATION
#if 0 /* disabled by -frewrite-includes */
#if 0
#  elif defined(__MVS__)
#endif
#endif /* disabled by -frewrite-includes */
#elif 0 /* evaluated by -frewrite-includes */
# 872 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_HAS_NO_LIBRARY_ALIGNED_ALLOCATION
#  endif
# 874 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#if 0 /* disabled by -frewrite-includes */
#  if defined(_LIBCPP_HAS_NO_LIBRARY_ALIGNED_ALLOCATION) || (!defined(__cpp_aligned_new) || __cpp_aligned_new < 201606)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 876 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_HAS_NO_ALIGNED_ALLOCATION
#  endif
# 878 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

// It is not yet possible to use aligned_alloc() on all Apple platforms since
// 10.15 was the first version to ship an implementation of aligned_alloc().
#if 0 /* disabled by -frewrite-includes */
#  if defined(__APPLE__)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 882 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#if 0 /* disabled by -frewrite-includes */
#    if (defined(__ENVIRONMENT_MAC_OS_X_VERSION_MIN_REQUIRED__) &&                                                     \
         __ENVIRONMENT_MAC_OS_X_VERSION_MIN_REQUIRED__ < 101500)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 884 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#      define _LIBCPP_HAS_NO_C11_ALIGNED_ALLOC
#    endif
# 886 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#if 0 /* disabled by -frewrite-includes */
#if 0
#  elif defined(__ANDROID__) && __ANDROID_API__ < 28
#endif
#endif /* disabled by -frewrite-includes */
#elif 0 /* evaluated by -frewrite-includes */
# 887 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
// Android only provides aligned_alloc when targeting API 28 or higher.
#    define _LIBCPP_HAS_NO_C11_ALIGNED_ALLOC
#  endif
# 890 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#if 0 /* disabled by -frewrite-includes */
#  if defined(__APPLE__) || defined(__FreeBSD__)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 892 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_HAS_DEFAULTRUNELOCALE
#  endif
# 894 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#if 0 /* disabled by -frewrite-includes */
#  if defined(__APPLE__) || defined(__FreeBSD__)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 896 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_WCTYPE_IS_MASK
#  endif
# 898 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#if 0 /* disabled by -frewrite-includes */
#  if _LIBCPP_STD_VER <= 17 || !defined(__cpp_char8_t)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 900 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_HAS_NO_CHAR8_T
#  endif
# 902 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

// Deprecation macros.
//
// Deprecations warnings are always enabled, except when users explicitly opt-out
// by defining _LIBCPP_DISABLE_DEPRECATION_WARNINGS.
#if 0 /* disabled by -frewrite-includes */
#  if !defined(_LIBCPP_DISABLE_DEPRECATION_WARNINGS)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 908 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#if 0 /* disabled by -frewrite-includes */
#    if __has_attribute(__deprecated__)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 909 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#      define _LIBCPP_DEPRECATED __attribute__((__deprecated__))
#      define _LIBCPP_DEPRECATED_(m) __attribute__((__deprecated__(m)))
#if 0 /* disabled by -frewrite-includes */
#if 0
#    elif _LIBCPP_STD_VER >= 14
#endif
#endif /* disabled by -frewrite-includes */
#elif 0 /* evaluated by -frewrite-includes */
# 912 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#      define _LIBCPP_DEPRECATED [[deprecated]]
#      define _LIBCPP_DEPRECATED_(m) [[deprecated(m)]]
#    else
# 915 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#      define _LIBCPP_DEPRECATED
#      define _LIBCPP_DEPRECATED_(m)
#    endif
# 918 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#  else
# 919 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_DEPRECATED
#    define _LIBCPP_DEPRECATED_(m)
#  endif
# 922 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#if 0 /* disabled by -frewrite-includes */
#  if !defined(_LIBCPP_CXX03_LANG)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 924 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_DEPRECATED_IN_CXX11 _LIBCPP_DEPRECATED
#  else
# 926 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_DEPRECATED_IN_CXX11
#  endif
# 928 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#if 0 /* disabled by -frewrite-includes */
#  if _LIBCPP_STD_VER >= 14
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 930 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_DEPRECATED_IN_CXX14 _LIBCPP_DEPRECATED
#  else
# 932 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_DEPRECATED_IN_CXX14
#  endif
# 934 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#if 0 /* disabled by -frewrite-includes */
#  if _LIBCPP_STD_VER >= 17
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 936 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_DEPRECATED_IN_CXX17 _LIBCPP_DEPRECATED
#  else
# 938 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_DEPRECATED_IN_CXX17
#  endif
# 940 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#if 0 /* disabled by -frewrite-includes */
#  if _LIBCPP_STD_VER >= 20
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 942 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_DEPRECATED_IN_CXX20 _LIBCPP_DEPRECATED
#  else
# 944 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_DEPRECATED_IN_CXX20
#  endif
# 946 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#if 0 /* disabled by -frewrite-includes */
#  if _LIBCPP_STD_VER >= 23
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 948 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_DEPRECATED_IN_CXX23 _LIBCPP_DEPRECATED
#  else
# 950 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_DEPRECATED_IN_CXX23
#  endif
# 952 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#if 0 /* disabled by -frewrite-includes */
#  if !defined(_LIBCPP_HAS_NO_CHAR8_T)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 954 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_DEPRECATED_WITH_CHAR8_T _LIBCPP_DEPRECATED
#  else
# 956 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_DEPRECATED_WITH_CHAR8_T
#  endif
# 958 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

// Macros to enter and leave a state where deprecation warnings are suppressed.
#if 0 /* disabled by -frewrite-includes */
#  if defined(_LIBCPP_COMPILER_CLANG_BASED) || defined(_LIBCPP_COMPILER_GCC)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 961 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_SUPPRESS_DEPRECATED_PUSH                                                                           \
      _Pragma("GCC diagnostic push") _Pragma("GCC diagnostic ignored \"-Wdeprecated\"")                                \
          _Pragma("GCC diagnostic ignored \"-Wdeprecated-declarations\"")
#    define _LIBCPP_SUPPRESS_DEPRECATED_POP _Pragma("GCC diagnostic pop")
#  else
# 966 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_SUPPRESS_DEPRECATED_PUSH
#    define _LIBCPP_SUPPRESS_DEPRECATED_POP
#  endif
# 969 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#if 0 /* disabled by -frewrite-includes */
#  if _LIBCPP_STD_VER <= 11
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 971 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_EXPLICIT_SINCE_CXX14
#  else
# 973 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_EXPLICIT_SINCE_CXX14 explicit
#  endif
# 975 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#if 0 /* disabled by -frewrite-includes */
#  if _LIBCPP_STD_VER >= 23
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 977 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_EXPLICIT_SINCE_CXX23 explicit
#  else
# 979 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_EXPLICIT_SINCE_CXX23
#  endif
# 981 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#if 0 /* disabled by -frewrite-includes */
#  if _LIBCPP_STD_VER >= 14
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 983 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_CONSTEXPR_SINCE_CXX14 constexpr
#  else
# 985 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_CONSTEXPR_SINCE_CXX14
#  endif
# 987 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#if 0 /* disabled by -frewrite-includes */
#  if _LIBCPP_STD_VER >= 17
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 989 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_CONSTEXPR_SINCE_CXX17 constexpr
#  else
# 991 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_CONSTEXPR_SINCE_CXX17
#  endif
# 993 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#if 0 /* disabled by -frewrite-includes */
#  if _LIBCPP_STD_VER >= 20
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 995 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_CONSTEXPR_SINCE_CXX20 constexpr
#  else
# 997 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_CONSTEXPR_SINCE_CXX20
#  endif
# 999 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#if 0 /* disabled by -frewrite-includes */
#  if _LIBCPP_STD_VER >= 23
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 1001 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_CONSTEXPR_SINCE_CXX23 constexpr
#  else
# 1003 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_CONSTEXPR_SINCE_CXX23
#  endif
# 1005 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#if 0 /* disabled by -frewrite-includes */
#  if __has_cpp_attribute(nodiscard)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 1007 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_NODISCARD [[__nodiscard__]]
#  else
# 1009 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
// We can't use GCC's [[gnu::warn_unused_result]] and
// __attribute__((warn_unused_result)), because GCC does not silence them via
// (void) cast.
#    define _LIBCPP_NODISCARD
#  endif
# 1014 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

// _LIBCPP_NODISCARD_EXT may be used to apply [[nodiscard]] to entities not
// specified as such as an extension.
#if 0 /* disabled by -frewrite-includes */
#  if !defined(_LIBCPP_DISABLE_NODISCARD_EXT)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 1018 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_NODISCARD_EXT _LIBCPP_NODISCARD
#  else
# 1020 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_NODISCARD_EXT
#  endif
# 1022 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#if 0 /* disabled by -frewrite-includes */
#  if _LIBCPP_STD_VER >= 20 || !defined(_LIBCPP_DISABLE_NODISCARD_EXT)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 1024 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_NODISCARD_AFTER_CXX17 _LIBCPP_NODISCARD
#  else
# 1026 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_NODISCARD_AFTER_CXX17
#  endif
# 1028 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#if 0 /* disabled by -frewrite-includes */
#  if __has_attribute(__no_destroy__)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 1030 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_NO_DESTROY __attribute__((__no_destroy__))
#  else
# 1032 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_NO_DESTROY
#  endif
# 1034 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#  ifndef _LIBCPP_HAS_NO_ASAN
    extern "C" _LIBCPP_EXPORTED_FROM_ABI void
    __sanitizer_annotate_contiguous_container(const void*, const void*, const void*, const void*);
#if 0 /* disabled by -frewrite-includes */
#    if _LIBCPP_CLANG_VER >= 1600
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 1039 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
extern "C" _LIBCPP_EXPORTED_FROM_ABI void __sanitizer_annotate_double_ended_contiguous_container(
    const void*, const void*, const void*, const void*, const void*, const void*);
extern "C" _LIBCPP_EXPORTED_FROM_ABI int
__sanitizer_verify_double_ended_contiguous_container(const void*, const void*, const void*, const void*);
#    endif
# 1044 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#  endif
# 1045 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

// Try to find out if RTTI is disabled.
#if 0 /* disabled by -frewrite-includes */
#  if !defined(__cpp_rtti) || __cpp_rtti < 199711L
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 1048 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_HAS_NO_RTTI
#  endif
# 1050 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#  ifndef _LIBCPP_WEAK
#    define _LIBCPP_WEAK __attribute__((__weak__))
#  endif
# 1054 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

// Thread API
// clang-format off
#if 0 /* disabled by -frewrite-includes */
#  if !defined(_LIBCPP_HAS_NO_THREADS) &&                                                                              \
      !defined(_LIBCPP_HAS_THREAD_API_PTHREAD) &&                                                                      \
      !defined(_LIBCPP_HAS_THREAD_API_WIN32) &&                                                                        \
      !defined(_LIBCPP_HAS_THREAD_API_EXTERNAL)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 1061 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#if 0 /* disabled by -frewrite-includes */
#    if defined(__FreeBSD__) ||                                                                                        \
        defined(__wasi__) ||                                                                                           \
        defined(__NetBSD__) ||                                                                                         \
        defined(__OpenBSD__) ||                                                                                        \
        defined(__NuttX__) ||                                                                                          \
        defined(__linux__) ||                                                                                          \
        defined(__GNU__) ||                                                                                            \
        defined(__APPLE__) ||                                                                                          \
        defined(__MVS__) ||                                                                                            \
        defined(_AIX) ||                                                                                               \
        defined(__EMSCRIPTEN__)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 1073 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
// clang-format on
#      define _LIBCPP_HAS_THREAD_API_PTHREAD
#if 0 /* disabled by -frewrite-includes */
#if 0
#    elif defined(__Fuchsia__)
#endif
#endif /* disabled by -frewrite-includes */
#elif 1 /* evaluated by -frewrite-includes */
# 1076 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
// TODO(44575): Switch to C11 thread API when possible.
#      define _LIBCPP_HAS_THREAD_API_PTHREAD
#if 0 /* disabled by -frewrite-includes */
#if 0
#    elif defined(_LIBCPP_WIN32API)
#endif
#endif /* disabled by -frewrite-includes */
#elif 0 /* evaluated by -frewrite-includes */
# 1079 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#      define _LIBCPP_HAS_THREAD_API_WIN32
#    else
# 1081 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#      error "No thread API"
#    endif // _LIBCPP_HAS_THREAD_API
# 1083 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#  endif   // _LIBCPP_HAS_NO_THREADS
# 1084 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#if 0 /* disabled by -frewrite-includes */
#  if defined(_LIBCPP_HAS_THREAD_API_PTHREAD)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 1086 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#if 0 /* disabled by -frewrite-includes */
#    if defined(__ANDROID__) && __ANDROID_API__ >= 30
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 1087 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#      define _LIBCPP_HAS_COND_CLOCKWAIT
#if 0 /* disabled by -frewrite-includes */
#if 0
#    elif defined(_LIBCPP_GLIBC_PREREQ)
#endif
#endif /* disabled by -frewrite-includes */
#elif 0 /* evaluated by -frewrite-includes */
# 1089 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#if 0 /* disabled by -frewrite-includes */
#      if _LIBCPP_GLIBC_PREREQ(2, 30)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 1090 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#        define _LIBCPP_HAS_COND_CLOCKWAIT
#      endif
# 1092 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    endif
# 1093 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#  endif
# 1094 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#if 0 /* disabled by -frewrite-includes */
#  if defined(_LIBCPP_HAS_NO_THREADS) && defined(_LIBCPP_HAS_THREAD_API_PTHREAD)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 1096 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    error _LIBCPP_HAS_THREAD_API_PTHREAD may only be defined when \
       _LIBCPP_HAS_NO_THREADS is not defined.
#  endif
# 1099 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#if 0 /* disabled by -frewrite-includes */
#  if defined(_LIBCPP_HAS_NO_THREADS) && defined(_LIBCPP_HAS_THREAD_API_EXTERNAL)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 1101 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    error _LIBCPP_HAS_THREAD_API_EXTERNAL may not be defined when \
       _LIBCPP_HAS_NO_THREADS is defined.
#  endif
# 1104 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#if 0 /* disabled by -frewrite-includes */
#  if defined(_LIBCPP_HAS_NO_MONOTONIC_CLOCK) && !defined(_LIBCPP_HAS_NO_THREADS)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 1106 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    error _LIBCPP_HAS_NO_MONOTONIC_CLOCK may only be defined when \
       _LIBCPP_HAS_NO_THREADS is defined.
#  endif
# 1109 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#if 0 /* disabled by -frewrite-includes */
#  if !defined(_LIBCPP_HAS_NO_THREADS) && !defined(__STDCPP_THREADS__)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 1111 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define __STDCPP_THREADS__ 1
#  endif
# 1113 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

// The glibc and Bionic implementation of pthreads implements
// pthread_mutex_destroy as nop for regular mutexes. Additionally, Win32
// mutexes have no destroy mechanism.
//
// This optimization can't be performed on Apple platforms, where
// pthread_mutex_destroy can allow the kernel to release resources.
// See https://llvm.org/D64298 for details.
//
// TODO(EricWF): Enable this optimization on Bionic after speaking to their
//               respective stakeholders.
// clang-format off
#if 0 /* disabled by -frewrite-includes */
#  if (defined(_LIBCPP_HAS_THREAD_API_PTHREAD) && defined(__GLIBC__)) ||                                               \
      (defined(_LIBCPP_HAS_THREAD_API_C11) && defined(__Fuchsia__)) ||                                                 \
       defined(_LIBCPP_HAS_THREAD_API_WIN32)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 1128 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
// clang-format on
#    define _LIBCPP_HAS_TRIVIAL_MUTEX_DESTRUCTION
#  endif
# 1131 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

// Destroying a condvar is a nop on Windows.
//
// This optimization can't be performed on Apple platforms, where
// pthread_cond_destroy can allow the kernel to release resources.
// See https://llvm.org/D64298 for details.
//
// TODO(EricWF): This is potentially true for some pthread implementations
// as well.
#if 0 /* disabled by -frewrite-includes */
#  if (defined(_LIBCPP_HAS_THREAD_API_C11) && defined(__Fuchsia__)) || defined(_LIBCPP_HAS_THREAD_API_WIN32)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 1141 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_HAS_TRIVIAL_CONDVAR_DESTRUCTION
#  endif
# 1143 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

// Some systems do not provide gets() in their C library, for security reasons.
#if 0 /* disabled by -frewrite-includes */
#  if defined(_LIBCPP_MSVCRT) || (defined(__FreeBSD_version) && __FreeBSD_version >= 1300043) || defined(__OpenBSD__)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 1146 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_C_HAS_NO_GETS
#  endif
# 1148 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#if 0 /* disabled by -frewrite-includes */
#  if defined(__BIONIC__) || defined(__NuttX__) || defined(__Fuchsia__) || defined(__wasi__) ||                        \
      defined(_LIBCPP_HAS_MUSL_LIBC) || defined(__OpenBSD__)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 1151 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_PROVIDES_DEFAULT_RUNE_TABLE
#  endif
# 1153 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#if 0 /* disabled by -frewrite-includes */
#  if __has_feature(cxx_atomic) || __has_extension(c_atomic) || __has_keyword(_Atomic)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 1155 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_HAS_C_ATOMIC_IMP
#if 0 /* disabled by -frewrite-includes */
#if 0
#  elif defined(_LIBCPP_COMPILER_GCC)
#endif
#endif /* disabled by -frewrite-includes */
#elif 0 /* evaluated by -frewrite-includes */
# 1157 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_HAS_GCC_ATOMIC_IMP
#  endif
# 1159 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#if 0 /* disabled by -frewrite-includes */
#  if !defined(_LIBCPP_HAS_C_ATOMIC_IMP) && !defined(_LIBCPP_HAS_GCC_ATOMIC_IMP) &&                                    \
      !defined(_LIBCPP_HAS_EXTERNAL_ATOMIC_IMP)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 1162 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_HAS_NO_ATOMIC_HEADER
#  else
# 1164 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    ifndef _LIBCPP_ATOMIC_FLAG_TYPE
#      define _LIBCPP_ATOMIC_FLAG_TYPE bool
#    endif
# 1167 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    ifdef _LIBCPP_FREESTANDING
#      define _LIBCPP_ATOMIC_ONLY_USE_BUILTINS
#    endif
# 1170 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#  endif
# 1171 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#  ifndef _LIBCPP_DISABLE_UBSAN_UNSIGNED_INTEGER_CHECK
#    define _LIBCPP_DISABLE_UBSAN_UNSIGNED_INTEGER_CHECK
#  endif
# 1175 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#if 0 /* disabled by -frewrite-includes */
#  if defined(__FreeBSD__) && defined(__clang__) && __has_attribute(__no_thread_safety_analysis__)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 1177 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_NO_THREAD_SAFETY_ANALYSIS __attribute__((__no_thread_safety_analysis__))
#  else
# 1179 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_NO_THREAD_SAFETY_ANALYSIS
#  endif
# 1181 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#if 0 /* disabled by -frewrite-includes */
#  if defined(_LIBCPP_ENABLE_THREAD_SAFETY_ANNOTATIONS)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 1183 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#if 0 /* disabled by -frewrite-includes */
#    if defined(__clang__) && __has_attribute(acquire_capability)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 1184 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
// Work around the attribute handling in clang.  When both __declspec and
// __attribute__ are present, the processing goes awry preventing the definition
// of the types. In MinGW mode, __declspec evaluates to __attribute__, and thus
// combining the two does work.
#if 0 /* disabled by -frewrite-includes */
#      if !defined(_MSC_VER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 1189 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#        define _LIBCPP_HAS_THREAD_SAFETY_ANNOTATIONS
#      endif
# 1191 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    endif
# 1192 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#  endif
# 1193 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#  ifdef _LIBCPP_HAS_THREAD_SAFETY_ANNOTATIONS
#    define _LIBCPP_THREAD_SAFETY_ANNOTATION(x) __attribute__((x))
#  else
# 1197 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_THREAD_SAFETY_ANNOTATION(x)
#  endif
# 1199 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#if 0 /* disabled by -frewrite-includes */
#  if _LIBCPP_STD_VER >= 20
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 1201 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_CONSTINIT constinit
#if 0 /* disabled by -frewrite-includes */
#if 0
#  elif __has_attribute(__require_constant_initialization__)
#endif
#endif /* disabled by -frewrite-includes */
#elif 1 /* evaluated by -frewrite-includes */
# 1203 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_CONSTINIT __attribute__((__require_constant_initialization__))
#  else
# 1205 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_CONSTINIT
#  endif
# 1207 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#if 0 /* disabled by -frewrite-includes */
#  if __has_attribute(__diagnose_if__) && !defined(_LIBCPP_DISABLE_ADDITIONAL_DIAGNOSTICS)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 1209 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_DIAGNOSE_WARNING(...) __attribute__((__diagnose_if__(__VA_ARGS__, "warning")))
#  else
# 1211 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_DIAGNOSE_WARNING(...)
#  endif
# 1213 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

// Use a function like macro to imply that it must be followed by a semicolon
#if 0 /* disabled by -frewrite-includes */
#  if __has_cpp_attribute(fallthrough)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 1216 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_FALLTHROUGH() [[fallthrough]]
#if 0 /* disabled by -frewrite-includes */
#if 0
#  elif __has_attribute(__fallthrough__)
#endif
#endif /* disabled by -frewrite-includes */
#elif 0 /* evaluated by -frewrite-includes */
# 1218 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_FALLTHROUGH() __attribute__((__fallthrough__))
#  else
# 1220 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_FALLTHROUGH() ((void)0)
#  endif
# 1222 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#if 0 /* disabled by -frewrite-includes */
#  if __has_cpp_attribute(_Clang::__lifetimebound__)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 1224 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_LIFETIMEBOUND [[_Clang::__lifetimebound__]]
#  else
# 1226 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_LIFETIMEBOUND
#  endif
# 1228 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#if 0 /* disabled by -frewrite-includes */
#  if __has_attribute(__nodebug__)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 1230 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_NODEBUG __attribute__((__nodebug__))
#  else
# 1232 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_NODEBUG
#  endif
# 1234 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#if 0 /* disabled by -frewrite-includes */
#  if __has_attribute(__standalone_debug__)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 1236 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_STANDALONE_DEBUG __attribute__((__standalone_debug__))
#  else
# 1238 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_STANDALONE_DEBUG
#  endif
# 1240 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#if 0 /* disabled by -frewrite-includes */
#  if __has_attribute(__preferred_name__)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 1242 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_PREFERRED_NAME(x) __attribute__((__preferred_name__(x)))
#  else
# 1244 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_PREFERRED_NAME(x)
#  endif
# 1246 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#if 0 /* disabled by -frewrite-includes */
#  if __has_attribute(__no_sanitize__)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 1248 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_NO_SANITIZE(...) __attribute__((__no_sanitize__(__VA_ARGS__)))
#  else
# 1250 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_NO_SANITIZE(...)
#  endif
# 1252 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

// We often repeat things just for handling wide characters in the library.
// When wide characters are disabled, it can be useful to have a quick way of
// disabling it without having to resort to #if-#endif, which has a larger
// impact on readability.
#if 0 /* disabled by -frewrite-includes */
#  if defined(_LIBCPP_HAS_NO_WIDE_CHARACTERS)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 1258 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_IF_WIDE_CHARACTERS(...)
#  else
# 1260 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_IF_WIDE_CHARACTERS(...) __VA_ARGS__
#  endif
# 1262 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#if 0 /* disabled by -frewrite-includes */
#  if defined(_LIBCPP_ABI_MICROSOFT) && __has_declspec_attribute(empty_bases)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 1264 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_DECLSPEC_EMPTY_BASES __declspec(empty_bases)
#  else
# 1266 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_DECLSPEC_EMPTY_BASES
#  endif
# 1268 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#if 0 /* disabled by -frewrite-includes */
#  if defined(_LIBCPP_ENABLE_CXX17_REMOVED_FEATURES)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 1270 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_ENABLE_CXX17_REMOVED_AUTO_PTR
#    define _LIBCPP_ENABLE_CXX17_REMOVED_BINDERS
#    define _LIBCPP_ENABLE_CXX17_REMOVED_RANDOM_SHUFFLE
#    define _LIBCPP_ENABLE_CXX17_REMOVED_UNEXPECTED_FUNCTIONS
#    define _LIBCPP_ENABLE_CXX17_REMOVED_UNARY_BINARY_FUNCTION
#  endif // _LIBCPP_ENABLE_CXX17_REMOVED_FEATURES
# 1276 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#if 0 /* disabled by -frewrite-includes */
#  if defined(_LIBCPP_ENABLE_CXX20_REMOVED_FEATURES)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 1278 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_ENABLE_CXX20_REMOVED_ALLOCATOR_MEMBERS
#    define _LIBCPP_ENABLE_CXX20_REMOVED_ALLOCATOR_VOID_SPECIALIZATION
#    define _LIBCPP_ENABLE_CXX20_REMOVED_BINDER_TYPEDEFS
#    define _LIBCPP_ENABLE_CXX20_REMOVED_NEGATORS
#    define _LIBCPP_ENABLE_CXX20_REMOVED_RAW_STORAGE_ITERATOR
#    define _LIBCPP_ENABLE_CXX20_REMOVED_TYPE_TRAITS
#  endif // _LIBCPP_ENABLE_CXX20_REMOVED_FEATURES
# 1285 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

// clang-format off
#  define _LIBCPP_PUSH_MACROS _Pragma("push_macro(\"min\")") _Pragma("push_macro(\"max\")") _Pragma("push_macro(\"refresh()\")") _Pragma("push_macro(\"move(int, int)\")") _Pragma("push_macro(\"erase()\")")
#  define _LIBCPP_POP_MACROS _Pragma("pop_macro(\"min\")") _Pragma("pop_macro(\"max\")") _Pragma("pop_macro(\"refresh()\")") _Pragma("pop_macro(\"move(int, int)\")") _Pragma("pop_macro(\"erase()\")")
// clang-format on

#  ifndef _LIBCPP_NO_AUTO_LINK
#if 0 /* disabled by -frewrite-includes */
#    if defined(_LIBCPP_ABI_MICROSOFT) && !defined(_LIBCPP_BUILDING_LIBRARY)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 1293 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#if 0 /* disabled by -frewrite-includes */
#      if !defined(_LIBCPP_DISABLE_VISIBILITY_ANNOTATIONS)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 1294 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#        pragma comment(lib, "c++.lib")
#      else
# 1296 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#        pragma comment(lib, "libc++.lib")
#      endif
# 1298 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    endif // defined(_LIBCPP_ABI_MICROSOFT) && !defined(_LIBCPP_BUILDING_LIBRARY)
# 1299 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#  endif   // _LIBCPP_NO_AUTO_LINK
# 1300 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

// Configures the fopen close-on-exec mode character, if any. This string will
// be appended to any mode string used by fstream for fopen/fdopen.
//
// Not all platforms support this, but it helps avoid fd-leaks on platforms that
// do.
#if 0 /* disabled by -frewrite-includes */
#  if defined(__BIONIC__)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 1307 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_FOPEN_CLOEXEC_MODE "e"
#  else
# 1309 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_FOPEN_CLOEXEC_MODE
#  endif
# 1311 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

// Support for _FILE_OFFSET_BITS=64 landed gradually in Android, so the full set
// of functions used in cstdio may not be available for low API levels when
// using 64-bit file offsets on LP32.
#if 0 /* disabled by -frewrite-includes */
#  if defined(__BIONIC__) && defined(__USE_FILE_OFFSET64) && __ANDROID_API__ < 24
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 1316 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_HAS_NO_FGETPOS_FSETPOS
#  endif
# 1318 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#if 0 /* disabled by -frewrite-includes */
#  if __has_attribute(__init_priority__)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 1320 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_INIT_PRIORITY_MAX __attribute__((__init_priority__(100)))
#  else
# 1322 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_INIT_PRIORITY_MAX
#  endif
# 1324 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#if 0 /* disabled by -frewrite-includes */
#  if __has_attribute(__format__)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 1326 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
// The attribute uses 1-based indices for ordinary and static member functions.
// The attribute uses 2-based indices for non-static member functions.
#    define _LIBCPP_ATTRIBUTE_FORMAT(archetype, format_string_index, first_format_arg_index)                           \
      __attribute__((__format__(archetype, format_string_index, first_format_arg_index)))
#  else
# 1331 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_ATTRIBUTE_FORMAT(archetype, format_string_index, first_format_arg_index) /* nothing */
#  endif
# 1333 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#if 0 /* disabled by -frewrite-includes */
#  if __has_cpp_attribute(msvc::no_unique_address)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 1335 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
// MSVC implements [[no_unique_address]] as a silent no-op currently.
// (If/when MSVC breaks its C++ ABI, it will be changed to work as intended.)
// However, MSVC implements [[msvc::no_unique_address]] which does what
// [[no_unique_address]] is supposed to do, in general.

// Clang-cl does not yet (14.0) implement either [[no_unique_address]] or
// [[msvc::no_unique_address]] though. If/when it does implement
// [[msvc::no_unique_address]], this should be preferred though.
#    define _LIBCPP_NO_UNIQUE_ADDRESS [[msvc::no_unique_address]]
#if 0 /* disabled by -frewrite-includes */
#if 0
#  elif __has_cpp_attribute(no_unique_address)
#endif
#endif /* disabled by -frewrite-includes */
#elif 1 /* evaluated by -frewrite-includes */
# 1345 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_NO_UNIQUE_ADDRESS [[__no_unique_address__]]
#  else
# 1347 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_NO_UNIQUE_ADDRESS /* nothing */
// Note that this can be replaced by #error as soon as clang-cl
// implements msvc::no_unique_address, since there should be no C++20
// compiler that doesn't support one of the two attributes at that point.
// We generally don't want to use this macro outside of C++20-only code,
// because using it conditionally in one language version only would make
// the ABI inconsistent.
#  endif
# 1355 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#  ifdef _LIBCPP_COMPILER_CLANG_BASED
#    define _LIBCPP_DIAGNOSTIC_PUSH _Pragma("clang diagnostic push")
#    define _LIBCPP_DIAGNOSTIC_POP _Pragma("clang diagnostic pop")
#    define _LIBCPP_CLANG_DIAGNOSTIC_IGNORED(str) _Pragma(_LIBCPP_TOSTRING(clang diagnostic ignored str))
#    define _LIBCPP_GCC_DIAGNOSTIC_IGNORED(str)
#if 0 /* disabled by -frewrite-includes */
#if 0
#  elif defined(_LIBCPP_COMPILER_GCC)
#endif
#endif /* disabled by -frewrite-includes */
#elif 0 /* evaluated by -frewrite-includes */
# 1362 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_DIAGNOSTIC_PUSH _Pragma("GCC diagnostic push")
#    define _LIBCPP_DIAGNOSTIC_POP _Pragma("GCC diagnostic pop")
#    define _LIBCPP_CLANG_DIAGNOSTIC_IGNORED(str)
#    define _LIBCPP_GCC_DIAGNOSTIC_IGNORED(str) _Pragma(_LIBCPP_TOSTRING(GCC diagnostic ignored str))
#  else
# 1367 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_DIAGNOSTIC_PUSH
#    define _LIBCPP_DIAGNOSTIC_POP
#    define _LIBCPP_CLANG_DIAGNOSTIC_IGNORED(str)
#    define _LIBCPP_GCC_DIAGNOSTIC_IGNORED(str)
#  endif
# 1372 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#if 0 /* disabled by -frewrite-includes */
#  if defined(_AIX) && !defined(_LIBCPP_COMPILER_GCC)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 1374 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_PACKED_BYTE_FOR_AIX _Pragma("pack(1)")
#    define _LIBCPP_PACKED_BYTE_FOR_AIX_END _Pragma("pack(pop)")
#  else
# 1377 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_PACKED_BYTE_FOR_AIX     /* empty */
#    define _LIBCPP_PACKED_BYTE_FOR_AIX_END /* empty */
#  endif
# 1380 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#if 0 /* disabled by -frewrite-includes */
#  if __has_attribute(__packed__)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 1382 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_PACKED __attribute__((__packed__))
#  else
# 1384 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_PACKED
#  endif
# 1386 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

// c8rtomb() and mbrtoc8() were added in C++20 and C23. Support for these
// functions is gradually being added to existing C libraries. The conditions
// below check for known C library versions and conditions under which these
// functions are declared by the C library.
#  define _LIBCPP_HAS_NO_C8RTOMB_MBRTOC8
// GNU libc 2.36 and newer declare c8rtomb() and mbrtoc8() in C++ modes if
// __cpp_char8_t is defined or if C2X extensions are enabled. Determining
// the latter depends on internal GNU libc details that are not appropriate
// to depend on here, so any declarations present when __cpp_char8_t is not
// defined are ignored.
#if 0 /* disabled by -frewrite-includes */
#  if defined(_LIBCPP_GLIBC_PREREQ)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 1398 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#if 0 /* disabled by -frewrite-includes */
#    if _LIBCPP_GLIBC_PREREQ(2, 36) && defined(__cpp_char8_t)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 1399 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#      undef _LIBCPP_HAS_NO_C8RTOMB_MBRTOC8
#    endif
# 1401 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#  endif
# 1402 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

// There are a handful of public standard library types that are intended to
// support CTAD but don't need any explicit deduction guides to do so. This
// macro is used to mark them as such, which suppresses the
// '-Wctad-maybe-unsupported' compiler warning when CTAD is used in user code
// with these classes.
#if 0 /* disabled by -frewrite-includes */
#  if _LIBCPP_STD_VER >= 17
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 1409 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    ifdef _LIBCPP_COMPILER_CLANG_BASED
#      define _LIBCPP_CTAD_SUPPORTED_FOR_TYPE(_ClassName)                                                              \
        template <class... _Tag>                                                                                       \
        [[maybe_unused]] _ClassName(typename _Tag::__allow_ctad...)->_ClassName<_Tag...>
#    else
# 1414 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#      define _LIBCPP_CTAD_SUPPORTED_FOR_TYPE(ClassName)                                                               \
        template <class... _Tag>                                                                                       \
        ClassName(typename _Tag::__allow_ctad...)->ClassName<_Tag...>
#    endif
# 1418 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#  else
# 1419 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#    define _LIBCPP_CTAD_SUPPORTED_FOR_TYPE(_ClassName) static_assert(true, "")
#  endif
# 1421 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

// TODO(varconst): currently, there are bugs in Clang's intrinsics when handling Objective-C++ `id`, so don't use
// compiler intrinsics in the Objective-C++ mode.
#  ifdef __OBJC__
#    define _LIBCPP_WORKAROUND_OBJCXX_COMPILER_INTRINSICS
#  endif
# 1427 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#  define _PSTL_PRAGMA(x) _Pragma(#x)

// Enable SIMD for compilers that support OpenMP 4.0
#if 0 /* disabled by -frewrite-includes */
#  if (defined(_OPENMP) && _OPENMP >= 201307)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 1432 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#    define _PSTL_UDR_PRESENT
#    define _PSTL_PRAGMA_SIMD _PSTL_PRAGMA(omp simd)
#    define _PSTL_PRAGMA_DECLARE_SIMD _PSTL_PRAGMA(omp declare simd)
#    define _PSTL_PRAGMA_SIMD_REDUCTION(PRM) _PSTL_PRAGMA(omp simd reduction(PRM))
#    define _PSTL_PRAGMA_SIMD_SCAN(PRM) _PSTL_PRAGMA(omp simd reduction(inscan, PRM))
#    define _PSTL_PRAGMA_SIMD_INCLUSIVE_SCAN(PRM) _PSTL_PRAGMA(omp scan inclusive(PRM))
#    define _PSTL_PRAGMA_SIMD_EXCLUSIVE_SCAN(PRM) _PSTL_PRAGMA(omp scan exclusive(PRM))

// Declaration of reduction functor, where
// NAME - the name of the functor
// OP - type of the callable object with the reduction operation
// omp_in - refers to the local partial result
// omp_out - refers to the final value of the combiner operator
// omp_priv - refers to the private copy of the initial value
// omp_orig - refers to the original variable to be reduced
#    define _PSTL_PRAGMA_DECLARE_REDUCTION(NAME, OP)                                                                   \
      _PSTL_PRAGMA(omp declare reduction(NAME:OP : omp_out(omp_in)) initializer(omp_priv = omp_orig))

#if 0 /* disabled by -frewrite-includes */
#if 0
#  elif defined(_LIBCPP_COMPILER_CLANG_BASED)
#endif
#endif /* disabled by -frewrite-includes */
#elif 1 /* evaluated by -frewrite-includes */
# 1452 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#    define _PSTL_PRAGMA_SIMD _Pragma("clang loop vectorize(enable) interleave(enable)")
#    define _PSTL_PRAGMA_DECLARE_SIMD
#    define _PSTL_PRAGMA_SIMD_REDUCTION(PRM) _Pragma("clang loop vectorize(enable) interleave(enable)")
#    define _PSTL_PRAGMA_SIMD_SCAN(PRM) _Pragma("clang loop vectorize(enable) interleave(enable)")
#    define _PSTL_PRAGMA_SIMD_INCLUSIVE_SCAN(PRM)
#    define _PSTL_PRAGMA_SIMD_EXCLUSIVE_SCAN(PRM)
#    define _PSTL_PRAGMA_DECLARE_REDUCTION(NAME, OP)

#  else // (defined(_OPENMP) && _OPENMP >= 201307)
# 1462 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#    define _PSTL_PRAGMA_SIMD
#    define _PSTL_PRAGMA_DECLARE_SIMD
#    define _PSTL_PRAGMA_SIMD_REDUCTION(PRM)
#    define _PSTL_PRAGMA_SIMD_SCAN(PRM)
#    define _PSTL_PRAGMA_SIMD_INCLUSIVE_SCAN(PRM)
#    define _PSTL_PRAGMA_SIMD_EXCLUSIVE_SCAN(PRM)
#    define _PSTL_PRAGMA_DECLARE_REDUCTION(NAME, OP)

#  endif // (defined(_OPENMP) && _OPENMP >= 201307)
# 1472 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#  define _PSTL_USE_NONTEMPORAL_STORES_IF_ALLOWED

#endif // __cplusplus
# 1476 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3

#endif // _LIBCPP___CONFIG
# 1478 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__config" 3
#endif /* __config expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__assert" 2 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* __verbose_abort expanded by -frewrite-includes */
#include <__verbose_abort>
#else /* __verbose_abort expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__assert" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__verbose_abort" 1 3
// -*- C++ -*-
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___VERBOSE_ABORT
#define _LIBCPP___VERBOSE_ABORT

#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* __availability expanded by -frewrite-includes */
#include <__availability>
#else /* __availability expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__verbose_abort" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__availability" 1 3
// -*- C++ -*-
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___AVAILABILITY
#define _LIBCPP___AVAILABILITY

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__availability" 3
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__availability" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__availability" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__availability" 3
#endif
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__availability" 3

// Libc++ is shipped by various vendors. In particular, it is used as a system
// library on macOS, iOS and other Apple platforms. In order for users to be
// able to compile a binary that is intended to be deployed to an older version
// of a platform, Clang provides availability attributes [1]. These attributes
// can be placed on declarations and are used to describe the life cycle of a
// symbol in the library.
//
// The main goal is to ensure a compile-time error if a symbol that hasn't been
// introduced in a previously released library is used in a program that targets
// that previously released library. Normally, this would be a load-time error
// when one tries to launch the program against the older library.
//
// For example, the filesystem library was introduced in the dylib in macOS 10.15.
// If a user compiles on a macOS 10.15 host but targets macOS 10.13 with their
// program, the compiler would normally not complain (because the required
// declarations are in the headers), but the dynamic loader would fail to find
// the symbols when actually trying to launch the program on macOS 10.13. To
// turn this into a compile-time issue instead, declarations are annotated with
// when they were introduced, and the compiler can produce a diagnostic if the
// program references something that isn't available on the deployment target.
//
// This mechanism is general in nature, and any vendor can add their markup to
// the library (see below). Whenever a new feature is added that requires support
// in the shared library, two macros are added below to allow marking the feature
// as unavailable:
// 1. A macro named `_LIBCPP_AVAILABILITY_HAS_NO_<feature>` which must be defined
//    exactly when compiling for a target that doesn't support the feature.
// 2. A macro named `_LIBCPP_AVAILABILITY_<feature>`, which must always be defined
//    and must expand to the proper availability attribute for the platform.
//
// When vendors decide to ship the feature as part of their shared library, they
// can update these macros appropriately for their platform, and the library will
// use those to provide an optimal user experience.
//
// Furthermore, many features in the standard library have corresponding
// feature-test macros. The `_LIBCPP_AVAILABILITY_HAS_NO_<feature>` macros
// are checked by the corresponding feature-test macros generated by
// generate_feature_test_macro_components.py to ensure that the library
// doesn't announce a feature as being implemented if it is unavailable on
// the deployment target.
//
// Note that this mechanism is disabled by default in the "upstream" libc++.
// Availability annotations are only meaningful when shipping libc++ inside
// a platform (i.e. as a system library), and so vendors that want them should
// turn those annotations on at CMake configuration time.
//
// [1]: https://clang.llvm.org/docs/AttributeReference.html#availability


// For backwards compatibility, allow users to define _LIBCPP_DISABLE_AVAILABILITY
// for a while.
#if 0 /* disabled by -frewrite-includes */
#if defined(_LIBCPP_DISABLE_AVAILABILITY)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 71 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__availability" 3
#if 0 /* disabled by -frewrite-includes */
#   if !defined(_LIBCPP_HAS_NO_VENDOR_AVAILABILITY_ANNOTATIONS)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 72 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__availability" 3
#       define _LIBCPP_HAS_NO_VENDOR_AVAILABILITY_ANNOTATIONS
#   endif
# 74 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__availability" 3
#endif
# 75 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__availability" 3

// Availability markup is disabled when building the library, or when the compiler
// doesn't support the proper attributes.
#if 0 /* disabled by -frewrite-includes */
#if defined(_LIBCPP_BUILDING_LIBRARY) ||                                        \
    defined(_LIBCXXABI_BUILDING_LIBRARY) ||                                     \
    !__has_feature(attribute_availability_with_strict) ||                       \
    !__has_feature(attribute_availability_in_templates) ||                      \
    !__has_extension(pragma_clang_attribute_external_declaration)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 83 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__availability" 3
#if 0 /* disabled by -frewrite-includes */
#   if !defined(_LIBCPP_HAS_NO_VENDOR_AVAILABILITY_ANNOTATIONS)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 84 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__availability" 3
#       define _LIBCPP_HAS_NO_VENDOR_AVAILABILITY_ANNOTATIONS
#   endif
# 86 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__availability" 3
#endif
# 87 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__availability" 3

#if 0 /* disabled by -frewrite-includes */
#if defined(_LIBCPP_HAS_NO_VENDOR_AVAILABILITY_ANNOTATIONS)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 89 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__availability" 3

    // This controls the availability of std::shared_mutex and std::shared_timed_mutex,
    // which were added to the dylib later.
// #   define _LIBCPP_AVAILABILITY_HAS_NO_SHARED_MUTEX
#   define _LIBCPP_AVAILABILITY_SHARED_MUTEX

    // These macros control the availability of std::bad_optional_access and
    // other exception types. These were put in the shared library to prevent
    // code bloat from every user program defining the vtable for these exception
    // types.
    //
    // Note that when exceptions are disabled, the methods that normally throw
    // these exceptions can be used even on older deployment targets, but those
    // methods will abort instead of throwing.
// #   define _LIBCPP_AVAILABILITY_HAS_NO_BAD_OPTIONAL_ACCESS
#   define _LIBCPP_AVAILABILITY_BAD_OPTIONAL_ACCESS

// #   define _LIBCPP_AVAILABILITY_HAS_NO_BAD_VARIANT_ACCESS
#   define _LIBCPP_AVAILABILITY_BAD_VARIANT_ACCESS

// #   define _LIBCPP_AVAILABILITY_HAS_NO_BAD_ANY_CAST
#   define _LIBCPP_AVAILABILITY_BAD_ANY_CAST

    // This controls the availability of std::uncaught_exceptions().
// #   define _LIBCPP_AVAILABILITY_HAS_NO_UNCAUGHT_EXCEPTIONS
#   define _LIBCPP_AVAILABILITY_UNCAUGHT_EXCEPTIONS

    // This controls the availability of the sized version of ::operator delete,
    // ::operator delete[], and their align_val_t variants, which were all added
    // in C++17, and hence not present in early dylibs.
// #   define _LIBCPP_AVAILABILITY_HAS_NO_SIZED_NEW_DELETE
#   define _LIBCPP_AVAILABILITY_SIZED_NEW_DELETE

    // This controls the availability of the std::future_error exception.
    //
    // Note that when exceptions are disabled, the methods that normally throw
    // std::future_error can be used even on older deployment targets, but those
    // methods will abort instead of throwing.
// #   define _LIBCPP_AVAILABILITY_HAS_NO_FUTURE_ERROR
#   define _LIBCPP_AVAILABILITY_FUTURE_ERROR

    // This controls the availability of std::type_info's vtable.
    // I can't imagine how using std::type_info can work at all if
    // this isn't supported.
// #   define _LIBCPP_AVAILABILITY_HAS_NO_TYPEINFO_VTABLE
#   define _LIBCPP_AVAILABILITY_TYPEINFO_VTABLE

    // This controls the availability of std::locale::category members
    // (e.g. std::locale::collate), which are defined in the dylib.
// #   define _LIBCPP_AVAILABILITY_HAS_NO_LOCALE_CATEGORY
#   define _LIBCPP_AVAILABILITY_LOCALE_CATEGORY

    // This controls the availability of atomic operations on std::shared_ptr
    // (e.g. `std::atomic_store(std::shared_ptr)`), which require a shared
    // lock table located in the dylib.
// #   define _LIBCPP_AVAILABILITY_HAS_NO_ATOMIC_SHARED_PTR
#   define _LIBCPP_AVAILABILITY_ATOMIC_SHARED_PTR

    // These macros control the availability of all parts of <filesystem> that
    // depend on something in the dylib.
// #   define _LIBCPP_AVAILABILITY_HAS_NO_FILESYSTEM_LIBRARY
#   define _LIBCPP_AVAILABILITY_FILESYSTEM_LIBRARY
#   define _LIBCPP_AVAILABILITY_FILESYSTEM_LIBRARY_PUSH
#   define _LIBCPP_AVAILABILITY_FILESYSTEM_LIBRARY_POP

    // This controls the availability of floating-point std::to_chars functions.
    // These overloads were added later than the integer overloads.
// #   define _LIBCPP_AVAILABILITY_HAS_NO_TO_CHARS_FLOATING_POINT
#   define _LIBCPP_AVAILABILITY_TO_CHARS_FLOATING_POINT

    // This controls the availability of the C++20 synchronization library,
    // which requires shared library support for various operations
    // (see libcxx/src/atomic.cpp). This includes <barier>, <latch>,
    // <semaphore>, and notification functions on std::atomic.
// #   define _LIBCPP_AVAILABILITY_HAS_NO_SYNC
#   define _LIBCPP_AVAILABILITY_SYNC

    // This controls whether the library claims to provide a default verbose
    // termination function, and consequently whether the headers will try
    // to use it when the mechanism isn't overriden at compile-time.
// #   define _LIBCPP_AVAILABILITY_HAS_NO_VERBOSE_ABORT
#   define _LIBCPP_AVAILABILITY_VERBOSE_ABORT

    // This controls the availability of the C++17 std::pmr library,
    // which is implemented in large part in the built library.
// #   define _LIBCPP_AVAILABILITY_HAS_NO_PMR
#   define _LIBCPP_AVAILABILITY_PMR

    // This controls the availability of the C++20 time zone database.
    // The parser code is built in the library.
// #   define _LIBCPP_AVAILABILITY_HAS_NO_TZDB
#   define _LIBCPP_AVAILABILITY_TZDB

// Enable additional explicit instantiations of iostreams components. This
// reduces the number of weak definitions generated in programs that use
// iostreams by providing a single strong definition in the shared library.
//
// TODO: Enable additional explicit instantiations on GCC once it supports exclude_from_explicit_instantiation,
//       or once libc++ doesn't use the attribute anymore.
// TODO: Enable them on Windows once https://llvm.org/PR41018 has been fixed.
#if 0 /* disabled by -frewrite-includes */
#if defined(_LIBCPP_COMPILER_GCC) || defined(_WIN32)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 190 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__availability" 3
#  define _LIBCPP_AVAILABILITY_HAS_NO_ADDITIONAL_IOSTREAM_EXPLICIT_INSTANTIATIONS_1
#endif
# 192 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__availability" 3

#if 0 /* disabled by -frewrite-includes */
#if 0
#elif defined(__APPLE__)
#endif
#endif /* disabled by -frewrite-includes */
#elif 0 /* evaluated by -frewrite-includes */
# 194 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__availability" 3

    // shared_mutex and shared_timed_mutex
#if 0 /* disabled by -frewrite-includes */
#   if (defined(__ENVIRONMENT_MAC_OS_X_VERSION_MIN_REQUIRED__) && __ENVIRONMENT_MAC_OS_X_VERSION_MIN_REQUIRED__ < 101200) ||    \
        (defined(__ENVIRONMENT_IPHONE_OS_VERSION_MIN_REQUIRED__) && __ENVIRONMENT_IPHONE_OS_VERSION_MIN_REQUIRED__ < 100000) || \
        (defined(__ENVIRONMENT_TV_OS_VERSION_MIN_REQUIRED__) && __ENVIRONMENT_TV_OS_VERSION_MIN_REQUIRED__ < 100000) ||         \
        (defined(__ENVIRONMENT_WATCH_OS_VERSION_MIN_REQUIRED__) && __ENVIRONMENT_WATCH_OS_VERSION_MIN_REQUIRED__ < 30000)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 200 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__availability" 3
#       define _LIBCPP_AVAILABILITY_HAS_NO_SHARED_MUTEX
#   endif
# 202 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__availability" 3
#   define _LIBCPP_AVAILABILITY_SHARED_MUTEX                                    \
        __attribute__((availability(macos,strict,introduced=10.12)))            \
        __attribute__((availability(ios,strict,introduced=10.0)))               \
        __attribute__((availability(tvos,strict,introduced=10.0)))              \
        __attribute__((availability(watchos,strict,introduced=3.0)))

        // bad_optional_access, bad_variant_access and bad_any_cast
        // Note: bad_optional_access & friends were not introduced in the matching
        // macOS and iOS versions, so the version mismatch between macOS and others
        // is intended.
#if 0 /* disabled by -frewrite-includes */
#   if (defined(__ENVIRONMENT_MAC_OS_X_VERSION_MIN_REQUIRED__) && __ENVIRONMENT_MAC_OS_X_VERSION_MIN_REQUIRED__ < 101300) ||    \
        (defined(__ENVIRONMENT_IPHONE_OS_VERSION_MIN_REQUIRED__) && __ENVIRONMENT_IPHONE_OS_VERSION_MIN_REQUIRED__ < 120000) || \
        (defined(__ENVIRONMENT_TV_OS_VERSION_MIN_REQUIRED__) && __ENVIRONMENT_TV_OS_VERSION_MIN_REQUIRED__ < 120000) ||         \
        (defined(__ENVIRONMENT_WATCH_OS_VERSION_MIN_REQUIRED__) && __ENVIRONMENT_WATCH_OS_VERSION_MIN_REQUIRED__ < 50000)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 216 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__availability" 3
#       define _LIBCPP_AVAILABILITY_HAS_NO_BAD_OPTIONAL_ACCESS
#       define _LIBCPP_AVAILABILITY_HAS_NO_BAD_VARIANT_ACCESS
#       define _LIBCPP_AVAILABILITY_HAS_NO_BAD_ANY_CAST
#   endif
# 220 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__availability" 3
#   define _LIBCPP_AVAILABILITY_BAD_OPTIONAL_ACCESS                             \
        __attribute__((availability(macos,strict,introduced=10.13)))            \
        __attribute__((availability(ios,strict,introduced=12.0)))               \
        __attribute__((availability(tvos,strict,introduced=12.0)))              \
        __attribute__((availability(watchos,strict,introduced=5.0)))
#   define _LIBCPP_AVAILABILITY_BAD_VARIANT_ACCESS                              \
        _LIBCPP_AVAILABILITY_BAD_OPTIONAL_ACCESS
#   define _LIBCPP_AVAILABILITY_BAD_ANY_CAST                                    \
        _LIBCPP_AVAILABILITY_BAD_OPTIONAL_ACCESS

    // uncaught_exceptions
#if 0 /* disabled by -frewrite-includes */
#   if (defined(__ENVIRONMENT_MAC_OS_X_VERSION_MIN_REQUIRED__) && __ENVIRONMENT_MAC_OS_X_VERSION_MIN_REQUIRED__ < 101200) ||    \
        (defined(__ENVIRONMENT_IPHONE_OS_VERSION_MIN_REQUIRED__) && __ENVIRONMENT_IPHONE_OS_VERSION_MIN_REQUIRED__ < 100000) || \
        (defined(__ENVIRONMENT_TV_OS_VERSION_MIN_REQUIRED__) && __ENVIRONMENT_TV_OS_VERSION_MIN_REQUIRED__ < 100000) ||         \
        (defined(__ENVIRONMENT_WATCH_OS_VERSION_MIN_REQUIRED__) && __ENVIRONMENT_WATCH_OS_VERSION_MIN_REQUIRED__ < 30000)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 235 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__availability" 3
#       define _LIBCPP_AVAILABILITY_HAS_NO_UNCAUGHT_EXCEPTIONS
#   endif
# 237 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__availability" 3
#   define _LIBCPP_AVAILABILITY_UNCAUGHT_EXCEPTIONS                             \
        __attribute__((availability(macos,strict,introduced=10.12)))            \
        __attribute__((availability(ios,strict,introduced=10.0)))               \
        __attribute__((availability(tvos,strict,introduced=10.0)))              \
        __attribute__((availability(watchos,strict,introduced=3.0)))

    // sized operator new and sized operator delete
#if 0 /* disabled by -frewrite-includes */
#   if (defined(__ENVIRONMENT_MAC_OS_X_VERSION_MIN_REQUIRED__) && __ENVIRONMENT_MAC_OS_X_VERSION_MIN_REQUIRED__ < 101200) ||    \
        (defined(__ENVIRONMENT_IPHONE_OS_VERSION_MIN_REQUIRED__) && __ENVIRONMENT_IPHONE_OS_VERSION_MIN_REQUIRED__ < 100000) || \
        (defined(__ENVIRONMENT_TV_OS_VERSION_MIN_REQUIRED__) && __ENVIRONMENT_TV_OS_VERSION_MIN_REQUIRED__ < 100000) ||         \
        (defined(__ENVIRONMENT_WATCH_OS_VERSION_MIN_REQUIRED__) && __ENVIRONMENT_WATCH_OS_VERSION_MIN_REQUIRED__ < 30000)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 248 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__availability" 3
#       define _LIBCPP_AVAILABILITY_HAS_NO_SIZED_NEW_DELETE
#   endif
# 250 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__availability" 3
#   define _LIBCPP_AVAILABILITY_SIZED_NEW_DELETE                                \
        __attribute__((availability(macos,strict,introduced=10.12)))            \
        __attribute__((availability(ios,strict,introduced=10.0)))               \
        __attribute__((availability(tvos,strict,introduced=10.0)))              \
        __attribute__((availability(watchos,strict,introduced=3.0)))

    // future_error
#if 0 /* disabled by -frewrite-includes */
#   if (defined(__ENVIRONMENT_IPHONE_OS_VERSION_MIN_REQUIRED__) && __ENVIRONMENT_IPHONE_OS_VERSION_MIN_REQUIRED__ < 60000)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 258 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__availability" 3
#       define _LIBCPP_AVAILABILITY_HAS_NO_FUTURE_ERROR
#   endif
# 260 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__availability" 3
#   define _LIBCPP_AVAILABILITY_FUTURE_ERROR                                    \
        __attribute__((availability(ios,strict,introduced=6.0)))

    // type_info's vtable
#if 0 /* disabled by -frewrite-includes */
#   if (defined(__ENVIRONMENT_MAC_OS_X_VERSION_MIN_REQUIRED__) && __ENVIRONMENT_MAC_OS_X_VERSION_MIN_REQUIRED__ < 100900) ||    \
        (defined(__ENVIRONMENT_IPHONE_OS_VERSION_MIN_REQUIRED__) && __ENVIRONMENT_IPHONE_OS_VERSION_MIN_REQUIRED__ < 70000)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 266 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__availability" 3
#       define _LIBCPP_AVAILABILITY_HAS_NO_TYPEINFO_VTABLE
#   endif
# 268 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__availability" 3
#   define _LIBCPP_AVAILABILITY_TYPEINFO_VTABLE                                 \
        __attribute__((availability(macos,strict,introduced=10.9)))             \
        __attribute__((availability(ios,strict,introduced=7.0)))

    // locale::category
#if 0 /* disabled by -frewrite-includes */
#   if (defined(__ENVIRONMENT_MAC_OS_X_VERSION_MIN_REQUIRED__) && __ENVIRONMENT_MAC_OS_X_VERSION_MIN_REQUIRED__ < 100900) ||    \
        (defined(__ENVIRONMENT_IPHONE_OS_VERSION_MIN_REQUIRED__) && __ENVIRONMENT_IPHONE_OS_VERSION_MIN_REQUIRED__ < 70000)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 275 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__availability" 3
#       define _LIBCPP_AVAILABILITY_HAS_NO_LOCALE_CATEGORY
#   endif
# 277 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__availability" 3
#   define _LIBCPP_AVAILABILITY_LOCALE_CATEGORY                                 \
        __attribute__((availability(macos,strict,introduced=10.9)))             \
        __attribute__((availability(ios,strict,introduced=7.0)))

    // atomic operations on shared_ptr
#if 0 /* disabled by -frewrite-includes */
#   if (defined(__ENVIRONMENT_MAC_OS_X_VERSION_MIN_REQUIRED__) && __ENVIRONMENT_MAC_OS_X_VERSION_MIN_REQUIRED__ < 100900) ||    \
        (defined(__ENVIRONMENT_IPHONE_OS_VERSION_MIN_REQUIRED__) && __ENVIRONMENT_IPHONE_OS_VERSION_MIN_REQUIRED__ < 70000)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 284 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__availability" 3
#       define _LIBCPP_AVAILABILITY_HAS_NO_ATOMIC_SHARED_PTR
#   endif
# 286 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__availability" 3
#   define _LIBCPP_AVAILABILITY_ATOMIC_SHARED_PTR                               \
        __attribute__((availability(macos,strict,introduced=10.9)))             \
        __attribute__((availability(ios,strict,introduced=7.0)))

    // <filesystem>
#if 0 /* disabled by -frewrite-includes */
#   if (defined(__ENVIRONMENT_MAC_OS_X_VERSION_MIN_REQUIRED__) && __ENVIRONMENT_MAC_OS_X_VERSION_MIN_REQUIRED__ < 101500) ||    \
        (defined(__ENVIRONMENT_IPHONE_OS_VERSION_MIN_REQUIRED__) && __ENVIRONMENT_IPHONE_OS_VERSION_MIN_REQUIRED__ < 130000) || \
        (defined(__ENVIRONMENT_TV_OS_VERSION_MIN_REQUIRED__) && __ENVIRONMENT_TV_OS_VERSION_MIN_REQUIRED__ < 130000) ||         \
        (defined(__ENVIRONMENT_WATCH_OS_VERSION_MIN_REQUIRED__) && __ENVIRONMENT_WATCH_OS_VERSION_MIN_REQUIRED__ < 60000)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 295 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__availability" 3
#       define _LIBCPP_AVAILABILITY_HAS_NO_FILESYSTEM_LIBRARY
#   endif
# 297 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__availability" 3
#   define _LIBCPP_AVAILABILITY_FILESYSTEM_LIBRARY                              \
        __attribute__((availability(macos,strict,introduced=10.15)))            \
        __attribute__((availability(ios,strict,introduced=13.0)))               \
        __attribute__((availability(tvos,strict,introduced=13.0)))              \
        __attribute__((availability(watchos,strict,introduced=6.0)))
#   define _LIBCPP_AVAILABILITY_FILESYSTEM_LIBRARY_PUSH                                 \
        _Pragma("clang attribute push(__attribute__((availability(macos,strict,introduced=10.15))), apply_to=any(function,record))") \
        _Pragma("clang attribute push(__attribute__((availability(ios,strict,introduced=13.0))), apply_to=any(function,record))")    \
        _Pragma("clang attribute push(__attribute__((availability(tvos,strict,introduced=13.0))), apply_to=any(function,record))")   \
        _Pragma("clang attribute push(__attribute__((availability(watchos,strict,introduced=6.0))), apply_to=any(function,record))")
#   define _LIBCPP_AVAILABILITY_FILESYSTEM_LIBRARY_POP                                  \
        _Pragma("clang attribute pop")                                          \
        _Pragma("clang attribute pop")                                          \
        _Pragma("clang attribute pop")                                          \
        _Pragma("clang attribute pop")

    // std::to_chars(floating-point)
#if 0 /* disabled by -frewrite-includes */
#   if (defined(__ENVIRONMENT_MAC_OS_X_VERSION_MIN_REQUIRED__) && __ENVIRONMENT_MAC_OS_X_VERSION_MIN_REQUIRED__ < 130300) ||    \
        (defined(__ENVIRONMENT_IPHONE_OS_VERSION_MIN_REQUIRED__) && __ENVIRONMENT_IPHONE_OS_VERSION_MIN_REQUIRED__ < 160300) || \
        (defined(__ENVIRONMENT_TV_OS_VERSION_MIN_REQUIRED__) && __ENVIRONMENT_TV_OS_VERSION_MIN_REQUIRED__ < 160300) ||         \
        (defined(__ENVIRONMENT_WATCH_OS_VERSION_MIN_REQUIRED__) && __ENVIRONMENT_WATCH_OS_VERSION_MIN_REQUIRED__ < 90300)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 318 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__availability" 3
#       define _LIBCPP_AVAILABILITY_HAS_NO_TO_CHARS_FLOATING_POINT
#   endif
# 320 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__availability" 3
#   define _LIBCPP_AVAILABILITY_TO_CHARS_FLOATING_POINT                         \
        __attribute__((availability(macos,strict,introduced=13.3)))             \
        __attribute__((availability(ios,strict,introduced=16.3)))               \
        __attribute__((availability(tvos,strict,introduced=16.3)))              \
        __attribute__((availability(watchos,strict,introduced=9.3)))

    // c++20 synchronization library
#if 0 /* disabled by -frewrite-includes */
#   if (defined(__ENVIRONMENT_MAC_OS_X_VERSION_MIN_REQUIRED__) && __ENVIRONMENT_MAC_OS_X_VERSION_MIN_REQUIRED__ < 110000) ||    \
        (defined(__ENVIRONMENT_IPHONE_OS_VERSION_MIN_REQUIRED__) && __ENVIRONMENT_IPHONE_OS_VERSION_MIN_REQUIRED__ < 140000) || \
        (defined(__ENVIRONMENT_TV_OS_VERSION_MIN_REQUIRED__) && __ENVIRONMENT_TV_OS_VERSION_MIN_REQUIRED__ < 140000) ||         \
        (defined(__ENVIRONMENT_WATCH_OS_VERSION_MIN_REQUIRED__) && __ENVIRONMENT_WATCH_OS_VERSION_MIN_REQUIRED__ < 70000)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 331 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__availability" 3
#       define _LIBCPP_AVAILABILITY_HAS_NO_SYNC
#   endif
# 333 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__availability" 3
#   define _LIBCPP_AVAILABILITY_SYNC                                            \
        __attribute__((availability(macos,strict,introduced=11.0)))             \
        __attribute__((availability(ios,strict,introduced=14.0)))               \
        __attribute__((availability(tvos,strict,introduced=14.0)))              \
        __attribute__((availability(watchos,strict,introduced=7.0)))

    // __libcpp_verbose_abort
#if 0 /* disabled by -frewrite-includes */
#   if 1 // TODO: Update once this is released
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 341 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__availability" 3
#       define _LIBCPP_AVAILABILITY_HAS_NO_VERBOSE_ABORT
#   endif
# 343 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__availability" 3
#   define _LIBCPP_AVAILABILITY_VERBOSE_ABORT                                   \
        __attribute__((unavailable))

    // std::pmr
#if 0 /* disabled by -frewrite-includes */
#   if (defined(__ENVIRONMENT_MAC_OS_X_VERSION_MIN_REQUIRED__) && __ENVIRONMENT_MAC_OS_X_VERSION_MIN_REQUIRED__ < 140000) ||    \
        (defined(__ENVIRONMENT_IPHONE_OS_VERSION_MIN_REQUIRED__) && __ENVIRONMENT_IPHONE_OS_VERSION_MIN_REQUIRED__ < 170000) || \
        (defined(__ENVIRONMENT_TV_OS_VERSION_MIN_REQUIRED__) && __ENVIRONMENT_TV_OS_VERSION_MIN_REQUIRED__ < 170000) ||         \
        (defined(__ENVIRONMENT_WATCH_OS_VERSION_MIN_REQUIRED__) && __ENVIRONMENT_WATCH_OS_VERSION_MIN_REQUIRED__ < 100000)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 351 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__availability" 3
#       define _LIBCPP_AVAILABILITY_HAS_NO_PMR
#   endif
# 353 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__availability" 3
// TODO: Enable std::pmr markup once https://github.com/llvm/llvm-project/issues/40340 has been fixed
//       Until then, it is possible for folks to try to use `std::pmr` when back-deploying to targets that don't support
//       it and it'll be a load-time error, but we don't have a good alternative because the library won't compile if we
//       use availability annotations until that bug has been fixed.
#if 0 /* disabled by -frewrite-includes */
#  if 0
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 358 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__availability" 3
#    define _LIBCPP_AVAILABILITY_PMR                                                                                   \
      __attribute__((availability(macos, strict, introduced = 14.0)))                                                  \
      __attribute__((availability(ios, strict, introduced = 17.0)))                                                    \
      __attribute__((availability(tvos, strict, introduced = 17.0)))                                                   \
      __attribute__((availability(watchos, strict, introduced = 10.0)))
#  else
# 364 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__availability" 3
#    define _LIBCPP_AVAILABILITY_PMR
#  endif
# 366 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__availability" 3

#  define _LIBCPP_AVAILABILITY_HAS_NO_TZDB
#  define _LIBCPP_AVAILABILITY_TZDB __attribute__((unavailable))

#if 0 /* disabled by -frewrite-includes */
#  if (defined(__ENVIRONMENT_MAC_OS_X_VERSION_MIN_REQUIRED__) && __ENVIRONMENT_MAC_OS_X_VERSION_MIN_REQUIRED__ < 120000)   || \
      (defined(__ENVIRONMENT_IPHONE_OS_VERSION_MIN_REQUIRED__) && __ENVIRONMENT_IPHONE_OS_VERSION_MIN_REQUIRED__ < 150000) || \
      (defined(__ENVIRONMENT_TV_OS_VERSION_MIN_REQUIRED__) && __ENVIRONMENT_TV_OS_VERSION_MIN_REQUIRED__ < 150000)         || \
      (defined(__ENVIRONMENT_WATCH_OS_VERSION_MIN_REQUIRED__) && __ENVIRONMENT_WATCH_OS_VERSION_MIN_REQUIRED__ < 80000)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 374 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__availability" 3
#    define _LIBCPP_AVAILABILITY_HAS_NO_ADDITIONAL_IOSTREAM_EXPLICIT_INSTANTIATIONS_1
#  endif
# 376 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__availability" 3
#else
# 377 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__availability" 3

// ...New vendors can add availability markup here...

#   error "It looks like you're trying to enable vendor availability markup, but you haven't defined the corresponding macros yet!"

#endif
# 383 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__availability" 3

// Define availability attributes that depend on _LIBCPP_HAS_NO_EXCEPTIONS.
// Those are defined in terms of the availability attributes above, and
// should not be vendor-specific.
#if 0 /* disabled by -frewrite-includes */
#if defined(_LIBCPP_HAS_NO_EXCEPTIONS)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 388 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__availability" 3
#   define _LIBCPP_AVAILABILITY_FUTURE
#   define _LIBCPP_AVAILABILITY_THROW_BAD_ANY_CAST
#   define _LIBCPP_AVAILABILITY_THROW_BAD_OPTIONAL_ACCESS
#   define _LIBCPP_AVAILABILITY_THROW_BAD_VARIANT_ACCESS
#else
# 393 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__availability" 3
#   define _LIBCPP_AVAILABILITY_FUTURE                    _LIBCPP_AVAILABILITY_FUTURE_ERROR
#   define _LIBCPP_AVAILABILITY_THROW_BAD_ANY_CAST        _LIBCPP_AVAILABILITY_BAD_ANY_CAST
#   define _LIBCPP_AVAILABILITY_THROW_BAD_OPTIONAL_ACCESS _LIBCPP_AVAILABILITY_BAD_OPTIONAL_ACCESS
#   define _LIBCPP_AVAILABILITY_THROW_BAD_VARIANT_ACCESS  _LIBCPP_AVAILABILITY_BAD_VARIANT_ACCESS
#endif
# 398 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__availability" 3

#endif // _LIBCPP___AVAILABILITY
# 400 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__availability" 3
#endif /* __availability expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__verbose_abort" 2 3
#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__verbose_abort" 3
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__verbose_abort" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__verbose_abort" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__verbose_abort" 3
#endif
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__verbose_abort" 3

_LIBCPP_BEGIN_NAMESPACE_STD

// This function should never be called directly from the code -- it should only be called through
// the _LIBCPP_VERBOSE_ABORT macro.
_LIBCPP_NORETURN _LIBCPP_AVAILABILITY_VERBOSE_ABORT _LIBCPP_OVERRIDABLE_FUNC_VIS _LIBCPP_ATTRIBUTE_FORMAT(__printf__, 1, 2)
void __libcpp_verbose_abort(const char *__format, ...);

// _LIBCPP_VERBOSE_ABORT(format, args...)
//
// This macro is used to abort the program abnormally while providing additional diagnostic information.
//
// The first argument is a printf-style format string, and the remaining arguments are values to format
// into the format-string. This macro can be customized by users to provide fine-grained control over
// how verbose termination is triggered.
//
// If the user does not supply their own version of the _LIBCPP_VERBOSE_ABORT macro, we pick the default
// behavior based on whether we know the built library we're running against provides support for the
// verbose termination handler or not. If it does, we call it. If it doesn't, we call __builtin_abort to
// make sure that the program terminates but without taking any complex dependencies in this header.
#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_VERBOSE_ABORT)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 40 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__verbose_abort" 3

// Support _LIBCPP_AVAILABILITY_CUSTOM_VERBOSE_ABORT_PROVIDED until LLVM 18, but tell people
// to move to customizing _LIBCPP_VERBOSE_ABORT instead.
#if 0 /* disabled by -frewrite-includes */
#  if defined(_LIBCPP_AVAILABILITY_HAS_NO_VERBOSE_ABORT) && defined(_LIBCPP_AVAILABILITY_CUSTOM_VERBOSE_ABORT_PROVIDED)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 44 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__verbose_abort" 3
#    undef _LIBCPP_AVAILABILITY_HAS_NO_VERBOSE_ABORT
#    warning _LIBCPP_AVAILABILITY_CUSTOM_VERBOSE_ABORT_PROVIDED is deprecated, please customize _LIBCPP_VERBOSE_ABORT instead
#  endif
# 47 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__verbose_abort" 3

#if 0 /* disabled by -frewrite-includes */
#  if defined(_LIBCPP_AVAILABILITY_HAS_NO_VERBOSE_ABORT)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 49 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__verbose_abort" 3
// The decltype is there to suppress -Wunused warnings in this configuration.
void __use(const char*, ...);
#    define _LIBCPP_VERBOSE_ABORT(...) (decltype(::std::__use(__VA_ARGS__))(), __builtin_abort())
#  else
# 53 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__verbose_abort" 3
#    define _LIBCPP_VERBOSE_ABORT(...) ::std::__libcpp_verbose_abort(__VA_ARGS__)
#  endif
# 55 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__verbose_abort" 3

#endif // !defined(_LIBCPP_VERBOSE_ABORT)
# 57 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__verbose_abort" 3

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___VERBOSE_ABORT
# 61 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__verbose_abort" 3
#endif /* __verbose_abort expanded by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__assert" 2 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__assert" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__assert" 3
#endif
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__assert" 3

#define _LIBCPP_ASSERT(expression, message)                                                                            \
  (__builtin_expect(static_cast<bool>(expression), 1)                                                                  \
       ? (void)0                                                                                                       \
       : _LIBCPP_VERBOSE_ABORT(                                                                                        \
             "%s:%d: assertion %s failed: %s\n", __builtin_FILE(), __builtin_LINE(), #expression, message))

// TODO: __builtin_assume can currently inhibit optimizations. Until this has been fixed and we can add
//       assumptions without a clear optimization intent, disable that to avoid worsening the code generation.
//       See https://discourse.llvm.org/t/llvm-assume-blocks-optimization/71609 for a discussion.
#if 0 /* disabled by -frewrite-includes */
#if 0 && __has_builtin(__builtin_assume)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 30 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__assert" 3
#  define _LIBCPP_ASSUME(expression)                                                                                   \
    (_LIBCPP_DIAGNOSTIC_PUSH _LIBCPP_CLANG_DIAGNOSTIC_IGNORED("-Wassume")                                              \
         __builtin_assume(static_cast<bool>(expression)) _LIBCPP_DIAGNOSTIC_POP)
#else
# 34 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__assert" 3
#  define _LIBCPP_ASSUME(expression) ((void)0)
#endif
# 36 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__assert" 3

#endif // _LIBCPP___ASSERT
# 38 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__assert" 3
#endif /* __assert expanded by -frewrite-includes */
# 678 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/iterator" 2 3
#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 678 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/iterator" 3
# 679 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/iterator" 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* access.h expanded by -frewrite-includes */
#include <__iterator/access.h>
#else /* access.h expanded by -frewrite-includes */
# 679 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/iterator" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/access.h" 1 3
// -*- C++ -*-
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___ITERATOR_ACCESS_H
#define _LIBCPP___ITERATOR_ACCESS_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/access.h" 3
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/access.h" 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* cstddef expanded by -frewrite-includes */
#include <cstddef>
#else /* cstddef expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/access.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/cstddef" 1 3
// -*- C++ -*-
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP_CSTDDEF
#define _LIBCPP_CSTDDEF

/*
    cstddef synopsis

Macros:

    offsetof(type,member-designator)
    NULL

namespace std
{

Types:

    ptrdiff_t
    size_t
    max_align_t // C++11
    nullptr_t
    byte // C++17

}  // std

*/

#if 0 /* expanded by -frewrite-includes */
#include <__assert> // all public C++ headers provide the assertion handler
#endif /* expanded by -frewrite-includes */
# 36 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/cstddef" 3
# 37 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/cstddef" 3
#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 37 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/cstddef" 3
# 38 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/cstddef" 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* enable_if.h expanded by -frewrite-includes */
#include <__type_traits/enable_if.h>
#else /* enable_if.h expanded by -frewrite-includes */
# 38 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/cstddef" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/enable_if.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___TYPE_TRAITS_ENABLE_IF_H
#define _LIBCPP___TYPE_TRAITS_ENABLE_IF_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/enable_if.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/enable_if.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/enable_if.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/enable_if.h" 3
#endif
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/enable_if.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

template <bool, class _Tp = void>
struct _LIBCPP_TEMPLATE_VIS enable_if {};
template <class _Tp>
struct _LIBCPP_TEMPLATE_VIS enable_if<true, _Tp> {
  typedef _Tp type;
};

template <bool _Bp, class _Tp = void>
using __enable_if_t _LIBCPP_NODEBUG = typename enable_if<_Bp, _Tp>::type;

#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 14
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 31 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/enable_if.h" 3
template <bool _Bp, class _Tp = void>
using enable_if_t = typename enable_if<_Bp, _Tp>::type;
#endif
# 34 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/enable_if.h" 3

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___TYPE_TRAITS_ENABLE_IF_H
# 38 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/enable_if.h" 3
#endif /* enable_if.h expanded by -frewrite-includes */
# 39 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/cstddef" 2 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* integral_constant.h expanded by -frewrite-includes */
#include <__type_traits/integral_constant.h>
#else /* integral_constant.h expanded by -frewrite-includes */
# 39 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/cstddef" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/integral_constant.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___TYPE_TRAITS_INTEGRAL_CONSTANT_H
#define _LIBCPP___TYPE_TRAITS_INTEGRAL_CONSTANT_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/integral_constant.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/integral_constant.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/integral_constant.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/integral_constant.h" 3
#endif
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/integral_constant.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

template <class _Tp, _Tp __v>
struct _LIBCPP_TEMPLATE_VIS integral_constant {
  static _LIBCPP_CONSTEXPR const _Tp value = __v;
  typedef _Tp value_type;
  typedef integral_constant type;
  _LIBCPP_INLINE_VISIBILITY _LIBCPP_CONSTEXPR operator value_type() const _NOEXCEPT { return value; }
#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 14
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 27 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/integral_constant.h" 3
  _LIBCPP_INLINE_VISIBILITY constexpr value_type operator()() const _NOEXCEPT { return value; }
#endif
# 29 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/integral_constant.h" 3
};

template <class _Tp, _Tp __v>
_LIBCPP_CONSTEXPR const _Tp integral_constant<_Tp, __v>::value;

typedef integral_constant<bool, true> true_type;
typedef integral_constant<bool, false> false_type;

template <bool _Val>
using _BoolConstant _LIBCPP_NODEBUG = integral_constant<bool, _Val>;

#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 17
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 41 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/integral_constant.h" 3
template <bool __b>
using bool_constant = integral_constant<bool, __b>;
#endif
# 44 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/integral_constant.h" 3

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___TYPE_TRAITS_INTEGRAL_CONSTANT_H
# 48 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/integral_constant.h" 3
#endif /* integral_constant.h expanded by -frewrite-includes */
# 40 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/cstddef" 2 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* is_integral.h expanded by -frewrite-includes */
#include <__type_traits/is_integral.h>
#else /* is_integral.h expanded by -frewrite-includes */
# 40 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/cstddef" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_integral.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___TYPE_TRAITS_IS_INTEGRAL_H
#define _LIBCPP___TYPE_TRAITS_IS_INTEGRAL_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_integral.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_integral.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/integral_constant.h>
#endif /* expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_integral.h" 3
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_integral.h" 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* remove_cv.h expanded by -frewrite-includes */
#include <__type_traits/remove_cv.h>
#else /* remove_cv.h expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_integral.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_cv.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___TYPE_TRAITS_REMOVE_CV_H
#define _LIBCPP___TYPE_TRAITS_REMOVE_CV_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_cv.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_cv.h" 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* remove_const.h expanded by -frewrite-includes */
#include <__type_traits/remove_const.h>
#else /* remove_const.h expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_cv.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_const.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___TYPE_TRAITS_REMOVE_CONST_H
#define _LIBCPP___TYPE_TRAITS_REMOVE_CONST_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_const.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_const.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_const.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_const.h" 3
#endif
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_const.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

#if 0 /* disabled by -frewrite-includes */
#if __has_builtin(__remove_const)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 21 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_const.h" 3
template <class _Tp>
struct remove_const {
  using type _LIBCPP_NODEBUG = __remove_const(_Tp);
};

template <class _Tp>
using __remove_const_t = __remove_const(_Tp);
#else
# 29 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_const.h" 3
template <class _Tp>
struct _LIBCPP_TEMPLATE_VIS remove_const {
  typedef _Tp type;
};
template <class _Tp>
struct _LIBCPP_TEMPLATE_VIS remove_const<const _Tp> {
  typedef _Tp type;
};

template <class _Tp>
using __remove_const_t = typename remove_const<_Tp>::type;
#endif // __has_builtin(__remove_const)
# 41 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_const.h" 3

#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 14
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 43 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_const.h" 3
template <class _Tp>
using remove_const_t = __remove_const_t<_Tp>;
#endif
# 46 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_const.h" 3

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___TYPE_TRAITS_REMOVE_CONST_H
# 50 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_const.h" 3
#endif /* remove_const.h expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_cv.h" 2 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* remove_volatile.h expanded by -frewrite-includes */
#include <__type_traits/remove_volatile.h>
#else /* remove_volatile.h expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_cv.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_volatile.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___TYPE_TRAITS_REMOVE_VOLATILE_H
#define _LIBCPP___TYPE_TRAITS_REMOVE_VOLATILE_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_volatile.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_volatile.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_volatile.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_volatile.h" 3
#endif
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_volatile.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

#if 0 /* disabled by -frewrite-includes */
#if __has_builtin(__remove_volatile)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 21 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_volatile.h" 3
template <class _Tp>
struct remove_volatile {
  using type _LIBCPP_NODEBUG = __remove_volatile(_Tp);
};

template <class _Tp>
using __remove_volatile_t = __remove_volatile(_Tp);
#else
# 29 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_volatile.h" 3
template <class _Tp>
struct _LIBCPP_TEMPLATE_VIS remove_volatile {
  typedef _Tp type;
};
template <class _Tp>
struct _LIBCPP_TEMPLATE_VIS remove_volatile<volatile _Tp> {
  typedef _Tp type;
};

template <class _Tp>
using __remove_volatile_t = typename remove_volatile<_Tp>::type;
#endif // __has_builtin(__remove_volatile)
# 41 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_volatile.h" 3

#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 14
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 43 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_volatile.h" 3
template <class _Tp>
using remove_volatile_t = __remove_volatile_t<_Tp>;
#endif
# 46 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_volatile.h" 3

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___TYPE_TRAITS_REMOVE_VOLATILE_H
# 50 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_volatile.h" 3
#endif /* remove_volatile.h expanded by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_cv.h" 2 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_cv.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_cv.h" 3
#endif
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_cv.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

#if 0 /* disabled by -frewrite-includes */
#if __has_builtin(__remove_cv) && !defined(_LIBCPP_COMPILER_GCC)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 23 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_cv.h" 3
template <class _Tp>
struct remove_cv {
  using type _LIBCPP_NODEBUG = __remove_cv(_Tp);
};

template <class _Tp>
using __remove_cv_t = __remove_cv(_Tp);
#else
# 31 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_cv.h" 3
template <class _Tp>
struct _LIBCPP_TEMPLATE_VIS remove_cv {
  typedef __remove_volatile_t<__remove_const_t<_Tp> > type;
};

template <class _Tp>
using __remove_cv_t = __remove_volatile_t<__remove_const_t<_Tp> >;
#endif // __has_builtin(__remove_cv)
# 39 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_cv.h" 3

#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 14
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 41 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_cv.h" 3
template <class _Tp>
using remove_cv_t = __remove_cv_t<_Tp>;
#endif
# 44 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_cv.h" 3

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___TYPE_TRAITS_REMOVE_CV_H
# 48 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_cv.h" 3
#endif /* remove_cv.h expanded by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_integral.h" 2 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_integral.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_integral.h" 3
#endif
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_integral.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

// clang-format off
template <class _Tp> struct __libcpp_is_integral                     { enum { value = 0 }; };
template <>          struct __libcpp_is_integral<bool>               { enum { value = 1 }; };
template <>          struct __libcpp_is_integral<char>               { enum { value = 1 }; };
template <>          struct __libcpp_is_integral<signed char>        { enum { value = 1 }; };
template <>          struct __libcpp_is_integral<unsigned char>      { enum { value = 1 }; };
#ifndef _LIBCPP_HAS_NO_WIDE_CHARACTERS
template <>          struct __libcpp_is_integral<wchar_t>            { enum { value = 1 }; };
#endif
# 31 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_integral.h" 3
#ifndef _LIBCPP_HAS_NO_CHAR8_T
template <>          struct __libcpp_is_integral<char8_t>            { enum { value = 1 }; };
#endif
# 34 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_integral.h" 3
template <>          struct __libcpp_is_integral<char16_t>           { enum { value = 1 }; };
template <>          struct __libcpp_is_integral<char32_t>           { enum { value = 1 }; };
template <>          struct __libcpp_is_integral<short>              { enum { value = 1 }; };
template <>          struct __libcpp_is_integral<unsigned short>     { enum { value = 1 }; };
template <>          struct __libcpp_is_integral<int>                { enum { value = 1 }; };
template <>          struct __libcpp_is_integral<unsigned int>       { enum { value = 1 }; };
template <>          struct __libcpp_is_integral<long>               { enum { value = 1 }; };
template <>          struct __libcpp_is_integral<unsigned long>      { enum { value = 1 }; };
template <>          struct __libcpp_is_integral<long long>          { enum { value = 1 }; };
template <>          struct __libcpp_is_integral<unsigned long long> { enum { value = 1 }; };
#ifndef _LIBCPP_HAS_NO_INT128
template <>          struct __libcpp_is_integral<__int128_t>         { enum { value = 1 }; };
template <>          struct __libcpp_is_integral<__uint128_t>        { enum { value = 1 }; };
#endif
# 48 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_integral.h" 3
// clang-format on

#if 0 /* disabled by -frewrite-includes */
#if __has_builtin(__is_integral)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 51 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_integral.h" 3

template <class _Tp>
struct _LIBCPP_TEMPLATE_VIS is_integral : _BoolConstant<__is_integral(_Tp)> {};

#if 0 /* disabled by -frewrite-includes */
#  if _LIBCPP_STD_VER >= 17
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 56 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_integral.h" 3
template <class _Tp>
inline constexpr bool is_integral_v = __is_integral(_Tp);
#  endif
# 59 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_integral.h" 3

#else
# 61 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_integral.h" 3

template <class _Tp>
struct _LIBCPP_TEMPLATE_VIS is_integral : public _BoolConstant<__libcpp_is_integral<__remove_cv_t<_Tp> >::value> {};

#if 0 /* disabled by -frewrite-includes */
#  if _LIBCPP_STD_VER >= 17
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 66 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_integral.h" 3
template <class _Tp>
inline constexpr bool is_integral_v = is_integral<_Tp>::value;
#  endif
# 69 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_integral.h" 3

#endif // __has_builtin(__is_integral)
# 71 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_integral.h" 3

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___TYPE_TRAITS_IS_INTEGRAL_H
# 75 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_integral.h" 3
#endif /* is_integral.h expanded by -frewrite-includes */
# 41 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/cstddef" 2 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* version expanded by -frewrite-includes */
#include <version>
#else /* version expanded by -frewrite-includes */
# 41 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/cstddef" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/version" 1 3
// -*- C++ -*-
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP_VERSIONH
#define _LIBCPP_VERSIONH

/*
  version synopsis

Macro name                                              Value   Headers
__cpp_lib_adaptor_iterator_pair_constructor             202106L <queue> <stack>
__cpp_lib_addressof_constexpr                           201603L <memory>
__cpp_lib_allocate_at_least                             202106L <memory>
__cpp_lib_allocator_traits_is_always_equal              201411L <deque> <forward_list> <list>
                                                                <map> <memory> <scoped_allocator>
                                                                <set> <string> <unordered_map>
                                                                <unordered_set> <vector>
__cpp_lib_any                                           201606L <any>
__cpp_lib_apply                                         201603L <tuple>
__cpp_lib_array_constexpr                               201811L <array> <iterator>
                                                        201603L // C++17
__cpp_lib_as_const                                      201510L <utility>
__cpp_lib_associative_heterogeneous_erasure             202110L <map> <set> <unordered_map>
                                                                <unordered_set>
__cpp_lib_associative_heterogeneous_insertion           202306L <map> <set> <unordered_map>
                                                                <unordered_set>
__cpp_lib_assume_aligned                                201811L <memory>
__cpp_lib_atomic_flag_test                              201907L <atomic>
__cpp_lib_atomic_float                                  201711L <atomic>
__cpp_lib_atomic_is_always_lock_free                    201603L <atomic>
__cpp_lib_atomic_lock_free_type_aliases                 201907L <atomic>
__cpp_lib_atomic_ref                                    201806L <atomic>
__cpp_lib_atomic_shared_ptr                             201711L <atomic>
__cpp_lib_atomic_value_initialization                   201911L <atomic> <memory>
__cpp_lib_atomic_wait                                   201907L <atomic>
__cpp_lib_barrier                                       201907L <barrier>
__cpp_lib_bind_back                                     202306L <functional>
                                                        202202L // C++23
__cpp_lib_bind_front                                    202306L <functional>
                                                        201907L // C++20
__cpp_lib_bit_cast                                      201806L <bit>
__cpp_lib_bitops                                        201907L <bit>
__cpp_lib_bitset                                        202306L <bitset>
__cpp_lib_bool_constant                                 201505L <type_traits>
__cpp_lib_bounded_array_traits                          201902L <type_traits>
__cpp_lib_boyer_moore_searcher                          201603L <functional>
__cpp_lib_byte                                          201603L <cstddef>
__cpp_lib_byteswap                                      202110L <bit>
__cpp_lib_char8_t                                       201907L <atomic> <filesystem> <istream>
                                                                <limits> <locale> <ostream>
                                                                <string> <string_view>
__cpp_lib_chrono                                        201611L <chrono>
__cpp_lib_chrono_udls                                   201304L <chrono>
__cpp_lib_clamp                                         201603L <algorithm>
__cpp_lib_complex_udls                                  201309L <complex>
__cpp_lib_concepts                                      202002L <concepts>
__cpp_lib_constexpr_algorithms                          201806L <algorithm> <utility>
__cpp_lib_constexpr_bitset                              202207L <bitset>
__cpp_lib_constexpr_charconv                            202207L <charconv>
__cpp_lib_constexpr_cmath                               202202L <cmath> <cstdlib>
__cpp_lib_constexpr_complex                             201711L <complex>
__cpp_lib_constexpr_dynamic_alloc                       201907L <memory>
__cpp_lib_constexpr_functional                          201907L <functional>
__cpp_lib_constexpr_iterator                            201811L <iterator>
__cpp_lib_constexpr_memory                              202202L <memory>
                                                        201811L // C++20
__cpp_lib_constexpr_numeric                             201911L <numeric>
__cpp_lib_constexpr_string                              201907L <string>
__cpp_lib_constexpr_string_view                         201811L <string_view>
__cpp_lib_constexpr_tuple                               201811L <tuple>
__cpp_lib_constexpr_typeinfo                            202106L <typeinfo>
__cpp_lib_constexpr_utility                             201811L <utility>
__cpp_lib_constexpr_vector                              201907L <vector>
__cpp_lib_copyable_function                             202306L <functional>
__cpp_lib_coroutine                                     201902L <coroutine>
__cpp_lib_destroying_delete                             201806L <new>
__cpp_lib_enable_shared_from_this                       201603L <memory>
__cpp_lib_endian                                        201907L <bit>
__cpp_lib_erase_if                                      202002L <deque> <forward_list> <list>
                                                                <map> <set> <string>
                                                                <unordered_map> <unordered_set> <vector>
__cpp_lib_exchange_function                             201304L <utility>
__cpp_lib_execution                                     201902L <execution>
                                                        201603L // C++17
__cpp_lib_expected                                      202211L <expected>
__cpp_lib_filesystem                                    201703L <filesystem>
__cpp_lib_format                                        202106L <format>
__cpp_lib_format_ranges                                 202207L <format>
__cpp_lib_formatters                                    202302L <stacktrace> <thread>
__cpp_lib_forward_like                                  202207L <utility>
__cpp_lib_fstream_native_handle                         202306L <fstream>
__cpp_lib_function_ref                                  202306L <functional>
__cpp_lib_gcd_lcm                                       201606L <numeric>
__cpp_lib_generic_associative_lookup                    201304L <map> <set>
__cpp_lib_generic_unordered_lookup                      201811L <unordered_map> <unordered_set>
__cpp_lib_hardware_interference_size                    201703L <new>
__cpp_lib_has_unique_object_representations             201606L <type_traits>
__cpp_lib_hazard_pointer                                202306L <hazard_pointer>
__cpp_lib_hypot                                         201603L <cmath>
__cpp_lib_incomplete_container_elements                 201505L <forward_list> <list> <vector>
__cpp_lib_int_pow2                                      202002L <bit>
__cpp_lib_integer_comparison_functions                  202002L <utility>
__cpp_lib_integer_sequence                              201304L <utility>
__cpp_lib_integral_constant_callable                    201304L <type_traits>
__cpp_lib_interpolate                                   201902L <cmath> <numeric>
__cpp_lib_invoke                                        201411L <functional>
__cpp_lib_invoke_r                                      202106L <functional>
__cpp_lib_is_aggregate                                  201703L <type_traits>
__cpp_lib_is_constant_evaluated                         201811L <type_traits>
__cpp_lib_is_final                                      201402L <type_traits>
__cpp_lib_is_invocable                                  201703L <type_traits>
__cpp_lib_is_layout_compatible                          201907L <type_traits>
__cpp_lib_is_nothrow_convertible                        201806L <type_traits>
__cpp_lib_is_null_pointer                               201309L <type_traits>
__cpp_lib_is_pointer_interconvertible                   201907L <type_traits>
__cpp_lib_is_scoped_enum                                202011L <type_traits>
__cpp_lib_is_swappable                                  201603L <type_traits>
__cpp_lib_jthread                                       201911L <stop_token> <thread>
__cpp_lib_latch                                         201907L <latch>
__cpp_lib_launder                                       201606L <new>
__cpp_lib_list_remove_return_type                       201806L <forward_list> <list>
__cpp_lib_logical_traits                                201510L <type_traits>
__cpp_lib_make_from_tuple                               201606L <tuple>
__cpp_lib_make_reverse_iterator                         201402L <iterator>
__cpp_lib_make_unique                                   201304L <memory>
__cpp_lib_map_try_emplace                               201411L <map>
__cpp_lib_math_constants                                201907L <numbers>
__cpp_lib_math_special_functions                        201603L <cmath>
__cpp_lib_mdspan                                        202207L <mdspan>
__cpp_lib_memory_resource                               201603L <memory_resource>
__cpp_lib_move_iterator_concept                         202207L <iterator>
__cpp_lib_move_only_function                            202110L <functional>
__cpp_lib_node_extract                                  201606L <map> <set> <unordered_map>
                                                                <unordered_set>
__cpp_lib_nonmember_container_access                    201411L <array> <deque> <forward_list>
                                                                <iterator> <list> <map>
                                                                <regex> <set> <string>
                                                                <unordered_map> <unordered_set> <vector>
__cpp_lib_not_fn                                        201603L <functional>
__cpp_lib_null_iterators                                201304L <iterator>
__cpp_lib_optional                                      202110L <optional>
                                                        201606L // C++17
__cpp_lib_out_ptr                                       202106L <memory>
__cpp_lib_parallel_algorithm                            201603L <algorithm> <numeric>
__cpp_lib_polymorphic_allocator                         201902L <memory_resource>
__cpp_lib_print                                         202207L <ostream> <print>
__cpp_lib_quoted_string_io                              201304L <iomanip>
__cpp_lib_ranges                                        202207L <algorithm> <functional> <iterator>
                                                                <memory> <ranges>
__cpp_lib_ranges_as_rvalue                              202207L <ranges>
__cpp_lib_ranges_chunk                                  202202L <ranges>
__cpp_lib_ranges_chunk_by                               202202L <ranges>
__cpp_lib_ranges_iota                                   202202L <numeric>
__cpp_lib_ranges_join_with                              202202L <ranges>
__cpp_lib_ranges_repeat                                 202207L <ranges>
__cpp_lib_ranges_slide                                  202202L <ranges>
__cpp_lib_ranges_starts_ends_with                       202106L <algorithm>
__cpp_lib_ranges_to_container                           202202L <deque> <forward_list> <list>
                                                                <map> <queue> <ranges>
                                                                <set> <stack> <string>
                                                                <unordered_map> <unordered_set> <vector>
__cpp_lib_ranges_zip                                    202110L <ranges> <tuple> <utility>
__cpp_lib_ratio                                         202306L <ratio>
__cpp_lib_raw_memory_algorithms                         201606L <memory>
__cpp_lib_rcu                                           202306L <rcu>
__cpp_lib_reference_from_temporary                      202202L <type_traits>
__cpp_lib_remove_cvref                                  201711L <type_traits>
__cpp_lib_result_of_sfinae                              201210L <functional> <type_traits>
__cpp_lib_robust_nonmodifying_seq_ops                   201304L <algorithm>
__cpp_lib_sample                                        201603L <algorithm>
__cpp_lib_scoped_lock                                   201703L <mutex>
__cpp_lib_semaphore                                     201907L <semaphore>
__cpp_lib_shared_mutex                                  201505L <shared_mutex>
__cpp_lib_shared_ptr_arrays                             201707L <memory>
                                                        201611L // C++17
__cpp_lib_shared_ptr_weak_type                          201606L <memory>
__cpp_lib_shared_timed_mutex                            201402L <shared_mutex>
__cpp_lib_shift                                         201806L <algorithm>
__cpp_lib_smart_ptr_for_overwrite                       202002L <memory>
__cpp_lib_smart_ptr_owner_equality                      202306L <memory>
__cpp_lib_source_location                               201907L <source_location>
__cpp_lib_span                                          202002L <span>
__cpp_lib_spanstream                                    202106L <spanstream>
__cpp_lib_ssize                                         201902L <iterator>
__cpp_lib_sstream_from_string_view                      202306L <sstream>
__cpp_lib_stacktrace                                    202011L <stacktrace>
__cpp_lib_starts_ends_with                              201711L <string> <string_view>
__cpp_lib_stdatomic_h                                   202011L <stdatomic.h>
__cpp_lib_string_contains                               202011L <string> <string_view>
__cpp_lib_string_resize_and_overwrite                   202110L <string>
__cpp_lib_string_udls                                   201304L <string>
__cpp_lib_string_view                                   201803L <string> <string_view>
                                                        201606L // C++17
__cpp_lib_submdspan                                     202306L <mdspan>
__cpp_lib_syncbuf                                       201803L <syncstream>
__cpp_lib_text_encoding                                 202306L <text_encoding>
__cpp_lib_three_way_comparison                          201907L <compare>
__cpp_lib_to_address                                    201711L <memory>
__cpp_lib_to_array                                      201907L <array>
__cpp_lib_to_chars                                      202306L <charconv>
                                                        201611L // C++17
__cpp_lib_to_string                                     202306L <string>
__cpp_lib_to_underlying                                 202102L <utility>
__cpp_lib_transformation_trait_aliases                  201304L <type_traits>
__cpp_lib_transparent_operators                         201510L <functional> <memory>
                                                        201210L // C++14
__cpp_lib_tuple_element_t                               201402L <tuple>
__cpp_lib_tuples_by_type                                201304L <tuple> <utility>
__cpp_lib_type_identity                                 201806L <type_traits>
__cpp_lib_type_trait_variable_templates                 201510L <type_traits>
__cpp_lib_uncaught_exceptions                           201411L <exception>
__cpp_lib_unordered_map_try_emplace                     201411L <unordered_map>
__cpp_lib_unreachable                                   202202L <utility>
__cpp_lib_unwrap_ref                                    201811L <functional>
__cpp_lib_variant                                       202102L <variant>
__cpp_lib_void_t                                        201411L <type_traits>
__cpp_lib_within_lifetime                               202306L <type_traits>

*/

#if 0 /* expanded by -frewrite-includes */
#include <__assert> // all public C++ headers provide the assertion handler
#endif /* expanded by -frewrite-includes */
# 227 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/version" 3
# 228 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/version" 3
#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 228 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/version" 3
# 229 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/version" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 231 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/version" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 232 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/version" 3
#endif
# 233 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/version" 3

// clang-format off

#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 14
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 237 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/version" 3
# define __cpp_lib_chrono_udls                          201304L
# define __cpp_lib_complex_udls                         201309L
# define __cpp_lib_exchange_function                    201304L
# define __cpp_lib_generic_associative_lookup           201304L
# define __cpp_lib_integer_sequence                     201304L
# define __cpp_lib_integral_constant_callable           201304L
# define __cpp_lib_is_final                             201402L
# define __cpp_lib_is_null_pointer                      201309L
# define __cpp_lib_make_reverse_iterator                201402L
# define __cpp_lib_make_unique                          201304L
# define __cpp_lib_null_iterators                       201304L
# define __cpp_lib_quoted_string_io                     201304L
# define __cpp_lib_result_of_sfinae                     201210L
# define __cpp_lib_robust_nonmodifying_seq_ops          201304L
#if 0 /* disabled by -frewrite-includes */
# if !defined(_LIBCPP_HAS_NO_THREADS) && !defined(_LIBCPP_AVAILABILITY_HAS_NO_SHARED_MUTEX)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 252 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/version" 3
#   define __cpp_lib_shared_timed_mutex                 201402L
# endif
# 254 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/version" 3
# define __cpp_lib_string_udls                          201304L
# define __cpp_lib_transformation_trait_aliases         201304L
# define __cpp_lib_transparent_operators                201210L
# define __cpp_lib_tuple_element_t                      201402L
# define __cpp_lib_tuples_by_type                       201304L
#endif
# 260 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/version" 3

#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 17
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 262 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/version" 3
# define __cpp_lib_addressof_constexpr                  201603L
# define __cpp_lib_allocator_traits_is_always_equal     201411L
# define __cpp_lib_any                                  201606L
# define __cpp_lib_apply                                201603L
# define __cpp_lib_array_constexpr                      201603L
# define __cpp_lib_as_const                             201510L
# define __cpp_lib_atomic_is_always_lock_free           201603L
# define __cpp_lib_bool_constant                        201505L
# define __cpp_lib_boyer_moore_searcher                 201603L
# define __cpp_lib_byte                                 201603L
# define __cpp_lib_chrono                               201611L
# define __cpp_lib_clamp                                201603L
# define __cpp_lib_enable_shared_from_this              201603L
// # define __cpp_lib_execution                            201603L
#if 0 /* disabled by -frewrite-includes */
# if !defined(_LIBCPP_AVAILABILITY_HAS_NO_FILESYSTEM_LIBRARY)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 277 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/version" 3
#   define __cpp_lib_filesystem                         201703L
# endif
# 279 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/version" 3
# define __cpp_lib_gcd_lcm                              201606L
#if 0 /* disabled by -frewrite-includes */
# if defined(__GCC_DESTRUCTIVE_SIZE) && defined(__GCC_CONSTRUCTIVE_SIZE)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 281 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/version" 3
#   define __cpp_lib_hardware_interference_size         201703L
# endif
# 283 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/version" 3
# define __cpp_lib_has_unique_object_representations    201606L
# define __cpp_lib_hypot                                201603L
# define __cpp_lib_incomplete_container_elements        201505L
# define __cpp_lib_invoke                               201411L
# define __cpp_lib_is_aggregate                         201703L
# define __cpp_lib_is_invocable                         201703L
# define __cpp_lib_is_swappable                         201603L
# define __cpp_lib_launder                              201606L
# define __cpp_lib_logical_traits                       201510L
# define __cpp_lib_make_from_tuple                      201606L
# define __cpp_lib_map_try_emplace                      201411L
// # define __cpp_lib_math_special_functions               201603L
#if 0 /* disabled by -frewrite-includes */
# if !defined(_LIBCPP_AVAILABILITY_HAS_NO_PMR)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 296 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/version" 3
#   define __cpp_lib_memory_resource                    201603L
# endif
# 298 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/version" 3
# define __cpp_lib_node_extract                         201606L
# define __cpp_lib_nonmember_container_access           201411L
# define __cpp_lib_not_fn                               201603L
# define __cpp_lib_optional                             201606L
// # define __cpp_lib_parallel_algorithm                   201603L
# define __cpp_lib_raw_memory_algorithms                201606L
# define __cpp_lib_sample                               201603L
# define __cpp_lib_scoped_lock                          201703L
#if 0 /* disabled by -frewrite-includes */
# if !defined(_LIBCPP_HAS_NO_THREADS) && !defined(_LIBCPP_AVAILABILITY_HAS_NO_SHARED_MUTEX)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 307 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/version" 3
#   define __cpp_lib_shared_mutex                       201505L
# endif
# 309 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/version" 3
# define __cpp_lib_shared_ptr_arrays                    201611L
# define __cpp_lib_shared_ptr_weak_type                 201606L
# define __cpp_lib_string_view                          201606L
// # define __cpp_lib_to_chars                             201611L
# undef  __cpp_lib_transparent_operators
# define __cpp_lib_transparent_operators                201510L
# define __cpp_lib_type_trait_variable_templates        201510L
# define __cpp_lib_uncaught_exceptions                  201411L
# define __cpp_lib_unordered_map_try_emplace            201411L
# define __cpp_lib_variant                              202102L
# define __cpp_lib_void_t                               201411L
#endif
# 321 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/version" 3

#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 20
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 323 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/version" 3
# undef  __cpp_lib_array_constexpr
# define __cpp_lib_array_constexpr                      201811L
# define __cpp_lib_assume_aligned                       201811L
# define __cpp_lib_atomic_flag_test                     201907L
// # define __cpp_lib_atomic_float                         201711L
# define __cpp_lib_atomic_lock_free_type_aliases        201907L
// # define __cpp_lib_atomic_ref                           201806L
// # define __cpp_lib_atomic_shared_ptr                    201711L
# define __cpp_lib_atomic_value_initialization          201911L
#if 0 /* disabled by -frewrite-includes */
# if !defined(_LIBCPP_AVAILABILITY_HAS_NO_SYNC)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 333 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/version" 3
#   define __cpp_lib_atomic_wait                        201907L
# endif
# 335 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/version" 3
#if 0 /* disabled by -frewrite-includes */
# if !defined(_LIBCPP_HAS_NO_THREADS) && !defined(_LIBCPP_AVAILABILITY_HAS_NO_SYNC)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 336 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/version" 3
#   define __cpp_lib_barrier                            201907L
# endif
# 338 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/version" 3
# define __cpp_lib_bind_front                           201907L
# define __cpp_lib_bit_cast                             201806L
# define __cpp_lib_bitops                               201907L
# define __cpp_lib_bounded_array_traits                 201902L
#if 0 /* disabled by -frewrite-includes */
# if !defined(_LIBCPP_HAS_NO_CHAR8_T)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 343 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/version" 3
#   define __cpp_lib_char8_t                            201907L
# endif
# 345 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/version" 3
# define __cpp_lib_concepts                             202002L
# define __cpp_lib_constexpr_algorithms                 201806L
# define __cpp_lib_constexpr_complex                    201711L
# define __cpp_lib_constexpr_dynamic_alloc              201907L
# define __cpp_lib_constexpr_functional                 201907L
# define __cpp_lib_constexpr_iterator                   201811L
# define __cpp_lib_constexpr_memory                     201811L
# define __cpp_lib_constexpr_numeric                    201911L
# define __cpp_lib_constexpr_string                     201907L
# define __cpp_lib_constexpr_string_view                201811L
# define __cpp_lib_constexpr_tuple                      201811L
# define __cpp_lib_constexpr_utility                    201811L
# define __cpp_lib_constexpr_vector                     201907L
# define __cpp_lib_coroutine                            201902L
#if 0 /* disabled by -frewrite-includes */
# if _LIBCPP_STD_VER >= 20 && defined(__cpp_impl_destroying_delete) && __cpp_impl_destroying_delete >= 201806L
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 360 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/version" 3
#   define __cpp_lib_destroying_delete                  201806L
# endif
# 362 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/version" 3
# define __cpp_lib_endian                               201907L
# define __cpp_lib_erase_if                             202002L
# undef  __cpp_lib_execution
// # define __cpp_lib_execution                            201902L
// # define __cpp_lib_format                               202106L
# define __cpp_lib_generic_unordered_lookup             201811L
# define __cpp_lib_int_pow2                             202002L
# define __cpp_lib_integer_comparison_functions         202002L
# define __cpp_lib_interpolate                          201902L
# define __cpp_lib_is_constant_evaluated                201811L
// # define __cpp_lib_is_layout_compatible                 201907L
# define __cpp_lib_is_nothrow_convertible               201806L
// # define __cpp_lib_is_pointer_interconvertible          201907L
#if 0 /* disabled by -frewrite-includes */
# if !defined(_LIBCPP_HAS_NO_THREADS) && !defined(_LIBCPP_HAS_NO_EXPERIMENTAL_STOP_TOKEN) && !defined(_LIBCPP_AVAILABILITY_HAS_NO_SYNC)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 376 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/version" 3
#   define __cpp_lib_jthread                            201911L
# endif
# 378 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/version" 3
#if 0 /* disabled by -frewrite-includes */
# if !defined(_LIBCPP_HAS_NO_THREADS) && !defined(_LIBCPP_AVAILABILITY_HAS_NO_SYNC)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 379 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/version" 3
#   define __cpp_lib_latch                              201907L
# endif
# 381 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/version" 3
# define __cpp_lib_list_remove_return_type              201806L
# define __cpp_lib_math_constants                       201907L
# define __cpp_lib_move_iterator_concept                202207L
#if 0 /* disabled by -frewrite-includes */
# if !defined(_LIBCPP_AVAILABILITY_HAS_NO_PMR)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 385 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/version" 3
#   define __cpp_lib_polymorphic_allocator              201902L
# endif
# 387 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/version" 3
# define __cpp_lib_ranges                               202207L
# define __cpp_lib_remove_cvref                         201711L
#if 0 /* disabled by -frewrite-includes */
# if !defined(_LIBCPP_HAS_NO_THREADS) && !defined(_LIBCPP_AVAILABILITY_HAS_NO_SYNC)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 390 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/version" 3
#   define __cpp_lib_semaphore                          201907L
# endif
# 392 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/version" 3
# undef  __cpp_lib_shared_ptr_arrays
# define __cpp_lib_shared_ptr_arrays                    201707L
# define __cpp_lib_shift                                201806L
// # define __cpp_lib_smart_ptr_for_overwrite              202002L
#if 0 /* disabled by -frewrite-includes */
# if __has_builtin(__builtin_source_location) && !(defined(_LIBCPP_APPLE_CLANG_VER) && _LIBCPP_APPLE_CLANG_VER <= 1403)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 397 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/version" 3
#   define __cpp_lib_source_location                    201907L
# endif
# 399 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/version" 3
# define __cpp_lib_span                                 202002L
# define __cpp_lib_ssize                                201902L
# define __cpp_lib_starts_ends_with                     201711L
# undef  __cpp_lib_string_view
# define __cpp_lib_string_view                          201803L
// # define __cpp_lib_syncbuf                              201803L
// # define __cpp_lib_three_way_comparison                 201907L
# define __cpp_lib_to_address                           201711L
# define __cpp_lib_to_array                             201907L
# define __cpp_lib_type_identity                        201806L
# define __cpp_lib_unwrap_ref                           201811L
#endif
# 411 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/version" 3

#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 23
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 413 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/version" 3
# define __cpp_lib_adaptor_iterator_pair_constructor    202106L
# define __cpp_lib_allocate_at_least                    202106L
// # define __cpp_lib_associative_heterogeneous_erasure    202110L
// # define __cpp_lib_bind_back                            202202L
# define __cpp_lib_byteswap                             202110L
# define __cpp_lib_constexpr_bitset                     202207L
# define __cpp_lib_constexpr_charconv                   202207L
// # define __cpp_lib_constexpr_cmath                      202202L
# undef  __cpp_lib_constexpr_memory
# define __cpp_lib_constexpr_memory                     202202L
# define __cpp_lib_constexpr_typeinfo                   202106L
# define __cpp_lib_expected                             202211L
# define __cpp_lib_format_ranges                        202207L
// # define __cpp_lib_formatters                           202302L
# define __cpp_lib_forward_like                         202207L
# define __cpp_lib_invoke_r                             202106L
# define __cpp_lib_is_scoped_enum                       202011L
// # define __cpp_lib_mdspan                               202207L
// # define __cpp_lib_move_only_function                   202110L
# undef  __cpp_lib_optional
# define __cpp_lib_optional                             202110L
// # define __cpp_lib_out_ptr                              202106L
// # define __cpp_lib_print                                202207L
# define __cpp_lib_ranges_as_rvalue                     202207L
// # define __cpp_lib_ranges_chunk                         202202L
# define __cpp_lib_ranges_chunk_by                      202202L
// # define __cpp_lib_ranges_iota                          202202L
// # define __cpp_lib_ranges_join_with                     202202L
# define __cpp_lib_ranges_repeat                        202207L
// # define __cpp_lib_ranges_slide                         202202L
// # define __cpp_lib_ranges_starts_ends_with              202106L
# define __cpp_lib_ranges_to_container                  202202L
// # define __cpp_lib_ranges_zip                           202110L
// # define __cpp_lib_reference_from_temporary             202202L
// # define __cpp_lib_spanstream                           202106L
// # define __cpp_lib_stacktrace                           202011L
# define __cpp_lib_stdatomic_h                          202011L
# define __cpp_lib_string_contains                      202011L
# define __cpp_lib_string_resize_and_overwrite          202110L
// # define __cpp_lib_to_string                            202306L
# define __cpp_lib_to_underlying                        202102L
# define __cpp_lib_unreachable                          202202L
#endif
# 456 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/version" 3

#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 26
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 458 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/version" 3
// # define __cpp_lib_associative_heterogeneous_insertion  202306L
# undef  __cpp_lib_bind_back
// # define __cpp_lib_bind_back                            202306L
# undef  __cpp_lib_bind_front
# define __cpp_lib_bind_front                           202306L
# define __cpp_lib_bitset                               202306L
// # define __cpp_lib_copyable_function                    202306L
// # define __cpp_lib_fstream_native_handle                202306L
// # define __cpp_lib_function_ref                         202306L
// # define __cpp_lib_hazard_pointer                       202306L
# define __cpp_lib_ratio                                202306L
// # define __cpp_lib_rcu                                  202306L
// # define __cpp_lib_smart_ptr_owner_equality             202306L
// # define __cpp_lib_sstream_from_string_view             202306L
// # define __cpp_lib_submdspan                            202306L
// # define __cpp_lib_text_encoding                        202306L
# undef  __cpp_lib_to_chars
// # define __cpp_lib_to_chars                             202306L
// # define __cpp_lib_within_lifetime                      202306L
#endif
# 478 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/version" 3

// clang-format on

#endif // _LIBCPP_VERSIONH
# 482 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/version" 3
#endif /* version expanded by -frewrite-includes */
# 42 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/cstddef" 2 3

#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* stddef.h expanded by -frewrite-includes */
#include <stddef.h>
#else /* stddef.h expanded by -frewrite-includes */
# 43 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/cstddef" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/stddef.h" 1 3
// -*- C++ -*-
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#if 0 /* disabled by -frewrite-includes */
#if defined(__need_ptrdiff_t) || defined(__need_size_t) || \
    defined(__need_wchar_t) || defined(__need_NULL) || defined(__need_wint_t)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/stddef.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/stddef.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/stddef.h" 3
#endif
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/stddef.h" 3

#if 0 /* expanded by -frewrite-includes */
#include_next <stddef.h>
#endif /* expanded by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/stddef.h" 3
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/stddef.h" 3

#if 0 /* disabled by -frewrite-includes */
#if 0
#elif !defined(_LIBCPP_STDDEF_H)
#endif
#endif /* disabled by -frewrite-includes */
#elif 1 /* evaluated by -frewrite-includes */
# 20 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/stddef.h" 3
#define _LIBCPP_STDDEF_H

/*
    stddef.h synopsis

Macros:

    offsetof(type,member-designator)
    NULL

Types:

    ptrdiff_t
    size_t
    max_align_t // C++11
    nullptr_t

*/

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 39 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/stddef.h" 3
# 40 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/stddef.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 42 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/stddef.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 43 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/stddef.h" 3
#endif
# 44 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/stddef.h" 3

#if 0 /* disabled by -frewrite-includes */
#  if __has_include_next(<stddef.h>)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 46 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/stddef.h" 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* stddef.h expanded by -frewrite-includes */
#    include_next <stddef.h>
#else /* stddef.h expanded by -frewrite-includes */
# 46 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/stddef.h" 3
# 1 "../../prebuilt/third_party/clang/custom/lib/clang/18/include/stddef.h" 1 3
/*===---- stddef.h - Basic type definitions --------------------------------===
 *
 * Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
 * See https://llvm.org/LICENSE.txt for license information.
 * SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
 *
 *===-----------------------------------------------------------------------===
 */

/*
 * This header is designed to be included multiple times. If any of the __need_
 * macros are defined, then only that subset of interfaces are provided. This
 * can be useful for POSIX headers that need to not expose all of stddef.h, but
 * need to use some of its interfaces. Otherwise this header provides all of
 * the expected interfaces.
 *
 * When clang modules are enabled, this header is a textual header. It ignores
 * its header guard so that multiple submodules can export its interfaces.
 * Take module SM with submodules A and B, whose headers both include stddef.h
 * When SM.A builds, __STDDEF_H will be defined. When SM.B builds, the
 * definition from SM.A will leak when building without local submodule
 * visibility. stddef.h wouldn't include any of its implementation headers, and
 * SM.B wouldn't import any of the stddef modules, and SM.B's `export *`
 * wouldn't export any stddef interfaces as expected. However, since stddef.h
 * ignores its header guard when building with modules, it all works as
 * expected.
 *
 * When clang modules are not enabled, the header guards can function in the
 * normal simple fashion.
 */
#if 0 /* disabled by -frewrite-includes */
#if !defined(__STDDEF_H) || __has_feature(modules) ||                          \
    (defined(__STDC_WANT_LIB_EXT1__) && __STDC_WANT_LIB_EXT1__ >= 1) ||        \
    defined(__need_ptrdiff_t) || defined(__need_size_t) ||                     \
    defined(__need_rsize_t) || defined(__need_wchar_t) ||                      \
    defined(__need_NULL) || defined(__need_nullptr_t) ||                       \
    defined(__need_unreachable) || defined(__need_max_align_t) ||              \
    defined(__need_offsetof) || defined(__need_wint_t)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 38 "../../prebuilt/third_party/clang/custom/lib/clang/18/include/stddef.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(__need_ptrdiff_t) && !defined(__need_size_t) &&                   \
    !defined(__need_rsize_t) && !defined(__need_wchar_t) &&                    \
    !defined(__need_NULL) && !defined(__need_nullptr_t) &&                     \
    !defined(__need_unreachable) && !defined(__need_max_align_t) &&            \
    !defined(__need_offsetof) && !defined(__need_wint_t)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 44 "../../prebuilt/third_party/clang/custom/lib/clang/18/include/stddef.h" 3
#define __STDDEF_H
#define __need_ptrdiff_t
#define __need_size_t
/* ISO9899:2011 7.20 (C11 Annex K): Define rsize_t if __STDC_WANT_LIB_EXT1__ is
 * enabled. */
#if 0 /* disabled by -frewrite-includes */
#if defined(__STDC_WANT_LIB_EXT1__) && __STDC_WANT_LIB_EXT1__ >= 1
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 50 "../../prebuilt/third_party/clang/custom/lib/clang/18/include/stddef.h" 3
#define __need_rsize_t
#endif
# 52 "../../prebuilt/third_party/clang/custom/lib/clang/18/include/stddef.h" 3
#define __need_wchar_t
#define __need_NULL
#if 0 /* disabled by -frewrite-includes */
#if (defined(__STDC_VERSION__) && __STDC_VERSION__ >= 202311L) ||              \
    defined(__cplusplus)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 56 "../../prebuilt/third_party/clang/custom/lib/clang/18/include/stddef.h" 3
#define __need_nullptr_t
#endif
# 58 "../../prebuilt/third_party/clang/custom/lib/clang/18/include/stddef.h" 3
#if 0 /* disabled by -frewrite-includes */
#if defined(__STDC_VERSION__) && __STDC_VERSION__ >= 202311L
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 59 "../../prebuilt/third_party/clang/custom/lib/clang/18/include/stddef.h" 3
#define __need_unreachable
#endif
# 61 "../../prebuilt/third_party/clang/custom/lib/clang/18/include/stddef.h" 3
#if 0 /* disabled by -frewrite-includes */
#if (defined(__STDC_VERSION__) && __STDC_VERSION__ >= 201112L) ||              \
    (defined(__cplusplus) && __cplusplus >= 201103L)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 63 "../../prebuilt/third_party/clang/custom/lib/clang/18/include/stddef.h" 3
#define __need_max_align_t
#endif
# 65 "../../prebuilt/third_party/clang/custom/lib/clang/18/include/stddef.h" 3
#define __need_offsetof
/* wint_t is provided by <wchar.h> and not <stddef.h>. It's here
 * for compatibility, but must be explicitly requested. Therefore
 * __need_wint_t is intentionally not defined here. */
#endif
# 70 "../../prebuilt/third_party/clang/custom/lib/clang/18/include/stddef.h" 3

#if 0 /* disabled by -frewrite-includes */
#if defined(__need_ptrdiff_t)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 72 "../../prebuilt/third_party/clang/custom/lib/clang/18/include/stddef.h" 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* __stddef_ptrdiff_t.h expanded by -frewrite-includes */
#include <__stddef_ptrdiff_t.h>
#else /* __stddef_ptrdiff_t.h expanded by -frewrite-includes */
# 72 "../../prebuilt/third_party/clang/custom/lib/clang/18/include/stddef.h" 3
# 1 "../../prebuilt/third_party/clang/custom/lib/clang/18/include/__stddef_ptrdiff_t.h" 1 3
/*===---- __stddef_ptrdiff_t.h - Definition of ptrdiff_t -------------------===
 *
 * Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
 * See https://llvm.org/LICENSE.txt for license information.
 * SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
 *
 *===-----------------------------------------------------------------------===
 */

#ifndef _PTRDIFF_T
#define _PTRDIFF_T

typedef __PTRDIFF_TYPE__ ptrdiff_t;

#endif
# 16 "../../prebuilt/third_party/clang/custom/lib/clang/18/include/__stddef_ptrdiff_t.h" 3
#endif /* __stddef_ptrdiff_t.h expanded by -frewrite-includes */
# 73 "../../prebuilt/third_party/clang/custom/lib/clang/18/include/stddef.h" 2 3
#undef __need_ptrdiff_t
#endif /* defined(__need_ptrdiff_t) */
# 75 "../../prebuilt/third_party/clang/custom/lib/clang/18/include/stddef.h" 3

#if 0 /* disabled by -frewrite-includes */
#if defined(__need_size_t)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 77 "../../prebuilt/third_party/clang/custom/lib/clang/18/include/stddef.h" 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* __stddef_size_t.h expanded by -frewrite-includes */
#include <__stddef_size_t.h>
#else /* __stddef_size_t.h expanded by -frewrite-includes */
# 77 "../../prebuilt/third_party/clang/custom/lib/clang/18/include/stddef.h" 3
# 1 "../../prebuilt/third_party/clang/custom/lib/clang/18/include/__stddef_size_t.h" 1 3
/*===---- __stddef_size_t.h - Definition of size_t -------------------------===
 *
 * Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
 * See https://llvm.org/LICENSE.txt for license information.
 * SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
 *
 *===-----------------------------------------------------------------------===
 */

#ifndef _SIZE_T
#define _SIZE_T

typedef __SIZE_TYPE__ size_t;

#endif
# 16 "../../prebuilt/third_party/clang/custom/lib/clang/18/include/__stddef_size_t.h" 3
#endif /* __stddef_size_t.h expanded by -frewrite-includes */
# 78 "../../prebuilt/third_party/clang/custom/lib/clang/18/include/stddef.h" 2 3
#undef __need_size_t
#endif /*defined(__need_size_t) */
# 80 "../../prebuilt/third_party/clang/custom/lib/clang/18/include/stddef.h" 3

#if 0 /* disabled by -frewrite-includes */
#if defined(__need_rsize_t)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 82 "../../prebuilt/third_party/clang/custom/lib/clang/18/include/stddef.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__stddef_rsize_t.h>
#endif /* expanded by -frewrite-includes */
# 82 "../../prebuilt/third_party/clang/custom/lib/clang/18/include/stddef.h" 3
# 83 "../../prebuilt/third_party/clang/custom/lib/clang/18/include/stddef.h" 3
#undef __need_rsize_t
#endif /* defined(__need_rsize_t) */
# 85 "../../prebuilt/third_party/clang/custom/lib/clang/18/include/stddef.h" 3

#if 0 /* disabled by -frewrite-includes */
#if defined(__need_wchar_t)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 87 "../../prebuilt/third_party/clang/custom/lib/clang/18/include/stddef.h" 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* __stddef_wchar_t.h expanded by -frewrite-includes */
#include <__stddef_wchar_t.h>
#else /* __stddef_wchar_t.h expanded by -frewrite-includes */
# 87 "../../prebuilt/third_party/clang/custom/lib/clang/18/include/stddef.h" 3
# 1 "../../prebuilt/third_party/clang/custom/lib/clang/18/include/__stddef_wchar_t.h" 1 3
/*===---- __stddef_wchar.h - Definition of wchar_t -------------------------===
 *
 * Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
 * See https://llvm.org/LICENSE.txt for license information.
 * SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
 *
 *===-----------------------------------------------------------------------===
 */

#if 0 /* disabled by -frewrite-includes */
#if !defined(__cplusplus) || (defined(_MSC_VER) && !_NATIVE_WCHAR_T_DEFINED)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 11 "../../prebuilt/third_party/clang/custom/lib/clang/18/include/__stddef_wchar_t.h" 3

#ifndef _WCHAR_T
#define _WCHAR_T

#ifdef _MSC_EXTENSIONS
#define _WCHAR_T_DEFINED
#endif
# 18 "../../prebuilt/third_party/clang/custom/lib/clang/18/include/__stddef_wchar_t.h" 3

typedef __WCHAR_TYPE__ wchar_t;

#endif
# 22 "../../prebuilt/third_party/clang/custom/lib/clang/18/include/__stddef_wchar_t.h" 3

#endif
# 24 "../../prebuilt/third_party/clang/custom/lib/clang/18/include/__stddef_wchar_t.h" 3
#endif /* __stddef_wchar_t.h expanded by -frewrite-includes */
# 88 "../../prebuilt/third_party/clang/custom/lib/clang/18/include/stddef.h" 2 3
#undef __need_wchar_t
#endif /* defined(__need_wchar_t) */
# 90 "../../prebuilt/third_party/clang/custom/lib/clang/18/include/stddef.h" 3

#if 0 /* disabled by -frewrite-includes */
#if defined(__need_NULL)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 92 "../../prebuilt/third_party/clang/custom/lib/clang/18/include/stddef.h" 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* __stddef_null.h expanded by -frewrite-includes */
#include <__stddef_null.h>
#else /* __stddef_null.h expanded by -frewrite-includes */
# 92 "../../prebuilt/third_party/clang/custom/lib/clang/18/include/stddef.h" 3
# 1 "../../prebuilt/third_party/clang/custom/lib/clang/18/include/__stddef_null.h" 1 3
/*===---- __stddef_null.h - Definition of NULL -----------------------------===
 *
 * Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
 * See https://llvm.org/LICENSE.txt for license information.
 * SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
 *
 *===-----------------------------------------------------------------------===
 */

#if 0 /* disabled by -frewrite-includes */
#if !defined(NULL) || !__has_feature(modules)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 11 "../../prebuilt/third_party/clang/custom/lib/clang/18/include/__stddef_null.h" 3

/* linux/stddef.h will define NULL to 0. glibc (and other) headers then define
 * __need_NULL and rely on stddef.h to redefine NULL to the correct value again.
 * Modules don't support redefining macros like that, but support that pattern
 * in the non-modules case.
 */
#undef NULL

#ifdef __cplusplus
#if 0 /* disabled by -frewrite-includes */
#if !defined(__MINGW32__) && !defined(_MSC_VER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 21 "../../prebuilt/third_party/clang/custom/lib/clang/18/include/__stddef_null.h" 3
#define NULL __null
#else
# 23 "../../prebuilt/third_party/clang/custom/lib/clang/18/include/__stddef_null.h" 3
#define NULL 0
#endif
# 25 "../../prebuilt/third_party/clang/custom/lib/clang/18/include/__stddef_null.h" 3
#else
# 26 "../../prebuilt/third_party/clang/custom/lib/clang/18/include/__stddef_null.h" 3
#define NULL ((void*)0)
#endif
# 28 "../../prebuilt/third_party/clang/custom/lib/clang/18/include/__stddef_null.h" 3

#endif
# 30 "../../prebuilt/third_party/clang/custom/lib/clang/18/include/__stddef_null.h" 3
#endif /* __stddef_null.h expanded by -frewrite-includes */
# 93 "../../prebuilt/third_party/clang/custom/lib/clang/18/include/stddef.h" 2 3
#undef __need_NULL
#endif /* defined(__need_NULL) */
# 95 "../../prebuilt/third_party/clang/custom/lib/clang/18/include/stddef.h" 3

#if 0 /* disabled by -frewrite-includes */
#if defined(__need_nullptr_t)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 97 "../../prebuilt/third_party/clang/custom/lib/clang/18/include/stddef.h" 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* __stddef_nullptr_t.h expanded by -frewrite-includes */
#include <__stddef_nullptr_t.h>
#else /* __stddef_nullptr_t.h expanded by -frewrite-includes */
# 97 "../../prebuilt/third_party/clang/custom/lib/clang/18/include/stddef.h" 3
# 1 "../../prebuilt/third_party/clang/custom/lib/clang/18/include/__stddef_nullptr_t.h" 1 3
/*===---- __stddef_nullptr_t.h - Definition of nullptr_t -------------------===
 *
 * Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
 * See https://llvm.org/LICENSE.txt for license information.
 * SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
 *
 *===-----------------------------------------------------------------------===
 */

#ifndef _NULLPTR_T
#define _NULLPTR_T

#ifdef __cplusplus
#if 0 /* disabled by -frewrite-includes */
#if defined(_MSC_EXTENSIONS) && defined(_NATIVE_NULLPTR_SUPPORTED)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/lib/clang/18/include/__stddef_nullptr_t.h" 3
namespace std {
typedef decltype(nullptr) nullptr_t;
}
using ::std::nullptr_t;
#endif
# 20 "../../prebuilt/third_party/clang/custom/lib/clang/18/include/__stddef_nullptr_t.h" 3
#if 0 /* disabled by -frewrite-includes */
#if 0
#elif defined(__STDC_VERSION__) && __STDC_VERSION__ >= 202311L
#endif
#endif /* disabled by -frewrite-includes */
#elif 0 /* evaluated by -frewrite-includes */
# 21 "../../prebuilt/third_party/clang/custom/lib/clang/18/include/__stddef_nullptr_t.h" 3
typedef typeof(nullptr) nullptr_t;
#endif
# 23 "../../prebuilt/third_party/clang/custom/lib/clang/18/include/__stddef_nullptr_t.h" 3

#endif
# 25 "../../prebuilt/third_party/clang/custom/lib/clang/18/include/__stddef_nullptr_t.h" 3
#endif /* __stddef_nullptr_t.h expanded by -frewrite-includes */
# 98 "../../prebuilt/third_party/clang/custom/lib/clang/18/include/stddef.h" 2 3
#undef __need_nullptr_t
#endif /* defined(__need_nullptr_t) */
# 100 "../../prebuilt/third_party/clang/custom/lib/clang/18/include/stddef.h" 3

#if 0 /* disabled by -frewrite-includes */
#if defined(__need_unreachable)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 102 "../../prebuilt/third_party/clang/custom/lib/clang/18/include/stddef.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__stddef_unreachable.h>
#endif /* expanded by -frewrite-includes */
# 102 "../../prebuilt/third_party/clang/custom/lib/clang/18/include/stddef.h" 3
# 103 "../../prebuilt/third_party/clang/custom/lib/clang/18/include/stddef.h" 3
#undef __need_unreachable
#endif /* defined(__need_unreachable) */
# 105 "../../prebuilt/third_party/clang/custom/lib/clang/18/include/stddef.h" 3

#if 0 /* disabled by -frewrite-includes */
#if defined(__need_max_align_t)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 107 "../../prebuilt/third_party/clang/custom/lib/clang/18/include/stddef.h" 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* __stddef_max_align_t.h expanded by -frewrite-includes */
#include <__stddef_max_align_t.h>
#else /* __stddef_max_align_t.h expanded by -frewrite-includes */
# 107 "../../prebuilt/third_party/clang/custom/lib/clang/18/include/stddef.h" 3
# 1 "../../prebuilt/third_party/clang/custom/lib/clang/18/include/__stddef_max_align_t.h" 1 3
/*===---- __stddef_max_align_t.h - Definition of max_align_t ---------------===
 *
 * Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
 * See https://llvm.org/LICENSE.txt for license information.
 * SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
 *
 *===-----------------------------------------------------------------------===
 */

#ifndef __CLANG_MAX_ALIGN_T_DEFINED
#define __CLANG_MAX_ALIGN_T_DEFINED

#if 0 /* disabled by -frewrite-includes */
#if defined(_MSC_VER)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/lib/clang/18/include/__stddef_max_align_t.h" 3
typedef double max_align_t;
#if 0 /* disabled by -frewrite-includes */
#if 0
#elif defined(__APPLE__)
#endif
#endif /* disabled by -frewrite-includes */
#elif 0 /* evaluated by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/lib/clang/18/include/__stddef_max_align_t.h" 3
typedef long double max_align_t;
#else
# 18 "../../prebuilt/third_party/clang/custom/lib/clang/18/include/__stddef_max_align_t.h" 3
// Define 'max_align_t' to match the GCC definition.
typedef struct {
  long long __clang_max_align_nonce1
      __attribute__((__aligned__(__alignof__(long long))));
  long double __clang_max_align_nonce2
      __attribute__((__aligned__(__alignof__(long double))));
} max_align_t;
#endif
# 26 "../../prebuilt/third_party/clang/custom/lib/clang/18/include/__stddef_max_align_t.h" 3

#endif
# 28 "../../prebuilt/third_party/clang/custom/lib/clang/18/include/__stddef_max_align_t.h" 3
#endif /* __stddef_max_align_t.h expanded by -frewrite-includes */
# 108 "../../prebuilt/third_party/clang/custom/lib/clang/18/include/stddef.h" 2 3
#undef __need_max_align_t
#endif /* defined(__need_max_align_t) */
# 110 "../../prebuilt/third_party/clang/custom/lib/clang/18/include/stddef.h" 3

#if 0 /* disabled by -frewrite-includes */
#if defined(__need_offsetof)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 112 "../../prebuilt/third_party/clang/custom/lib/clang/18/include/stddef.h" 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* __stddef_offsetof.h expanded by -frewrite-includes */
#include <__stddef_offsetof.h>
#else /* __stddef_offsetof.h expanded by -frewrite-includes */
# 112 "../../prebuilt/third_party/clang/custom/lib/clang/18/include/stddef.h" 3
# 1 "../../prebuilt/third_party/clang/custom/lib/clang/18/include/__stddef_offsetof.h" 1 3
/*===---- __stddef_offsetof.h - Definition of offsetof ---------------------===
 *
 * Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
 * See https://llvm.org/LICENSE.txt for license information.
 * SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
 *
 *===-----------------------------------------------------------------------===
 */

#ifndef offsetof
#define offsetof(t, d) __builtin_offsetof(t, d)
#endif
# 13 "../../prebuilt/third_party/clang/custom/lib/clang/18/include/__stddef_offsetof.h" 3
#endif /* __stddef_offsetof.h expanded by -frewrite-includes */
# 113 "../../prebuilt/third_party/clang/custom/lib/clang/18/include/stddef.h" 2 3
#undef __need_offsetof
#endif /* defined(__need_offsetof) */
# 115 "../../prebuilt/third_party/clang/custom/lib/clang/18/include/stddef.h" 3

/* Some C libraries expect to see a wint_t here. Others (notably MinGW) will use
__WINT_TYPE__ directly; accommodate both by requiring __need_wint_t */
#if 0 /* disabled by -frewrite-includes */
#if defined(__need_wint_t)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 119 "../../prebuilt/third_party/clang/custom/lib/clang/18/include/stddef.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__stddef_wint_t.h>
#endif /* expanded by -frewrite-includes */
# 119 "../../prebuilt/third_party/clang/custom/lib/clang/18/include/stddef.h" 3
# 120 "../../prebuilt/third_party/clang/custom/lib/clang/18/include/stddef.h" 3
#undef __need_wint_t
#endif /* __need_wint_t */
# 122 "../../prebuilt/third_party/clang/custom/lib/clang/18/include/stddef.h" 3

#endif
# 124 "../../prebuilt/third_party/clang/custom/lib/clang/18/include/stddef.h" 3
#endif /* stddef.h expanded by -frewrite-includes */
# 47 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/stddef.h" 2 3
#  endif
# 48 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/stddef.h" 3

#ifdef __cplusplus
    typedef decltype(nullptr) nullptr_t;
#endif
# 52 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/stddef.h" 3

#endif // _LIBCPP_STDDEF_H
# 54 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/stddef.h" 3
#endif /* stddef.h expanded by -frewrite-includes */
# 44 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/cstddef" 2 3

#ifndef _LIBCPP_STDDEF_H
#   error <cstddef> tried including <stddef.h> but didn't find libc++'s <stddef.h> header. \
          This usually means that your header search paths are not configured properly. \
          The header search paths should contain the C++ Standard Library headers before \
          any C Standard Library, and you are probably using compiler flags that make that \
          not be the case.
#endif
# 52 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/cstddef" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 54 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/cstddef" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 55 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/cstddef" 3
#endif
# 56 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/cstddef" 3

_LIBCPP_BEGIN_NAMESPACE_STD

using ::nullptr_t;
using ::ptrdiff_t _LIBCPP_USING_IF_EXISTS;
using ::size_t _LIBCPP_USING_IF_EXISTS;

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_CXX03_LANG)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 64 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/cstddef" 3
using ::max_align_t _LIBCPP_USING_IF_EXISTS;
#endif
# 66 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/cstddef" 3

_LIBCPP_END_NAMESPACE_STD

#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 17
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 70 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/cstddef" 3
namespace std  // purposefully not versioned
{
enum class byte : unsigned char {};

_LIBCPP_HIDE_FROM_ABI constexpr byte  operator| (byte  __lhs, byte __rhs) noexcept
{
    return static_cast<byte>(
      static_cast<unsigned char>(
         static_cast<unsigned int>(__lhs) | static_cast<unsigned int>(__rhs)
    ));
}

_LIBCPP_HIDE_FROM_ABI constexpr byte& operator|=(byte& __lhs, byte __rhs) noexcept
{ return __lhs = __lhs | __rhs; }

_LIBCPP_HIDE_FROM_ABI constexpr byte  operator& (byte  __lhs, byte __rhs) noexcept
{
    return static_cast<byte>(
      static_cast<unsigned char>(
         static_cast<unsigned int>(__lhs) & static_cast<unsigned int>(__rhs)
    ));
}

_LIBCPP_HIDE_FROM_ABI constexpr byte& operator&=(byte& __lhs, byte __rhs) noexcept
{ return __lhs = __lhs & __rhs; }

_LIBCPP_HIDE_FROM_ABI constexpr byte  operator^ (byte  __lhs, byte __rhs) noexcept
{
    return static_cast<byte>(
      static_cast<unsigned char>(
         static_cast<unsigned int>(__lhs) ^ static_cast<unsigned int>(__rhs)
    ));
}

_LIBCPP_HIDE_FROM_ABI constexpr byte& operator^=(byte& __lhs, byte __rhs) noexcept
{ return __lhs = __lhs ^ __rhs; }

_LIBCPP_HIDE_FROM_ABI constexpr byte  operator~ (byte __b) noexcept
{
    return static_cast<byte>(
      static_cast<unsigned char>(
        ~static_cast<unsigned int>(__b)
    ));
}

template <class _Tp>
using _EnableByteOverload = __enable_if_t<is_integral<_Tp>::value, byte>;

template <class _Integer>
_LIBCPP_HIDE_FROM_ABI constexpr _EnableByteOverload<_Integer> &
  operator<<=(byte& __lhs, _Integer __shift) noexcept
  { return __lhs = __lhs << __shift; }

template <class _Integer>
_LIBCPP_HIDE_FROM_ABI constexpr _EnableByteOverload<_Integer>
  operator<< (byte  __lhs, _Integer __shift) noexcept
  { return static_cast<byte>(static_cast<unsigned char>(static_cast<unsigned int>(__lhs) << __shift)); }

template <class _Integer>
_LIBCPP_HIDE_FROM_ABI constexpr _EnableByteOverload<_Integer> &
  operator>>=(byte& __lhs, _Integer __shift) noexcept
  { return __lhs = __lhs >> __shift; }

template <class _Integer>
_LIBCPP_HIDE_FROM_ABI constexpr _EnableByteOverload<_Integer>
  operator>> (byte  __lhs, _Integer __shift) noexcept
  { return static_cast<byte>(static_cast<unsigned char>(static_cast<unsigned int>(__lhs) >> __shift)); }

template <class _Integer, class = _EnableByteOverload<_Integer> >
_LIBCPP_NODISCARD_EXT _LIBCPP_HIDE_FROM_ABI constexpr _Integer
  to_integer(byte __b) noexcept { return static_cast<_Integer>(__b); }

} // namespace std

#endif
# 145 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/cstddef" 3

#endif // _LIBCPP_CSTDDEF
# 147 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/cstddef" 3
#endif /* cstddef expanded by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/access.h" 2 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/access.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/access.h" 3
#endif
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/access.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

template <class _Tp, size_t _Np>
_LIBCPP_INLINE_VISIBILITY _LIBCPP_CONSTEXPR_SINCE_CXX14
_Tp*
begin(_Tp (&__array)[_Np])
{
    return __array;
}

template <class _Tp, size_t _Np>
_LIBCPP_INLINE_VISIBILITY _LIBCPP_CONSTEXPR_SINCE_CXX14
_Tp*
end(_Tp (&__array)[_Np])
{
    return __array + _Np;
}

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_CXX03_LANG)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 39 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/access.h" 3

template <class _Cp>
_LIBCPP_INLINE_VISIBILITY _LIBCPP_CONSTEXPR_SINCE_CXX17
auto
begin(_Cp& __c) -> decltype(__c.begin())
{
    return __c.begin();
}

template <class _Cp>
_LIBCPP_INLINE_VISIBILITY _LIBCPP_CONSTEXPR_SINCE_CXX17
auto
begin(const _Cp& __c) -> decltype(__c.begin())
{
    return __c.begin();
}

template <class _Cp>
_LIBCPP_INLINE_VISIBILITY _LIBCPP_CONSTEXPR_SINCE_CXX17
auto
end(_Cp& __c) -> decltype(__c.end())
{
    return __c.end();
}

template <class _Cp>
_LIBCPP_INLINE_VISIBILITY _LIBCPP_CONSTEXPR_SINCE_CXX17
auto
end(const _Cp& __c) -> decltype(__c.end())
{
    return __c.end();
}

#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 14
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 73 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/access.h" 3

template <class _Cp>
_LIBCPP_INLINE_VISIBILITY _LIBCPP_CONSTEXPR_SINCE_CXX14
auto cbegin(const _Cp& __c) -> decltype(_VSTD::begin(__c))
{
    return _VSTD::begin(__c);
}

template <class _Cp>
_LIBCPP_INLINE_VISIBILITY _LIBCPP_CONSTEXPR_SINCE_CXX14
auto cend(const _Cp& __c) -> decltype(_VSTD::end(__c))
{
    return _VSTD::end(__c);
}

#endif
# 89 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/access.h" 3


#else  // defined(_LIBCPP_CXX03_LANG)
# 92 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/access.h" 3

template <class _Cp>
_LIBCPP_INLINE_VISIBILITY
typename _Cp::iterator
begin(_Cp& __c)
{
    return __c.begin();
}

template <class _Cp>
_LIBCPP_INLINE_VISIBILITY
typename _Cp::const_iterator
begin(const _Cp& __c)
{
    return __c.begin();
}

template <class _Cp>
_LIBCPP_INLINE_VISIBILITY
typename _Cp::iterator
end(_Cp& __c)
{
    return __c.end();
}

template <class _Cp>
_LIBCPP_INLINE_VISIBILITY
typename _Cp::const_iterator
end(const _Cp& __c)
{
    return __c.end();
}

#endif // !defined(_LIBCPP_CXX03_LANG)
# 126 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/access.h" 3

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___ITERATOR_ACCESS_H
# 130 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/access.h" 3
#endif /* access.h expanded by -frewrite-includes */
# 680 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/iterator" 2 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* advance.h expanded by -frewrite-includes */
#include <__iterator/advance.h>
#else /* advance.h expanded by -frewrite-includes */
# 680 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/iterator" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/advance.h" 1 3
// -*- C++ -*-
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___ITERATOR_ADVANCE_H
#define _LIBCPP___ITERATOR_ADVANCE_H

#if 0 /* expanded by -frewrite-includes */
#include <__assert>
#endif /* expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/advance.h" 3
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/advance.h" 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* assignable.h expanded by -frewrite-includes */
#include <__concepts/assignable.h>
#else /* assignable.h expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/advance.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/assignable.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___CONCEPTS_ASSIGNABLE_H
#define _LIBCPP___CONCEPTS_ASSIGNABLE_H

#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* common_reference_with.h expanded by -frewrite-includes */
#include <__concepts/common_reference_with.h>
#else /* common_reference_with.h expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/assignable.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/common_reference_with.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___CONCEPTS_COMMON_REFERENCE_WITH_H
#define _LIBCPP___CONCEPTS_COMMON_REFERENCE_WITH_H

#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* convertible_to.h expanded by -frewrite-includes */
#include <__concepts/convertible_to.h>
#else /* convertible_to.h expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/common_reference_with.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/convertible_to.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___CONCEPTS_CONVERTIBLE_TO_H
#define _LIBCPP___CONCEPTS_CONVERTIBLE_TO_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/convertible_to.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/convertible_to.h" 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* is_convertible.h expanded by -frewrite-includes */
#include <__type_traits/is_convertible.h>
#else /* is_convertible.h expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/convertible_to.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_convertible.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___TYPE_TRAITS_IS_CONVERTIBLE_H
#define _LIBCPP___TYPE_TRAITS_IS_CONVERTIBLE_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_convertible.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_convertible.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/integral_constant.h>
#endif /* expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_convertible.h" 3
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_convertible.h" 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* is_array.h expanded by -frewrite-includes */
#include <__type_traits/is_array.h>
#else /* is_array.h expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_convertible.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_array.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___TYPE_TRAITS_IS_ARRAY_H
#define _LIBCPP___TYPE_TRAITS_IS_ARRAY_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_array.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_array.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/integral_constant.h>
#endif /* expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_array.h" 3
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_array.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <cstddef>
#endif /* expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_array.h" 3
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_array.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_array.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_array.h" 3
#endif
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_array.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

// TODO: Clang incorrectly reports that __is_array is true for T[0].
//       Re-enable the branch once https://llvm.org/PR54705 is fixed.
#if 0 /* disabled by -frewrite-includes */
#if __has_builtin(__is_array) && 0
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 25 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_array.h" 3

template <class _Tp>
struct _LIBCPP_TEMPLATE_VIS is_array : _BoolConstant<__is_array(_Tp)> {};

#if 0 /* disabled by -frewrite-includes */
#  if _LIBCPP_STD_VER >= 17
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 30 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_array.h" 3
template <class _Tp>
inline constexpr bool is_array_v = __is_array(_Tp);
#  endif
# 33 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_array.h" 3

#else
# 35 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_array.h" 3

template <class _Tp>
struct _LIBCPP_TEMPLATE_VIS is_array : public false_type {};
template <class _Tp>
struct _LIBCPP_TEMPLATE_VIS is_array<_Tp[]> : public true_type {};
template <class _Tp, size_t _Np>
struct _LIBCPP_TEMPLATE_VIS is_array<_Tp[_Np]> : public true_type {};

#if 0 /* disabled by -frewrite-includes */
#  if _LIBCPP_STD_VER >= 17
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 44 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_array.h" 3
template <class _Tp>
inline constexpr bool is_array_v = is_array<_Tp>::value;
#  endif
# 47 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_array.h" 3

#endif // __has_builtin(__is_array)
# 49 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_array.h" 3

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___TYPE_TRAITS_IS_ARRAY_H
# 53 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_array.h" 3
#endif /* is_array.h expanded by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_convertible.h" 2 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* is_function.h expanded by -frewrite-includes */
#include <__type_traits/is_function.h>
#else /* is_function.h expanded by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_convertible.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_function.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___TYPE_TRAITS_IS_FUNCTIONAL_H
#define _LIBCPP___TYPE_TRAITS_IS_FUNCTIONAL_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_function.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_function.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/integral_constant.h>
#endif /* expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_function.h" 3
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_function.h" 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* is_const.h expanded by -frewrite-includes */
#include <__type_traits/is_const.h>
#else /* is_const.h expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_function.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_const.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___TYPE_TRAITS_IS_CONST_H
#define _LIBCPP___TYPE_TRAITS_IS_CONST_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_const.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_const.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/integral_constant.h>
#endif /* expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_const.h" 3
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_const.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_const.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_const.h" 3
#endif
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_const.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

#if 0 /* disabled by -frewrite-includes */
#if __has_builtin(__is_const)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 22 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_const.h" 3

template <class _Tp>
struct _LIBCPP_TEMPLATE_VIS is_const : _BoolConstant<__is_const(_Tp)> {};

#if 0 /* disabled by -frewrite-includes */
#  if _LIBCPP_STD_VER >= 17
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 27 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_const.h" 3
template <class _Tp>
inline constexpr bool is_const_v = __is_const(_Tp);
#  endif
# 30 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_const.h" 3

#else
# 32 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_const.h" 3

template <class _Tp>
struct _LIBCPP_TEMPLATE_VIS is_const : public false_type {};
template <class _Tp>
struct _LIBCPP_TEMPLATE_VIS is_const<_Tp const> : public true_type {};

#if 0 /* disabled by -frewrite-includes */
#  if _LIBCPP_STD_VER >= 17
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 39 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_const.h" 3
template <class _Tp>
inline constexpr bool is_const_v = is_const<_Tp>::value;
#  endif
# 42 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_const.h" 3

#endif // __has_builtin(__is_const)
# 44 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_const.h" 3

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___TYPE_TRAITS_IS_CONST_H
# 48 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_const.h" 3
#endif /* is_const.h expanded by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_function.h" 2 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* is_reference.h expanded by -frewrite-includes */
#include <__type_traits/is_reference.h>
#else /* is_reference.h expanded by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_function.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_reference.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___TYPE_TRAITS_IS_REFERENCE_H
#define _LIBCPP___TYPE_TRAITS_IS_REFERENCE_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_reference.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_reference.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/integral_constant.h>
#endif /* expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_reference.h" 3
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_reference.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_reference.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_reference.h" 3
#endif
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_reference.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

#if 0 /* disabled by -frewrite-includes */
#if __has_builtin(__is_lvalue_reference) && __has_builtin(__is_rvalue_reference) && __has_builtin(__is_reference)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 22 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_reference.h" 3

template <class _Tp>
struct _LIBCPP_TEMPLATE_VIS is_lvalue_reference : _BoolConstant<__is_lvalue_reference(_Tp)> {};

template <class _Tp>
struct _LIBCPP_TEMPLATE_VIS is_rvalue_reference : _BoolConstant<__is_rvalue_reference(_Tp)> {};

template <class _Tp>
struct _LIBCPP_TEMPLATE_VIS is_reference : _BoolConstant<__is_reference(_Tp)> {};

#if 0 /* disabled by -frewrite-includes */
#  if _LIBCPP_STD_VER >= 17
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 33 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_reference.h" 3
template <class _Tp>
inline constexpr bool is_reference_v = __is_reference(_Tp);
template <class _Tp>
inline constexpr bool is_lvalue_reference_v = __is_lvalue_reference(_Tp);
template <class _Tp>
inline constexpr bool is_rvalue_reference_v = __is_rvalue_reference(_Tp);
#  endif
# 40 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_reference.h" 3

#else // __has_builtin(__is_lvalue_reference) && etc...
# 42 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_reference.h" 3

template <class _Tp>
struct _LIBCPP_TEMPLATE_VIS is_lvalue_reference : public false_type {};
template <class _Tp>
struct _LIBCPP_TEMPLATE_VIS is_lvalue_reference<_Tp&> : public true_type {};

template <class _Tp>
struct _LIBCPP_TEMPLATE_VIS is_rvalue_reference : public false_type {};
template <class _Tp>
struct _LIBCPP_TEMPLATE_VIS is_rvalue_reference<_Tp&&> : public true_type {};

template <class _Tp>
struct _LIBCPP_TEMPLATE_VIS is_reference : public false_type {};
template <class _Tp>
struct _LIBCPP_TEMPLATE_VIS is_reference<_Tp&> : public true_type {};
template <class _Tp>
struct _LIBCPP_TEMPLATE_VIS is_reference<_Tp&&> : public true_type {};

#if 0 /* disabled by -frewrite-includes */
#  if _LIBCPP_STD_VER >= 17
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 61 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_reference.h" 3
template <class _Tp>
inline constexpr bool is_reference_v = is_reference<_Tp>::value;

template <class _Tp>
inline constexpr bool is_lvalue_reference_v = is_lvalue_reference<_Tp>::value;

template <class _Tp>
inline constexpr bool is_rvalue_reference_v = is_rvalue_reference<_Tp>::value;
#  endif
# 70 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_reference.h" 3

#endif // __has_builtin(__is_lvalue_reference) && etc...
# 72 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_reference.h" 3

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___TYPE_TRAITS_IS_REFERENCE_H
# 76 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_reference.h" 3
#endif /* is_reference.h expanded by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_function.h" 2 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_function.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_function.h" 3
#endif
# 20 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_function.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

#if 0 /* disabled by -frewrite-includes */
#if __has_builtin(__is_function)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 24 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_function.h" 3

template <class _Tp>
struct _LIBCPP_TEMPLATE_VIS is_function : integral_constant<bool, __is_function(_Tp)> {};

#else
# 29 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_function.h" 3

template <class _Tp>
struct _LIBCPP_TEMPLATE_VIS is_function
    : public integral_constant<bool, !(is_reference<_Tp>::value || is_const<const _Tp>::value)> {};

#endif // __has_builtin(__is_function)
# 35 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_function.h" 3

#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 17
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 37 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_function.h" 3
template <class _Tp>
inline constexpr bool is_function_v = is_function<_Tp>::value;
#endif
# 40 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_function.h" 3

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___TYPE_TRAITS_IS_FUNCTIONAL_H
# 44 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_function.h" 3
#endif /* is_function.h expanded by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_convertible.h" 2 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* is_void.h expanded by -frewrite-includes */
#include <__type_traits/is_void.h>
#else /* is_void.h expanded by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_convertible.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_void.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___TYPE_TRAITS_IS_VOID_H
#define _LIBCPP___TYPE_TRAITS_IS_VOID_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_void.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_void.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/integral_constant.h>
#endif /* expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_void.h" 3
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_void.h" 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* is_same.h expanded by -frewrite-includes */
#include <__type_traits/is_same.h>
#else /* is_same.h expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_void.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_same.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___TYPE_TRAITS_IS_SAME_H
#define _LIBCPP___TYPE_TRAITS_IS_SAME_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_same.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_same.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/integral_constant.h>
#endif /* expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_same.h" 3
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_same.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_same.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_same.h" 3
#endif
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_same.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

template <class _Tp, class _Up>
struct _LIBCPP_TEMPLATE_VIS is_same : _BoolConstant<__is_same(_Tp, _Up)> {};

#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 17
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 25 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_same.h" 3
template <class _Tp, class _Up>
inline constexpr bool is_same_v = __is_same(_Tp, _Up);
#endif
# 28 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_same.h" 3

// _IsSame<T,U> has the same effect as is_same<T,U> but instantiates fewer types:
// is_same<A,B> and is_same<C,D> are guaranteed to be different types, but
// _IsSame<A,B> and _IsSame<C,D> are the same type (namely, false_type).
// Neither GCC nor Clang can mangle the __is_same builtin, so _IsSame
// mustn't be directly used anywhere that contributes to name-mangling
// (such as in a dependent return type).

template <class _Tp, class _Up>
using _IsSame = _BoolConstant<__is_same(_Tp, _Up)>;

template <class _Tp, class _Up>
using _IsNotSame = _BoolConstant<!__is_same(_Tp, _Up)>;

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___TYPE_TRAITS_IS_SAME_H
# 45 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_same.h" 3
#endif /* is_same.h expanded by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_void.h" 2 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/remove_cv.h>
#endif /* expanded by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_void.h" 3
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_void.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_void.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_void.h" 3
#endif
# 20 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_void.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

#if 0 /* disabled by -frewrite-includes */
#if __has_builtin(__is_void)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 24 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_void.h" 3

template <class _Tp>
struct _LIBCPP_TEMPLATE_VIS is_void : _BoolConstant<__is_void(_Tp)> {};

#if 0 /* disabled by -frewrite-includes */
#  if _LIBCPP_STD_VER >= 17
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 29 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_void.h" 3
template <class _Tp>
inline constexpr bool is_void_v = __is_void(_Tp);
#  endif
# 32 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_void.h" 3

#else
# 34 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_void.h" 3

template <class _Tp>
struct _LIBCPP_TEMPLATE_VIS is_void : public is_same<__remove_cv_t<_Tp>, void> {};

#if 0 /* disabled by -frewrite-includes */
#  if _LIBCPP_STD_VER >= 17
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 39 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_void.h" 3
template <class _Tp>
inline constexpr bool is_void_v = is_void<_Tp>::value;
#  endif
# 42 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_void.h" 3

#endif // __has_builtin(__is_void)
# 44 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_void.h" 3

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___TYPE_TRAITS_IS_VOID_H
# 48 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_void.h" 3
#endif /* is_void.h expanded by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_convertible.h" 2 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* remove_reference.h expanded by -frewrite-includes */
#include <__type_traits/remove_reference.h>
#else /* remove_reference.h expanded by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_convertible.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_reference.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___TYPE_TRAITS_REMOVE_REFERENCE_H
#define _LIBCPP___TYPE_TRAITS_REMOVE_REFERENCE_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_reference.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_reference.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <cstddef>
#endif /* expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_reference.h" 3
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_reference.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_reference.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_reference.h" 3
#endif
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_reference.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

#if 0 /* disabled by -frewrite-includes */
#if __has_builtin(__remove_reference_t)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 22 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_reference.h" 3
template <class _Tp>
struct remove_reference {
  using type _LIBCPP_NODEBUG = __remove_reference_t(_Tp);
};

template <class _Tp>
using __libcpp_remove_reference_t = __remove_reference_t(_Tp);
#else
# 30 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_reference.h" 3
// clang-format off
template <class _Tp> struct _LIBCPP_TEMPLATE_VIS remove_reference        {typedef _LIBCPP_NODEBUG _Tp type;};
template <class _Tp> struct _LIBCPP_TEMPLATE_VIS remove_reference<_Tp&>  {typedef _LIBCPP_NODEBUG _Tp type;};
template <class _Tp> struct _LIBCPP_TEMPLATE_VIS remove_reference<_Tp&&> {typedef _LIBCPP_NODEBUG _Tp type;};
// clang-format on

template <class _Tp>
using __libcpp_remove_reference_t = typename remove_reference<_Tp>::type;
#endif // __has_builtin(__remove_reference_t)
# 39 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_reference.h" 3

#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 14
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 41 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_reference.h" 3
template <class _Tp>
using remove_reference_t = __libcpp_remove_reference_t<_Tp>;
#endif
# 44 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_reference.h" 3

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___TYPE_TRAITS_REMOVE_REFERENCE_H
# 48 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_reference.h" 3
#endif /* remove_reference.h expanded by -frewrite-includes */
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_convertible.h" 2 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* declval.h expanded by -frewrite-includes */
#include <__utility/declval.h>
#else /* declval.h expanded by -frewrite-includes */
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_convertible.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/declval.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___UTILITY_DECLVAL_H
#define _LIBCPP___UTILITY_DECLVAL_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/declval.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/declval.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/declval.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/declval.h" 3
#endif
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/declval.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

// Suppress deprecation notice for volatile-qualified return type resulting
// from volatile-qualified types _Tp.
_LIBCPP_SUPPRESS_DEPRECATED_PUSH
template <class _Tp>
_Tp&& __declval(int);
template <class _Tp>
_Tp __declval(long);
_LIBCPP_SUPPRESS_DEPRECATED_POP

template <class _Tp>
decltype(std::__declval<_Tp>(0)) declval() _NOEXCEPT;

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___UTILITY_DECLVAL_H
# 35 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/declval.h" 3
#endif /* declval.h expanded by -frewrite-includes */
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_convertible.h" 2 3
#if 0 /* expanded by -frewrite-includes */
#include <cstddef>
#endif /* expanded by -frewrite-includes */
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_convertible.h" 3
# 20 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_convertible.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 22 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_convertible.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 23 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_convertible.h" 3
#endif
# 24 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_convertible.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

template <class _T1, class _T2>
struct _LIBCPP_TEMPLATE_VIS is_convertible : public integral_constant<bool, __is_convertible(_T1, _T2)> {};

#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 17
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 31 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_convertible.h" 3
template <class _From, class _To>
inline constexpr bool is_convertible_v = __is_convertible(_From, _To);
#endif
# 34 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_convertible.h" 3

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___TYPE_TRAITS_IS_CONVERTIBLE_H
# 38 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_convertible.h" 3
#endif /* is_convertible.h expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/convertible_to.h" 2 3
#if 0 /* expanded by -frewrite-includes */
#include <__utility/declval.h>
#endif /* expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/convertible_to.h" 3
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/convertible_to.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/convertible_to.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/convertible_to.h" 3
#endif
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/convertible_to.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 20
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 23 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/convertible_to.h" 3

// [concept.convertible]

template <class _From, class _To>
concept convertible_to = is_convertible_v<_From, _To> && requires { static_cast<_To>(std::declval<_From>()); };

#endif // _LIBCPP_STD_VER >= 20
# 30 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/convertible_to.h" 3

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___CONCEPTS_CONVERTIBLE_TO_H
# 34 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/convertible_to.h" 3
#endif /* convertible_to.h expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/common_reference_with.h" 2 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* same_as.h expanded by -frewrite-includes */
#include <__concepts/same_as.h>
#else /* same_as.h expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/common_reference_with.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/same_as.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___CONCEPTS_SAME_AS_H
#define _LIBCPP___CONCEPTS_SAME_AS_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/same_as.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/same_as.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/is_same.h>
#endif /* expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/same_as.h" 3
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/same_as.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/same_as.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/same_as.h" 3
#endif
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/same_as.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 20
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 22 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/same_as.h" 3

// [concept.same]

template <class _Tp, class _Up>
concept __same_as_impl = _IsSame<_Tp, _Up>::value;

template <class _Tp, class _Up>
concept same_as = __same_as_impl<_Tp, _Up> && __same_as_impl<_Up, _Tp>;

#endif // _LIBCPP_STD_VER >= 20
# 32 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/same_as.h" 3

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___CONCEPTS_SAME_AS_H
# 36 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/same_as.h" 3
#endif /* same_as.h expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/common_reference_with.h" 2 3
#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/common_reference_with.h" 3
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/common_reference_with.h" 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* common_reference.h expanded by -frewrite-includes */
#include <__type_traits/common_reference.h>
#else /* common_reference.h expanded by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/common_reference_with.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/common_reference.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___TYPE_TRAITS_COMMON_REFERENCE_H
#define _LIBCPP___TYPE_TRAITS_COMMON_REFERENCE_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/common_reference.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/common_reference.h" 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* common_type.h expanded by -frewrite-includes */
#include <__type_traits/common_type.h>
#else /* common_type.h expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/common_reference.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/common_type.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___TYPE_TRAITS_COMMON_TYPE_H
#define _LIBCPP___TYPE_TRAITS_COMMON_TYPE_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/common_type.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/common_type.h" 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* conditional.h expanded by -frewrite-includes */
#include <__type_traits/conditional.h>
#else /* conditional.h expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/common_type.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/conditional.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___TYPE_TRAITS_CONDITIONAL_H
#define _LIBCPP___TYPE_TRAITS_CONDITIONAL_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/conditional.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/conditional.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/conditional.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/conditional.h" 3
#endif
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/conditional.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

template <bool>
struct _IfImpl;

template <>
struct _IfImpl<true> {
  template <class _IfRes, class _ElseRes>
  using _Select _LIBCPP_NODEBUG = _IfRes;
};

template <>
struct _IfImpl<false> {
  template <class _IfRes, class _ElseRes>
  using _Select _LIBCPP_NODEBUG = _ElseRes;
};

template <bool _Cond, class _IfRes, class _ElseRes>
using _If _LIBCPP_NODEBUG = typename _IfImpl<_Cond>::template _Select<_IfRes, _ElseRes>;

template <bool _Bp, class _If, class _Then>
struct _LIBCPP_TEMPLATE_VIS conditional {
  using type _LIBCPP_NODEBUG = _If;
};
template <class _If, class _Then>
struct _LIBCPP_TEMPLATE_VIS conditional<false, _If, _Then> {
  using type _LIBCPP_NODEBUG = _Then;
};

#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 14
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 48 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/conditional.h" 3
template <bool _Bp, class _IfRes, class _ElseRes>
using conditional_t _LIBCPP_NODEBUG = typename conditional<_Bp, _IfRes, _ElseRes>::type;
#endif
# 51 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/conditional.h" 3

// Helper so we can use "conditional_t" in all language versions.
template <bool _Bp, class _If, class _Then>
using __conditional_t _LIBCPP_NODEBUG = typename conditional<_Bp, _If, _Then>::type;

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___TYPE_TRAITS_CONDITIONAL_H
# 59 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/conditional.h" 3
#endif /* conditional.h expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/common_type.h" 2 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* decay.h expanded by -frewrite-includes */
#include <__type_traits/decay.h>
#else /* decay.h expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/common_type.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/decay.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___TYPE_TRAITS_DECAY_H
#define _LIBCPP___TYPE_TRAITS_DECAY_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/decay.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/decay.h" 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* add_pointer.h expanded by -frewrite-includes */
#include <__type_traits/add_pointer.h>
#else /* add_pointer.h expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/decay.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/add_pointer.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___TYPE_TRAITS_ADD_POINTER_H
#define _LIBCPP___TYPE_TRAITS_ADD_POINTER_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/add_pointer.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/add_pointer.h" 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* is_referenceable.h expanded by -frewrite-includes */
#include <__type_traits/is_referenceable.h>
#else /* is_referenceable.h expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/add_pointer.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_referenceable.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___TYPE_TRAITS_IS_REFERENCEABLE_H
#define _LIBCPP___TYPE_TRAITS_IS_REFERENCEABLE_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_referenceable.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_referenceable.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/integral_constant.h>
#endif /* expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_referenceable.h" 3
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_referenceable.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/is_same.h>
#endif /* expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_referenceable.h" 3
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_referenceable.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_referenceable.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_referenceable.h" 3
#endif
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_referenceable.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

#if 0 /* disabled by -frewrite-includes */
#if __has_builtin(__is_referenceable)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 23 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_referenceable.h" 3
template <class _Tp>
struct __libcpp_is_referenceable : integral_constant<bool, __is_referenceable(_Tp)> {};
#else
# 26 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_referenceable.h" 3
struct __libcpp_is_referenceable_impl {
  template <class _Tp>
  static _Tp& __test(int);
  template <class _Tp>
  static false_type __test(...);
};

template <class _Tp>
struct __libcpp_is_referenceable
    : integral_constant<bool, _IsNotSame<decltype(__libcpp_is_referenceable_impl::__test<_Tp>(0)), false_type>::value> {
};
#endif // __has_builtin(__is_referenceable)
# 38 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_referenceable.h" 3

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___TYPE_TRAITS_IS_REFERENCEABLE_H
# 42 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_referenceable.h" 3
#endif /* is_referenceable.h expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/add_pointer.h" 2 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/is_same.h>
#endif /* expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/add_pointer.h" 3
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/add_pointer.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/is_void.h>
#endif /* expanded by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/add_pointer.h" 3
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/add_pointer.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/remove_cv.h>
#endif /* expanded by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/add_pointer.h" 3
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/add_pointer.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/remove_reference.h>
#endif /* expanded by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/add_pointer.h" 3
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/add_pointer.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 20 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/add_pointer.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 21 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/add_pointer.h" 3
#endif
# 22 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/add_pointer.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_WORKAROUND_OBJCXX_COMPILER_INTRINSICS) && __has_builtin(__add_pointer)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 26 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/add_pointer.h" 3

template <class _Tp>
using __add_pointer_t = __add_pointer(_Tp);

#else
# 31 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/add_pointer.h" 3
template <class _Tp, bool = __libcpp_is_referenceable<_Tp>::value || is_void<_Tp>::value>
struct __add_pointer_impl {
  typedef _LIBCPP_NODEBUG __libcpp_remove_reference_t<_Tp>* type;
};
template <class _Tp>
struct __add_pointer_impl<_Tp, false> {
  typedef _LIBCPP_NODEBUG _Tp type;
};

template <class _Tp>
using __add_pointer_t = typename __add_pointer_impl<_Tp>::type;

#endif // !defined(_LIBCPP_WORKAROUND_OBJCXX_COMPILER_INTRINSICS) && __has_builtin(__add_pointer)
# 44 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/add_pointer.h" 3

template <class _Tp>
struct add_pointer {
  using type _LIBCPP_NODEBUG = __add_pointer_t<_Tp>;
};

#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 14
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 51 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/add_pointer.h" 3
template <class _Tp>
using add_pointer_t = __add_pointer_t<_Tp>;
#endif
# 54 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/add_pointer.h" 3

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___TYPE_TRAITS_ADD_POINTER_H
# 58 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/add_pointer.h" 3
#endif /* add_pointer.h expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/decay.h" 2 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/conditional.h>
#endif /* expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/decay.h" 3
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/decay.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/is_array.h>
#endif /* expanded by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/decay.h" 3
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/decay.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/is_function.h>
#endif /* expanded by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/decay.h" 3
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/decay.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/is_referenceable.h>
#endif /* expanded by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/decay.h" 3
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/decay.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/remove_cv.h>
#endif /* expanded by -frewrite-includes */
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/decay.h" 3
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/decay.h" 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* remove_extent.h expanded by -frewrite-includes */
#include <__type_traits/remove_extent.h>
#else /* remove_extent.h expanded by -frewrite-includes */
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/decay.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_extent.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___TYPE_TRAITS_REMOVE_EXTENT_H
#define _LIBCPP___TYPE_TRAITS_REMOVE_EXTENT_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_extent.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_extent.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <cstddef>
#endif /* expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_extent.h" 3
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_extent.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_extent.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_extent.h" 3
#endif
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_extent.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

#if 0 /* disabled by -frewrite-includes */
#if __has_builtin(__remove_extent)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 22 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_extent.h" 3
template <class _Tp>
struct remove_extent {
  using type _LIBCPP_NODEBUG = __remove_extent(_Tp);
};

template <class _Tp>
using __remove_extent_t = __remove_extent(_Tp);
#else
# 30 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_extent.h" 3
template <class _Tp>
struct _LIBCPP_TEMPLATE_VIS remove_extent {
  typedef _Tp type;
};
template <class _Tp>
struct _LIBCPP_TEMPLATE_VIS remove_extent<_Tp[]> {
  typedef _Tp type;
};
template <class _Tp, size_t _Np>
struct _LIBCPP_TEMPLATE_VIS remove_extent<_Tp[_Np]> {
  typedef _Tp type;
};

template <class _Tp>
using __remove_extent_t = typename remove_extent<_Tp>::type;
#endif // __has_builtin(__remove_extent)
# 46 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_extent.h" 3

#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 14
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 48 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_extent.h" 3
template <class _Tp>
using remove_extent_t = __remove_extent_t<_Tp>;
#endif
# 51 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_extent.h" 3

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___TYPE_TRAITS_REMOVE_EXTENT_H
# 55 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_extent.h" 3
#endif /* remove_extent.h expanded by -frewrite-includes */
# 20 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/decay.h" 2 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/remove_reference.h>
#endif /* expanded by -frewrite-includes */
# 20 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/decay.h" 3
# 21 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/decay.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 23 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/decay.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 24 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/decay.h" 3
#endif
# 25 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/decay.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

#if 0 /* disabled by -frewrite-includes */
#if __has_builtin(__decay)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 29 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/decay.h" 3
template <class _Tp>
using __decay_t _LIBCPP_NODEBUG = __decay(_Tp);

template <class _Tp>
struct decay {
  using type _LIBCPP_NODEBUG = __decay_t<_Tp>;
};

#else
# 38 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/decay.h" 3
template <class _Up, bool>
struct __decay {
  typedef _LIBCPP_NODEBUG __remove_cv_t<_Up> type;
};

template <class _Up>
struct __decay<_Up, true> {
public:
  typedef _LIBCPP_NODEBUG typename conditional<
      is_array<_Up>::value,
      __add_pointer_t<__remove_extent_t<_Up> >,
      typename conditional<is_function<_Up>::value, typename add_pointer<_Up>::type, __remove_cv_t<_Up> >::type >::type
      type;
};

template <class _Tp>
struct _LIBCPP_TEMPLATE_VIS decay {
private:
  typedef _LIBCPP_NODEBUG __libcpp_remove_reference_t<_Tp> _Up;

public:
  typedef _LIBCPP_NODEBUG typename __decay<_Up, __libcpp_is_referenceable<_Up>::value>::type type;
};

template <class _Tp>
using __decay_t = typename decay<_Tp>::type;
#endif // __has_builtin(__decay)
# 65 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/decay.h" 3

#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 14
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 67 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/decay.h" 3
template <class _Tp>
using decay_t = __decay_t<_Tp>;
#endif
# 70 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/decay.h" 3

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___TYPE_TRAITS_DECAY_H
# 74 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/decay.h" 3
#endif /* decay.h expanded by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/common_type.h" 2 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/is_same.h>
#endif /* expanded by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/common_type.h" 3
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/common_type.h" 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* remove_cvref.h expanded by -frewrite-includes */
#include <__type_traits/remove_cvref.h>
#else /* remove_cvref.h expanded by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/common_type.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_cvref.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___TYPE_TRAITS_REMOVE_CVREF_H
#define _LIBCPP___TYPE_TRAITS_REMOVE_CVREF_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_cvref.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_cvref.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/is_same.h>
#endif /* expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_cvref.h" 3
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_cvref.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/remove_cv.h>
#endif /* expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_cvref.h" 3
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_cvref.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/remove_reference.h>
#endif /* expanded by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_cvref.h" 3
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_cvref.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_cvref.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_cvref.h" 3
#endif
# 20 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_cvref.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

#if 0 /* disabled by -frewrite-includes */
#if __has_builtin(__remove_cvref) && !defined(_LIBCPP_COMPILER_GCC)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 24 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_cvref.h" 3
template <class _Tp>
using __remove_cvref_t _LIBCPP_NODEBUG = __remove_cvref(_Tp);
#else
# 27 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_cvref.h" 3
template <class _Tp>
using __remove_cvref_t _LIBCPP_NODEBUG = __remove_cv_t<__libcpp_remove_reference_t<_Tp> >;
#endif // __has_builtin(__remove_cvref)
# 30 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_cvref.h" 3

template <class _Tp, class _Up>
struct __is_same_uncvref : _IsSame<__remove_cvref_t<_Tp>, __remove_cvref_t<_Up> > {};

#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 20
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 35 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_cvref.h" 3
template <class _Tp>
struct remove_cvref {
  using type _LIBCPP_NODEBUG = __remove_cvref_t<_Tp>;
};

template <class _Tp>
using remove_cvref_t = __remove_cvref_t<_Tp>;
#endif
# 43 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_cvref.h" 3

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___TYPE_TRAITS_REMOVE_CVREF_H
# 47 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_cvref.h" 3
#endif /* remove_cvref.h expanded by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/common_type.h" 2 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* void_t.h expanded by -frewrite-includes */
#include <__type_traits/void_t.h>
#else /* void_t.h expanded by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/common_type.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/void_t.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___TYPE_TRAITS_VOID_T_H
#define _LIBCPP___TYPE_TRAITS_VOID_T_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/void_t.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/void_t.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/void_t.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/void_t.h" 3
#endif
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/void_t.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 17
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 21 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/void_t.h" 3
template <class...>
using void_t = void;
#endif
# 24 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/void_t.h" 3

template <class...>
using __void_t = void;

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___TYPE_TRAITS_VOID_T_H
# 31 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/void_t.h" 3
#endif /* void_t.h expanded by -frewrite-includes */
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/common_type.h" 2 3
#if 0 /* expanded by -frewrite-includes */
#include <__utility/declval.h>
#endif /* expanded by -frewrite-includes */
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/common_type.h" 3
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/common_type.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 21 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/common_type.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 22 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/common_type.h" 3
#endif
# 23 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/common_type.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 20
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 27 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/common_type.h" 3
// Let COND_RES(X, Y) be:
template <class _Tp, class _Up>
using __cond_type = decltype(false ? std::declval<_Tp>() : std::declval<_Up>());

template <class _Tp, class _Up, class = void>
struct __common_type3 {};

// sub-bullet 4 - "if COND_RES(CREF(D1), CREF(D2)) denotes a type..."
template <class _Tp, class _Up>
struct __common_type3<_Tp, _Up, void_t<__cond_type<const _Tp&, const _Up&>>> {
  using type = remove_cvref_t<__cond_type<const _Tp&, const _Up&>>;
};

template <class _Tp, class _Up, class = void>
struct __common_type2_imp : __common_type3<_Tp, _Up> {};
#else
# 43 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/common_type.h" 3
template <class _Tp, class _Up, class = void>
struct __common_type2_imp {};
#endif
# 46 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/common_type.h" 3

// sub-bullet 3 - "if decay_t<decltype(false ? declval<D1>() : declval<D2>())> ..."
template <class _Tp, class _Up>
struct __common_type2_imp<_Tp, _Up, __void_t<decltype(true ? std::declval<_Tp>() : std::declval<_Up>())> > {
  typedef _LIBCPP_NODEBUG __decay_t<decltype(true ? std::declval<_Tp>() : std::declval<_Up>())> type;
};

template <class, class = void>
struct __common_type_impl {};

template <class... _Tp>
struct __common_types;
template <class... _Tp>
struct _LIBCPP_TEMPLATE_VIS common_type;

template <class _Tp, class _Up>
struct __common_type_impl< __common_types<_Tp, _Up>, __void_t<typename common_type<_Tp, _Up>::type> > {
  typedef typename common_type<_Tp, _Up>::type type;
};

template <class _Tp, class _Up, class _Vp, class... _Rest>
struct __common_type_impl<__common_types<_Tp, _Up, _Vp, _Rest...>, __void_t<typename common_type<_Tp, _Up>::type> >
    : __common_type_impl<__common_types<typename common_type<_Tp, _Up>::type, _Vp, _Rest...> > {};

// bullet 1 - sizeof...(Tp) == 0

template <>
struct _LIBCPP_TEMPLATE_VIS common_type<> {};

// bullet 2 - sizeof...(Tp) == 1

template <class _Tp>
struct _LIBCPP_TEMPLATE_VIS common_type<_Tp> : public common_type<_Tp, _Tp> {};

// bullet 3 - sizeof...(Tp) == 2

// sub-bullet 1 - "If is_same_v<T1, D1> is false or ..."
template <class _Tp, class _Up>
struct _LIBCPP_TEMPLATE_VIS common_type<_Tp, _Up>
    : conditional<_IsSame<_Tp, __decay_t<_Tp> >::value && _IsSame<_Up, __decay_t<_Up> >::value,
                  __common_type2_imp<_Tp, _Up>,
                  common_type<__decay_t<_Tp>, __decay_t<_Up> > >::type {};

// bullet 4 - sizeof...(Tp) > 2

template <class _Tp, class _Up, class _Vp, class... _Rest>
struct _LIBCPP_TEMPLATE_VIS common_type<_Tp, _Up, _Vp, _Rest...>
    : __common_type_impl<__common_types<_Tp, _Up, _Vp, _Rest...> > {};

#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 14
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 96 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/common_type.h" 3
template <class... _Tp>
using common_type_t = typename common_type<_Tp...>::type;
#endif
# 99 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/common_type.h" 3

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___TYPE_TRAITS_COMMON_TYPE_H
# 103 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/common_type.h" 3
#endif /* common_type.h expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/common_reference.h" 2 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* copy_cv.h expanded by -frewrite-includes */
#include <__type_traits/copy_cv.h>
#else /* copy_cv.h expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/common_reference.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/copy_cv.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___TYPE_TRAITS_COPY_CV_H
#define _LIBCPP___TYPE_TRAITS_COPY_CV_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/copy_cv.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/copy_cv.h" 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* add_const.h expanded by -frewrite-includes */
#include <__type_traits/add_const.h>
#else /* add_const.h expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/copy_cv.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/add_const.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___TYPE_TRAITS_ADD_CONST_H
#define _LIBCPP___TYPE_TRAITS_ADD_CONST_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/add_const.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/add_const.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/add_const.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/add_const.h" 3
#endif
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/add_const.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

template <class _Tp>
struct _LIBCPP_TEMPLATE_VIS add_const {
  typedef _LIBCPP_NODEBUG const _Tp type;
};

#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 14
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 26 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/add_const.h" 3
template <class _Tp>
using add_const_t = typename add_const<_Tp>::type;
#endif
# 29 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/add_const.h" 3

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___TYPE_TRAITS_ADD_CONST_H
# 33 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/add_const.h" 3
#endif /* add_const.h expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/copy_cv.h" 2 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* add_cv.h expanded by -frewrite-includes */
#include <__type_traits/add_cv.h>
#else /* add_cv.h expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/copy_cv.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/add_cv.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___TYPE_TRAITS_ADD_CV_H
#define _LIBCPP___TYPE_TRAITS_ADD_CV_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/add_cv.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/add_cv.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/add_cv.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/add_cv.h" 3
#endif
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/add_cv.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

template <class _Tp>
struct _LIBCPP_TEMPLATE_VIS add_cv {
  typedef _LIBCPP_NODEBUG const volatile _Tp type;
};

#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 14
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 26 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/add_cv.h" 3
template <class _Tp>
using add_cv_t = typename add_cv<_Tp>::type;
#endif
# 29 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/add_cv.h" 3

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___TYPE_TRAITS_ADD_CV_H
# 33 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/add_cv.h" 3
#endif /* add_cv.h expanded by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/copy_cv.h" 2 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* add_volatile.h expanded by -frewrite-includes */
#include <__type_traits/add_volatile.h>
#else /* add_volatile.h expanded by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/copy_cv.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/add_volatile.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___TYPE_TRAITS_ADD_VOLATILE_H
#define _LIBCPP___TYPE_TRAITS_ADD_VOLATILE_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/add_volatile.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/add_volatile.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/add_volatile.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/add_volatile.h" 3
#endif
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/add_volatile.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

template <class _Tp>
struct _LIBCPP_TEMPLATE_VIS add_volatile {
  typedef _LIBCPP_NODEBUG volatile _Tp type;
};

#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 14
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 26 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/add_volatile.h" 3
template <class _Tp>
using add_volatile_t = typename add_volatile<_Tp>::type;
#endif
# 29 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/add_volatile.h" 3

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___TYPE_TRAITS_ADD_VOLATILE_H
# 33 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/add_volatile.h" 3
#endif /* add_volatile.h expanded by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/copy_cv.h" 2 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/copy_cv.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/copy_cv.h" 3
#endif
# 20 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/copy_cv.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

// Let COPYCV(FROM, TO) be an alias for type TO with the addition of FROM's
// top-level cv-qualifiers.
template <class _From, class _To>
struct __copy_cv {
  using type = _To;
};

template <class _From, class _To>
struct __copy_cv<const _From, _To> {
  using type = typename add_const<_To>::type;
};

template <class _From, class _To>
struct __copy_cv<volatile _From, _To> {
  using type = typename add_volatile<_To>::type;
};

template <class _From, class _To>
struct __copy_cv<const volatile _From, _To> {
  using type = typename add_cv<_To>::type;
};

template <class _From, class _To>
using __copy_cv_t = typename __copy_cv<_From, _To>::type;

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___TYPE_TRAITS_COPY_CV_H
# 51 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/copy_cv.h" 3
#endif /* copy_cv.h expanded by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/common_reference.h" 2 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* copy_cvref.h expanded by -frewrite-includes */
#include <__type_traits/copy_cvref.h>
#else /* copy_cvref.h expanded by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/common_reference.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/copy_cvref.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___TYPE_TRAITS_COPY_CVREF_H
#define _LIBCPP___TYPE_TRAITS_COPY_CVREF_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/copy_cvref.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/copy_cvref.h" 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* add_lvalue_reference.h expanded by -frewrite-includes */
#include <__type_traits/add_lvalue_reference.h>
#else /* add_lvalue_reference.h expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/copy_cvref.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/add_lvalue_reference.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___TYPE_TRAITS_ADD_LVALUE_REFERENCE_H
#define _LIBCPP___TYPE_TRAITS_ADD_LVALUE_REFERENCE_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/add_lvalue_reference.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/add_lvalue_reference.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/is_referenceable.h>
#endif /* expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/add_lvalue_reference.h" 3
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/add_lvalue_reference.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/add_lvalue_reference.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/add_lvalue_reference.h" 3
#endif
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/add_lvalue_reference.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

#if 0 /* disabled by -frewrite-includes */
#if __has_builtin(__add_lvalue_reference)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 22 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/add_lvalue_reference.h" 3

template <class _Tp>
using __add_lvalue_reference_t = __add_lvalue_reference(_Tp);

#else
# 27 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/add_lvalue_reference.h" 3

template <class _Tp, bool = __libcpp_is_referenceable<_Tp>::value>
struct __add_lvalue_reference_impl {
  typedef _LIBCPP_NODEBUG _Tp type;
};
template <class _Tp >
struct __add_lvalue_reference_impl<_Tp, true> {
  typedef _LIBCPP_NODEBUG _Tp& type;
};

template <class _Tp>
using __add_lvalue_reference_t = typename __add_lvalue_reference_impl<_Tp>::type;

#endif // __has_builtin(__add_lvalue_reference)
# 41 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/add_lvalue_reference.h" 3

template <class _Tp>
struct add_lvalue_reference {
  using type _LIBCPP_NODEBUG = __add_lvalue_reference_t<_Tp>;
};

#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 14
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 48 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/add_lvalue_reference.h" 3
template <class _Tp>
using add_lvalue_reference_t = __add_lvalue_reference_t<_Tp>;
#endif
# 51 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/add_lvalue_reference.h" 3

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___TYPE_TRAITS_ADD_LVALUE_REFERENCE_H
# 55 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/add_lvalue_reference.h" 3
#endif /* add_lvalue_reference.h expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/copy_cvref.h" 2 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* add_rvalue_reference.h expanded by -frewrite-includes */
#include <__type_traits/add_rvalue_reference.h>
#else /* add_rvalue_reference.h expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/copy_cvref.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/add_rvalue_reference.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___TYPE_TRAITS_ADD_RVALUE_REFERENCE_H
#define _LIBCPP___TYPE_TRAITS_ADD_RVALUE_REFERENCE_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/add_rvalue_reference.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/add_rvalue_reference.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/is_referenceable.h>
#endif /* expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/add_rvalue_reference.h" 3
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/add_rvalue_reference.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/add_rvalue_reference.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/add_rvalue_reference.h" 3
#endif
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/add_rvalue_reference.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

#if 0 /* disabled by -frewrite-includes */
#if __has_builtin(__add_rvalue_reference)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 22 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/add_rvalue_reference.h" 3

template <class _Tp>
using __add_rvalue_reference_t = __add_rvalue_reference(_Tp);

#else
# 27 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/add_rvalue_reference.h" 3

template <class _Tp, bool = __libcpp_is_referenceable<_Tp>::value>
struct __add_rvalue_reference_impl {
  typedef _LIBCPP_NODEBUG _Tp type;
};
template <class _Tp >
struct __add_rvalue_reference_impl<_Tp, true> {
  typedef _LIBCPP_NODEBUG _Tp&& type;
};

template <class _Tp>
using __add_rvalue_reference_t = typename __add_rvalue_reference_impl<_Tp>::type;

#endif // __has_builtin(__add_rvalue_reference)
# 41 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/add_rvalue_reference.h" 3

template <class _Tp>
struct add_rvalue_reference {
  using type = __add_rvalue_reference_t<_Tp>;
};

#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 14
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 48 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/add_rvalue_reference.h" 3
template <class _Tp>
using add_rvalue_reference_t = __add_rvalue_reference_t<_Tp>;
#endif
# 51 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/add_rvalue_reference.h" 3

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___TYPE_TRAITS_ADD_RVALUE_REFERENCE_H
# 55 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/add_rvalue_reference.h" 3
#endif /* add_rvalue_reference.h expanded by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/copy_cvref.h" 2 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/copy_cv.h>
#endif /* expanded by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/copy_cvref.h" 3
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/copy_cvref.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/copy_cvref.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/copy_cvref.h" 3
#endif
# 20 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/copy_cvref.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

template <class _From, class _To>
struct __copy_cvref {
  using type = __copy_cv_t<_From, _To>;
};

template <class _From, class _To>
struct __copy_cvref<_From&, _To> {
  using type = __add_lvalue_reference_t<__copy_cv_t<_From, _To> >;
};

template <class _From, class _To>
struct __copy_cvref<_From&&, _To> {
  using type = __add_rvalue_reference_t<__copy_cv_t<_From, _To> >;
};

template <class _From, class _To>
using __copy_cvref_t = typename __copy_cvref<_From, _To>::type;

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___TYPE_TRAITS_COPY_CVREF_H
# 44 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/copy_cvref.h" 3
#endif /* copy_cvref.h expanded by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/common_reference.h" 2 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/is_convertible.h>
#endif /* expanded by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/common_reference.h" 3
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/common_reference.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/is_reference.h>
#endif /* expanded by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/common_reference.h" 3
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/common_reference.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/remove_cv.h>
#endif /* expanded by -frewrite-includes */
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/common_reference.h" 3
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/common_reference.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/remove_cvref.h>
#endif /* expanded by -frewrite-includes */
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/common_reference.h" 3
# 20 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/common_reference.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/remove_reference.h>
#endif /* expanded by -frewrite-includes */
# 20 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/common_reference.h" 3
# 21 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/common_reference.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__utility/declval.h>
#endif /* expanded by -frewrite-includes */
# 21 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/common_reference.h" 3
# 22 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/common_reference.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 24 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/common_reference.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 25 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/common_reference.h" 3
#endif
# 26 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/common_reference.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

// common_reference
#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 20
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 31 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/common_reference.h" 3
// Let COND_RES(X, Y) be:
template <class _Xp, class _Yp>
using __cond_res = decltype(false ? std::declval<_Xp (&)()>()() : std::declval<_Yp (&)()>()());

// Let `XREF(A)` denote a unary alias template `T` such that `T<U>` denotes the same type as `U`
// with the addition of `A`'s cv and reference qualifiers, for a non-reference cv-unqualified type
// `U`.
// [Note: `XREF(A)` is `__xref<A>::template __apply`]
template <class _Tp>
struct __xref {
  template <class _Up>
  using __apply = __copy_cvref_t<_Tp, _Up>;
};

// Given types A and B, let X be remove_reference_t<A>, let Y be remove_reference_t<B>,
// and let COMMON-REF(A, B) be:
template <class _Ap, class _Bp, class _Xp = remove_reference_t<_Ap>, class _Yp = remove_reference_t<_Bp>>
struct __common_ref;

template <class _Xp, class _Yp>
using __common_ref_t = typename __common_ref<_Xp, _Yp>::__type;

template <class _Xp, class _Yp>
using __cv_cond_res = __cond_res<__copy_cv_t<_Xp, _Yp>&, __copy_cv_t<_Yp, _Xp>&>;

//    If A and B are both lvalue reference types, COMMON-REF(A, B) is
//    COND-RES(COPYCV(X, Y)&, COPYCV(Y, X)&) if that type exists and is a reference type.
// clang-format off
template <class _Ap, class _Bp, class _Xp, class _Yp>
  requires
    requires { typename __cv_cond_res<_Xp, _Yp>; } &&
    is_reference_v<__cv_cond_res<_Xp, _Yp>>
struct __common_ref<_Ap&, _Bp&, _Xp, _Yp> {
  using __type = __cv_cond_res<_Xp, _Yp>;
};
// clang-format on

//    Otherwise, let C be remove_reference_t<COMMON-REF(X&, Y&)>&&. ...
template <class _Xp, class _Yp>
using __common_ref_C = remove_reference_t<__common_ref_t<_Xp&, _Yp&>>&&;

//    .... If A and B are both rvalue reference types, C is well-formed, and
//    is_convertible_v<A, C> && is_convertible_v<B, C> is true, then COMMON-REF(A, B) is C.
// clang-format off
template <class _Ap, class _Bp, class _Xp, class _Yp>
  requires
    requires { typename __common_ref_C<_Xp, _Yp>; } &&
    is_convertible_v<_Ap&&, __common_ref_C<_Xp, _Yp>> &&
    is_convertible_v<_Bp&&, __common_ref_C<_Xp, _Yp>>
struct __common_ref<_Ap&&, _Bp&&, _Xp, _Yp> {
  using __type = __common_ref_C<_Xp, _Yp>;
};
// clang-format on

//    Otherwise, let D be COMMON-REF(const X&, Y&). ...
template <class _Tp, class _Up>
using __common_ref_D = __common_ref_t<const _Tp&, _Up&>;

//    ... If A is an rvalue reference and B is an lvalue reference and D is well-formed and
//    is_convertible_v<A, D> is true, then COMMON-REF(A, B) is D.
// clang-format off
template <class _Ap, class _Bp, class _Xp, class _Yp>
  requires
    requires { typename __common_ref_D<_Xp, _Yp>; } &&
    is_convertible_v<_Ap&&, __common_ref_D<_Xp, _Yp>>
struct __common_ref<_Ap&&, _Bp&, _Xp, _Yp> {
  using __type = __common_ref_D<_Xp, _Yp>;
};
// clang-format on

//    Otherwise, if A is an lvalue reference and B is an rvalue reference, then
//    COMMON-REF(A, B) is COMMON-REF(B, A).
template <class _Ap, class _Bp, class _Xp, class _Yp>
struct __common_ref<_Ap&, _Bp&&, _Xp, _Yp> : __common_ref<_Bp&&, _Ap&> {};

//    Otherwise, COMMON-REF(A, B) is ill-formed.
template <class _Ap, class _Bp, class _Xp, class _Yp>
struct __common_ref {};

// Note C: For the common_reference trait applied to a parameter pack [...]

template <class...>
struct common_reference;

template <class... _Types>
using common_reference_t = typename common_reference<_Types...>::type;

// bullet 1 - sizeof...(T) == 0
template <>
struct common_reference<> {};

// bullet 2 - sizeof...(T) == 1
template <class _Tp>
struct common_reference<_Tp> {
  using type = _Tp;
};

// bullet 3 - sizeof...(T) == 2
template <class _Tp, class _Up>
struct __common_reference_sub_bullet3;
template <class _Tp, class _Up>
struct __common_reference_sub_bullet2 : __common_reference_sub_bullet3<_Tp, _Up> {};
template <class _Tp, class _Up>
struct __common_reference_sub_bullet1 : __common_reference_sub_bullet2<_Tp, _Up> {};

// sub-bullet 1 - If T1 and T2 are reference types and COMMON-REF(T1, T2) is well-formed, then
// the member typedef `type` denotes that type.
template <class _Tp, class _Up>
struct common_reference<_Tp, _Up> : __common_reference_sub_bullet1<_Tp, _Up> {};

template <class _Tp, class _Up>
  requires is_reference_v<_Tp> && is_reference_v<_Up> && requires { typename __common_ref_t<_Tp, _Up>; }
struct __common_reference_sub_bullet1<_Tp, _Up> {
  using type = __common_ref_t<_Tp, _Up>;
};

// sub-bullet 2 - Otherwise, if basic_common_reference<remove_cvref_t<T1>, remove_cvref_t<T2>, XREF(T1), XREF(T2)>::type
// is well-formed, then the member typedef `type` denotes that type.
template <class, class, template <class> class, template <class> class>
struct basic_common_reference {};

template <class _Tp, class _Up>
using __basic_common_reference_t =
    typename basic_common_reference<remove_cvref_t<_Tp>,
                                    remove_cvref_t<_Up>,
                                    __xref<_Tp>::template __apply,
                                    __xref<_Up>::template __apply>::type;

template <class _Tp, class _Up>
  requires requires { typename __basic_common_reference_t<_Tp, _Up>; }
struct __common_reference_sub_bullet2<_Tp, _Up> {
  using type = __basic_common_reference_t<_Tp, _Up>;
};

// sub-bullet 3 - Otherwise, if COND-RES(T1, T2) is well-formed,
// then the member typedef `type` denotes that type.
template <class _Tp, class _Up>
  requires requires { typename __cond_res<_Tp, _Up>; }
struct __common_reference_sub_bullet3<_Tp, _Up> {
  using type = __cond_res<_Tp, _Up>;
};

// sub-bullet 4 & 5 - Otherwise, if common_type_t<T1, T2> is well-formed,
//                    then the member typedef `type` denotes that type.
//                  - Otherwise, there shall be no member `type`.
template <class _Tp, class _Up>
struct __common_reference_sub_bullet3 : common_type<_Tp, _Up> {};

// bullet 4 - If there is such a type `C`, the member typedef type shall denote the same type, if
//            any, as `common_reference_t<C, Rest...>`.
template <class _Tp, class _Up, class _Vp, class... _Rest>
  requires requires { typename common_reference_t<_Tp, _Up>; }
struct common_reference<_Tp, _Up, _Vp, _Rest...> : common_reference<common_reference_t<_Tp, _Up>, _Vp, _Rest...> {};

// bullet 5 - Otherwise, there shall be no member `type`.
template <class...>
struct common_reference {};

#endif // _LIBCPP_STD_VER >= 20
# 190 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/common_reference.h" 3

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___TYPE_TRAITS_COMMON_REFERENCE_H
# 194 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/common_reference.h" 3
#endif /* common_reference.h expanded by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/common_reference_with.h" 2 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/common_reference_with.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/common_reference_with.h" 3
#endif
# 20 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/common_reference_with.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 20
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 24 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/common_reference_with.h" 3

// [concept.commonref]

template <class _Tp, class _Up>
concept common_reference_with =
    same_as<common_reference_t<_Tp, _Up>, common_reference_t<_Up, _Tp>> &&
    convertible_to<_Tp, common_reference_t<_Tp, _Up>> && convertible_to<_Up, common_reference_t<_Tp, _Up>>;

#endif // _LIBCPP_STD_VER >= 20
# 33 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/common_reference_with.h" 3

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___CONCEPTS_COMMON_REFERENCE_WITH_H
# 37 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/common_reference_with.h" 3
#endif /* common_reference_with.h expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/assignable.h" 2 3
#if 0 /* expanded by -frewrite-includes */
#include <__concepts/same_as.h>
#endif /* expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/assignable.h" 3
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/assignable.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/assignable.h" 3
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/assignable.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/is_reference.h>
#endif /* expanded by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/assignable.h" 3
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/assignable.h" 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* make_const_lvalue_ref.h expanded by -frewrite-includes */
#include <__type_traits/make_const_lvalue_ref.h>
#else /* make_const_lvalue_ref.h expanded by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/assignable.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/make_const_lvalue_ref.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___TYPE_TRAITS_MAKE_CONST_LVALUE_REF_H
#define _LIBCPP___TYPE_TRAITS_MAKE_CONST_LVALUE_REF_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/make_const_lvalue_ref.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/make_const_lvalue_ref.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/remove_reference.h>
#endif /* expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/make_const_lvalue_ref.h" 3
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/make_const_lvalue_ref.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/make_const_lvalue_ref.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/make_const_lvalue_ref.h" 3
#endif
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/make_const_lvalue_ref.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

template <class _Tp>
using __make_const_lvalue_ref = const __libcpp_remove_reference_t<_Tp>&;

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___TYPE_TRAITS_MAKE_CONST_LVALUE_REF_H
# 27 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/make_const_lvalue_ref.h" 3
#endif /* make_const_lvalue_ref.h expanded by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/assignable.h" 2 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* forward.h expanded by -frewrite-includes */
#include <__utility/forward.h>
#else /* forward.h expanded by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/assignable.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/forward.h" 1 3
// -*- C++ -*-
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___UTILITY_FORWARD_H
#define _LIBCPP___UTILITY_FORWARD_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/forward.h" 3
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/forward.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/is_reference.h>
#endif /* expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/forward.h" 3
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/forward.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/remove_reference.h>
#endif /* expanded by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/forward.h" 3
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/forward.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/forward.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/forward.h" 3
#endif
# 20 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/forward.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

template <class _Tp>
_LIBCPP_NODISCARD_EXT inline _LIBCPP_HIDE_FROM_ABI _LIBCPP_CONSTEXPR _Tp&&
forward(_LIBCPP_LIFETIMEBOUND __libcpp_remove_reference_t<_Tp>& __t) _NOEXCEPT {
  return static_cast<_Tp&&>(__t);
}

template <class _Tp>
_LIBCPP_NODISCARD_EXT inline _LIBCPP_HIDE_FROM_ABI _LIBCPP_CONSTEXPR _Tp&&
forward(_LIBCPP_LIFETIMEBOUND __libcpp_remove_reference_t<_Tp>&& __t) _NOEXCEPT {
  static_assert(!is_lvalue_reference<_Tp>::value, "cannot forward an rvalue as an lvalue");
  return static_cast<_Tp&&>(__t);
}

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___UTILITY_FORWARD_H
# 39 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/forward.h" 3
#endif /* forward.h expanded by -frewrite-includes */
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/assignable.h" 2 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 20 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/assignable.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 21 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/assignable.h" 3
#endif
# 22 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/assignable.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 20
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 26 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/assignable.h" 3

// [concept.assignable]

template <class _Lhs, class _Rhs>
concept assignable_from =
    is_lvalue_reference_v<_Lhs> &&
    common_reference_with<__make_const_lvalue_ref<_Lhs>, __make_const_lvalue_ref<_Rhs>> &&
    requires(_Lhs __lhs, _Rhs&& __rhs) {
      { __lhs = _VSTD::forward<_Rhs>(__rhs) } -> same_as<_Lhs>;
    };

#endif // _LIBCPP_STD_VER >= 20
# 38 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/assignable.h" 3

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___CONCEPTS_ASSIGNABLE_H
# 42 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/assignable.h" 3
#endif /* assignable.h expanded by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/advance.h" 2 3
#if 0 /* expanded by -frewrite-includes */
#include <__concepts/same_as.h>
#endif /* expanded by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/advance.h" 3
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/advance.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/advance.h" 3
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/advance.h" 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* concepts.h expanded by -frewrite-includes */
#include <__iterator/concepts.h>
#else /* concepts.h expanded by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/advance.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/concepts.h" 1 3
// -*- C++ -*-
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___ITERATOR_CONCEPTS_H
#define _LIBCPP___ITERATOR_CONCEPTS_H

#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* arithmetic.h expanded by -frewrite-includes */
#include <__concepts/arithmetic.h>
#else /* arithmetic.h expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/concepts.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/arithmetic.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___CONCEPTS_ARITHMETIC_H
#define _LIBCPP___CONCEPTS_ARITHMETIC_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/arithmetic.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/arithmetic.h" 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* is_floating_point.h expanded by -frewrite-includes */
#include <__type_traits/is_floating_point.h>
#else /* is_floating_point.h expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/arithmetic.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_floating_point.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___TYPE_TRAITS_IS_FLOATING_POINT_H
#define _LIBCPP___TYPE_TRAITS_IS_FLOATING_POINT_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_floating_point.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_floating_point.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/integral_constant.h>
#endif /* expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_floating_point.h" 3
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_floating_point.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/remove_cv.h>
#endif /* expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_floating_point.h" 3
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_floating_point.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_floating_point.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_floating_point.h" 3
#endif
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_floating_point.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

// clang-format off
template <class _Tp> struct __libcpp_is_floating_point              : public false_type {};
template <>          struct __libcpp_is_floating_point<float>       : public true_type {};
template <>          struct __libcpp_is_floating_point<double>      : public true_type {};
template <>          struct __libcpp_is_floating_point<long double> : public true_type {};
// clang-format on

template <class _Tp>
struct _LIBCPP_TEMPLATE_VIS is_floating_point : public __libcpp_is_floating_point<__remove_cv_t<_Tp> > {};

#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 17
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 33 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_floating_point.h" 3
template <class _Tp>
inline constexpr bool is_floating_point_v = is_floating_point<_Tp>::value;
#endif
# 36 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_floating_point.h" 3

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___TYPE_TRAITS_IS_FLOATING_POINT_H
# 40 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_floating_point.h" 3
#endif /* is_floating_point.h expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/arithmetic.h" 2 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/is_integral.h>
#endif /* expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/arithmetic.h" 3
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/arithmetic.h" 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* is_signed.h expanded by -frewrite-includes */
#include <__type_traits/is_signed.h>
#else /* is_signed.h expanded by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/arithmetic.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_signed.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___TYPE_TRAITS_IS_SIGNED_H
#define _LIBCPP___TYPE_TRAITS_IS_SIGNED_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_signed.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_signed.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/integral_constant.h>
#endif /* expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_signed.h" 3
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_signed.h" 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* is_arithmetic.h expanded by -frewrite-includes */
#include <__type_traits/is_arithmetic.h>
#else /* is_arithmetic.h expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_signed.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_arithmetic.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___TYPE_TRAITS_IS_ARITHMETIC_H
#define _LIBCPP___TYPE_TRAITS_IS_ARITHMETIC_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_arithmetic.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_arithmetic.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/integral_constant.h>
#endif /* expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_arithmetic.h" 3
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_arithmetic.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/is_floating_point.h>
#endif /* expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_arithmetic.h" 3
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_arithmetic.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/is_integral.h>
#endif /* expanded by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_arithmetic.h" 3
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_arithmetic.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_arithmetic.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_arithmetic.h" 3
#endif
# 20 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_arithmetic.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

template <class _Tp>
struct _LIBCPP_TEMPLATE_VIS is_arithmetic
    : public integral_constant<bool, is_integral<_Tp>::value || is_floating_point<_Tp>::value> {};

#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 17
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 28 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_arithmetic.h" 3
template <class _Tp>
inline constexpr bool is_arithmetic_v = is_arithmetic<_Tp>::value;
#endif
# 31 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_arithmetic.h" 3

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___TYPE_TRAITS_IS_ARITHMETIC_H
# 35 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_arithmetic.h" 3
#endif /* is_arithmetic.h expanded by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_signed.h" 2 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/is_integral.h>
#endif /* expanded by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_signed.h" 3
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_signed.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_signed.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_signed.h" 3
#endif
# 20 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_signed.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

#if 0 /* disabled by -frewrite-includes */
#if __has_builtin(__is_signed)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 24 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_signed.h" 3

template <class _Tp>
struct _LIBCPP_TEMPLATE_VIS is_signed : _BoolConstant<__is_signed(_Tp)> {};

#if 0 /* disabled by -frewrite-includes */
#  if _LIBCPP_STD_VER >= 17
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 29 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_signed.h" 3
template <class _Tp>
inline constexpr bool is_signed_v = __is_signed(_Tp);
#  endif
# 32 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_signed.h" 3

#else // __has_builtin(__is_signed)
# 34 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_signed.h" 3

template <class _Tp, bool = is_integral<_Tp>::value>
struct __libcpp_is_signed_impl : public _BoolConstant<(_Tp(-1) < _Tp(0))> {};

template <class _Tp>
struct __libcpp_is_signed_impl<_Tp, false> : public true_type {}; // floating point

template <class _Tp, bool = is_arithmetic<_Tp>::value>
struct __libcpp_is_signed : public __libcpp_is_signed_impl<_Tp> {};

template <class _Tp>
struct __libcpp_is_signed<_Tp, false> : public false_type {};

template <class _Tp>
struct _LIBCPP_TEMPLATE_VIS is_signed : public __libcpp_is_signed<_Tp> {};

#if 0 /* disabled by -frewrite-includes */
#  if _LIBCPP_STD_VER >= 17
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 51 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_signed.h" 3
template <class _Tp>
inline constexpr bool is_signed_v = is_signed<_Tp>::value;
#  endif
# 54 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_signed.h" 3

#endif // __has_builtin(__is_signed)
# 56 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_signed.h" 3

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___TYPE_TRAITS_IS_SIGNED_H
# 60 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_signed.h" 3
#endif /* is_signed.h expanded by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/arithmetic.h" 2 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* is_signed_integer.h expanded by -frewrite-includes */
#include <__type_traits/is_signed_integer.h>
#else /* is_signed_integer.h expanded by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/arithmetic.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_signed_integer.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___TYPE_TRAITS_IS_SIGNED_INTEGER_H
#define _LIBCPP___TYPE_TRAITS_IS_SIGNED_INTEGER_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_signed_integer.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_signed_integer.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/integral_constant.h>
#endif /* expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_signed_integer.h" 3
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_signed_integer.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_signed_integer.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_signed_integer.h" 3
#endif
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_signed_integer.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

// clang-format off
template <class _Tp> struct __libcpp_is_signed_integer                   : public false_type {};
template <>          struct __libcpp_is_signed_integer<signed char>      : public true_type {};
template <>          struct __libcpp_is_signed_integer<signed short>     : public true_type {};
template <>          struct __libcpp_is_signed_integer<signed int>       : public true_type {};
template <>          struct __libcpp_is_signed_integer<signed long>      : public true_type {};
template <>          struct __libcpp_is_signed_integer<signed long long> : public true_type {};
#ifndef _LIBCPP_HAS_NO_INT128
template <>          struct __libcpp_is_signed_integer<__int128_t>       : public true_type {};
#endif
# 31 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_signed_integer.h" 3
// clang-format on

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___TYPE_TRAITS_IS_SIGNED_INTEGER_H
# 36 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_signed_integer.h" 3
#endif /* is_signed_integer.h expanded by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/arithmetic.h" 2 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* is_unsigned_integer.h expanded by -frewrite-includes */
#include <__type_traits/is_unsigned_integer.h>
#else /* is_unsigned_integer.h expanded by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/arithmetic.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_unsigned_integer.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___TYPE_TRAITS_IS_UNSIGNED_INTEGER_H
#define _LIBCPP___TYPE_TRAITS_IS_UNSIGNED_INTEGER_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_unsigned_integer.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_unsigned_integer.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/integral_constant.h>
#endif /* expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_unsigned_integer.h" 3
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_unsigned_integer.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_unsigned_integer.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_unsigned_integer.h" 3
#endif
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_unsigned_integer.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

// clang-format off
template <class _Tp> struct __libcpp_is_unsigned_integer                     : public false_type {};
template <>          struct __libcpp_is_unsigned_integer<unsigned char>      : public true_type {};
template <>          struct __libcpp_is_unsigned_integer<unsigned short>     : public true_type {};
template <>          struct __libcpp_is_unsigned_integer<unsigned int>       : public true_type {};
template <>          struct __libcpp_is_unsigned_integer<unsigned long>      : public true_type {};
template <>          struct __libcpp_is_unsigned_integer<unsigned long long> : public true_type {};
#ifndef _LIBCPP_HAS_NO_INT128
template <>          struct __libcpp_is_unsigned_integer<__uint128_t>        : public true_type {};
#endif
# 31 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_unsigned_integer.h" 3
// clang-format on

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___TYPE_TRAITS_IS_UNSIGNED_INTEGER_H
# 36 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_unsigned_integer.h" 3
#endif /* is_unsigned_integer.h expanded by -frewrite-includes */
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/arithmetic.h" 2 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 20 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/arithmetic.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 21 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/arithmetic.h" 3
#endif
# 22 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/arithmetic.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 20
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 26 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/arithmetic.h" 3

// [concepts.arithmetic], arithmetic concepts

template <class _Tp>
concept integral = is_integral_v<_Tp>;

template <class _Tp>
concept signed_integral = integral<_Tp> && is_signed_v<_Tp>;

template <class _Tp>
concept unsigned_integral = integral<_Tp> && !signed_integral<_Tp>;

template <class _Tp>
concept floating_point = is_floating_point_v<_Tp>;

// Concept helpers for the internal type traits for the fundamental types.

template <class _Tp>
concept __libcpp_unsigned_integer = __libcpp_is_unsigned_integer<_Tp>::value;
template <class _Tp>
concept __libcpp_signed_integer = __libcpp_is_signed_integer<_Tp>::value;

#endif // _LIBCPP_STD_VER >= 20
# 49 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/arithmetic.h" 3

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___CONCEPTS_ARITHMETIC_H
# 53 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/arithmetic.h" 3
#endif /* arithmetic.h expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/concepts.h" 2 3
#if 0 /* expanded by -frewrite-includes */
#include <__concepts/assignable.h>
#endif /* expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/concepts.h" 3
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/concepts.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__concepts/common_reference_with.h>
#endif /* expanded by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/concepts.h" 3
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/concepts.h" 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* constructible.h expanded by -frewrite-includes */
#include <__concepts/constructible.h>
#else /* constructible.h expanded by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/concepts.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/constructible.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___CONCEPTS_CONSTRUCTIBLE_H
#define _LIBCPP___CONCEPTS_CONSTRUCTIBLE_H

#if 0 /* expanded by -frewrite-includes */
#include <__concepts/convertible_to.h>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/constructible.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/constructible.h" 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* destructible.h expanded by -frewrite-includes */
#include <__concepts/destructible.h>
#else /* destructible.h expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/constructible.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/destructible.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___CONCEPTS_DESTRUCTIBLE_H
#define _LIBCPP___CONCEPTS_DESTRUCTIBLE_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/destructible.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/destructible.h" 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* is_nothrow_destructible.h expanded by -frewrite-includes */
#include <__type_traits/is_nothrow_destructible.h>
#else /* is_nothrow_destructible.h expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/destructible.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_nothrow_destructible.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___TYPE_TRAITS_IS_NOTHROW_DESTRUCTIBLE_H
#define _LIBCPP___TYPE_TRAITS_IS_NOTHROW_DESTRUCTIBLE_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_nothrow_destructible.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_nothrow_destructible.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/integral_constant.h>
#endif /* expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_nothrow_destructible.h" 3
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_nothrow_destructible.h" 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* is_destructible.h expanded by -frewrite-includes */
#include <__type_traits/is_destructible.h>
#else /* is_destructible.h expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_nothrow_destructible.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_destructible.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___TYPE_TRAITS_IS_DESTRUCTIBLE_H
#define _LIBCPP___TYPE_TRAITS_IS_DESTRUCTIBLE_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_destructible.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_destructible.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/integral_constant.h>
#endif /* expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_destructible.h" 3
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_destructible.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/is_function.h>
#endif /* expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_destructible.h" 3
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_destructible.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/is_reference.h>
#endif /* expanded by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_destructible.h" 3
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_destructible.h" 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* remove_all_extents.h expanded by -frewrite-includes */
#include <__type_traits/remove_all_extents.h>
#else /* remove_all_extents.h expanded by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_destructible.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_all_extents.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___TYPE_TRAITS_REMOVE_ALL_EXTENTS_H
#define _LIBCPP___TYPE_TRAITS_REMOVE_ALL_EXTENTS_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_all_extents.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_all_extents.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <cstddef>
#endif /* expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_all_extents.h" 3
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_all_extents.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_all_extents.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_all_extents.h" 3
#endif
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_all_extents.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

#if 0 /* disabled by -frewrite-includes */
#if __has_builtin(__remove_all_extents)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 22 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_all_extents.h" 3
template <class _Tp>
struct remove_all_extents {
  using type _LIBCPP_NODEBUG = __remove_all_extents(_Tp);
};

template <class _Tp>
using __remove_all_extents_t = __remove_all_extents(_Tp);
#else
# 30 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_all_extents.h" 3
template <class _Tp>
struct _LIBCPP_TEMPLATE_VIS remove_all_extents {
  typedef _Tp type;
};
template <class _Tp>
struct _LIBCPP_TEMPLATE_VIS remove_all_extents<_Tp[]> {
  typedef typename remove_all_extents<_Tp>::type type;
};
template <class _Tp, size_t _Np>
struct _LIBCPP_TEMPLATE_VIS remove_all_extents<_Tp[_Np]> {
  typedef typename remove_all_extents<_Tp>::type type;
};

template <class _Tp>
using __remove_all_extents_t = typename remove_all_extents<_Tp>::type;
#endif // __has_builtin(__remove_all_extents)
# 46 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_all_extents.h" 3

#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 14
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 48 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_all_extents.h" 3
template <class _Tp>
using remove_all_extents_t = __remove_all_extents_t<_Tp>;
#endif
# 51 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_all_extents.h" 3

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___TYPE_TRAITS_REMOVE_ALL_EXTENTS_H
# 55 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/remove_all_extents.h" 3
#endif /* remove_all_extents.h expanded by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_destructible.h" 2 3
#if 0 /* expanded by -frewrite-includes */
#include <__utility/declval.h>
#endif /* expanded by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_destructible.h" 3
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_destructible.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 20 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_destructible.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 21 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_destructible.h" 3
#endif
# 22 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_destructible.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

#if 0 /* disabled by -frewrite-includes */
#if __has_builtin(__is_destructible)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 26 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_destructible.h" 3

template <class _Tp>
struct _LIBCPP_TEMPLATE_VIS is_destructible : _BoolConstant<__is_destructible(_Tp)> {};

#if 0 /* disabled by -frewrite-includes */
#  if _LIBCPP_STD_VER >= 17
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 31 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_destructible.h" 3
template <class _Tp>
inline constexpr bool is_destructible_v = __is_destructible(_Tp);
#  endif
# 34 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_destructible.h" 3

#else // __has_builtin(__is_destructible)
# 36 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_destructible.h" 3

//  if it's a reference, return true
//  if it's a function, return false
//  if it's   void,     return false
//  if it's an array of unknown bound, return false
//  Otherwise, return "declval<_Up&>().~_Up()" is well-formed
//    where _Up is remove_all_extents<_Tp>::type

template <class>
struct __is_destructible_apply {
  typedef int type;
};

template <typename _Tp>
struct __is_destructor_wellformed {
  template <typename _Tp1>
  static true_type __test(typename __is_destructible_apply<decltype(std::declval<_Tp1&>().~_Tp1())>::type);

  template <typename _Tp1>
  static false_type __test(...);

  static const bool value = decltype(__test<_Tp>(12))::value;
};

template <class _Tp, bool>
struct __destructible_imp;

template <class _Tp>
struct __destructible_imp<_Tp, false>
    : public integral_constant<bool, __is_destructor_wellformed<__remove_all_extents_t<_Tp> >::value> {};

template <class _Tp>
struct __destructible_imp<_Tp, true> : public true_type {};

template <class _Tp, bool>
struct __destructible_false;

template <class _Tp>
struct __destructible_false<_Tp, false> : public __destructible_imp<_Tp, is_reference<_Tp>::value> {};

template <class _Tp>
struct __destructible_false<_Tp, true> : public false_type {};

template <class _Tp>
struct is_destructible : public __destructible_false<_Tp, is_function<_Tp>::value> {};

template <class _Tp>
struct is_destructible<_Tp[]> : public false_type {};

template <>
struct is_destructible<void> : public false_type {};

#if 0 /* disabled by -frewrite-includes */
#  if _LIBCPP_STD_VER >= 17
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 89 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_destructible.h" 3
template <class _Tp>
inline constexpr bool is_destructible_v = is_destructible<_Tp>::value;
#  endif
# 92 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_destructible.h" 3

#endif // __has_builtin(__is_destructible)
# 94 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_destructible.h" 3

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___TYPE_TRAITS_IS_DESTRUCTIBLE_H
# 98 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_destructible.h" 3
#endif /* is_destructible.h expanded by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_nothrow_destructible.h" 2 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/is_reference.h>
#endif /* expanded by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_nothrow_destructible.h" 3
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_nothrow_destructible.h" 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* is_scalar.h expanded by -frewrite-includes */
#include <__type_traits/is_scalar.h>
#else /* is_scalar.h expanded by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_nothrow_destructible.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_scalar.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___TYPE_TRAITS_IS_SCALAR_H
#define _LIBCPP___TYPE_TRAITS_IS_SCALAR_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_scalar.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_scalar.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/integral_constant.h>
#endif /* expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_scalar.h" 3
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_scalar.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/is_arithmetic.h>
#endif /* expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_scalar.h" 3
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_scalar.h" 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* is_enum.h expanded by -frewrite-includes */
#include <__type_traits/is_enum.h>
#else /* is_enum.h expanded by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_scalar.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_enum.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___TYPE_TRAITS_IS_ENUM_H
#define _LIBCPP___TYPE_TRAITS_IS_ENUM_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_enum.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_enum.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/integral_constant.h>
#endif /* expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_enum.h" 3
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_enum.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_enum.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_enum.h" 3
#endif
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_enum.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

template <class _Tp>
struct _LIBCPP_TEMPLATE_VIS is_enum : public integral_constant<bool, __is_enum(_Tp)> {};

#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 17
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 25 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_enum.h" 3
template <class _Tp>
inline constexpr bool is_enum_v = __is_enum(_Tp);
#endif
# 28 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_enum.h" 3

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___TYPE_TRAITS_IS_ENUM_H
# 32 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_enum.h" 3
#endif /* is_enum.h expanded by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_scalar.h" 2 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* is_member_pointer.h expanded by -frewrite-includes */
#include <__type_traits/is_member_pointer.h>
#else /* is_member_pointer.h expanded by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_scalar.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_member_pointer.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___TYPE_TRAITS_IS_MEMBER_POINTER_H
#define _LIBCPP___TYPE_TRAITS_IS_MEMBER_POINTER_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_member_pointer.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_member_pointer.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/integral_constant.h>
#endif /* expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_member_pointer.h" 3
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_member_pointer.h" 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* is_member_function_pointer.h expanded by -frewrite-includes */
#include <__type_traits/is_member_function_pointer.h>
#else /* is_member_function_pointer.h expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_member_pointer.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_member_function_pointer.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___TYPE_TRAITS_IS_MEMBER_FUNCTION_POINTER_H
#define _LIBCPP___TYPE_TRAITS_IS_MEMBER_FUNCTION_POINTER_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_member_function_pointer.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_member_function_pointer.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/integral_constant.h>
#endif /* expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_member_function_pointer.h" 3
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_member_function_pointer.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/is_function.h>
#endif /* expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_member_function_pointer.h" 3
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_member_function_pointer.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/remove_cv.h>
#endif /* expanded by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_member_function_pointer.h" 3
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_member_function_pointer.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <cstddef>
#endif /* expanded by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_member_function_pointer.h" 3
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_member_function_pointer.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_member_function_pointer.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 20 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_member_function_pointer.h" 3
#endif
# 21 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_member_function_pointer.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

template <class _Tp>
struct __libcpp_is_member_pointer {
  enum { __is_member = false, __is_func = false, __is_obj = false };
};
template <class _Tp, class _Up>
struct __libcpp_is_member_pointer<_Tp _Up::*> {
  enum {
    __is_member = true,
    __is_func   = is_function<_Tp>::value,
    __is_obj    = !__is_func,
  };
};

#if 0 /* disabled by -frewrite-includes */
#if __has_builtin(__is_member_function_pointer)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 38 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_member_function_pointer.h" 3

template <class _Tp>
struct _LIBCPP_TEMPLATE_VIS is_member_function_pointer : _BoolConstant<__is_member_function_pointer(_Tp)> {};

#if 0 /* disabled by -frewrite-includes */
#  if _LIBCPP_STD_VER >= 17
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 43 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_member_function_pointer.h" 3
template <class _Tp>
inline constexpr bool is_member_function_pointer_v = __is_member_function_pointer(_Tp);
#  endif
# 46 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_member_function_pointer.h" 3

#else // __has_builtin(__is_member_function_pointer)
# 48 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_member_function_pointer.h" 3

template <class _Tp>
struct _LIBCPP_TEMPLATE_VIS is_member_function_pointer
    : public _BoolConstant<__libcpp_is_member_pointer<__remove_cv_t<_Tp> >::__is_func> {};

#if 0 /* disabled by -frewrite-includes */
#  if _LIBCPP_STD_VER >= 17
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 54 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_member_function_pointer.h" 3
template <class _Tp>
inline constexpr bool is_member_function_pointer_v = is_member_function_pointer<_Tp>::value;
#  endif
# 57 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_member_function_pointer.h" 3

#endif // __has_builtin(__is_member_function_pointer)
# 59 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_member_function_pointer.h" 3

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___TYPE_TRAITS_IS_MEMBER_FUNCTION_POINTER_H
# 63 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_member_function_pointer.h" 3
#endif /* is_member_function_pointer.h expanded by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_member_pointer.h" 2 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_member_pointer.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_member_pointer.h" 3
#endif
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_member_pointer.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

#if 0 /* disabled by -frewrite-includes */
#if __has_builtin(__is_member_pointer)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 23 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_member_pointer.h" 3

template <class _Tp>
struct _LIBCPP_TEMPLATE_VIS is_member_pointer : _BoolConstant<__is_member_pointer(_Tp)> {};

#if 0 /* disabled by -frewrite-includes */
#  if _LIBCPP_STD_VER >= 17
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 28 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_member_pointer.h" 3
template <class _Tp>
inline constexpr bool is_member_pointer_v = __is_member_pointer(_Tp);
#  endif
# 31 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_member_pointer.h" 3

#else // __has_builtin(__is_member_pointer)
# 33 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_member_pointer.h" 3

template <class _Tp>
struct _LIBCPP_TEMPLATE_VIS is_member_pointer
    : public _BoolConstant<__libcpp_is_member_pointer<__remove_cv_t<_Tp> >::__is_member> {};

#if 0 /* disabled by -frewrite-includes */
#  if _LIBCPP_STD_VER >= 17
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 39 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_member_pointer.h" 3
template <class _Tp>
inline constexpr bool is_member_pointer_v = is_member_pointer<_Tp>::value;
#  endif
# 42 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_member_pointer.h" 3

#endif // __has_builtin(__is_member_pointer)
# 44 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_member_pointer.h" 3

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___TYPE_TRAITS_IS_MEMBER_POINTER_H
# 48 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_member_pointer.h" 3
#endif /* is_member_pointer.h expanded by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_scalar.h" 2 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* is_null_pointer.h expanded by -frewrite-includes */
#include <__type_traits/is_null_pointer.h>
#else /* is_null_pointer.h expanded by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_scalar.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_null_pointer.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___TYPE_TRAITS_IS_NULL_POINTER_H
#define _LIBCPP___TYPE_TRAITS_IS_NULL_POINTER_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_null_pointer.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_null_pointer.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/integral_constant.h>
#endif /* expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_null_pointer.h" 3
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_null_pointer.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/remove_cv.h>
#endif /* expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_null_pointer.h" 3
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_null_pointer.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <cstddef>
#endif /* expanded by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_null_pointer.h" 3
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_null_pointer.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_null_pointer.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_null_pointer.h" 3
#endif
# 20 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_null_pointer.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

template <class _Tp>
struct __is_nullptr_t_impl : public false_type {};
template <>
struct __is_nullptr_t_impl<nullptr_t> : public true_type {};

template <class _Tp>
struct _LIBCPP_TEMPLATE_VIS __is_nullptr_t : public __is_nullptr_t_impl<__remove_cv_t<_Tp> > {};

#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 14
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 32 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_null_pointer.h" 3
template <class _Tp>
struct _LIBCPP_TEMPLATE_VIS is_null_pointer : public __is_nullptr_t_impl<__remove_cv_t<_Tp> > {};

#if 0 /* disabled by -frewrite-includes */
#  if _LIBCPP_STD_VER >= 17
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 36 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_null_pointer.h" 3
template <class _Tp>
inline constexpr bool is_null_pointer_v = is_null_pointer<_Tp>::value;
#  endif
# 39 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_null_pointer.h" 3
#endif // _LIBCPP_STD_VER >= 14
# 40 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_null_pointer.h" 3

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___TYPE_TRAITS_IS_NULL_POINTER_H
# 44 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_null_pointer.h" 3
#endif /* is_null_pointer.h expanded by -frewrite-includes */
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_scalar.h" 2 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* is_pointer.h expanded by -frewrite-includes */
#include <__type_traits/is_pointer.h>
#else /* is_pointer.h expanded by -frewrite-includes */
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_scalar.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_pointer.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___TYPE_TRAITS_IS_POINTER_H
#define _LIBCPP___TYPE_TRAITS_IS_POINTER_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_pointer.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_pointer.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/integral_constant.h>
#endif /* expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_pointer.h" 3
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_pointer.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/remove_cv.h>
#endif /* expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_pointer.h" 3
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_pointer.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_pointer.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_pointer.h" 3
#endif
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_pointer.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

#if 0 /* disabled by -frewrite-includes */
#if __has_builtin(__is_pointer)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 23 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_pointer.h" 3

template <class _Tp>
struct _LIBCPP_TEMPLATE_VIS is_pointer : _BoolConstant<__is_pointer(_Tp)> {};

#if 0 /* disabled by -frewrite-includes */
#  if _LIBCPP_STD_VER >= 17
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 28 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_pointer.h" 3
template <class _Tp>
inline constexpr bool is_pointer_v = __is_pointer(_Tp);
#  endif
# 31 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_pointer.h" 3

#else // __has_builtin(__is_pointer)
# 33 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_pointer.h" 3

template <class _Tp>
struct __libcpp_is_pointer : public false_type {};
template <class _Tp>
struct __libcpp_is_pointer<_Tp*> : public true_type {};

template <class _Tp>
struct __libcpp_remove_objc_qualifiers {
  typedef _Tp type;
};
#if 0 /* disabled by -frewrite-includes */
#  if defined(_LIBCPP_HAS_OBJC_ARC)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 44 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_pointer.h" 3
// clang-format off
template <class _Tp> struct __libcpp_remove_objc_qualifiers<_Tp __strong> { typedef _Tp type; };
template <class _Tp> struct __libcpp_remove_objc_qualifiers<_Tp __weak> { typedef _Tp type; };
template <class _Tp> struct __libcpp_remove_objc_qualifiers<_Tp __autoreleasing> { typedef _Tp type; };
template <class _Tp> struct __libcpp_remove_objc_qualifiers<_Tp __unsafe_unretained> { typedef _Tp type; };
// clang-format on
#  endif
# 51 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_pointer.h" 3

template <class _Tp>
struct _LIBCPP_TEMPLATE_VIS is_pointer
    : public __libcpp_is_pointer<typename __libcpp_remove_objc_qualifiers<__remove_cv_t<_Tp> >::type> {};

#if 0 /* disabled by -frewrite-includes */
#  if _LIBCPP_STD_VER >= 17
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 57 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_pointer.h" 3
template <class _Tp>
inline constexpr bool is_pointer_v = is_pointer<_Tp>::value;
#  endif
# 60 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_pointer.h" 3

#endif // __has_builtin(__is_pointer)
# 62 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_pointer.h" 3

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___TYPE_TRAITS_IS_POINTER_H
# 66 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_pointer.h" 3
#endif /* is_pointer.h expanded by -frewrite-includes */
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_scalar.h" 2 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 21 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_scalar.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 22 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_scalar.h" 3
#endif
# 23 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_scalar.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

#if 0 /* disabled by -frewrite-includes */
#if __has_builtin(__is_scalar)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 27 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_scalar.h" 3

template <class _Tp>
struct _LIBCPP_TEMPLATE_VIS is_scalar : _BoolConstant<__is_scalar(_Tp)> {};

#if 0 /* disabled by -frewrite-includes */
#  if _LIBCPP_STD_VER >= 17
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 32 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_scalar.h" 3
template <class _Tp>
inline constexpr bool is_scalar_v = __is_scalar(_Tp);
#  endif
# 35 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_scalar.h" 3

#else // __has_builtin(__is_scalar)
# 37 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_scalar.h" 3

template <class _Tp>
struct __is_block : false_type {};
#if 0 /* disabled by -frewrite-includes */
#  if defined(_LIBCPP_HAS_EXTENSION_BLOCKS)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 41 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_scalar.h" 3
template <class _Rp, class... _Args>
struct __is_block<_Rp (^)(_Args...)> : true_type {};
#  endif
# 44 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_scalar.h" 3

// clang-format off
template <class _Tp>
struct _LIBCPP_TEMPLATE_VIS is_scalar
    : public integral_constant<
          bool, is_arithmetic<_Tp>::value ||
                is_member_pointer<_Tp>::value ||
                is_pointer<_Tp>::value ||
                __is_nullptr_t<_Tp>::value ||
                __is_block<_Tp>::value ||
                is_enum<_Tp>::value> {};
// clang-format on

template <>
struct _LIBCPP_TEMPLATE_VIS is_scalar<nullptr_t> : public true_type {};

#if 0 /* disabled by -frewrite-includes */
#  if _LIBCPP_STD_VER >= 17
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 61 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_scalar.h" 3
template <class _Tp>
inline constexpr bool is_scalar_v = is_scalar<_Tp>::value;
#  endif
# 64 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_scalar.h" 3

#endif // __has_builtin(__is_scalar)
# 66 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_scalar.h" 3

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___TYPE_TRAITS_IS_SCALAR_H
# 70 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_scalar.h" 3
#endif /* is_scalar.h expanded by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_nothrow_destructible.h" 2 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/remove_all_extents.h>
#endif /* expanded by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_nothrow_destructible.h" 3
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_nothrow_destructible.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__utility/declval.h>
#endif /* expanded by -frewrite-includes */
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_nothrow_destructible.h" 3
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_nothrow_destructible.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <cstddef>
#endif /* expanded by -frewrite-includes */
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_nothrow_destructible.h" 3
# 20 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_nothrow_destructible.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 22 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_nothrow_destructible.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 23 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_nothrow_destructible.h" 3
#endif
# 24 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_nothrow_destructible.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_CXX03_LANG)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 28 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_nothrow_destructible.h" 3

template <bool, class _Tp>
struct __libcpp_is_nothrow_destructible;

template <class _Tp>
struct __libcpp_is_nothrow_destructible<false, _Tp> : public false_type {};

template <class _Tp>
struct __libcpp_is_nothrow_destructible<true, _Tp>
    : public integral_constant<bool, noexcept(std::declval<_Tp>().~_Tp()) > {};

template <class _Tp>
struct _LIBCPP_TEMPLATE_VIS is_nothrow_destructible
    : public __libcpp_is_nothrow_destructible<is_destructible<_Tp>::value, _Tp> {};

template <class _Tp, size_t _Ns>
struct _LIBCPP_TEMPLATE_VIS is_nothrow_destructible<_Tp[_Ns]> : public is_nothrow_destructible<_Tp> {};

template <class _Tp>
struct _LIBCPP_TEMPLATE_VIS is_nothrow_destructible<_Tp&> : public true_type {};

template <class _Tp>
struct _LIBCPP_TEMPLATE_VIS is_nothrow_destructible<_Tp&&> : public true_type {};

#else
# 53 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_nothrow_destructible.h" 3

template <class _Tp>
struct __libcpp_nothrow_destructor : public integral_constant<bool, is_scalar<_Tp>::value || is_reference<_Tp>::value> {
};

template <class _Tp>
struct _LIBCPP_TEMPLATE_VIS is_nothrow_destructible : public __libcpp_nothrow_destructor<__remove_all_extents_t<_Tp> > {
};

template <class _Tp>
struct _LIBCPP_TEMPLATE_VIS is_nothrow_destructible<_Tp[]> : public false_type {};

#endif
# 66 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_nothrow_destructible.h" 3

#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 17
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 68 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_nothrow_destructible.h" 3
template <class _Tp>
inline constexpr bool is_nothrow_destructible_v = is_nothrow_destructible<_Tp>::value;
#endif
# 71 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_nothrow_destructible.h" 3

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___TYPE_TRAITS_IS_NOTHROW_DESTRUCTIBLE_H
# 75 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_nothrow_destructible.h" 3
#endif /* is_nothrow_destructible.h expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/destructible.h" 2 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/destructible.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/destructible.h" 3
#endif
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/destructible.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 20
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 22 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/destructible.h" 3

// [concept.destructible]

template <class _Tp>
concept destructible = is_nothrow_destructible_v<_Tp>;

#endif // _LIBCPP_STD_VER >= 20
# 29 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/destructible.h" 3

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___CONCEPTS_DESTRUCTIBLE_H
# 33 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/destructible.h" 3
#endif /* destructible.h expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/constructible.h" 2 3
#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/constructible.h" 3
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/constructible.h" 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* is_constructible.h expanded by -frewrite-includes */
#include <__type_traits/is_constructible.h>
#else /* is_constructible.h expanded by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/constructible.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_constructible.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___TYPE_IS_CONSTRUCTIBLE_H
#define _LIBCPP___TYPE_IS_CONSTRUCTIBLE_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_constructible.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_constructible.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/integral_constant.h>
#endif /* expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_constructible.h" 3
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_constructible.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_constructible.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_constructible.h" 3
#endif
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_constructible.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

template <class _Tp, class... _Args>
struct _LIBCPP_TEMPLATE_VIS is_constructible : public integral_constant<bool, __is_constructible(_Tp, _Args...)> {};

#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 17
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 25 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_constructible.h" 3
template <class _Tp, class... _Args>
inline constexpr bool is_constructible_v = __is_constructible(_Tp, _Args...);
#endif
# 28 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_constructible.h" 3

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___TYPE_IS_CONSTRUCTIBLE_H
# 32 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_constructible.h" 3
#endif /* is_constructible.h expanded by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/constructible.h" 2 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/constructible.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/constructible.h" 3
#endif
# 20 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/constructible.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 20
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 24 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/constructible.h" 3

// [concept.constructible]
template <class _Tp, class... _Args>
concept constructible_from = destructible<_Tp> && is_constructible_v<_Tp, _Args...>;

// [concept.default.init]

template <class _Tp>
concept __default_initializable = requires { ::new _Tp; };

template <class _Tp>
concept default_initializable = constructible_from<_Tp> && requires { _Tp{}; } && __default_initializable<_Tp>;

// [concept.moveconstructible]
template <class _Tp>
concept move_constructible = constructible_from<_Tp, _Tp> && convertible_to<_Tp, _Tp>;

// [concept.copyconstructible]
// clang-format off
template <class _Tp>
concept copy_constructible =
    move_constructible<_Tp> &&
    constructible_from<_Tp, _Tp&> && convertible_to<_Tp&, _Tp> &&
    constructible_from<_Tp, const _Tp&> && convertible_to<const _Tp&, _Tp> &&
    constructible_from<_Tp, const _Tp> && convertible_to<const _Tp, _Tp>;
// clang-format on

#endif // _LIBCPP_STD_VER >= 20
# 52 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/constructible.h" 3

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___CONCEPTS_CONSTRUCTIBLE_H
# 56 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/constructible.h" 3
#endif /* constructible.h expanded by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/concepts.h" 2 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* copyable.h expanded by -frewrite-includes */
#include <__concepts/copyable.h>
#else /* copyable.h expanded by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/concepts.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/copyable.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___CONCEPTS_COPYABLE_H
#define _LIBCPP___CONCEPTS_COPYABLE_H

#if 0 /* expanded by -frewrite-includes */
#include <__concepts/assignable.h>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/copyable.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/copyable.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__concepts/constructible.h>
#endif /* expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/copyable.h" 3
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/copyable.h" 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* movable.h expanded by -frewrite-includes */
#include <__concepts/movable.h>
#else /* movable.h expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/copyable.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/movable.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___CONCEPTS_MOVABLE_H
#define _LIBCPP___CONCEPTS_MOVABLE_H

#if 0 /* expanded by -frewrite-includes */
#include <__concepts/assignable.h>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/movable.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/movable.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__concepts/constructible.h>
#endif /* expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/movable.h" 3
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/movable.h" 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* swappable.h expanded by -frewrite-includes */
#include <__concepts/swappable.h>
#else /* swappable.h expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/movable.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/swappable.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___CONCEPTS_SWAPPABLE_H
#define _LIBCPP___CONCEPTS_SWAPPABLE_H

#if 0 /* expanded by -frewrite-includes */
#include <__concepts/assignable.h>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/swappable.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/swappable.h" 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* class_or_enum.h expanded by -frewrite-includes */
#include <__concepts/class_or_enum.h>
#else /* class_or_enum.h expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/swappable.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/class_or_enum.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___CONCEPTS_CLASS_OR_ENUM_H
#define _LIBCPP___CONCEPTS_CLASS_OR_ENUM_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/class_or_enum.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/class_or_enum.h" 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* is_class.h expanded by -frewrite-includes */
#include <__type_traits/is_class.h>
#else /* is_class.h expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/class_or_enum.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_class.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___TYPE_TRAITS_IS_CLASS_H
#define _LIBCPP___TYPE_TRAITS_IS_CLASS_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_class.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_class.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/integral_constant.h>
#endif /* expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_class.h" 3
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_class.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_class.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_class.h" 3
#endif
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_class.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

template <class _Tp>
struct _LIBCPP_TEMPLATE_VIS is_class : public integral_constant<bool, __is_class(_Tp)> {};

#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 17
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 25 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_class.h" 3
template <class _Tp>
inline constexpr bool is_class_v = __is_class(_Tp);
#endif
# 28 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_class.h" 3

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___TYPE_TRAITS_IS_CLASS_H
# 32 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_class.h" 3
#endif /* is_class.h expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/class_or_enum.h" 2 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/is_enum.h>
#endif /* expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/class_or_enum.h" 3
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/class_or_enum.h" 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* is_union.h expanded by -frewrite-includes */
#include <__type_traits/is_union.h>
#else /* is_union.h expanded by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/class_or_enum.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_union.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___TYPE_TRAITS_IS_UNION_H
#define _LIBCPP___TYPE_TRAITS_IS_UNION_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_union.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_union.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/integral_constant.h>
#endif /* expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_union.h" 3
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_union.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_union.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_union.h" 3
#endif
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_union.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

template <class _Tp>
struct _LIBCPP_TEMPLATE_VIS is_union : public integral_constant<bool, __is_union(_Tp)> {};

#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 17
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 25 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_union.h" 3
template <class _Tp>
inline constexpr bool is_union_v = __is_union(_Tp);
#endif
# 28 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_union.h" 3

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___TYPE_TRAITS_IS_UNION_H
# 32 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_union.h" 3
#endif /* is_union.h expanded by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/class_or_enum.h" 2 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/remove_cvref.h>
#endif /* expanded by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/class_or_enum.h" 3
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/class_or_enum.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/class_or_enum.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 20 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/class_or_enum.h" 3
#endif
# 21 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/class_or_enum.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 20
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 25 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/class_or_enum.h" 3

// Whether a type is a class type or enumeration type according to the Core wording.

template <class _Tp>
concept __class_or_enum = is_class_v<_Tp> || is_union_v<_Tp> || is_enum_v<_Tp>;

// Work around Clang bug https://llvm.org/PR52970
// TODO: remove this workaround once libc++ no longer has to support Clang 13 (it was fixed in Clang 14).
template <class _Tp>
concept __workaround_52970 = is_class_v<__remove_cvref_t<_Tp>> || is_union_v<__remove_cvref_t<_Tp>>;

#endif // _LIBCPP_STD_VER >= 20
# 37 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/class_or_enum.h" 3

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___CONCEPTS_CLASS_OR_ENUM_H
# 41 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/class_or_enum.h" 3
#endif /* class_or_enum.h expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/swappable.h" 2 3
#if 0 /* expanded by -frewrite-includes */
#include <__concepts/common_reference_with.h>
#endif /* expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/swappable.h" 3
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/swappable.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__concepts/constructible.h>
#endif /* expanded by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/swappable.h" 3
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/swappable.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/swappable.h" 3
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/swappable.h" 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* extent.h expanded by -frewrite-includes */
#include <__type_traits/extent.h>
#else /* extent.h expanded by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/swappable.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/extent.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___TYPE_TRAITS_EXTENT_H
#define _LIBCPP___TYPE_TRAITS_EXTENT_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/extent.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/extent.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/integral_constant.h>
#endif /* expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/extent.h" 3
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/extent.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <cstddef>
#endif /* expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/extent.h" 3
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/extent.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/extent.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/extent.h" 3
#endif
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/extent.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

#if 0 /* disabled by -frewrite-includes */
#if __has_builtin(__array_extent)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 23 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/extent.h" 3

template <class _Tp, size_t _Dim = 0>
struct _LIBCPP_TEMPLATE_VIS extent : integral_constant<size_t, __array_extent(_Tp, _Dim)> {};

#if 0 /* disabled by -frewrite-includes */
#  if _LIBCPP_STD_VER >= 17
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 28 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/extent.h" 3
template <class _Tp, unsigned _Ip = 0>
inline constexpr size_t extent_v = __array_extent(_Tp, _Ip);
#  endif
# 31 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/extent.h" 3

#else // __has_builtin(__array_extent)
# 33 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/extent.h" 3

template <class _Tp, unsigned _Ip = 0>
struct _LIBCPP_TEMPLATE_VIS extent : public integral_constant<size_t, 0> {};
template <class _Tp>
struct _LIBCPP_TEMPLATE_VIS extent<_Tp[], 0> : public integral_constant<size_t, 0> {};
template <class _Tp, unsigned _Ip>
struct _LIBCPP_TEMPLATE_VIS extent<_Tp[], _Ip> : public integral_constant<size_t, extent<_Tp, _Ip - 1>::value> {};
template <class _Tp, size_t _Np>
struct _LIBCPP_TEMPLATE_VIS extent<_Tp[_Np], 0> : public integral_constant<size_t, _Np> {};
template <class _Tp, size_t _Np, unsigned _Ip>
struct _LIBCPP_TEMPLATE_VIS extent<_Tp[_Np], _Ip> : public integral_constant<size_t, extent<_Tp, _Ip - 1>::value> {};

#if 0 /* disabled by -frewrite-includes */
#  if _LIBCPP_STD_VER >= 17
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 46 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/extent.h" 3
template <class _Tp, unsigned _Ip = 0>
inline constexpr size_t extent_v = extent<_Tp, _Ip>::value;
#  endif
# 49 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/extent.h" 3

#endif // __has_builtin(__array_extent)
# 51 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/extent.h" 3

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___TYPE_TRAITS_EXTENT_H
# 55 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/extent.h" 3
#endif /* extent.h expanded by -frewrite-includes */
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/swappable.h" 2 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* is_nothrow_move_assignable.h expanded by -frewrite-includes */
#include <__type_traits/is_nothrow_move_assignable.h>
#else /* is_nothrow_move_assignable.h expanded by -frewrite-includes */
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/swappable.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_nothrow_move_assignable.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___TYPE_TRAITS_IS_NOTHROW_MOVE_ASSIGNABLE_H
#define _LIBCPP___TYPE_TRAITS_IS_NOTHROW_MOVE_ASSIGNABLE_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_nothrow_move_assignable.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_nothrow_move_assignable.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/add_lvalue_reference.h>
#endif /* expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_nothrow_move_assignable.h" 3
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_nothrow_move_assignable.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/add_rvalue_reference.h>
#endif /* expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_nothrow_move_assignable.h" 3
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_nothrow_move_assignable.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/integral_constant.h>
#endif /* expanded by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_nothrow_move_assignable.h" 3
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_nothrow_move_assignable.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_nothrow_move_assignable.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_nothrow_move_assignable.h" 3
#endif
# 20 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_nothrow_move_assignable.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

template <class _Tp>
struct _LIBCPP_TEMPLATE_VIS is_nothrow_move_assignable
    : public integral_constant<bool,
                               __is_nothrow_assignable(__add_lvalue_reference_t<_Tp>, __add_rvalue_reference_t<_Tp>)> {
};

#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 17
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 30 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_nothrow_move_assignable.h" 3
template <class _Tp>
inline constexpr bool is_nothrow_move_assignable_v = is_nothrow_move_assignable<_Tp>::value;
#endif
# 33 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_nothrow_move_assignable.h" 3

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___TYPE_TRAITS_IS_NOTHROW_MOVE_ASSIGNABLE_H
# 37 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_nothrow_move_assignable.h" 3
#endif /* is_nothrow_move_assignable.h expanded by -frewrite-includes */
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/swappable.h" 2 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* is_nothrow_move_constructible.h expanded by -frewrite-includes */
#include <__type_traits/is_nothrow_move_constructible.h>
#else /* is_nothrow_move_constructible.h expanded by -frewrite-includes */
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/swappable.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_nothrow_move_constructible.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___TYPE_TRAITS_IS_NOTHROW_MOVE_CONSTRUCTIBLE_H
#define _LIBCPP___TYPE_TRAITS_IS_NOTHROW_MOVE_CONSTRUCTIBLE_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_nothrow_move_constructible.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_nothrow_move_constructible.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/add_rvalue_reference.h>
#endif /* expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_nothrow_move_constructible.h" 3
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_nothrow_move_constructible.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/integral_constant.h>
#endif /* expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_nothrow_move_constructible.h" 3
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_nothrow_move_constructible.h" 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* is_nothrow_constructible.h expanded by -frewrite-includes */
#include <__type_traits/is_nothrow_constructible.h>
#else /* is_nothrow_constructible.h expanded by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_nothrow_move_constructible.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_nothrow_constructible.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___TYPE_TRAITS_IS_NOTHROW_CONSTRUCTIBLE_H
#define _LIBCPP___TYPE_TRAITS_IS_NOTHROW_CONSTRUCTIBLE_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_nothrow_constructible.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_nothrow_constructible.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/integral_constant.h>
#endif /* expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_nothrow_constructible.h" 3
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_nothrow_constructible.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/is_constructible.h>
#endif /* expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_nothrow_constructible.h" 3
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_nothrow_constructible.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/is_reference.h>
#endif /* expanded by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_nothrow_constructible.h" 3
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_nothrow_constructible.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__utility/declval.h>
#endif /* expanded by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_nothrow_constructible.h" 3
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_nothrow_constructible.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <cstddef>
#endif /* expanded by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_nothrow_constructible.h" 3
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_nothrow_constructible.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 20 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_nothrow_constructible.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 21 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_nothrow_constructible.h" 3
#endif
# 22 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_nothrow_constructible.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

// GCC is disabled due to https://gcc.gnu.org/bugzilla/show_bug.cgi?id=106611
#if 0 /* disabled by -frewrite-includes */
#if __has_builtin(__is_nothrow_constructible) && !defined(_LIBCPP_COMPILER_GCC)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 27 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_nothrow_constructible.h" 3

template < class _Tp, class... _Args>
struct _LIBCPP_TEMPLATE_VIS is_nothrow_constructible
    : public integral_constant<bool, __is_nothrow_constructible(_Tp, _Args...)> {};
#else
# 32 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_nothrow_constructible.h" 3

template <bool, bool, class _Tp, class... _Args>
struct __libcpp_is_nothrow_constructible;

template <class _Tp, class... _Args>
struct __libcpp_is_nothrow_constructible</*is constructible*/ true, /*is reference*/ false, _Tp, _Args...>
    : public integral_constant<bool, noexcept(_Tp(std::declval<_Args>()...))> {};

template <class _Tp>
void __implicit_conversion_to(_Tp) noexcept {}

template <class _Tp, class _Arg>
struct __libcpp_is_nothrow_constructible</*is constructible*/ true, /*is reference*/ true, _Tp, _Arg>
    : public integral_constant<bool, noexcept(_VSTD::__implicit_conversion_to<_Tp>(std::declval<_Arg>()))> {};

template <class _Tp, bool _IsReference, class... _Args>
struct __libcpp_is_nothrow_constructible</*is constructible*/ false, _IsReference, _Tp, _Args...> : public false_type {
};

template <class _Tp, class... _Args>
struct _LIBCPP_TEMPLATE_VIS is_nothrow_constructible
    : __libcpp_is_nothrow_constructible<is_constructible<_Tp, _Args...>::value,
                                        is_reference<_Tp>::value,
                                        _Tp,
                                        _Args...> {};

template <class _Tp, size_t _Ns>
struct _LIBCPP_TEMPLATE_VIS is_nothrow_constructible<_Tp[_Ns]>
    : __libcpp_is_nothrow_constructible<is_constructible<_Tp>::value, is_reference<_Tp>::value, _Tp> {};

#endif // __has_builtin(__is_nothrow_constructible)
# 63 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_nothrow_constructible.h" 3

#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 17
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 65 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_nothrow_constructible.h" 3
template <class _Tp, class... _Args>
inline constexpr bool is_nothrow_constructible_v = is_nothrow_constructible<_Tp, _Args...>::value;
#endif
# 68 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_nothrow_constructible.h" 3

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___TYPE_TRAITS_IS_NOTHROW_CONSTRUCTIBLE_H
# 72 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_nothrow_constructible.h" 3
#endif /* is_nothrow_constructible.h expanded by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_nothrow_move_constructible.h" 2 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_nothrow_move_constructible.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_nothrow_move_constructible.h" 3
#endif
# 20 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_nothrow_move_constructible.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

// TODO: remove this implementation once https://gcc.gnu.org/bugzilla/show_bug.cgi?id=106611 is fixed
#ifndef _LIBCPP_COMPILER_GCC

template <class _Tp>
struct _LIBCPP_TEMPLATE_VIS is_nothrow_move_constructible
    : public integral_constant<bool, __is_nothrow_constructible(_Tp, __add_rvalue_reference_t<_Tp>)> {};

#else // _LIBCPP_COMPILER_GCC
# 31 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_nothrow_move_constructible.h" 3

template <class _Tp>
struct _LIBCPP_TEMPLATE_VIS is_nothrow_move_constructible
    : public is_nothrow_constructible<_Tp, __add_rvalue_reference_t<_Tp> > {};

#endif // _LIBCPP_COMPILER_GCC
# 37 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_nothrow_move_constructible.h" 3

#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 17
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 39 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_nothrow_move_constructible.h" 3
template <class _Tp>
inline constexpr bool is_nothrow_move_constructible_v = is_nothrow_move_constructible<_Tp>::value;
#endif
# 42 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_nothrow_move_constructible.h" 3

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___TYPE_TRAITS_IS_NOTHROW_MOVE_CONSTRUCTIBLE_H
# 46 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_nothrow_move_constructible.h" 3
#endif /* is_nothrow_move_constructible.h expanded by -frewrite-includes */
# 20 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/swappable.h" 2 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/remove_cvref.h>
#endif /* expanded by -frewrite-includes */
# 20 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/swappable.h" 3
# 21 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/swappable.h" 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* exchange.h expanded by -frewrite-includes */
#include <__utility/exchange.h>
#else /* exchange.h expanded by -frewrite-includes */
# 21 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/swappable.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/exchange.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___UTILITY_EXCHANGE_H
#define _LIBCPP___UTILITY_EXCHANGE_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/exchange.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/exchange.h" 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* is_nothrow_assignable.h expanded by -frewrite-includes */
#include <__type_traits/is_nothrow_assignable.h>
#else /* is_nothrow_assignable.h expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/exchange.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_nothrow_assignable.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___TYPE_TRAITS_IS_NOTHROW_ASSIGNABLE_H
#define _LIBCPP___TYPE_TRAITS_IS_NOTHROW_ASSIGNABLE_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_nothrow_assignable.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_nothrow_assignable.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/integral_constant.h>
#endif /* expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_nothrow_assignable.h" 3
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_nothrow_assignable.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_nothrow_assignable.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_nothrow_assignable.h" 3
#endif
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_nothrow_assignable.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

template <class _Tp, class _Arg>
struct _LIBCPP_TEMPLATE_VIS is_nothrow_assignable : public integral_constant<bool, __is_nothrow_assignable(_Tp, _Arg)> {
};

#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 17
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 26 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_nothrow_assignable.h" 3
template <class _Tp, class _Arg>
inline constexpr bool is_nothrow_assignable_v = __is_nothrow_assignable(_Tp, _Arg);
#endif
# 29 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_nothrow_assignable.h" 3

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___TYPE_TRAITS_IS_NOTHROW_ASSIGNABLE_H
# 33 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_nothrow_assignable.h" 3
#endif /* is_nothrow_assignable.h expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/exchange.h" 2 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/is_nothrow_move_constructible.h>
#endif /* expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/exchange.h" 3
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/exchange.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__utility/forward.h>
#endif /* expanded by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/exchange.h" 3
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/exchange.h" 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* move.h expanded by -frewrite-includes */
#include <__utility/move.h>
#else /* move.h expanded by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/exchange.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/move.h" 1 3
// -*- C++ -*-
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___UTILITY_MOVE_H
#define _LIBCPP___UTILITY_MOVE_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/move.h" 3
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/move.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/conditional.h>
#endif /* expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/move.h" 3
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/move.h" 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* is_copy_constructible.h expanded by -frewrite-includes */
#include <__type_traits/is_copy_constructible.h>
#else /* is_copy_constructible.h expanded by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/move.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_copy_constructible.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___TYPE_TRAITS_IS_COPY_CONSTRUCTIBLE_H
#define _LIBCPP___TYPE_TRAITS_IS_COPY_CONSTRUCTIBLE_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_copy_constructible.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_copy_constructible.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/add_const.h>
#endif /* expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_copy_constructible.h" 3
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_copy_constructible.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/add_lvalue_reference.h>
#endif /* expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_copy_constructible.h" 3
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_copy_constructible.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/integral_constant.h>
#endif /* expanded by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_copy_constructible.h" 3
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_copy_constructible.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_copy_constructible.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_copy_constructible.h" 3
#endif
# 20 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_copy_constructible.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

template <class _Tp>
struct _LIBCPP_TEMPLATE_VIS is_copy_constructible
    : public integral_constant<bool, __is_constructible(_Tp, __add_lvalue_reference_t<typename add_const<_Tp>::type>)> {
};

#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 17
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 29 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_copy_constructible.h" 3
template <class _Tp>
inline constexpr bool is_copy_constructible_v = is_copy_constructible<_Tp>::value;
#endif
# 32 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_copy_constructible.h" 3

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___TYPE_TRAITS_IS_COPY_CONSTRUCTIBLE_H
# 36 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_copy_constructible.h" 3
#endif /* is_copy_constructible.h expanded by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/move.h" 2 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/is_nothrow_move_constructible.h>
#endif /* expanded by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/move.h" 3
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/move.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/remove_reference.h>
#endif /* expanded by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/move.h" 3
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/move.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 20 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/move.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 21 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/move.h" 3
#endif
# 22 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/move.h" 3

_LIBCPP_PUSH_MACROS
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* __undef_macros expanded by -frewrite-includes */
#include <__undef_macros>
#else /* __undef_macros expanded by -frewrite-includes */
# 24 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/move.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__undef_macros" 1 3
// -*- C++ -*-
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifdef min
#  undef min
#endif
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__undef_macros" 3

#ifdef max
#  undef max
#endif
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__undef_macros" 3

#ifdef refresh
#  undef refresh
#endif
# 21 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__undef_macros" 3

#ifdef move
#  undef move
#endif
# 25 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__undef_macros" 3

#ifdef erase
#  undef erase
#endif
# 29 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__undef_macros" 3
#endif /* __undef_macros expanded by -frewrite-includes */
# 25 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/move.h" 2 3

_LIBCPP_BEGIN_NAMESPACE_STD

template <class _Tp>
_LIBCPP_NODISCARD_EXT inline _LIBCPP_HIDE_FROM_ABI _LIBCPP_CONSTEXPR __libcpp_remove_reference_t<_Tp>&&
move(_LIBCPP_LIFETIMEBOUND _Tp&& __t) _NOEXCEPT {
  typedef _LIBCPP_NODEBUG __libcpp_remove_reference_t<_Tp> _Up;
  return static_cast<_Up&&>(__t);
}

template <class _Tp>
using __move_if_noexcept_result_t =
    __conditional_t<!is_nothrow_move_constructible<_Tp>::value && is_copy_constructible<_Tp>::value, const _Tp&, _Tp&&>;

template <class _Tp>
_LIBCPP_NODISCARD_EXT inline _LIBCPP_HIDE_FROM_ABI _LIBCPP_CONSTEXPR_SINCE_CXX14 __move_if_noexcept_result_t<_Tp>
move_if_noexcept(_LIBCPP_LIFETIMEBOUND _Tp& __x) _NOEXCEPT {
  return std::move(__x);
}

_LIBCPP_END_NAMESPACE_STD

_LIBCPP_POP_MACROS

#endif // _LIBCPP___UTILITY_MOVE_H
# 50 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/move.h" 3
#endif /* move.h expanded by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/exchange.h" 2 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/exchange.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 20 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/exchange.h" 3
#endif
# 21 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/exchange.h" 3

_LIBCPP_PUSH_MACROS
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* __undef_macros expanded by -frewrite-includes */
#include <__undef_macros>
#else /* __undef_macros expanded by -frewrite-includes */
# 23 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/exchange.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__undef_macros" 1 3
// -*- C++ -*-
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifdef min
#  undef min
#endif
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__undef_macros" 3

#ifdef max
#  undef max
#endif
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__undef_macros" 3

#ifdef refresh
#  undef refresh
#endif
# 21 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__undef_macros" 3

#ifdef move
#  undef move
#endif
# 25 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__undef_macros" 3

#ifdef erase
#  undef erase
#endif
# 29 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__undef_macros" 3
#endif /* __undef_macros expanded by -frewrite-includes */
# 24 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/exchange.h" 2 3

_LIBCPP_BEGIN_NAMESPACE_STD

#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 14
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 28 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/exchange.h" 3
template<class _T1, class _T2 = _T1>
inline _LIBCPP_INLINE_VISIBILITY _LIBCPP_CONSTEXPR_SINCE_CXX20
_T1 exchange(_T1& __obj, _T2&& __new_value)
    noexcept(is_nothrow_move_constructible<_T1>::value && is_nothrow_assignable<_T1&, _T2>::value)
{
    _T1 __old_value = _VSTD::move(__obj);
    __obj = _VSTD::forward<_T2>(__new_value);
    return __old_value;
}
#endif // _LIBCPP_STD_VER >= 14
# 38 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/exchange.h" 3

_LIBCPP_END_NAMESPACE_STD

_LIBCPP_POP_MACROS

#endif // _LIBCPP___UTILITY_EXCHANGE_H
# 44 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/exchange.h" 3
#endif /* exchange.h expanded by -frewrite-includes */
# 22 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/swappable.h" 2 3
#if 0 /* expanded by -frewrite-includes */
#include <__utility/forward.h>
#endif /* expanded by -frewrite-includes */
# 22 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/swappable.h" 3
# 23 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/swappable.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__utility/move.h>
#endif /* expanded by -frewrite-includes */
# 23 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/swappable.h" 3
# 24 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/swappable.h" 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* swap.h expanded by -frewrite-includes */
#include <__utility/swap.h>
#else /* swap.h expanded by -frewrite-includes */
# 24 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/swappable.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/swap.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___UTILITY_SWAP_H
#define _LIBCPP___UTILITY_SWAP_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/swap.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/swap.h" 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* is_move_assignable.h expanded by -frewrite-includes */
#include <__type_traits/is_move_assignable.h>
#else /* is_move_assignable.h expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/swap.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_move_assignable.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___TYPE_TRAITS_IS_MOVE_ASSIGNABLE_H
#define _LIBCPP___TYPE_TRAITS_IS_MOVE_ASSIGNABLE_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_move_assignable.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_move_assignable.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/add_lvalue_reference.h>
#endif /* expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_move_assignable.h" 3
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_move_assignable.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/add_rvalue_reference.h>
#endif /* expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_move_assignable.h" 3
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_move_assignable.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/integral_constant.h>
#endif /* expanded by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_move_assignable.h" 3
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_move_assignable.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_move_assignable.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_move_assignable.h" 3
#endif
# 20 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_move_assignable.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

template <class _Tp>
struct _LIBCPP_TEMPLATE_VIS is_move_assignable
    : public integral_constant<bool, __is_assignable(__add_lvalue_reference_t<_Tp>, __add_rvalue_reference_t<_Tp>)> {};

#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 17
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 28 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_move_assignable.h" 3
template <class _Tp>
inline constexpr bool is_move_assignable_v = is_move_assignable<_Tp>::value;
#endif
# 31 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_move_assignable.h" 3

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___TYPE_TRAITS_IS_MOVE_ASSIGNABLE_H
# 35 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_move_assignable.h" 3
#endif /* is_move_assignable.h expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/swap.h" 2 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* is_move_constructible.h expanded by -frewrite-includes */
#include <__type_traits/is_move_constructible.h>
#else /* is_move_constructible.h expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/swap.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_move_constructible.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___TYPE_TRAITS_IS_MOVE_CONSTRUCTIBLE_H
#define _LIBCPP___TYPE_TRAITS_IS_MOVE_CONSTRUCTIBLE_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_move_constructible.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_move_constructible.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/add_rvalue_reference.h>
#endif /* expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_move_constructible.h" 3
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_move_constructible.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/integral_constant.h>
#endif /* expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_move_constructible.h" 3
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_move_constructible.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_move_constructible.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_move_constructible.h" 3
#endif
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_move_constructible.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

template <class _Tp>
struct _LIBCPP_TEMPLATE_VIS is_move_constructible
    : public integral_constant<bool, __is_constructible(_Tp, __add_rvalue_reference_t<_Tp>)> {};

#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 17
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 27 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_move_constructible.h" 3
template <class _Tp>
inline constexpr bool is_move_constructible_v = is_move_constructible<_Tp>::value;
#endif
# 30 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_move_constructible.h" 3

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___TYPE_TRAITS_IS_MOVE_CONSTRUCTIBLE_H
# 34 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_move_constructible.h" 3
#endif /* is_move_constructible.h expanded by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/swap.h" 2 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/is_nothrow_move_assignable.h>
#endif /* expanded by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/swap.h" 3
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/swap.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/is_nothrow_move_constructible.h>
#endif /* expanded by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/swap.h" 3
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/swap.h" 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* is_swappable.h expanded by -frewrite-includes */
#include <__type_traits/is_swappable.h>
#else /* is_swappable.h expanded by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/swap.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_swappable.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___TYPE_TRAITS_IS_SWAPPABLE_H
#define _LIBCPP___TYPE_TRAITS_IS_SWAPPABLE_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_swappable.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_swappable.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/add_lvalue_reference.h>
#endif /* expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_swappable.h" 3
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_swappable.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/conditional.h>
#endif /* expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_swappable.h" 3
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_swappable.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/enable_if.h>
#endif /* expanded by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_swappable.h" 3
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_swappable.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/is_move_assignable.h>
#endif /* expanded by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_swappable.h" 3
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_swappable.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/is_move_constructible.h>
#endif /* expanded by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_swappable.h" 3
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_swappable.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/is_nothrow_move_assignable.h>
#endif /* expanded by -frewrite-includes */
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_swappable.h" 3
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_swappable.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/is_nothrow_move_constructible.h>
#endif /* expanded by -frewrite-includes */
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_swappable.h" 3
# 20 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_swappable.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/is_referenceable.h>
#endif /* expanded by -frewrite-includes */
# 20 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_swappable.h" 3
# 21 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_swappable.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/is_same.h>
#endif /* expanded by -frewrite-includes */
# 21 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_swappable.h" 3
# 22 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_swappable.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/is_void.h>
#endif /* expanded by -frewrite-includes */
# 22 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_swappable.h" 3
# 23 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_swappable.h" 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* nat.h expanded by -frewrite-includes */
#include <__type_traits/nat.h>
#else /* nat.h expanded by -frewrite-includes */
# 23 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_swappable.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/nat.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___TYPE_TRAITS_NAT_H
#define _LIBCPP___TYPE_TRAITS_NAT_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/nat.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/nat.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/nat.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/nat.h" 3
#endif
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/nat.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

struct __nat {
#ifndef _LIBCPP_CXX03_LANG
  __nat()                        = delete;
  __nat(const __nat&)            = delete;
  __nat& operator=(const __nat&) = delete;
  ~__nat()                       = delete;
#endif
# 27 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/nat.h" 3
};

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___TYPE_TRAITS_NAT_H
# 32 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/nat.h" 3
#endif /* nat.h expanded by -frewrite-includes */
# 24 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_swappable.h" 2 3
#if 0 /* expanded by -frewrite-includes */
#include <__utility/declval.h>
#endif /* expanded by -frewrite-includes */
# 24 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_swappable.h" 3
# 25 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_swappable.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <cstddef>
#endif /* expanded by -frewrite-includes */
# 25 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_swappable.h" 3
# 26 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_swappable.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 28 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_swappable.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 29 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_swappable.h" 3
#endif
# 30 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_swappable.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

template <class _Tp>
struct __is_swappable;
template <class _Tp>
struct __is_nothrow_swappable;

#ifndef _LIBCPP_CXX03_LANG
template <class _Tp>
using __swap_result_t = __enable_if_t<is_move_constructible<_Tp>::value && is_move_assignable<_Tp>::value>;
#else
# 42 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_swappable.h" 3
template <class>
using __swap_result_t = void;
#endif
# 45 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_swappable.h" 3

template <class _Tp>
inline _LIBCPP_INLINE_VISIBILITY _LIBCPP_CONSTEXPR_SINCE_CXX20 __swap_result_t<_Tp> swap(_Tp& __x, _Tp& __y)
    _NOEXCEPT_(is_nothrow_move_constructible<_Tp>::value&& is_nothrow_move_assignable<_Tp>::value);

template <class _Tp, size_t _Np, __enable_if_t<__is_swappable<_Tp>::value, int> = 0>
inline _LIBCPP_INLINE_VISIBILITY _LIBCPP_CONSTEXPR_SINCE_CXX20 void swap(_Tp (&__a)[_Np], _Tp (&__b)[_Np])
    _NOEXCEPT_(__is_nothrow_swappable<_Tp>::value);

namespace __detail {
// ALL generic swap overloads MUST already have a declaration available at this point.

template <class _Tp, class _Up = _Tp, bool _NotVoid = !is_void<_Tp>::value && !is_void<_Up>::value>
struct __swappable_with {
  template <class _LHS, class _RHS>
  static decltype(swap(std::declval<_LHS>(), std::declval<_RHS>())) __test_swap(int);
  template <class, class>
  static __nat __test_swap(long);

  // Extra parens are needed for the C++03 definition of decltype.
  typedef decltype((__test_swap<_Tp, _Up>(0))) __swap1;
  typedef decltype((__test_swap<_Up, _Tp>(0))) __swap2;

  static const bool value = _IsNotSame<__swap1, __nat>::value && _IsNotSame<__swap2, __nat>::value;
};

template <class _Tp, class _Up>
struct __swappable_with<_Tp, _Up, false> : false_type {};

template <class _Tp, class _Up = _Tp, bool _Swappable = __swappable_with<_Tp, _Up>::value>
struct __nothrow_swappable_with {
  static const bool value =
#ifndef _LIBCPP_HAS_NO_NOEXCEPT
      noexcept(swap(std::declval<_Tp>(), std::declval<_Up>()))&& noexcept(
          swap(std::declval<_Up>(), std::declval<_Tp>()));
#else
# 81 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_swappable.h" 3
      false;
#endif
# 83 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_swappable.h" 3
};

template <class _Tp, class _Up>
struct __nothrow_swappable_with<_Tp, _Up, false> : false_type {};

} // namespace __detail

template <class _Tp>
struct __is_swappable : public integral_constant<bool, __detail::__swappable_with<_Tp&>::value> {};

template <class _Tp>
struct __is_nothrow_swappable : public integral_constant<bool, __detail::__nothrow_swappable_with<_Tp&>::value> {};

#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 17
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 97 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_swappable.h" 3

template <class _Tp, class _Up>
struct _LIBCPP_TEMPLATE_VIS is_swappable_with
    : public integral_constant<bool, __detail::__swappable_with<_Tp, _Up>::value> {};

template <class _Tp>
struct _LIBCPP_TEMPLATE_VIS is_swappable
    : public __conditional_t<__libcpp_is_referenceable<_Tp>::value,
                             is_swappable_with<__add_lvalue_reference_t<_Tp>, __add_lvalue_reference_t<_Tp> >,
                             false_type> {};

template <class _Tp, class _Up>
struct _LIBCPP_TEMPLATE_VIS is_nothrow_swappable_with
    : public integral_constant<bool, __detail::__nothrow_swappable_with<_Tp, _Up>::value> {};

template <class _Tp>
struct _LIBCPP_TEMPLATE_VIS is_nothrow_swappable
    : public __conditional_t<__libcpp_is_referenceable<_Tp>::value,
                             is_nothrow_swappable_with<__add_lvalue_reference_t<_Tp>, __add_lvalue_reference_t<_Tp> >,
                             false_type> {};

template <class _Tp, class _Up>
inline constexpr bool is_swappable_with_v = is_swappable_with<_Tp, _Up>::value;

template <class _Tp>
inline constexpr bool is_swappable_v = is_swappable<_Tp>::value;

template <class _Tp, class _Up>
inline constexpr bool is_nothrow_swappable_with_v = is_nothrow_swappable_with<_Tp, _Up>::value;

template <class _Tp>
inline constexpr bool is_nothrow_swappable_v = is_nothrow_swappable<_Tp>::value;

#endif // _LIBCPP_STD_VER >= 17
# 131 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_swappable.h" 3

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___TYPE_TRAITS_IS_SWAPPABLE_H
# 135 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_swappable.h" 3
#endif /* is_swappable.h expanded by -frewrite-includes */
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/swap.h" 2 3
#if 0 /* expanded by -frewrite-includes */
#include <__utility/declval.h>
#endif /* expanded by -frewrite-includes */
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/swap.h" 3
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/swap.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__utility/move.h>
#endif /* expanded by -frewrite-includes */
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/swap.h" 3
# 20 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/swap.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <cstddef>
#endif /* expanded by -frewrite-includes */
# 20 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/swap.h" 3
# 21 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/swap.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 23 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/swap.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 24 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/swap.h" 3
#endif
# 25 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/swap.h" 3

_LIBCPP_PUSH_MACROS
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* __undef_macros expanded by -frewrite-includes */
#include <__undef_macros>
#else /* __undef_macros expanded by -frewrite-includes */
# 27 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/swap.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__undef_macros" 1 3
// -*- C++ -*-
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifdef min
#  undef min
#endif
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__undef_macros" 3

#ifdef max
#  undef max
#endif
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__undef_macros" 3

#ifdef refresh
#  undef refresh
#endif
# 21 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__undef_macros" 3

#ifdef move
#  undef move
#endif
# 25 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__undef_macros" 3

#ifdef erase
#  undef erase
#endif
# 29 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__undef_macros" 3
#endif /* __undef_macros expanded by -frewrite-includes */
# 28 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/swap.h" 2 3

_LIBCPP_BEGIN_NAMESPACE_STD

#ifndef _LIBCPP_CXX03_LANG
template <class _Tp>
using __swap_result_t = __enable_if_t<is_move_constructible<_Tp>::value && is_move_assignable<_Tp>::value>;
#else
# 35 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/swap.h" 3
template <class>
using __swap_result_t = void;
#endif
# 38 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/swap.h" 3

template <class _Tp>
inline _LIBCPP_INLINE_VISIBILITY __swap_result_t<_Tp> _LIBCPP_CONSTEXPR_SINCE_CXX20 swap(_Tp& __x, _Tp& __y)
    _NOEXCEPT_(is_nothrow_move_constructible<_Tp>::value&& is_nothrow_move_assignable<_Tp>::value) {
  _Tp __t(_VSTD::move(__x));
  __x = _VSTD::move(__y);
  __y = _VSTD::move(__t);
}

template <class _Tp, size_t _Np, __enable_if_t<__is_swappable<_Tp>::value, int> >
inline _LIBCPP_INLINE_VISIBILITY _LIBCPP_CONSTEXPR_SINCE_CXX20 void swap(_Tp (&__a)[_Np], _Tp (&__b)[_Np])
    _NOEXCEPT_(__is_nothrow_swappable<_Tp>::value) {
  for (size_t __i = 0; __i != _Np; ++__i) {
    swap(__a[__i], __b[__i]);
  }
}

_LIBCPP_END_NAMESPACE_STD

_LIBCPP_POP_MACROS

#endif // _LIBCPP___UTILITY_SWAP_H
# 60 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/swap.h" 3
#endif /* swap.h expanded by -frewrite-includes */
# 25 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/swappable.h" 2 3
#if 0 /* expanded by -frewrite-includes */
#include <cstddef>
#endif /* expanded by -frewrite-includes */
# 25 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/swappable.h" 3
# 26 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/swappable.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 28 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/swappable.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 29 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/swappable.h" 3
#endif
# 30 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/swappable.h" 3

_LIBCPP_PUSH_MACROS
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* __undef_macros expanded by -frewrite-includes */
#include <__undef_macros>
#else /* __undef_macros expanded by -frewrite-includes */
# 32 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/swappable.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__undef_macros" 1 3
// -*- C++ -*-
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifdef min
#  undef min
#endif
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__undef_macros" 3

#ifdef max
#  undef max
#endif
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__undef_macros" 3

#ifdef refresh
#  undef refresh
#endif
# 21 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__undef_macros" 3

#ifdef move
#  undef move
#endif
# 25 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__undef_macros" 3

#ifdef erase
#  undef erase
#endif
# 29 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__undef_macros" 3
#endif /* __undef_macros expanded by -frewrite-includes */
# 33 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/swappable.h" 2 3

_LIBCPP_BEGIN_NAMESPACE_STD

#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 20
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 37 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/swappable.h" 3

// [concept.swappable]

namespace ranges {
namespace __swap {

template <class _Tp>
void swap(_Tp&, _Tp&) = delete;

// clang-format off
template <class _Tp, class _Up>
concept __unqualified_swappable_with =
    (__class_or_enum<remove_cvref_t<_Tp>> || __class_or_enum<remove_cvref_t<_Up>>) &&
    requires(_Tp&& __t, _Up&& __u) {
        swap(_VSTD::forward<_Tp>(__t), _VSTD::forward<_Up>(__u));
    };
// clang-format on

struct __fn;

// clang-format off
template <class _Tp, class _Up, size_t _Size>
concept __swappable_arrays =
    !__unqualified_swappable_with<_Tp (&)[_Size], _Up (&)[_Size]> &&
    extent_v<_Tp> == extent_v<_Up> &&
    requires(_Tp (&__t)[_Size], _Up (&__u)[_Size], const __fn& __swap) {
        __swap(__t[0], __u[0]);
    };
// clang-format on

template <class _Tp>
concept __exchangeable =
    !__unqualified_swappable_with<_Tp&, _Tp&> && move_constructible<_Tp> && assignable_from<_Tp&, _Tp>;

struct __fn {
  // 2.1   `S` is `(void)swap(E1, E2)`* if `E1` or `E2` has class or enumeration type and...
  // *The name `swap` is used here unqualified.
  template <class _Tp, class _Up>
    requires __unqualified_swappable_with<_Tp, _Up>
  _LIBCPP_HIDE_FROM_ABI constexpr void operator()(_Tp&& __t, _Up&& __u) const
      noexcept(noexcept(swap(_VSTD::forward<_Tp>(__t), _VSTD::forward<_Up>(__u)))) {
    swap(_VSTD::forward<_Tp>(__t), _VSTD::forward<_Up>(__u));
  }

  // 2.2   Otherwise, if `E1` and `E2` are lvalues of array types with equal extent and...
  template <class _Tp, class _Up, size_t _Size>
    requires __swappable_arrays<_Tp, _Up, _Size>
  _LIBCPP_HIDE_FROM_ABI constexpr void operator()(_Tp (&__t)[_Size], _Up (&__u)[_Size]) const
      noexcept(noexcept((*this)(*__t, *__u))) {
    // TODO(cjdb): replace with `ranges::swap_ranges`.
    for (size_t __i = 0; __i < _Size; ++__i) {
      (*this)(__t[__i], __u[__i]);
    }
  }

  // 2.3   Otherwise, if `E1` and `E2` are lvalues of the same type `T` that models...
  template <__exchangeable _Tp>
  _LIBCPP_HIDE_FROM_ABI constexpr void operator()(_Tp& __x, _Tp& __y) const
      noexcept(is_nothrow_move_constructible_v<_Tp> && is_nothrow_move_assignable_v<_Tp>) {
    __y = _VSTD::exchange(__x, _VSTD::move(__y));
  }
};
} // namespace __swap

inline namespace __cpo {
inline constexpr auto swap = __swap::__fn{};
} // namespace __cpo
} // namespace ranges

template <class _Tp>
concept swappable = requires(_Tp& __a, _Tp& __b) { ranges::swap(__a, __b); };

template <class _Tp, class _Up>
concept swappable_with = common_reference_with<_Tp, _Up> && requires(_Tp&& __t, _Up&& __u) {
  ranges::swap(_VSTD::forward<_Tp>(__t), _VSTD::forward<_Tp>(__t));
  ranges::swap(_VSTD::forward<_Up>(__u), _VSTD::forward<_Up>(__u));
  ranges::swap(_VSTD::forward<_Tp>(__t), _VSTD::forward<_Up>(__u));
  ranges::swap(_VSTD::forward<_Up>(__u), _VSTD::forward<_Tp>(__t));
};

#endif // _LIBCPP_STD_VER >= 20
# 118 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/swappable.h" 3

_LIBCPP_END_NAMESPACE_STD

_LIBCPP_POP_MACROS

#endif // _LIBCPP___CONCEPTS_SWAPPABLE_H
# 124 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/swappable.h" 3
#endif /* swappable.h expanded by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/movable.h" 2 3
#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/movable.h" 3
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/movable.h" 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* is_object.h expanded by -frewrite-includes */
#include <__type_traits/is_object.h>
#else /* is_object.h expanded by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/movable.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_object.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___TYPE_TRAITS_IS_OBJECT_H
#define _LIBCPP___TYPE_TRAITS_IS_OBJECT_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_object.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_object.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/integral_constant.h>
#endif /* expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_object.h" 3
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_object.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/is_array.h>
#endif /* expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_object.h" 3
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_object.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/is_class.h>
#endif /* expanded by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_object.h" 3
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_object.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/is_scalar.h>
#endif /* expanded by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_object.h" 3
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_object.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/is_union.h>
#endif /* expanded by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_object.h" 3
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_object.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 20 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_object.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 21 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_object.h" 3
#endif
# 22 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_object.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

#if 0 /* disabled by -frewrite-includes */
#if __has_builtin(__is_object)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 26 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_object.h" 3

template <class _Tp>
struct _LIBCPP_TEMPLATE_VIS is_object : _BoolConstant<__is_object(_Tp)> {};

#if 0 /* disabled by -frewrite-includes */
#  if _LIBCPP_STD_VER >= 17
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 31 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_object.h" 3
template <class _Tp>
inline constexpr bool is_object_v = __is_object(_Tp);
#  endif
# 34 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_object.h" 3

#else // __has_builtin(__is_object)
# 36 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_object.h" 3

template <class _Tp>
struct _LIBCPP_TEMPLATE_VIS is_object
    : public integral_constant<bool,
                               is_scalar<_Tp>::value || is_array<_Tp>::value || is_union<_Tp>::value ||
                                   is_class<_Tp>::value > {};

#if 0 /* disabled by -frewrite-includes */
#  if _LIBCPP_STD_VER >= 17
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 44 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_object.h" 3
template <class _Tp>
inline constexpr bool is_object_v = is_object<_Tp>::value;
#  endif
# 47 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_object.h" 3

#endif // __has_builtin(__is_object)
# 49 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_object.h" 3

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___TYPE_TRAITS_IS_OBJECT_H
# 53 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_object.h" 3
#endif /* is_object.h expanded by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/movable.h" 2 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/movable.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 20 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/movable.h" 3
#endif
# 21 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/movable.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 20
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 25 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/movable.h" 3

// [concepts.object]

template <class _Tp>
concept movable = is_object_v<_Tp> && move_constructible<_Tp> && assignable_from<_Tp&, _Tp> && swappable<_Tp>;

#endif // _LIBCPP_STD_VER >= 20
# 32 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/movable.h" 3

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___CONCEPTS_MOVABLE_H
# 36 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/movable.h" 3
#endif /* movable.h expanded by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/copyable.h" 2 3
#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/copyable.h" 3
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/copyable.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/copyable.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/copyable.h" 3
#endif
# 20 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/copyable.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 20
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 24 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/copyable.h" 3

// [concepts.object]

// clang-format off
template <class _Tp>
concept copyable =
    copy_constructible<_Tp> &&
    movable<_Tp> &&
    assignable_from<_Tp&, _Tp&> &&
    assignable_from<_Tp&, const _Tp&> &&
    assignable_from<_Tp&, const _Tp>;
// clang-format on

#endif // _LIBCPP_STD_VER >= 20
# 38 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/copyable.h" 3

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___CONCEPTS_COPYABLE_H
# 42 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/copyable.h" 3
#endif /* copyable.h expanded by -frewrite-includes */
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/concepts.h" 2 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* derived_from.h expanded by -frewrite-includes */
#include <__concepts/derived_from.h>
#else /* derived_from.h expanded by -frewrite-includes */
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/concepts.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/derived_from.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___CONCEPTS_DERIVED_FROM_H
#define _LIBCPP___CONCEPTS_DERIVED_FROM_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/derived_from.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/derived_from.h" 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* is_base_of.h expanded by -frewrite-includes */
#include <__type_traits/is_base_of.h>
#else /* is_base_of.h expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/derived_from.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_base_of.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___TYPE_TRAITS_IS_BASE_OF_H
#define _LIBCPP___TYPE_TRAITS_IS_BASE_OF_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_base_of.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_base_of.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/integral_constant.h>
#endif /* expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_base_of.h" 3
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_base_of.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_base_of.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_base_of.h" 3
#endif
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_base_of.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

template <class _Bp, class _Dp>
struct _LIBCPP_TEMPLATE_VIS is_base_of : public integral_constant<bool, __is_base_of(_Bp, _Dp)> {};

#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 17
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 25 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_base_of.h" 3
template <class _Bp, class _Dp>
inline constexpr bool is_base_of_v = __is_base_of(_Bp, _Dp);
#endif
# 28 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_base_of.h" 3

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___TYPE_TRAITS_IS_BASE_OF_H
# 32 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_base_of.h" 3
#endif /* is_base_of.h expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/derived_from.h" 2 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/is_convertible.h>
#endif /* expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/derived_from.h" 3
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/derived_from.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/derived_from.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/derived_from.h" 3
#endif
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/derived_from.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 20
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 23 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/derived_from.h" 3

// [concept.derived]

template <class _Dp, class _Bp>
concept derived_from = is_base_of_v<_Bp, _Dp> && is_convertible_v<const volatile _Dp*, const volatile _Bp*>;

#endif // _LIBCPP_STD_VER >= 20
# 30 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/derived_from.h" 3

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___CONCEPTS_DERIVED_FROM_H
# 34 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/derived_from.h" 3
#endif /* derived_from.h expanded by -frewrite-includes */
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/concepts.h" 2 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* equality_comparable.h expanded by -frewrite-includes */
#include <__concepts/equality_comparable.h>
#else /* equality_comparable.h expanded by -frewrite-includes */
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/concepts.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/equality_comparable.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___CONCEPTS_EQUALITY_COMPARABLE_H
#define _LIBCPP___CONCEPTS_EQUALITY_COMPARABLE_H

#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* boolean_testable.h expanded by -frewrite-includes */
#include <__concepts/boolean_testable.h>
#else /* boolean_testable.h expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/equality_comparable.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/boolean_testable.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___CONCEPTS_BOOLEAN_TESTABLE_H
#define _LIBCPP___CONCEPTS_BOOLEAN_TESTABLE_H

#if 0 /* expanded by -frewrite-includes */
#include <__concepts/convertible_to.h>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/boolean_testable.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/boolean_testable.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/boolean_testable.h" 3
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/boolean_testable.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__utility/forward.h>
#endif /* expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/boolean_testable.h" 3
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/boolean_testable.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/boolean_testable.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/boolean_testable.h" 3
#endif
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/boolean_testable.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 20
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 23 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/boolean_testable.h" 3

// [concepts.booleantestable]

template <class _Tp>
concept __boolean_testable_impl = convertible_to<_Tp, bool>;

template <class _Tp>
concept __boolean_testable = __boolean_testable_impl<_Tp> && requires(_Tp&& __t) {
  { !_VSTD::forward<_Tp>(__t) } -> __boolean_testable_impl;
};

#endif // _LIBCPP_STD_VER >= 20
# 35 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/boolean_testable.h" 3

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___CONCEPTS_BOOLEAN_TESTABLE_H
# 39 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/boolean_testable.h" 3
#endif /* boolean_testable.h expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/equality_comparable.h" 2 3
#if 0 /* expanded by -frewrite-includes */
#include <__concepts/common_reference_with.h>
#endif /* expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/equality_comparable.h" 3
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/equality_comparable.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/equality_comparable.h" 3
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/equality_comparable.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/common_reference.h>
#endif /* expanded by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/equality_comparable.h" 3
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/equality_comparable.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/make_const_lvalue_ref.h>
#endif /* expanded by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/equality_comparable.h" 3
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/equality_comparable.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/equality_comparable.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 20 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/equality_comparable.h" 3
#endif
# 21 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/equality_comparable.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 20
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 25 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/equality_comparable.h" 3

// [concept.equalitycomparable]

template <class _Tp, class _Up>
concept __weakly_equality_comparable_with =
    requires(__make_const_lvalue_ref<_Tp> __t, __make_const_lvalue_ref<_Up> __u) {
      { __t == __u } -> __boolean_testable;
      { __t != __u } -> __boolean_testable;
      { __u == __t } -> __boolean_testable;
      { __u != __t } -> __boolean_testable;
    };

template <class _Tp>
concept equality_comparable = __weakly_equality_comparable_with<_Tp, _Tp>;

// clang-format off
template <class _Tp, class _Up>
concept equality_comparable_with =
    equality_comparable<_Tp> && equality_comparable<_Up> &&
    common_reference_with<__make_const_lvalue_ref<_Tp>, __make_const_lvalue_ref<_Up>> &&
    equality_comparable<
        common_reference_t<
            __make_const_lvalue_ref<_Tp>,
            __make_const_lvalue_ref<_Up>>> &&
    __weakly_equality_comparable_with<_Tp, _Up>;
// clang-format on

#endif // _LIBCPP_STD_VER >= 20
# 53 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/equality_comparable.h" 3

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___CONCEPTS_EQUALITY_COMPARABLE_H
# 57 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/equality_comparable.h" 3
#endif /* equality_comparable.h expanded by -frewrite-includes */
# 20 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/concepts.h" 2 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* invocable.h expanded by -frewrite-includes */
#include <__concepts/invocable.h>
#else /* invocable.h expanded by -frewrite-includes */
# 20 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/concepts.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/invocable.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___CONCEPTS_INVOCABLE_H
#define _LIBCPP___CONCEPTS_INVOCABLE_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/invocable.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/invocable.h" 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* invoke.h expanded by -frewrite-includes */
#include <__functional/invoke.h>
#else /* invoke.h expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/invocable.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__functional/invoke.h" 1 3
// -*- C++ -*-
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___FUNCTIONAL_INVOKE_H
#define _LIBCPP___FUNCTIONAL_INVOKE_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__functional/invoke.h" 3
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__functional/invoke.h" 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* invoke.h expanded by -frewrite-includes */
#include <__type_traits/invoke.h>
#else /* invoke.h expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__functional/invoke.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/invoke.h" 1 3
// -*- C++ -*-
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___TYPE_TRAITS_INVOKE_H
#define _LIBCPP___TYPE_TRAITS_INVOKE_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/invoke.h" 3
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/invoke.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/add_lvalue_reference.h>
#endif /* expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/invoke.h" 3
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/invoke.h" 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* apply_cv.h expanded by -frewrite-includes */
#include <__type_traits/apply_cv.h>
#else /* apply_cv.h expanded by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/invoke.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/apply_cv.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___TYPE_TRAITS_APPLY_CV_H
#define _LIBCPP___TYPE_TRAITS_APPLY_CV_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/apply_cv.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/apply_cv.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/is_const.h>
#endif /* expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/apply_cv.h" 3
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/apply_cv.h" 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* is_volatile.h expanded by -frewrite-includes */
#include <__type_traits/is_volatile.h>
#else /* is_volatile.h expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/apply_cv.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_volatile.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___TYPE_TRAITS_IS_VOLATILE_H
#define _LIBCPP___TYPE_TRAITS_IS_VOLATILE_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_volatile.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_volatile.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/integral_constant.h>
#endif /* expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_volatile.h" 3
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_volatile.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_volatile.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_volatile.h" 3
#endif
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_volatile.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

#if 0 /* disabled by -frewrite-includes */
#if __has_builtin(__is_volatile)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 22 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_volatile.h" 3

template <class _Tp>
struct _LIBCPP_TEMPLATE_VIS is_volatile : _BoolConstant<__is_volatile(_Tp)> {};

#if 0 /* disabled by -frewrite-includes */
#  if _LIBCPP_STD_VER >= 17
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 27 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_volatile.h" 3
template <class _Tp>
inline constexpr bool is_volatile_v = __is_volatile(_Tp);
#  endif
# 30 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_volatile.h" 3

#else
# 32 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_volatile.h" 3

template <class _Tp>
struct _LIBCPP_TEMPLATE_VIS is_volatile : public false_type {};
template <class _Tp>
struct _LIBCPP_TEMPLATE_VIS is_volatile<_Tp volatile> : public true_type {};

#if 0 /* disabled by -frewrite-includes */
#  if _LIBCPP_STD_VER >= 17
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 39 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_volatile.h" 3
template <class _Tp>
inline constexpr bool is_volatile_v = is_volatile<_Tp>::value;
#  endif
# 42 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_volatile.h" 3

#endif // __has_builtin(__is_volatile)
# 44 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_volatile.h" 3

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___TYPE_TRAITS_IS_VOLATILE_H
# 48 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_volatile.h" 3
#endif /* is_volatile.h expanded by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/apply_cv.h" 2 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/remove_reference.h>
#endif /* expanded by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/apply_cv.h" 3
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/apply_cv.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/apply_cv.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/apply_cv.h" 3
#endif
# 20 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/apply_cv.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

template <class _Tp,
          bool = is_const<__libcpp_remove_reference_t<_Tp> >::value,
          bool = is_volatile<__libcpp_remove_reference_t<_Tp> >::value>
struct __apply_cv_impl {
  template <class _Up>
  using __apply _LIBCPP_NODEBUG = _Up;
};

template <class _Tp>
struct __apply_cv_impl<_Tp, true, false> {
  template <class _Up>
  using __apply _LIBCPP_NODEBUG = const _Up;
};

template <class _Tp>
struct __apply_cv_impl<_Tp, false, true> {
  template <class _Up>
  using __apply _LIBCPP_NODEBUG = volatile _Up;
};

template <class _Tp>
struct __apply_cv_impl<_Tp, true, true> {
  template <class _Up>
  using __apply _LIBCPP_NODEBUG = const volatile _Up;
};

template <class _Tp>
struct __apply_cv_impl<_Tp&, false, false> {
  template <class _Up>
  using __apply _LIBCPP_NODEBUG = _Up&;
};

template <class _Tp>
struct __apply_cv_impl<_Tp&, true, false> {
  template <class _Up>
  using __apply _LIBCPP_NODEBUG = const _Up&;
};

template <class _Tp>
struct __apply_cv_impl<_Tp&, false, true> {
  template <class _Up>
  using __apply _LIBCPP_NODEBUG = volatile _Up&;
};

template <class _Tp>
struct __apply_cv_impl<_Tp&, true, true> {
  template <class _Up>
  using __apply _LIBCPP_NODEBUG = const volatile _Up&;
};

template <class _Tp, class _Up>
using __apply_cv_t _LIBCPP_NODEBUG = typename __apply_cv_impl<_Tp>::template __apply<_Up>;

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___TYPE_TRAITS_APPLY_CV_H
# 79 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/apply_cv.h" 3
#endif /* apply_cv.h expanded by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/invoke.h" 2 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/conditional.h>
#endif /* expanded by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/invoke.h" 3
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/invoke.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/decay.h>
#endif /* expanded by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/invoke.h" 3
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/invoke.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/enable_if.h>
#endif /* expanded by -frewrite-includes */
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/invoke.h" 3
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/invoke.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/integral_constant.h>
#endif /* expanded by -frewrite-includes */
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/invoke.h" 3
# 20 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/invoke.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/is_base_of.h>
#endif /* expanded by -frewrite-includes */
# 20 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/invoke.h" 3
# 21 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/invoke.h" 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* is_core_convertible.h expanded by -frewrite-includes */
#include <__type_traits/is_core_convertible.h>
#else /* is_core_convertible.h expanded by -frewrite-includes */
# 21 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/invoke.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_core_convertible.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___TYPE_TRAITS_IS_CORE_CONVERTIBLE_H
#define _LIBCPP___TYPE_TRAITS_IS_CORE_CONVERTIBLE_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_core_convertible.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_core_convertible.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/integral_constant.h>
#endif /* expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_core_convertible.h" 3
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_core_convertible.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_core_convertible.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_core_convertible.h" 3
#endif
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_core_convertible.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

// [conv.general]/3 says "E is convertible to T" whenever "T t=E;" is well-formed.
// We can't test for that, but we can test implicit convertibility by passing it
// to a function. Notice that __is_core_convertible<void,void> is false,
// and __is_core_convertible<immovable-type,immovable-type> is true in C++17 and later.

template <class _Tp, class _Up, class = void>
struct __is_core_convertible : public false_type {};

template <class _Tp, class _Up>
struct __is_core_convertible<_Tp, _Up, decltype(static_cast<void (*)(_Up)>(0)(static_cast<_Tp (*)()>(0)()))>
    : public true_type {};

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___TYPE_TRAITS_IS_CORE_CONVERTIBLE_H
# 36 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_core_convertible.h" 3
#endif /* is_core_convertible.h expanded by -frewrite-includes */
# 22 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/invoke.h" 2 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/is_member_function_pointer.h>
#endif /* expanded by -frewrite-includes */
# 22 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/invoke.h" 3
# 23 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/invoke.h" 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* is_member_object_pointer.h expanded by -frewrite-includes */
#include <__type_traits/is_member_object_pointer.h>
#else /* is_member_object_pointer.h expanded by -frewrite-includes */
# 23 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/invoke.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_member_object_pointer.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___TYPE_TRAITS_IS_MEMBER_OBJECT_POINTER_H
#define _LIBCPP___TYPE_TRAITS_IS_MEMBER_OBJECT_POINTER_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_member_object_pointer.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_member_object_pointer.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/integral_constant.h>
#endif /* expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_member_object_pointer.h" 3
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_member_object_pointer.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_member_object_pointer.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_member_object_pointer.h" 3
#endif
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_member_object_pointer.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

#if 0 /* disabled by -frewrite-includes */
#if __has_builtin(__is_member_object_pointer)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 22 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_member_object_pointer.h" 3

template <class _Tp>
struct _LIBCPP_TEMPLATE_VIS is_member_object_pointer : _BoolConstant<__is_member_object_pointer(_Tp)> {};

#if 0 /* disabled by -frewrite-includes */
#  if _LIBCPP_STD_VER >= 17
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 27 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_member_object_pointer.h" 3
template <class _Tp>
inline constexpr bool is_member_object_pointer_v = __is_member_object_pointer(_Tp);
#  endif
# 30 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_member_object_pointer.h" 3

#else // __has_builtin(__is_member_object_pointer)
# 32 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_member_object_pointer.h" 3

template <class _Tp>
struct _LIBCPP_TEMPLATE_VIS is_member_object_pointer
    : public _BoolConstant<__libcpp_is_member_pointer<__remove_cv_t<_Tp> >::__is_obj> {};

#if 0 /* disabled by -frewrite-includes */
#  if _LIBCPP_STD_VER >= 17
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 38 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_member_object_pointer.h" 3
template <class _Tp>
inline constexpr bool is_member_object_pointer_v = is_member_object_pointer<_Tp>::value;
#  endif
# 41 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_member_object_pointer.h" 3

#endif // __has_builtin(__is_member_object_pointer)
# 43 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_member_object_pointer.h" 3

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___TYPE_TRAITS_IS_MEMBER_FUNCTION_POINTER_H
# 47 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_member_object_pointer.h" 3
#endif /* is_member_object_pointer.h expanded by -frewrite-includes */
# 24 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/invoke.h" 2 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* is_reference_wrapper.h expanded by -frewrite-includes */
#include <__type_traits/is_reference_wrapper.h>
#else /* is_reference_wrapper.h expanded by -frewrite-includes */
# 24 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/invoke.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_reference_wrapper.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___TYPE_TRAITS_IS_REFERENCE_WRAPPER_H
#define _LIBCPP___TYPE_TRAITS_IS_REFERENCE_WRAPPER_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_reference_wrapper.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_reference_wrapper.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/integral_constant.h>
#endif /* expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_reference_wrapper.h" 3
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_reference_wrapper.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/remove_cv.h>
#endif /* expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_reference_wrapper.h" 3
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_reference_wrapper.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_reference_wrapper.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_reference_wrapper.h" 3
#endif
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_reference_wrapper.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

template <class _Tp>
class _LIBCPP_TEMPLATE_VIS reference_wrapper;

template <class _Tp>
struct __is_reference_wrapper_impl : public false_type {};
template <class _Tp>
struct __is_reference_wrapper_impl<reference_wrapper<_Tp> > : public true_type {};
template <class _Tp>
struct __is_reference_wrapper : public __is_reference_wrapper_impl<__remove_cv_t<_Tp> > {};

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___TYPE_TRAITS_ENABLE_IF_H
# 35 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_reference_wrapper.h" 3
#endif /* is_reference_wrapper.h expanded by -frewrite-includes */
# 25 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/invoke.h" 2 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/is_same.h>
#endif /* expanded by -frewrite-includes */
# 25 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/invoke.h" 3
# 26 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/invoke.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/is_void.h>
#endif /* expanded by -frewrite-includes */
# 26 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/invoke.h" 3
# 27 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/invoke.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/nat.h>
#endif /* expanded by -frewrite-includes */
# 27 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/invoke.h" 3
# 28 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/invoke.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/remove_cv.h>
#endif /* expanded by -frewrite-includes */
# 28 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/invoke.h" 3
# 29 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/invoke.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__utility/declval.h>
#endif /* expanded by -frewrite-includes */
# 29 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/invoke.h" 3
# 30 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/invoke.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__utility/forward.h>
#endif /* expanded by -frewrite-includes */
# 30 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/invoke.h" 3
# 31 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/invoke.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 33 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/invoke.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 34 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/invoke.h" 3
#endif
# 35 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/invoke.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

struct __any {
  __any(...);
};

template <class _MP, bool _IsMemberFunctionPtr, bool _IsMemberObjectPtr>
struct __member_pointer_traits_imp {};

template <class _Rp, class _Class, class... _Param>
struct __member_pointer_traits_imp<_Rp (_Class::*)(_Param...), true, false> {
  typedef _Class _ClassType;
  typedef _Rp _ReturnType;
  typedef _Rp(_FnType)(_Param...);
};

template <class _Rp, class _Class, class... _Param>
struct __member_pointer_traits_imp<_Rp (_Class::*)(_Param..., ...), true, false> {
  typedef _Class _ClassType;
  typedef _Rp _ReturnType;
  typedef _Rp(_FnType)(_Param..., ...);
};

template <class _Rp, class _Class, class... _Param>
struct __member_pointer_traits_imp<_Rp (_Class::*)(_Param...) const, true, false> {
  typedef _Class const _ClassType;
  typedef _Rp _ReturnType;
  typedef _Rp(_FnType)(_Param...);
};

template <class _Rp, class _Class, class... _Param>
struct __member_pointer_traits_imp<_Rp (_Class::*)(_Param..., ...) const, true, false> {
  typedef _Class const _ClassType;
  typedef _Rp _ReturnType;
  typedef _Rp(_FnType)(_Param..., ...);
};

template <class _Rp, class _Class, class... _Param>
struct __member_pointer_traits_imp<_Rp (_Class::*)(_Param...) volatile, true, false> {
  typedef _Class volatile _ClassType;
  typedef _Rp _ReturnType;
  typedef _Rp(_FnType)(_Param...);
};

template <class _Rp, class _Class, class... _Param>
struct __member_pointer_traits_imp<_Rp (_Class::*)(_Param..., ...) volatile, true, false> {
  typedef _Class volatile _ClassType;
  typedef _Rp _ReturnType;
  typedef _Rp(_FnType)(_Param..., ...);
};

template <class _Rp, class _Class, class... _Param>
struct __member_pointer_traits_imp<_Rp (_Class::*)(_Param...) const volatile, true, false> {
  typedef _Class const volatile _ClassType;
  typedef _Rp _ReturnType;
  typedef _Rp(_FnType)(_Param...);
};

template <class _Rp, class _Class, class... _Param>
struct __member_pointer_traits_imp<_Rp (_Class::*)(_Param..., ...) const volatile, true, false> {
  typedef _Class const volatile _ClassType;
  typedef _Rp _ReturnType;
  typedef _Rp(_FnType)(_Param..., ...);
};

template <class _Rp, class _Class, class... _Param>
struct __member_pointer_traits_imp<_Rp (_Class::*)(_Param...)&, true, false> {
  typedef _Class& _ClassType;
  typedef _Rp _ReturnType;
  typedef _Rp(_FnType)(_Param...);
};

template <class _Rp, class _Class, class... _Param>
struct __member_pointer_traits_imp<_Rp (_Class::*)(_Param..., ...)&, true, false> {
  typedef _Class& _ClassType;
  typedef _Rp _ReturnType;
  typedef _Rp(_FnType)(_Param..., ...);
};

template <class _Rp, class _Class, class... _Param>
struct __member_pointer_traits_imp<_Rp (_Class::*)(_Param...) const&, true, false> {
  typedef _Class const& _ClassType;
  typedef _Rp _ReturnType;
  typedef _Rp(_FnType)(_Param...);
};

template <class _Rp, class _Class, class... _Param>
struct __member_pointer_traits_imp<_Rp (_Class::*)(_Param..., ...) const&, true, false> {
  typedef _Class const& _ClassType;
  typedef _Rp _ReturnType;
  typedef _Rp(_FnType)(_Param..., ...);
};

template <class _Rp, class _Class, class... _Param>
struct __member_pointer_traits_imp<_Rp (_Class::*)(_Param...) volatile&, true, false> {
  typedef _Class volatile& _ClassType;
  typedef _Rp _ReturnType;
  typedef _Rp(_FnType)(_Param...);
};

template <class _Rp, class _Class, class... _Param>
struct __member_pointer_traits_imp<_Rp (_Class::*)(_Param..., ...) volatile&, true, false> {
  typedef _Class volatile& _ClassType;
  typedef _Rp _ReturnType;
  typedef _Rp(_FnType)(_Param..., ...);
};

template <class _Rp, class _Class, class... _Param>
struct __member_pointer_traits_imp<_Rp (_Class::*)(_Param...) const volatile&, true, false> {
  typedef _Class const volatile& _ClassType;
  typedef _Rp _ReturnType;
  typedef _Rp(_FnType)(_Param...);
};

template <class _Rp, class _Class, class... _Param>
struct __member_pointer_traits_imp<_Rp (_Class::*)(_Param..., ...) const volatile&, true, false> {
  typedef _Class const volatile& _ClassType;
  typedef _Rp _ReturnType;
  typedef _Rp(_FnType)(_Param..., ...);
};

template <class _Rp, class _Class, class... _Param>
struct __member_pointer_traits_imp<_Rp (_Class::*)(_Param...)&&, true, false> {
  typedef _Class&& _ClassType;
  typedef _Rp _ReturnType;
  typedef _Rp(_FnType)(_Param...);
};

template <class _Rp, class _Class, class... _Param>
struct __member_pointer_traits_imp<_Rp (_Class::*)(_Param..., ...)&&, true, false> {
  typedef _Class&& _ClassType;
  typedef _Rp _ReturnType;
  typedef _Rp(_FnType)(_Param..., ...);
};

template <class _Rp, class _Class, class... _Param>
struct __member_pointer_traits_imp<_Rp (_Class::*)(_Param...) const&&, true, false> {
  typedef _Class const&& _ClassType;
  typedef _Rp _ReturnType;
  typedef _Rp(_FnType)(_Param...);
};

template <class _Rp, class _Class, class... _Param>
struct __member_pointer_traits_imp<_Rp (_Class::*)(_Param..., ...) const&&, true, false> {
  typedef _Class const&& _ClassType;
  typedef _Rp _ReturnType;
  typedef _Rp(_FnType)(_Param..., ...);
};

template <class _Rp, class _Class, class... _Param>
struct __member_pointer_traits_imp<_Rp (_Class::*)(_Param...) volatile&&, true, false> {
  typedef _Class volatile&& _ClassType;
  typedef _Rp _ReturnType;
  typedef _Rp(_FnType)(_Param...);
};

template <class _Rp, class _Class, class... _Param>
struct __member_pointer_traits_imp<_Rp (_Class::*)(_Param..., ...) volatile&&, true, false> {
  typedef _Class volatile&& _ClassType;
  typedef _Rp _ReturnType;
  typedef _Rp(_FnType)(_Param..., ...);
};

template <class _Rp, class _Class, class... _Param>
struct __member_pointer_traits_imp<_Rp (_Class::*)(_Param...) const volatile&&, true, false> {
  typedef _Class const volatile&& _ClassType;
  typedef _Rp _ReturnType;
  typedef _Rp(_FnType)(_Param...);
};

template <class _Rp, class _Class, class... _Param>
struct __member_pointer_traits_imp<_Rp (_Class::*)(_Param..., ...) const volatile&&, true, false> {
  typedef _Class const volatile&& _ClassType;
  typedef _Rp _ReturnType;
  typedef _Rp(_FnType)(_Param..., ...);
};

template <class _Rp, class _Class>
struct __member_pointer_traits_imp<_Rp _Class::*, false, true> {
  typedef _Class _ClassType;
  typedef _Rp _ReturnType;
};

template <class _MP>
struct __member_pointer_traits
    : public __member_pointer_traits_imp<__remove_cv_t<_MP>,
                                         is_member_function_pointer<_MP>::value,
                                         is_member_object_pointer<_MP>::value> {
  //     typedef ... _ClassType;
  //     typedef ... _ReturnType;
  //     typedef ... _FnType;
};

template <class _DecayedFp>
struct __member_pointer_class_type {};

template <class _Ret, class _ClassType>
struct __member_pointer_class_type<_Ret _ClassType::*> {
  typedef _ClassType type;
};

template <class _Fp,
          class _A0,
          class _DecayFp = __decay_t<_Fp>,
          class _DecayA0 = __decay_t<_A0>,
          class _ClassT  = typename __member_pointer_class_type<_DecayFp>::type>
using __enable_if_bullet1 =
    __enable_if_t<is_member_function_pointer<_DecayFp>::value &&
                  (is_same<_ClassT, _DecayA0>::value || is_base_of<_ClassT, _DecayA0>::value)>;

template <class _Fp, class _A0, class _DecayFp = __decay_t<_Fp>, class _DecayA0 = __decay_t<_A0> >
using __enable_if_bullet2 =
    __enable_if_t<is_member_function_pointer<_DecayFp>::value && __is_reference_wrapper<_DecayA0>::value>;

template <class _Fp,
          class _A0,
          class _DecayFp = __decay_t<_Fp>,
          class _DecayA0 = __decay_t<_A0>,
          class _ClassT  = typename __member_pointer_class_type<_DecayFp>::type>
using __enable_if_bullet3 =
    __enable_if_t<is_member_function_pointer<_DecayFp>::value &&
                  !(is_same<_ClassT, _DecayA0>::value || is_base_of<_ClassT, _DecayA0>::value) &&
                  !__is_reference_wrapper<_DecayA0>::value>;

template <class _Fp,
          class _A0,
          class _DecayFp = __decay_t<_Fp>,
          class _DecayA0 = __decay_t<_A0>,
          class _ClassT  = typename __member_pointer_class_type<_DecayFp>::type>
using __enable_if_bullet4 =
    __enable_if_t<is_member_object_pointer<_DecayFp>::value &&
                  (is_same<_ClassT, _DecayA0>::value || is_base_of<_ClassT, _DecayA0>::value)>;

template <class _Fp, class _A0, class _DecayFp = __decay_t<_Fp>, class _DecayA0 = __decay_t<_A0> >
using __enable_if_bullet5 =
    __enable_if_t<is_member_object_pointer<_DecayFp>::value && __is_reference_wrapper<_DecayA0>::value>;

template <class _Fp,
          class _A0,
          class _DecayFp = __decay_t<_Fp>,
          class _DecayA0 = __decay_t<_A0>,
          class _ClassT  = typename __member_pointer_class_type<_DecayFp>::type>
using __enable_if_bullet6 =
    __enable_if_t<is_member_object_pointer<_DecayFp>::value &&
                  !(is_same<_ClassT, _DecayA0>::value || is_base_of<_ClassT, _DecayA0>::value) &&
                  !__is_reference_wrapper<_DecayA0>::value>;

// __invoke forward declarations

// fall back - none of the bullets

template <class... _Args>
__nat __invoke(__any, _Args&&... __args);

// bullets 1, 2 and 3

// clang-format off
template <class _Fp, class _A0, class... _Args, class = __enable_if_bullet1<_Fp, _A0> >
inline _LIBCPP_INLINE_VISIBILITY _LIBCPP_CONSTEXPR
decltype((std::declval<_A0>().*std::declval<_Fp>())(std::declval<_Args>()...))
__invoke(_Fp&& __f, _A0&& __a0, _Args&&... __args)
    _NOEXCEPT_(noexcept((static_cast<_A0&&>(__a0).*__f)(static_cast<_Args&&>(__args)...)))
               { return (static_cast<_A0&&>(__a0).*__f)(static_cast<_Args&&>(__args)...); }

template <class _Fp, class _A0, class... _Args, class = __enable_if_bullet2<_Fp, _A0> >
inline _LIBCPP_INLINE_VISIBILITY _LIBCPP_CONSTEXPR
decltype((std::declval<_A0>().get().*std::declval<_Fp>())(std::declval<_Args>()...))
__invoke(_Fp&& __f, _A0&& __a0, _Args&&... __args)
    _NOEXCEPT_(noexcept((__a0.get().*__f)(static_cast<_Args&&>(__args)...)))
               { return (__a0.get().*__f)(static_cast<_Args&&>(__args)...); }

template <class _Fp, class _A0, class... _Args, class = __enable_if_bullet3<_Fp, _A0> >
inline _LIBCPP_INLINE_VISIBILITY _LIBCPP_CONSTEXPR
decltype(((*std::declval<_A0>()).*std::declval<_Fp>())(std::declval<_Args>()...))
__invoke(_Fp&& __f, _A0&& __a0, _Args&&... __args)
    _NOEXCEPT_(noexcept(((*static_cast<_A0&&>(__a0)).*__f)(static_cast<_Args&&>(__args)...)))
               { return ((*static_cast<_A0&&>(__a0)).*__f)(static_cast<_Args&&>(__args)...); }

// bullets 4, 5 and 6

template <class _Fp, class _A0, class = __enable_if_bullet4<_Fp, _A0> >
inline _LIBCPP_INLINE_VISIBILITY _LIBCPP_CONSTEXPR
decltype(std::declval<_A0>().*std::declval<_Fp>())
__invoke(_Fp&& __f, _A0&& __a0)
    _NOEXCEPT_(noexcept(static_cast<_A0&&>(__a0).*__f))
               { return static_cast<_A0&&>(__a0).*__f; }

template <class _Fp, class _A0, class = __enable_if_bullet5<_Fp, _A0> >
inline _LIBCPP_INLINE_VISIBILITY _LIBCPP_CONSTEXPR
decltype(std::declval<_A0>().get().*std::declval<_Fp>())
__invoke(_Fp&& __f, _A0&& __a0)
    _NOEXCEPT_(noexcept(__a0.get().*__f))
               { return __a0.get().*__f; }

template <class _Fp, class _A0, class = __enable_if_bullet6<_Fp, _A0> >
inline _LIBCPP_INLINE_VISIBILITY _LIBCPP_CONSTEXPR
decltype((*std::declval<_A0>()).*std::declval<_Fp>())
__invoke(_Fp&& __f, _A0&& __a0)
    _NOEXCEPT_(noexcept((*static_cast<_A0&&>(__a0)).*__f))
               { return (*static_cast<_A0&&>(__a0)).*__f; }

// bullet 7

template <class _Fp, class... _Args>
inline _LIBCPP_INLINE_VISIBILITY _LIBCPP_CONSTEXPR
decltype(std::declval<_Fp>()(std::declval<_Args>()...))
__invoke(_Fp&& __f, _Args&&... __args)
    _NOEXCEPT_(noexcept(static_cast<_Fp&&>(__f)(static_cast<_Args&&>(__args)...)))
               { return static_cast<_Fp&&>(__f)(static_cast<_Args&&>(__args)...); }
// clang-format on

// __invokable
template <class _Ret, class _Fp, class... _Args>
struct __invokable_r {
  template <class _XFp, class... _XArgs>
  static decltype(std::__invoke(std::declval<_XFp>(), std::declval<_XArgs>()...)) __try_call(int);
  template <class _XFp, class... _XArgs>
  static __nat __try_call(...);

  // FIXME: Check that _Ret, _Fp, and _Args... are all complete types, cv void,
  // or incomplete array types as required by the standard.
  using _Result = decltype(__try_call<_Fp, _Args...>(0));

  using type              = __conditional_t<_IsNotSame<_Result, __nat>::value,
                               __conditional_t<is_void<_Ret>::value, true_type, __is_core_convertible<_Result, _Ret> >,
                               false_type>;
  static const bool value = type::value;
};
template <class _Fp, class... _Args>
using __invokable = __invokable_r<void, _Fp, _Args...>;

template <bool _IsInvokable, bool _IsCVVoid, class _Ret, class _Fp, class... _Args>
struct __nothrow_invokable_r_imp {
  static const bool value = false;
};

template <class _Ret, class _Fp, class... _Args>
struct __nothrow_invokable_r_imp<true, false, _Ret, _Fp, _Args...> {
  typedef __nothrow_invokable_r_imp _ThisT;

  template <class _Tp>
  static void __test_noexcept(_Tp) _NOEXCEPT;

#ifdef _LIBCPP_CXX03_LANG
  static const bool value = false;
#else
# 382 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/invoke.h" 3
  static const bool value =
      noexcept(_ThisT::__test_noexcept<_Ret>(_VSTD::__invoke(std::declval<_Fp>(), std::declval<_Args>()...)));
#endif
# 385 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/invoke.h" 3
};

template <class _Ret, class _Fp, class... _Args>
struct __nothrow_invokable_r_imp<true, true, _Ret, _Fp, _Args...> {
#ifdef _LIBCPP_CXX03_LANG
  static const bool value = false;
#else
# 392 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/invoke.h" 3
  static const bool value = noexcept(_VSTD::__invoke(std::declval<_Fp>(), std::declval<_Args>()...));
#endif
# 394 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/invoke.h" 3
};

template <class _Ret, class _Fp, class... _Args>
using __nothrow_invokable_r =
    __nothrow_invokable_r_imp<__invokable_r<_Ret, _Fp, _Args...>::value, is_void<_Ret>::value, _Ret, _Fp, _Args...>;

template <class _Fp, class... _Args>
using __nothrow_invokable = __nothrow_invokable_r_imp<__invokable<_Fp, _Args...>::value, true, void, _Fp, _Args...>;

template <class _Fp, class... _Args>
struct __invoke_of
    : public enable_if<__invokable<_Fp, _Args...>::value, typename __invokable_r<void, _Fp, _Args...>::_Result> {};

template <class _Ret, bool = is_void<_Ret>::value>
struct __invoke_void_return_wrapper {
  template <class... _Args>
  _LIBCPP_HIDE_FROM_ABI _LIBCPP_CONSTEXPR_SINCE_CXX20 static _Ret __call(_Args&&... __args) {
    return std::__invoke(std::forward<_Args>(__args)...);
  }
};

template <class _Ret>
struct __invoke_void_return_wrapper<_Ret, true> {
  template <class... _Args>
  _LIBCPP_HIDE_FROM_ABI _LIBCPP_CONSTEXPR_SINCE_CXX20 static void __call(_Args&&... __args) {
    std::__invoke(std::forward<_Args>(__args)...);
  }
};

#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 17
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 424 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/invoke.h" 3

// is_invocable

template <class _Fn, class... _Args>
struct _LIBCPP_TEMPLATE_VIS is_invocable : integral_constant<bool, __invokable<_Fn, _Args...>::value> {};

template <class _Ret, class _Fn, class... _Args>
struct _LIBCPP_TEMPLATE_VIS is_invocable_r : integral_constant<bool, __invokable_r<_Ret, _Fn, _Args...>::value> {};

template <class _Fn, class... _Args>
inline constexpr bool is_invocable_v = is_invocable<_Fn, _Args...>::value;

template <class _Ret, class _Fn, class... _Args>
inline constexpr bool is_invocable_r_v = is_invocable_r<_Ret, _Fn, _Args...>::value;

// is_nothrow_invocable

template <class _Fn, class... _Args>
struct _LIBCPP_TEMPLATE_VIS is_nothrow_invocable : integral_constant<bool, __nothrow_invokable<_Fn, _Args...>::value> {
};

template <class _Ret, class _Fn, class... _Args>
struct _LIBCPP_TEMPLATE_VIS is_nothrow_invocable_r
    : integral_constant<bool, __nothrow_invokable_r<_Ret, _Fn, _Args...>::value> {};

template <class _Fn, class... _Args>
inline constexpr bool is_nothrow_invocable_v = is_nothrow_invocable<_Fn, _Args...>::value;

template <class _Ret, class _Fn, class... _Args>
inline constexpr bool is_nothrow_invocable_r_v = is_nothrow_invocable_r<_Ret, _Fn, _Args...>::value;

template <class _Fn, class... _Args>
struct _LIBCPP_TEMPLATE_VIS invoke_result : __invoke_of<_Fn, _Args...> {};

template <class _Fn, class... _Args>
using invoke_result_t = typename invoke_result<_Fn, _Args...>::type;

#endif // _LIBCPP_STD_VER >= 17
# 462 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/invoke.h" 3

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___TYPE_TRAITS_INVOKE_H
# 466 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/invoke.h" 3
#endif /* invoke.h expanded by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__functional/invoke.h" 2 3
#if 0 /* expanded by -frewrite-includes */
#include <__utility/forward.h>
#endif /* expanded by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__functional/invoke.h" 3
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__functional/invoke.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__functional/invoke.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__functional/invoke.h" 3
#endif
# 20 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__functional/invoke.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 17
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 24 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__functional/invoke.h" 3

template <class _Fn, class ..._Args>
_LIBCPP_HIDE_FROM_ABI _LIBCPP_CONSTEXPR_SINCE_CXX20 invoke_result_t<_Fn, _Args...>
invoke(_Fn&& __f, _Args&&... __args)
    noexcept(is_nothrow_invocable_v<_Fn, _Args...>)
{
    return _VSTD::__invoke(_VSTD::forward<_Fn>(__f), _VSTD::forward<_Args>(__args)...);
}

#endif // _LIBCPP_STD_VER >= 17
# 34 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__functional/invoke.h" 3

#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 23
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 36 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__functional/invoke.h" 3
template <class _Result, class _Fn, class... _Args>
  requires is_invocable_r_v<_Result, _Fn, _Args...>
_LIBCPP_HIDE_FROM_ABI constexpr _Result
invoke_r(_Fn&& __f, _Args&&... __args) noexcept(is_nothrow_invocable_r_v<_Result, _Fn, _Args...>) {
    if constexpr (is_void_v<_Result>) {
        static_cast<void>(std::invoke(std::forward<_Fn>(__f), std::forward<_Args>(__args)...));
    } else {
        // TODO: Use reference_converts_from_temporary_v once implemented
        // using _ImplicitInvokeResult = invoke_result_t<_Fn, _Args...>;
        // static_assert(!reference_converts_from_temporary_v<_Result, _ImplicitInvokeResult>,
        static_assert(true,
            "Returning from invoke_r would bind a temporary object to the reference return type, "
            "which would result in a dangling reference.");
        return std::invoke(std::forward<_Fn>(__f), std::forward<_Args>(__args)...);
    }
}
#endif
# 53 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__functional/invoke.h" 3

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___FUNCTIONAL_INVOKE_H
# 57 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__functional/invoke.h" 3
#endif /* invoke.h expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/invocable.h" 2 3
#if 0 /* expanded by -frewrite-includes */
#include <__utility/forward.h>
#endif /* expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/invocable.h" 3
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/invocable.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/invocable.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/invocable.h" 3
#endif
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/invocable.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 20
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 23 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/invocable.h" 3

// [concept.invocable]

template <class _Fn, class... _Args>
concept invocable = requires(_Fn&& __fn, _Args&&... __args) {
  _VSTD::invoke(_VSTD::forward<_Fn>(__fn), _VSTD::forward<_Args>(__args)...); // not required to be equality preserving
};

// [concept.regular.invocable]

template <class _Fn, class... _Args>
concept regular_invocable = invocable<_Fn, _Args...>;

#endif // _LIBCPP_STD_VER >= 20
# 37 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/invocable.h" 3

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___CONCEPTS_INVOCABLE_H
# 41 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/invocable.h" 3
#endif /* invocable.h expanded by -frewrite-includes */
# 21 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/concepts.h" 2 3
#if 0 /* expanded by -frewrite-includes */
#include <__concepts/movable.h>
#endif /* expanded by -frewrite-includes */
# 21 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/concepts.h" 3
# 22 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/concepts.h" 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* predicate.h expanded by -frewrite-includes */
#include <__concepts/predicate.h>
#else /* predicate.h expanded by -frewrite-includes */
# 22 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/concepts.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/predicate.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___CONCEPTS_PREDICATE_H
#define _LIBCPP___CONCEPTS_PREDICATE_H

#if 0 /* expanded by -frewrite-includes */
#include <__concepts/boolean_testable.h>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/predicate.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/predicate.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__concepts/invocable.h>
#endif /* expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/predicate.h" 3
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/predicate.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/predicate.h" 3
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/predicate.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__functional/invoke.h>
#endif /* expanded by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/predicate.h" 3
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/predicate.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/predicate.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/predicate.h" 3
#endif
# 20 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/predicate.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 20
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 24 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/predicate.h" 3

// [concept.predicate]

template <class _Fn, class... _Args>
concept predicate = regular_invocable<_Fn, _Args...> && __boolean_testable<invoke_result_t<_Fn, _Args...>>;

#endif // _LIBCPP_STD_VER >= 20
# 31 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/predicate.h" 3

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___CONCEPTS_PREDICATE_H
# 35 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/predicate.h" 3
#endif /* predicate.h expanded by -frewrite-includes */
# 23 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/concepts.h" 2 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* regular.h expanded by -frewrite-includes */
#include <__concepts/regular.h>
#else /* regular.h expanded by -frewrite-includes */
# 23 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/concepts.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/regular.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___CONCEPTS_REGULAR_H
#define _LIBCPP___CONCEPTS_REGULAR_H

#if 0 /* expanded by -frewrite-includes */
#include <__concepts/equality_comparable.h>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/regular.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/regular.h" 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* semiregular.h expanded by -frewrite-includes */
#include <__concepts/semiregular.h>
#else /* semiregular.h expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/regular.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/semiregular.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___CONCEPTS_SEMIREGULAR_H
#define _LIBCPP___CONCEPTS_SEMIREGULAR_H

#if 0 /* expanded by -frewrite-includes */
#include <__concepts/constructible.h>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/semiregular.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/semiregular.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__concepts/copyable.h>
#endif /* expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/semiregular.h" 3
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/semiregular.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/semiregular.h" 3
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/semiregular.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/semiregular.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/semiregular.h" 3
#endif
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/semiregular.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 20
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 23 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/semiregular.h" 3

// [concept.object]

template <class _Tp>
concept semiregular = copyable<_Tp> && default_initializable<_Tp>;

#endif // _LIBCPP_STD_VER >= 20
# 30 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/semiregular.h" 3

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___CONCEPTS_SEMIREGULAR_H
# 34 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/semiregular.h" 3
#endif /* semiregular.h expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/regular.h" 2 3
#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/regular.h" 3
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/regular.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/regular.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/regular.h" 3
#endif
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/regular.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 20
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 23 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/regular.h" 3

// [concept.object]

template <class _Tp>
concept regular = semiregular<_Tp> && equality_comparable<_Tp>;

#endif // _LIBCPP_STD_VER >= 20
# 30 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/regular.h" 3

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___CONCEPTS_REGULAR_H
# 34 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/regular.h" 3
#endif /* regular.h expanded by -frewrite-includes */
# 24 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/concepts.h" 2 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* relation.h expanded by -frewrite-includes */
#include <__concepts/relation.h>
#else /* relation.h expanded by -frewrite-includes */
# 24 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/concepts.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/relation.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___CONCEPTS_RELATION_H
#define _LIBCPP___CONCEPTS_RELATION_H

#if 0 /* expanded by -frewrite-includes */
#include <__concepts/predicate.h>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/relation.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/relation.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/relation.h" 3
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/relation.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/relation.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/relation.h" 3
#endif
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/relation.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 20
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 22 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/relation.h" 3

// [concept.relation]

template <class _Rp, class _Tp, class _Up>
concept relation =
    predicate<_Rp, _Tp, _Tp> && predicate<_Rp, _Up, _Up> && predicate<_Rp, _Tp, _Up> && predicate<_Rp, _Up, _Tp>;

// [concept.equiv]

template <class _Rp, class _Tp, class _Up>
concept equivalence_relation = relation<_Rp, _Tp, _Up>;

// [concept.strictweakorder]

template <class _Rp, class _Tp, class _Up>
concept strict_weak_order = relation<_Rp, _Tp, _Up>;

#endif // _LIBCPP_STD_VER >= 20
# 40 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/relation.h" 3

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___CONCEPTS_RELATION_H
# 44 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/relation.h" 3
#endif /* relation.h expanded by -frewrite-includes */
# 25 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/concepts.h" 2 3
#if 0 /* expanded by -frewrite-includes */
#include <__concepts/same_as.h>
#endif /* expanded by -frewrite-includes */
# 25 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/concepts.h" 3
# 26 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/concepts.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__concepts/semiregular.h>
#endif /* expanded by -frewrite-includes */
# 26 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/concepts.h" 3
# 27 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/concepts.h" 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* totally_ordered.h expanded by -frewrite-includes */
#include <__concepts/totally_ordered.h>
#else /* totally_ordered.h expanded by -frewrite-includes */
# 27 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/concepts.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/totally_ordered.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___CONCEPTS_TOTALLY_ORDERED_H
#define _LIBCPP___CONCEPTS_TOTALLY_ORDERED_H

#if 0 /* expanded by -frewrite-includes */
#include <__concepts/boolean_testable.h>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/totally_ordered.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/totally_ordered.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__concepts/equality_comparable.h>
#endif /* expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/totally_ordered.h" 3
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/totally_ordered.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/totally_ordered.h" 3
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/totally_ordered.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/common_reference.h>
#endif /* expanded by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/totally_ordered.h" 3
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/totally_ordered.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/make_const_lvalue_ref.h>
#endif /* expanded by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/totally_ordered.h" 3
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/totally_ordered.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/totally_ordered.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 20 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/totally_ordered.h" 3
#endif
# 21 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/totally_ordered.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 20
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 25 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/totally_ordered.h" 3

// [concept.totallyordered]

template <class _Tp, class _Up>
concept __partially_ordered_with = requires(__make_const_lvalue_ref<_Tp> __t, __make_const_lvalue_ref<_Up> __u) {
  { __t < __u } -> __boolean_testable;
  { __t > __u } -> __boolean_testable;
  { __t <= __u } -> __boolean_testable;
  { __t >= __u } -> __boolean_testable;
  { __u < __t } -> __boolean_testable;
  { __u > __t } -> __boolean_testable;
  { __u <= __t } -> __boolean_testable;
  { __u >= __t } -> __boolean_testable;
};

template <class _Tp>
concept totally_ordered = equality_comparable<_Tp> && __partially_ordered_with<_Tp, _Tp>;

// clang-format off
template <class _Tp, class _Up>
concept totally_ordered_with =
    totally_ordered<_Tp> && totally_ordered<_Up> &&
    equality_comparable_with<_Tp, _Up> &&
    totally_ordered<
        common_reference_t<
            __make_const_lvalue_ref<_Tp>,
            __make_const_lvalue_ref<_Up>>> &&
    __partially_ordered_with<_Tp, _Up>;
// clang-format on

#endif // _LIBCPP_STD_VER >= 20
# 56 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/totally_ordered.h" 3

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___CONCEPTS_TOTALLY_ORDERED_H
# 60 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__concepts/totally_ordered.h" 3
#endif /* totally_ordered.h expanded by -frewrite-includes */
# 28 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/concepts.h" 2 3
#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 28 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/concepts.h" 3
# 29 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/concepts.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__functional/invoke.h>
#endif /* expanded by -frewrite-includes */
# 29 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/concepts.h" 3
# 30 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/concepts.h" 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* incrementable_traits.h expanded by -frewrite-includes */
#include <__iterator/incrementable_traits.h>
#else /* incrementable_traits.h expanded by -frewrite-includes */
# 30 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/concepts.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/incrementable_traits.h" 1 3
// -*- C++ -*-
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___ITERATOR_INCREMENTABLE_TRAITS_H
#define _LIBCPP___ITERATOR_INCREMENTABLE_TRAITS_H

#if 0 /* expanded by -frewrite-includes */
#include <__concepts/arithmetic.h>
#endif /* expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/incrementable_traits.h" 3
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/incrementable_traits.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/incrementable_traits.h" 3
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/incrementable_traits.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/conditional.h>
#endif /* expanded by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/incrementable_traits.h" 3
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/incrementable_traits.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/is_object.h>
#endif /* expanded by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/incrementable_traits.h" 3
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/incrementable_traits.h" 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* is_primary_template.h expanded by -frewrite-includes */
#include <__type_traits/is_primary_template.h>
#else /* is_primary_template.h expanded by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/incrementable_traits.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_primary_template.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___TYPE_TRAITS_IS_PRIMARY_TEMPLATE_H
#define _LIBCPP___TYPE_TRAITS_IS_PRIMARY_TEMPLATE_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_primary_template.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_primary_template.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/enable_if.h>
#endif /* expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_primary_template.h" 3
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_primary_template.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/is_same.h>
#endif /* expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_primary_template.h" 3
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_primary_template.h" 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* is_valid_expansion.h expanded by -frewrite-includes */
#include <__type_traits/is_valid_expansion.h>
#else /* is_valid_expansion.h expanded by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_primary_template.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_valid_expansion.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___TYPE_TRAITS_IS_VALID_EXPANSION_H
#define _LIBCPP___TYPE_TRAITS_IS_VALID_EXPANSION_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_valid_expansion.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_valid_expansion.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/integral_constant.h>
#endif /* expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_valid_expansion.h" 3
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_valid_expansion.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_valid_expansion.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_valid_expansion.h" 3
#endif
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_valid_expansion.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

template <template <class...> class _Templ, class... _Args, class = _Templ<_Args...> >
true_type __sfinae_test_impl(int);
template <template <class...> class, class...>
false_type __sfinae_test_impl(...);

template <template <class...> class _Templ, class... _Args>
using _IsValidExpansion _LIBCPP_NODEBUG = decltype(std::__sfinae_test_impl<_Templ, _Args...>(0));

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___TYPE_TRAITS_IS_VALID_EXPANSION_H
# 32 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_valid_expansion.h" 3
#endif /* is_valid_expansion.h expanded by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_primary_template.h" 2 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_primary_template.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_primary_template.h" 3
#endif
# 20 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_primary_template.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

template <class _Tp>
using __test_for_primary_template = __enable_if_t<_IsSame<_Tp, typename _Tp::__primary_template>::value>;

template <class _Tp>
using __is_primary_template = _IsValidExpansion<__test_for_primary_template, _Tp>;

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___TYPE_TRAITS_IS_PRIMARY_TEMPLATE_H
# 32 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_primary_template.h" 3
#endif /* is_primary_template.h expanded by -frewrite-includes */
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/incrementable_traits.h" 2 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* make_signed.h expanded by -frewrite-includes */
#include <__type_traits/make_signed.h>
#else /* make_signed.h expanded by -frewrite-includes */
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/incrementable_traits.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/make_signed.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___TYPE_TRAITS_MAKE_SIGNED_H
#define _LIBCPP___TYPE_TRAITS_MAKE_SIGNED_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/make_signed.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/make_signed.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/apply_cv.h>
#endif /* expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/make_signed.h" 3
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/make_signed.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/is_enum.h>
#endif /* expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/make_signed.h" 3
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/make_signed.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/is_integral.h>
#endif /* expanded by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/make_signed.h" 3
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/make_signed.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/nat.h>
#endif /* expanded by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/make_signed.h" 3
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/make_signed.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/remove_cv.h>
#endif /* expanded by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/make_signed.h" 3
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/make_signed.h" 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* type_list.h expanded by -frewrite-includes */
#include <__type_traits/type_list.h>
#else /* type_list.h expanded by -frewrite-includes */
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/make_signed.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/type_list.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___TYPE_TRAITS_TYPE_LIST_H
#define _LIBCPP___TYPE_TRAITS_TYPE_LIST_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/type_list.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/type_list.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <cstddef>
#endif /* expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/type_list.h" 3
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/type_list.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/type_list.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/type_list.h" 3
#endif
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/type_list.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

template <class _Hp, class _Tp>
struct __type_list {
  typedef _Hp _Head;
  typedef _Tp _Tail;
};

template <class _TypeList, size_t _Size, bool = _Size <= sizeof(typename _TypeList::_Head)>
struct __find_first;

template <class _Hp, class _Tp, size_t _Size>
struct __find_first<__type_list<_Hp, _Tp>, _Size, true> {
  typedef _LIBCPP_NODEBUG _Hp type;
};

template <class _Hp, class _Tp, size_t _Size>
struct __find_first<__type_list<_Hp, _Tp>, _Size, false> {
  typedef _LIBCPP_NODEBUG typename __find_first<_Tp, _Size>::type type;
};

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___TYPE_TRAITS_TYPE_LIST_H
# 43 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/type_list.h" 3
#endif /* type_list.h expanded by -frewrite-includes */
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/make_signed.h" 2 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 21 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/make_signed.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 22 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/make_signed.h" 3
#endif
# 23 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/make_signed.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

#if 0 /* disabled by -frewrite-includes */
#if __has_builtin(__make_signed)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 27 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/make_signed.h" 3

template <class _Tp>
using __make_signed_t = __make_signed(_Tp);

#else
# 32 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/make_signed.h" 3
// clang-format off
typedef __type_list<signed char,
        __type_list<signed short,
        __type_list<signed int,
        __type_list<signed long,
        __type_list<signed long long,
#  ifndef _LIBCPP_HAS_NO_INT128
        __type_list<__int128_t,
#  endif
# 41 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/make_signed.h" 3
        __nat
#  ifndef _LIBCPP_HAS_NO_INT128
        >
#  endif
# 45 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/make_signed.h" 3
        > > > > > __signed_types;
// clang-format on

template <class _Tp, bool = is_integral<_Tp>::value || is_enum<_Tp>::value>
struct __make_signed{};

template <class _Tp>
struct __make_signed<_Tp, true> {
  typedef typename __find_first<__signed_types, sizeof(_Tp)>::type type;
};

// clang-format off
template <> struct __make_signed<bool,               true> {};
template <> struct __make_signed<  signed short,     true> {typedef short     type;};
template <> struct __make_signed<unsigned short,     true> {typedef short     type;};
template <> struct __make_signed<  signed int,       true> {typedef int       type;};
template <> struct __make_signed<unsigned int,       true> {typedef int       type;};
template <> struct __make_signed<  signed long,      true> {typedef long      type;};
template <> struct __make_signed<unsigned long,      true> {typedef long      type;};
template <> struct __make_signed<  signed long long, true> {typedef long long type;};
template <> struct __make_signed<unsigned long long, true> {typedef long long type;};
#  ifndef _LIBCPP_HAS_NO_INT128
template <> struct __make_signed<__int128_t,         true> {typedef __int128_t type;};
template <> struct __make_signed<__uint128_t,        true> {typedef __int128_t type;};
#  endif
# 70 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/make_signed.h" 3
// clang-format on

template <class _Tp>
using __make_signed_t = __apply_cv_t<_Tp, typename __make_signed<__remove_cv_t<_Tp> >::type>;

#endif // __has_builtin(__make_signed)
# 76 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/make_signed.h" 3

template <class _Tp>
struct make_signed {
  using type _LIBCPP_NODEBUG = __make_signed_t<_Tp>;
};

#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 14
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 83 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/make_signed.h" 3
template <class _Tp>
using make_signed_t = __make_signed_t<_Tp>;
#endif
# 86 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/make_signed.h" 3

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___TYPE_TRAITS_MAKE_SIGNED_H
# 90 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/make_signed.h" 3
#endif /* make_signed.h expanded by -frewrite-includes */
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/incrementable_traits.h" 2 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/remove_cvref.h>
#endif /* expanded by -frewrite-includes */
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/incrementable_traits.h" 3
# 20 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/incrementable_traits.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__utility/declval.h>
#endif /* expanded by -frewrite-includes */
# 20 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/incrementable_traits.h" 3
# 21 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/incrementable_traits.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <cstddef>
#endif /* expanded by -frewrite-includes */
# 21 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/incrementable_traits.h" 3
# 22 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/incrementable_traits.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 24 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/incrementable_traits.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 25 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/incrementable_traits.h" 3
#endif
# 26 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/incrementable_traits.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 20
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 30 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/incrementable_traits.h" 3

// [incrementable.traits]
template<class> struct incrementable_traits {};

template<class _Tp>
requires is_object_v<_Tp>
struct incrementable_traits<_Tp*> {
  using difference_type = ptrdiff_t;
};

template<class _Ip>
struct incrementable_traits<const _Ip> : incrementable_traits<_Ip> {};

template<class _Tp>
concept __has_member_difference_type = requires { typename _Tp::difference_type; };

template<__has_member_difference_type _Tp>
struct incrementable_traits<_Tp> {
  using difference_type = typename _Tp::difference_type;
};

template<class _Tp>
concept __has_integral_minus =
  requires(const _Tp& __x, const _Tp& __y) {
    { __x - __y } -> integral;
  };

template<__has_integral_minus _Tp>
requires (!__has_member_difference_type<_Tp>)
struct incrementable_traits<_Tp> {
  using difference_type = make_signed_t<decltype(std::declval<_Tp>() - std::declval<_Tp>())>;
};

template <class>
struct iterator_traits;

// Let `RI` be `remove_cvref_t<I>`. The type `iter_difference_t<I>` denotes
// `incrementable_traits<RI>::difference_type` if `iterator_traits<RI>` names a specialization
// generated from the primary template, and `iterator_traits<RI>::difference_type` otherwise.
template <class _Ip>
using iter_difference_t = typename conditional_t<__is_primary_template<iterator_traits<remove_cvref_t<_Ip> > >::value,
                                                 incrementable_traits<remove_cvref_t<_Ip> >,
                                                 iterator_traits<remove_cvref_t<_Ip> > >::difference_type;

#endif // _LIBCPP_STD_VER >= 20
# 75 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/incrementable_traits.h" 3

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___ITERATOR_INCREMENTABLE_TRAITS_H
# 79 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/incrementable_traits.h" 3
#endif /* incrementable_traits.h expanded by -frewrite-includes */
# 31 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/concepts.h" 2 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* iter_move.h expanded by -frewrite-includes */
#include <__iterator/iter_move.h>
#else /* iter_move.h expanded by -frewrite-includes */
# 31 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/concepts.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iter_move.h" 1 3
// -*- C++ -*-
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___ITERATOR_ITER_MOVE_H
#define _LIBCPP___ITERATOR_ITER_MOVE_H

#if 0 /* expanded by -frewrite-includes */
#include <__concepts/class_or_enum.h>
#endif /* expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iter_move.h" 3
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iter_move.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iter_move.h" 3
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iter_move.h" 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* iterator_traits.h expanded by -frewrite-includes */
#include <__iterator/iterator_traits.h>
#else /* iterator_traits.h expanded by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iter_move.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iterator_traits.h" 1 3
// -*- C++ -*-
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___ITERATOR_ITERATOR_TRAITS_H
#define _LIBCPP___ITERATOR_ITERATOR_TRAITS_H

#if 0 /* expanded by -frewrite-includes */
#include <__concepts/arithmetic.h>
#endif /* expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iterator_traits.h" 3
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iterator_traits.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__concepts/constructible.h>
#endif /* expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iterator_traits.h" 3
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iterator_traits.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__concepts/convertible_to.h>
#endif /* expanded by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iterator_traits.h" 3
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iterator_traits.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__concepts/copyable.h>
#endif /* expanded by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iterator_traits.h" 3
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iterator_traits.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__concepts/equality_comparable.h>
#endif /* expanded by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iterator_traits.h" 3
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iterator_traits.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__concepts/same_as.h>
#endif /* expanded by -frewrite-includes */
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iterator_traits.h" 3
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iterator_traits.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__concepts/totally_ordered.h>
#endif /* expanded by -frewrite-includes */
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iterator_traits.h" 3
# 20 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iterator_traits.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 20 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iterator_traits.h" 3
# 21 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iterator_traits.h" 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* pair.h expanded by -frewrite-includes */
#include <__fwd/pair.h>
#else /* pair.h expanded by -frewrite-includes */
# 21 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iterator_traits.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__fwd/pair.h" 1 3
//===---------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===---------------------------------------------------------------------===//

#ifndef _LIBCPP___FWD_PAIR_H
#define _LIBCPP___FWD_PAIR_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__fwd/pair.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__fwd/pair.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__fwd/pair.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__fwd/pair.h" 3
#endif
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__fwd/pair.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

template <class, class>
struct _LIBCPP_TEMPLATE_VIS pair;

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___FWD_PAIR_H
# 26 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__fwd/pair.h" 3
#endif /* pair.h expanded by -frewrite-includes */
# 22 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iterator_traits.h" 2 3
#if 0 /* expanded by -frewrite-includes */
#include <__iterator/incrementable_traits.h>
#endif /* expanded by -frewrite-includes */
# 22 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iterator_traits.h" 3
# 23 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iterator_traits.h" 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* readable_traits.h expanded by -frewrite-includes */
#include <__iterator/readable_traits.h>
#else /* readable_traits.h expanded by -frewrite-includes */
# 23 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iterator_traits.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/readable_traits.h" 1 3
// -*- C++ -*-
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___ITERATOR_READABLE_TRAITS_H
#define _LIBCPP___ITERATOR_READABLE_TRAITS_H

#if 0 /* expanded by -frewrite-includes */
#include <__concepts/same_as.h>
#endif /* expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/readable_traits.h" 3
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/readable_traits.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/readable_traits.h" 3
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/readable_traits.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/conditional.h>
#endif /* expanded by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/readable_traits.h" 3
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/readable_traits.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/is_array.h>
#endif /* expanded by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/readable_traits.h" 3
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/readable_traits.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/is_object.h>
#endif /* expanded by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/readable_traits.h" 3
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/readable_traits.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/is_primary_template.h>
#endif /* expanded by -frewrite-includes */
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/readable_traits.h" 3
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/readable_traits.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/remove_cv.h>
#endif /* expanded by -frewrite-includes */
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/readable_traits.h" 3
# 20 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/readable_traits.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/remove_cvref.h>
#endif /* expanded by -frewrite-includes */
# 20 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/readable_traits.h" 3
# 21 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/readable_traits.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/remove_extent.h>
#endif /* expanded by -frewrite-includes */
# 21 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/readable_traits.h" 3
# 22 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/readable_traits.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 24 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/readable_traits.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 25 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/readable_traits.h" 3
#endif
# 26 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/readable_traits.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 20
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 30 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/readable_traits.h" 3

// [readable.traits]
template<class> struct __cond_value_type {};

template<class _Tp>
requires is_object_v<_Tp>
struct __cond_value_type<_Tp> { using value_type = remove_cv_t<_Tp>; };

template<class _Tp>
concept __has_member_value_type = requires { typename _Tp::value_type; };

template<class _Tp>
concept __has_member_element_type = requires { typename _Tp::element_type; };

template<class> struct indirectly_readable_traits {};

template<class _Ip>
requires is_array_v<_Ip>
struct indirectly_readable_traits<_Ip> {
  using value_type = remove_cv_t<remove_extent_t<_Ip>>;
};

template<class _Ip>
struct indirectly_readable_traits<const _Ip> : indirectly_readable_traits<_Ip> {};

template<class _Tp>
struct indirectly_readable_traits<_Tp*> : __cond_value_type<_Tp> {};

template<__has_member_value_type _Tp>
struct indirectly_readable_traits<_Tp>
  : __cond_value_type<typename _Tp::value_type> {};

template<__has_member_element_type _Tp>
struct indirectly_readable_traits<_Tp>
  : __cond_value_type<typename _Tp::element_type> {};

template<__has_member_value_type _Tp>
  requires __has_member_element_type<_Tp>
struct indirectly_readable_traits<_Tp> {};

template<__has_member_value_type _Tp>
  requires __has_member_element_type<_Tp> &&
           same_as<remove_cv_t<typename _Tp::element_type>,
                   remove_cv_t<typename _Tp::value_type>>
struct indirectly_readable_traits<_Tp>
  : __cond_value_type<typename _Tp::value_type> {};

#endif // _LIBCPP_STD_VER >= 20
# 78 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/readable_traits.h" 3

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___ITERATOR_READABLE_TRAITS_H
# 82 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/readable_traits.h" 3
#endif /* readable_traits.h expanded by -frewrite-includes */
# 24 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iterator_traits.h" 2 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/add_const.h>
#endif /* expanded by -frewrite-includes */
# 24 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iterator_traits.h" 3
# 25 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iterator_traits.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/common_reference.h>
#endif /* expanded by -frewrite-includes */
# 25 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iterator_traits.h" 3
# 26 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iterator_traits.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/conditional.h>
#endif /* expanded by -frewrite-includes */
# 26 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iterator_traits.h" 3
# 27 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iterator_traits.h" 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* disjunction.h expanded by -frewrite-includes */
#include <__type_traits/disjunction.h>
#else /* disjunction.h expanded by -frewrite-includes */
# 27 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iterator_traits.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/disjunction.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___TYPE_TRAITS_DISJUNCTION_H
#define _LIBCPP___TYPE_TRAITS_DISJUNCTION_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/disjunction.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/disjunction.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/integral_constant.h>
#endif /* expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/disjunction.h" 3
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/disjunction.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/disjunction.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/disjunction.h" 3
#endif
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/disjunction.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

template <bool>
struct _OrImpl;

template <>
struct _OrImpl<true> {
  template <class _Res, class _First, class... _Rest>
  using _Result _LIBCPP_NODEBUG =
      typename _OrImpl<!bool(_First::value) && sizeof...(_Rest) != 0>::template _Result<_First, _Rest...>;
};

template <>
struct _OrImpl<false> {
  template <class _Res, class...>
  using _Result = _Res;
};

// _Or always performs lazy evaluation of its arguments.
//
// However, `_Or<_Pred...>` itself will evaluate its result immediately (without having to
// be instantiated) since it is an alias, unlike `disjunction<_Pred...>`, which is a struct.
// If you want to defer the evaluation of `_Or<_Pred...>` itself, use `_Lazy<_Or, _Pred...>`
// or `disjunction<_Pred...>` directly.
template <class... _Args>
using _Or _LIBCPP_NODEBUG = typename _OrImpl<sizeof...(_Args) != 0>::template _Result<false_type, _Args...>;

#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 17
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 47 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/disjunction.h" 3

template <class... _Args>
struct disjunction : _Or<_Args...> {};

template <class... _Args>
inline constexpr bool disjunction_v = _Or<_Args...>::value;

#endif // _LIBCPP_STD_VER >= 17
# 55 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/disjunction.h" 3

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___TYPE_TRAITS_DISJUNCTION_H
# 59 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/disjunction.h" 3
#endif /* disjunction.h expanded by -frewrite-includes */
# 28 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iterator_traits.h" 2 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/is_convertible.h>
#endif /* expanded by -frewrite-includes */
# 28 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iterator_traits.h" 3
# 29 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iterator_traits.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/is_object.h>
#endif /* expanded by -frewrite-includes */
# 29 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iterator_traits.h" 3
# 30 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iterator_traits.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/is_primary_template.h>
#endif /* expanded by -frewrite-includes */
# 30 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iterator_traits.h" 3
# 31 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iterator_traits.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/is_reference.h>
#endif /* expanded by -frewrite-includes */
# 31 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iterator_traits.h" 3
# 32 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iterator_traits.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/is_valid_expansion.h>
#endif /* expanded by -frewrite-includes */
# 32 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iterator_traits.h" 3
# 33 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iterator_traits.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/remove_const.h>
#endif /* expanded by -frewrite-includes */
# 33 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iterator_traits.h" 3
# 34 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iterator_traits.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/remove_cv.h>
#endif /* expanded by -frewrite-includes */
# 34 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iterator_traits.h" 3
# 35 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iterator_traits.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/remove_cvref.h>
#endif /* expanded by -frewrite-includes */
# 35 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iterator_traits.h" 3
# 36 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iterator_traits.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/void_t.h>
#endif /* expanded by -frewrite-includes */
# 36 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iterator_traits.h" 3
# 37 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iterator_traits.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__utility/declval.h>
#endif /* expanded by -frewrite-includes */
# 37 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iterator_traits.h" 3
# 38 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iterator_traits.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <cstddef>
#endif /* expanded by -frewrite-includes */
# 38 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iterator_traits.h" 3
# 39 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iterator_traits.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 41 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iterator_traits.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 42 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iterator_traits.h" 3
#endif
# 43 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iterator_traits.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 20
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 47 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iterator_traits.h" 3

template <class _Tp>
using __with_reference = _Tp&;

template <class _Tp>
concept __can_reference = requires {
  typename __with_reference<_Tp>;
};

template <class _Tp>
concept __dereferenceable = requires(_Tp& __t) {
  { *__t } -> __can_reference; // not required to be equality-preserving
};

// [iterator.traits]
template<__dereferenceable _Tp>
using iter_reference_t = decltype(*std::declval<_Tp&>());

#endif // _LIBCPP_STD_VER >= 20
# 66 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iterator_traits.h" 3

template <class _Iter>
struct _LIBCPP_TEMPLATE_VIS iterator_traits;

struct _LIBCPP_TEMPLATE_VIS input_iterator_tag {};
struct _LIBCPP_TEMPLATE_VIS output_iterator_tag {};
struct _LIBCPP_TEMPLATE_VIS forward_iterator_tag       : public input_iterator_tag {};
struct _LIBCPP_TEMPLATE_VIS bidirectional_iterator_tag : public forward_iterator_tag {};
struct _LIBCPP_TEMPLATE_VIS random_access_iterator_tag : public bidirectional_iterator_tag {};
#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 20
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 76 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iterator_traits.h" 3
struct _LIBCPP_TEMPLATE_VIS contiguous_iterator_tag    : public random_access_iterator_tag {};
#endif
# 78 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iterator_traits.h" 3

template <class _Iter>
struct __iter_traits_cache {
  using type = _If<
    __is_primary_template<iterator_traits<_Iter> >::value,
    _Iter,
    iterator_traits<_Iter>
  >;
};
template <class _Iter>
using _ITER_TRAITS = typename __iter_traits_cache<_Iter>::type;

struct __iter_concept_concept_test {
  template <class _Iter>
  using _Apply = typename _ITER_TRAITS<_Iter>::iterator_concept;
};
struct __iter_concept_category_test {
  template <class _Iter>
  using _Apply = typename _ITER_TRAITS<_Iter>::iterator_category;
};
struct __iter_concept_random_fallback {
  template <class _Iter>
  using _Apply = __enable_if_t<
                          __is_primary_template<iterator_traits<_Iter> >::value,
                          random_access_iterator_tag
                        >;
};

template <class _Iter, class _Tester> struct __test_iter_concept
    : _IsValidExpansion<_Tester::template _Apply, _Iter>,
      _Tester
{
};

template <class _Iter>
struct __iter_concept_cache {
  using type = _Or<
    __test_iter_concept<_Iter, __iter_concept_concept_test>,
    __test_iter_concept<_Iter, __iter_concept_category_test>,
    __test_iter_concept<_Iter, __iter_concept_random_fallback>
  >;
};

template <class _Iter>
using _ITER_CONCEPT = typename __iter_concept_cache<_Iter>::type::template _Apply<_Iter>;


template <class _Tp>
struct __has_iterator_typedefs
{
private:
    template <class _Up> static false_type __test(...);
    template <class _Up> static true_type __test(__void_t<typename _Up::iterator_category>* = nullptr,
                                                 __void_t<typename _Up::difference_type>* = nullptr,
                                                 __void_t<typename _Up::value_type>* = nullptr,
                                                 __void_t<typename _Up::reference>* = nullptr,
                                                 __void_t<typename _Up::pointer>* = nullptr);
public:
    static const bool value = decltype(__test<_Tp>(0,0,0,0,0))::value;
};


template <class _Tp>
struct __has_iterator_category
{
private:
    template <class _Up> static false_type __test(...);
    template <class _Up> static true_type __test(typename _Up::iterator_category* = nullptr);
public:
    static const bool value = decltype(__test<_Tp>(nullptr))::value;
};

template <class _Tp>
struct __has_iterator_concept
{
private:
    template <class _Up> static false_type __test(...);
    template <class _Up> static true_type __test(typename _Up::iterator_concept* = nullptr);
public:
    static const bool value = decltype(__test<_Tp>(nullptr))::value;
};

#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 20
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 161 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iterator_traits.h" 3

// The `cpp17-*-iterator` exposition-only concepts have very similar names to the `Cpp17*Iterator` named requirements
// from `[iterator.cpp17]`. To avoid confusion between the two, the exposition-only concepts have been banished to
// a "detail" namespace indicating they have a niche use-case.
namespace __iterator_traits_detail {
template<class _Ip>
concept __cpp17_iterator =
  requires(_Ip __i) {
    {   *__i } -> __can_reference;
    {  ++__i } -> same_as<_Ip&>;
    { *__i++ } -> __can_reference;
  } &&
  copyable<_Ip>;

template<class _Ip>
concept __cpp17_input_iterator =
  __cpp17_iterator<_Ip> &&
  equality_comparable<_Ip> &&
  requires(_Ip __i) {
    typename incrementable_traits<_Ip>::difference_type;
    typename indirectly_readable_traits<_Ip>::value_type;
    typename common_reference_t<iter_reference_t<_Ip>&&,
                                typename indirectly_readable_traits<_Ip>::value_type&>;
    typename common_reference_t<decltype(*__i++)&&,
                                typename indirectly_readable_traits<_Ip>::value_type&>;
    requires signed_integral<typename incrementable_traits<_Ip>::difference_type>;
  };

template<class _Ip>
concept __cpp17_forward_iterator =
  __cpp17_input_iterator<_Ip> &&
  constructible_from<_Ip> &&
  is_reference_v<iter_reference_t<_Ip>> &&
  same_as<remove_cvref_t<iter_reference_t<_Ip>>,
          typename indirectly_readable_traits<_Ip>::value_type> &&
  requires(_Ip __i) {
    {  __i++ } -> convertible_to<_Ip const&>;
    { *__i++ } -> same_as<iter_reference_t<_Ip>>;
  };

template<class _Ip>
concept __cpp17_bidirectional_iterator =
  __cpp17_forward_iterator<_Ip> &&
  requires(_Ip __i) {
    {  --__i } -> same_as<_Ip&>;
    {  __i-- } -> convertible_to<_Ip const&>;
    { *__i-- } -> same_as<iter_reference_t<_Ip>>;
  };

template<class _Ip>
concept __cpp17_random_access_iterator =
  __cpp17_bidirectional_iterator<_Ip> &&
  totally_ordered<_Ip> &&
  requires(_Ip __i, typename incrementable_traits<_Ip>::difference_type __n) {
    { __i += __n } -> same_as<_Ip&>;
    { __i -= __n } -> same_as<_Ip&>;
    { __i +  __n } -> same_as<_Ip>;
    { __n +  __i } -> same_as<_Ip>;
    { __i -  __n } -> same_as<_Ip>;
    { __i -  __i } -> same_as<decltype(__n)>; // NOLINT(misc-redundant-expression) ; This is llvm.org/PR54114
    {  __i[__n]  } -> convertible_to<iter_reference_t<_Ip>>;
  };
} // namespace __iterator_traits_detail

template<class _Ip>
concept __has_member_reference = requires { typename _Ip::reference; };

template<class _Ip>
concept __has_member_pointer = requires { typename _Ip::pointer; };

template<class _Ip>
concept __has_member_iterator_category = requires { typename _Ip::iterator_category; };

template<class _Ip>
concept __specifies_members = requires {
    typename _Ip::value_type;
    typename _Ip::difference_type;
    requires __has_member_reference<_Ip>;
    requires __has_member_iterator_category<_Ip>;
  };

template<class>
struct __iterator_traits_member_pointer_or_void {
  using type = void;
};

template<__has_member_pointer _Tp>
struct __iterator_traits_member_pointer_or_void<_Tp> {
  using type = typename _Tp::pointer;
};

template<class _Tp>
concept __cpp17_iterator_missing_members =
  !__specifies_members<_Tp> &&
  __iterator_traits_detail::__cpp17_iterator<_Tp>;

template<class _Tp>
concept __cpp17_input_iterator_missing_members =
  __cpp17_iterator_missing_members<_Tp> &&
  __iterator_traits_detail::__cpp17_input_iterator<_Tp>;

// Otherwise, `pointer` names `void`.
template<class>
struct __iterator_traits_member_pointer_or_arrow_or_void { using type = void; };

// [iterator.traits]/3.2.1
// If the qualified-id `I::pointer` is valid and denotes a type, `pointer` names that type.
template<__has_member_pointer _Ip>
struct __iterator_traits_member_pointer_or_arrow_or_void<_Ip> { using type = typename _Ip::pointer; };

// Otherwise, if `decltype(declval<I&>().operator->())` is well-formed, then `pointer` names that
// type.
template<class _Ip>
  requires requires(_Ip& __i) { __i.operator->(); } && (!__has_member_pointer<_Ip>)
struct __iterator_traits_member_pointer_or_arrow_or_void<_Ip> {
  using type = decltype(std::declval<_Ip&>().operator->());
};

// Otherwise, `reference` names `iter-reference-t<I>`.
template<class _Ip>
struct __iterator_traits_member_reference { using type = iter_reference_t<_Ip>; };

// [iterator.traits]/3.2.2
// If the qualified-id `I::reference` is valid and denotes a type, `reference` names that type.
template<__has_member_reference _Ip>
struct __iterator_traits_member_reference<_Ip> { using type = typename _Ip::reference; };

// [iterator.traits]/3.2.3.4
// input_iterator_tag
template<class _Ip>
struct __deduce_iterator_category {
  using type = input_iterator_tag;
};

// [iterator.traits]/3.2.3.1
// `random_access_iterator_tag` if `I` satisfies `cpp17-random-access-iterator`, or otherwise
template<__iterator_traits_detail::__cpp17_random_access_iterator _Ip>
struct __deduce_iterator_category<_Ip> {
  using type = random_access_iterator_tag;
};

// [iterator.traits]/3.2.3.2
// `bidirectional_iterator_tag` if `I` satisfies `cpp17-bidirectional-iterator`, or otherwise
template<__iterator_traits_detail::__cpp17_bidirectional_iterator _Ip>
struct __deduce_iterator_category<_Ip> {
  using type = bidirectional_iterator_tag;
};

// [iterator.traits]/3.2.3.3
// `forward_iterator_tag` if `I` satisfies `cpp17-forward-iterator`, or otherwise
template<__iterator_traits_detail::__cpp17_forward_iterator _Ip>
struct __deduce_iterator_category<_Ip> {
  using type = forward_iterator_tag;
};

template<class _Ip>
struct __iterator_traits_iterator_category : __deduce_iterator_category<_Ip> {};

// [iterator.traits]/3.2.3
// If the qualified-id `I::iterator-category` is valid and denotes a type, `iterator-category` names
// that type.
template<__has_member_iterator_category _Ip>
struct __iterator_traits_iterator_category<_Ip> {
  using type = typename _Ip::iterator_category;
};

// otherwise, it names void.
template<class>
struct __iterator_traits_difference_type { using type = void; };

// If the qualified-id `incrementable_traits<I>::difference_type` is valid and denotes a type, then
// `difference_type` names that type;
template<class _Ip>
requires requires { typename incrementable_traits<_Ip>::difference_type; }
struct __iterator_traits_difference_type<_Ip> {
  using type = typename incrementable_traits<_Ip>::difference_type;
};

// [iterator.traits]/3.4
// Otherwise, `iterator_traits<I>` has no members by any of the above names.
template<class>
struct __iterator_traits {};

// [iterator.traits]/3.1
// If `I` has valid ([temp.deduct]) member types `difference-type`, `value-type`, `reference`, and
// `iterator-category`, then `iterator-traits<I>` has the following publicly accessible members:
template<__specifies_members _Ip>
struct __iterator_traits<_Ip> {
  using iterator_category  = typename _Ip::iterator_category;
  using value_type         = typename _Ip::value_type;
  using difference_type    = typename _Ip::difference_type;
  using pointer            = typename __iterator_traits_member_pointer_or_void<_Ip>::type;
  using reference          = typename _Ip::reference;
};

// [iterator.traits]/3.2
// Otherwise, if `I` satisfies the exposition-only concept `cpp17-input-iterator`,
// `iterator-traits<I>` has the following publicly accessible members:
template<__cpp17_input_iterator_missing_members _Ip>
struct __iterator_traits<_Ip> {
  using iterator_category = typename __iterator_traits_iterator_category<_Ip>::type;
  using value_type        = typename indirectly_readable_traits<_Ip>::value_type;
  using difference_type   = typename incrementable_traits<_Ip>::difference_type;
  using pointer           = typename __iterator_traits_member_pointer_or_arrow_or_void<_Ip>::type;
  using reference         = typename __iterator_traits_member_reference<_Ip>::type;
};

// Otherwise, if `I` satisfies the exposition-only concept `cpp17-iterator`, then
// `iterator_traits<I>` has the following publicly accessible members:
template<__cpp17_iterator_missing_members _Ip>
struct __iterator_traits<_Ip> {
  using iterator_category = output_iterator_tag;
  using value_type        = void;
  using difference_type   = typename __iterator_traits_difference_type<_Ip>::type;
  using pointer           = void;
  using reference         = void;
};

template<class _Ip>
struct iterator_traits : __iterator_traits<_Ip> {
  using __primary_template = iterator_traits;
};

#else // _LIBCPP_STD_VER >= 20
# 385 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iterator_traits.h" 3

template <class _Iter, bool> struct __iterator_traits {};

template <class _Iter, bool> struct __iterator_traits_impl {};

template <class _Iter>
struct __iterator_traits_impl<_Iter, true>
{
    typedef typename _Iter::difference_type   difference_type;
    typedef typename _Iter::value_type        value_type;
    typedef typename _Iter::pointer           pointer;
    typedef typename _Iter::reference         reference;
    typedef typename _Iter::iterator_category iterator_category;
};

template <class _Iter>
struct __iterator_traits<_Iter, true>
    :  __iterator_traits_impl
      <
        _Iter,
        is_convertible<typename _Iter::iterator_category, input_iterator_tag>::value ||
        is_convertible<typename _Iter::iterator_category, output_iterator_tag>::value
      >
{};

// iterator_traits<Iterator> will only have the nested types if Iterator::iterator_category
//    exists.  Else iterator_traits<Iterator> will be an empty class.  This is a
//    conforming extension which allows some programs to compile and behave as
//    the client expects instead of failing at compile time.

template <class _Iter>
struct _LIBCPP_TEMPLATE_VIS iterator_traits
    : __iterator_traits<_Iter, __has_iterator_typedefs<_Iter>::value> {

  using __primary_template = iterator_traits;
};
#endif // _LIBCPP_STD_VER >= 20
# 422 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iterator_traits.h" 3

template<class _Tp>
#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 20
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 425 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iterator_traits.h" 3
requires is_object_v<_Tp>
#endif
# 427 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iterator_traits.h" 3
struct _LIBCPP_TEMPLATE_VIS iterator_traits<_Tp*>
{
    typedef ptrdiff_t difference_type;
    typedef __remove_cv_t<_Tp> value_type;
    typedef _Tp* pointer;
    typedef _Tp& reference;
    typedef random_access_iterator_tag iterator_category;
#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 20
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 435 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iterator_traits.h" 3
    typedef contiguous_iterator_tag    iterator_concept;
#endif
# 437 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iterator_traits.h" 3
};

template <class _Tp, class _Up, bool = __has_iterator_category<iterator_traits<_Tp> >::value>
struct __has_iterator_category_convertible_to
    : is_convertible<typename iterator_traits<_Tp>::iterator_category, _Up>
{};

template <class _Tp, class _Up>
struct __has_iterator_category_convertible_to<_Tp, _Up, false> : false_type {};

template <class _Tp, class _Up, bool = __has_iterator_concept<_Tp>::value>
struct __has_iterator_concept_convertible_to
    : is_convertible<typename _Tp::iterator_concept, _Up>
{};

template <class _Tp, class _Up>
struct __has_iterator_concept_convertible_to<_Tp, _Up, false> : false_type {};

template <class _Tp>
using __has_input_iterator_category = __has_iterator_category_convertible_to<_Tp, input_iterator_tag>;

template <class _Tp>
using __has_forward_iterator_category = __has_iterator_category_convertible_to<_Tp, forward_iterator_tag>;

template <class _Tp>
using __has_bidirectional_iterator_category = __has_iterator_category_convertible_to<_Tp, bidirectional_iterator_tag>;

template <class _Tp>
using __has_random_access_iterator_category = __has_iterator_category_convertible_to<_Tp, random_access_iterator_tag>;

// __libcpp_is_contiguous_iterator determines if an iterator is known by
// libc++ to be contiguous, either because it advertises itself as such
// (in C++20) or because it is a pointer type or a known trivial wrapper
// around a (possibly fancy) pointer type, such as __wrap_iter<T*>.
// Such iterators receive special "contiguous" optimizations in
// std::copy and std::sort.
//
#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 20
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 475 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iterator_traits.h" 3
template <class _Tp>
struct __libcpp_is_contiguous_iterator : _Or<
    __has_iterator_category_convertible_to<_Tp, contiguous_iterator_tag>,
    __has_iterator_concept_convertible_to<_Tp, contiguous_iterator_tag>
> {};
#else
# 481 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iterator_traits.h" 3
template <class _Tp>
struct __libcpp_is_contiguous_iterator : false_type {};
#endif
# 484 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iterator_traits.h" 3

// Any native pointer which is an iterator is also a contiguous iterator.
template <class _Up>
struct __libcpp_is_contiguous_iterator<_Up*> : true_type {};


template <class _Iter>
class __wrap_iter;

template <class _Tp>
using __has_exactly_input_iterator_category
    = integral_constant<bool,
         __has_iterator_category_convertible_to<_Tp, input_iterator_tag>::value &&
        !__has_iterator_category_convertible_to<_Tp, forward_iterator_tag>::value>;

template <class _Tp>
using __has_exactly_forward_iterator_category
    = integral_constant<bool,
         __has_iterator_category_convertible_to<_Tp, forward_iterator_tag>::value &&
        !__has_iterator_category_convertible_to<_Tp, bidirectional_iterator_tag>::value>;

template <class _Tp>
using __has_exactly_bidirectional_iterator_category
    = integral_constant<bool,
         __has_iterator_category_convertible_to<_Tp, bidirectional_iterator_tag>::value &&
        !__has_iterator_category_convertible_to<_Tp, random_access_iterator_tag>::value>;

template<class _InputIterator>
using __iter_value_type = typename iterator_traits<_InputIterator>::value_type;

template<class _InputIterator>
using __iter_key_type = __remove_const_t<typename iterator_traits<_InputIterator>::value_type::first_type>;

template<class _InputIterator>
using __iter_mapped_type = typename iterator_traits<_InputIterator>::value_type::second_type;

template<class _InputIterator>
using __iter_to_alloc_type = pair<
    typename add_const<typename iterator_traits<_InputIterator>::value_type::first_type>::type,
    typename iterator_traits<_InputIterator>::value_type::second_type>;

template <class _Iter>
using __iterator_category_type = typename iterator_traits<_Iter>::iterator_category;

template <class _Iter>
using __iterator_pointer_type = typename iterator_traits<_Iter>::pointer;

template <class _Iter>
using __iter_diff_t = typename iterator_traits<_Iter>::difference_type;

template <class _Iter>
using __iter_reference = typename iterator_traits<_Iter>::reference;

#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 20
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 538 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iterator_traits.h" 3

// [readable.traits]

// Let `RI` be `remove_cvref_t<I>`. The type `iter_value_t<I>` denotes
// `indirectly_readable_traits<RI>::value_type` if `iterator_traits<RI>` names a specialization
// generated from the primary template, and `iterator_traits<RI>::value_type` otherwise.
// This has to be in this file and not readable_traits.h to break the include cycle between the two.
template <class _Ip>
using iter_value_t = typename conditional_t<__is_primary_template<iterator_traits<remove_cvref_t<_Ip> > >::value,
                                            indirectly_readable_traits<remove_cvref_t<_Ip> >,
                                            iterator_traits<remove_cvref_t<_Ip> > >::value_type;

#endif // _LIBCPP_STD_VER >= 20
# 551 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iterator_traits.h" 3

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___ITERATOR_ITERATOR_TRAITS_H
# 555 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iterator_traits.h" 3
#endif /* iterator_traits.h expanded by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iter_move.h" 2 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/is_reference.h>
#endif /* expanded by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iter_move.h" 3
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iter_move.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/remove_cvref.h>
#endif /* expanded by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iter_move.h" 3
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iter_move.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__utility/declval.h>
#endif /* expanded by -frewrite-includes */
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iter_move.h" 3
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iter_move.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__utility/forward.h>
#endif /* expanded by -frewrite-includes */
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iter_move.h" 3
# 20 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iter_move.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__utility/move.h>
#endif /* expanded by -frewrite-includes */
# 20 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iter_move.h" 3
# 21 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iter_move.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 23 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iter_move.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 24 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iter_move.h" 3
#endif
# 25 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iter_move.h" 3

_LIBCPP_PUSH_MACROS
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* __undef_macros expanded by -frewrite-includes */
#include <__undef_macros>
#else /* __undef_macros expanded by -frewrite-includes */
# 27 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iter_move.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__undef_macros" 1 3
// -*- C++ -*-
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifdef min
#  undef min
#endif
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__undef_macros" 3

#ifdef max
#  undef max
#endif
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__undef_macros" 3

#ifdef refresh
#  undef refresh
#endif
# 21 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__undef_macros" 3

#ifdef move
#  undef move
#endif
# 25 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__undef_macros" 3

#ifdef erase
#  undef erase
#endif
# 29 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__undef_macros" 3
#endif /* __undef_macros expanded by -frewrite-includes */
# 28 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iter_move.h" 2 3

_LIBCPP_BEGIN_NAMESPACE_STD

#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 20
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 32 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iter_move.h" 3

// [iterator.cust.move]

namespace ranges {
namespace __iter_move {

void iter_move();

template <class _Tp>
concept __unqualified_iter_move =
  __class_or_enum<remove_cvref_t<_Tp>> &&
  requires (_Tp&& __t) {
    // NOLINTNEXTLINE(libcpp-robust-against-adl) iter_swap ADL calls should only be made through ranges::iter_swap
    iter_move(std::forward<_Tp>(__t));
  };

template<class _Tp>
concept __move_deref =
  !__unqualified_iter_move<_Tp> &&
  requires (_Tp&& __t) {
    *__t;
    requires is_lvalue_reference_v<decltype(*__t)>;
  };

template<class _Tp>
concept __just_deref =
  !__unqualified_iter_move<_Tp> &&
  !__move_deref<_Tp> &&
  requires (_Tp&& __t) {
    *__t;
    requires (!is_lvalue_reference_v<decltype(*__t)>);
  };

// [iterator.cust.move]

struct __fn {
  // NOLINTBEGIN(libcpp-robust-against-adl) iter_move ADL calls should only be made through ranges::iter_move
  template<class _Ip>
    requires __unqualified_iter_move<_Ip>
  [[nodiscard]] _LIBCPP_HIDE_FROM_ABI constexpr decltype(auto) operator()(_Ip&& __i) const
    noexcept(noexcept(iter_move(std::forward<_Ip>(__i))))
  {
    return iter_move(std::forward<_Ip>(__i));
  }
  // NOLINTEND(libcpp-robust-against-adl)

  template<class _Ip>
    requires __move_deref<_Ip>
  [[nodiscard]] _LIBCPP_HIDE_FROM_ABI constexpr auto operator()(_Ip&& __i) const
    noexcept(noexcept(std::move(*std::forward<_Ip>(__i))))
    -> decltype(      std::move(*std::forward<_Ip>(__i)))
    { return          std::move(*std::forward<_Ip>(__i)); }

  template<class _Ip>
    requires __just_deref<_Ip>
  [[nodiscard]] _LIBCPP_HIDE_FROM_ABI constexpr auto operator()(_Ip&& __i) const
    noexcept(noexcept(*std::forward<_Ip>(__i)))
    -> decltype(      *std::forward<_Ip>(__i))
    { return          *std::forward<_Ip>(__i); }
};
} // namespace __iter_move

inline namespace __cpo {
  inline constexpr auto iter_move = __iter_move::__fn{};
} // namespace __cpo
} // namespace ranges

template<__dereferenceable _Tp>
  requires requires(_Tp& __t) { { ranges::iter_move(__t) } -> __can_reference; }
using iter_rvalue_reference_t = decltype(ranges::iter_move(std::declval<_Tp&>()));

#endif // _LIBCPP_STD_VER >= 20
# 104 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iter_move.h" 3

_LIBCPP_END_NAMESPACE_STD

_LIBCPP_POP_MACROS

#endif // _LIBCPP___ITERATOR_ITER_MOVE_H
# 110 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iter_move.h" 3
#endif /* iter_move.h expanded by -frewrite-includes */
# 32 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/concepts.h" 2 3
#if 0 /* expanded by -frewrite-includes */
#include <__iterator/iterator_traits.h>
#endif /* expanded by -frewrite-includes */
# 32 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/concepts.h" 3
# 33 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/concepts.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__iterator/readable_traits.h>
#endif /* expanded by -frewrite-includes */
# 33 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/concepts.h" 3
# 34 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/concepts.h" 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* pointer_traits.h expanded by -frewrite-includes */
#include <__memory/pointer_traits.h>
#else /* pointer_traits.h expanded by -frewrite-includes */
# 34 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/concepts.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__memory/pointer_traits.h" 1 3
// -*- C++ -*-
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___MEMORY_POINTER_TRAITS_H
#define _LIBCPP___MEMORY_POINTER_TRAITS_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__memory/pointer_traits.h" 3
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__memory/pointer_traits.h" 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* addressof.h expanded by -frewrite-includes */
#include <__memory/addressof.h>
#else /* addressof.h expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__memory/pointer_traits.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__memory/addressof.h" 1 3
// -*- C++ -*-
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___MEMORY_ADDRESSOF_H
#define _LIBCPP___MEMORY_ADDRESSOF_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__memory/addressof.h" 3
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__memory/addressof.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__memory/addressof.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__memory/addressof.h" 3
#endif
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__memory/addressof.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

template <class _Tp>
inline _LIBCPP_CONSTEXPR_SINCE_CXX17
_LIBCPP_NO_CFI _LIBCPP_INLINE_VISIBILITY
_Tp*
addressof(_Tp& __x) _NOEXCEPT
{
    return __builtin_addressof(__x);
}

#if 0 /* disabled by -frewrite-includes */
#if defined(_LIBCPP_HAS_OBJC_ARC) && !defined(_LIBCPP_PREDEFINED_OBJC_ARC_ADDRESSOF)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 31 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__memory/addressof.h" 3
// Objective-C++ Automatic Reference Counting uses qualified pointers
// that require special addressof() signatures. When
// _LIBCPP_PREDEFINED_OBJC_ARC_ADDRESSOF is defined, the compiler
// itself is providing these definitions. Otherwise, we provide them.
template <class _Tp>
inline _LIBCPP_INLINE_VISIBILITY
__strong _Tp*
addressof(__strong _Tp& __x) _NOEXCEPT
{
  return &__x;
}

#ifdef _LIBCPP_HAS_OBJC_ARC_WEAK
template <class _Tp>
inline _LIBCPP_INLINE_VISIBILITY
__weak _Tp*
addressof(__weak _Tp& __x) _NOEXCEPT
{
  return &__x;
}
#endif
# 52 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__memory/addressof.h" 3

template <class _Tp>
inline _LIBCPP_INLINE_VISIBILITY
__autoreleasing _Tp*
addressof(__autoreleasing _Tp& __x) _NOEXCEPT
{
  return &__x;
}

template <class _Tp>
inline _LIBCPP_INLINE_VISIBILITY
__unsafe_unretained _Tp*
addressof(__unsafe_unretained _Tp& __x) _NOEXCEPT
{
  return &__x;
}
#endif
# 69 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__memory/addressof.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_CXX03_LANG)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 71 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__memory/addressof.h" 3
template <class _Tp> _Tp* addressof(const _Tp&&) noexcept = delete;
#endif
# 73 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__memory/addressof.h" 3

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___MEMORY_ADDRESSOF_H
# 77 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__memory/addressof.h" 3
#endif /* addressof.h expanded by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__memory/pointer_traits.h" 2 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/conditional.h>
#endif /* expanded by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__memory/pointer_traits.h" 3
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__memory/pointer_traits.h" 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* conjunction.h expanded by -frewrite-includes */
#include <__type_traits/conjunction.h>
#else /* conjunction.h expanded by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__memory/pointer_traits.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/conjunction.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___TYPE_TRAITS_CONJUNCTION_H
#define _LIBCPP___TYPE_TRAITS_CONJUNCTION_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/conjunction.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/conjunction.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/conditional.h>
#endif /* expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/conjunction.h" 3
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/conjunction.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/enable_if.h>
#endif /* expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/conjunction.h" 3
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/conjunction.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/integral_constant.h>
#endif /* expanded by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/conjunction.h" 3
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/conjunction.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/conjunction.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/conjunction.h" 3
#endif
# 20 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/conjunction.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

template <class...>
using __expand_to_true = true_type;

template <class... _Pred>
__expand_to_true<__enable_if_t<_Pred::value>...> __and_helper(int);

template <class...>
false_type __and_helper(...);

// _And always performs lazy evaluation of its arguments.
//
// However, `_And<_Pred...>` itself will evaluate its result immediately (without having to
// be instantiated) since it is an alias, unlike `conjunction<_Pred...>`, which is a struct.
// If you want to defer the evaluation of `_And<_Pred...>` itself, use `_Lazy<_And, _Pred...>`.
template <class... _Pred>
using _And _LIBCPP_NODEBUG = decltype(std::__and_helper<_Pred...>(0));

#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 17
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 41 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/conjunction.h" 3

template <class...>
struct conjunction : true_type {};

template <class _Arg>
struct conjunction<_Arg> : _Arg {};

template <class _Arg, class... _Args>
struct conjunction<_Arg, _Args...> : conditional_t<!bool(_Arg::value), _Arg, conjunction<_Args...>> {};

template <class... _Args>
inline constexpr bool conjunction_v = conjunction<_Args...>::value;

#endif // _LIBCPP_STD_VER >= 17
# 55 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/conjunction.h" 3

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___TYPE_TRAITS_CONJUNCTION_H
# 59 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/conjunction.h" 3
#endif /* conjunction.h expanded by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__memory/pointer_traits.h" 2 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/decay.h>
#endif /* expanded by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__memory/pointer_traits.h" 3
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__memory/pointer_traits.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/is_class.h>
#endif /* expanded by -frewrite-includes */
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__memory/pointer_traits.h" 3
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__memory/pointer_traits.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/is_function.h>
#endif /* expanded by -frewrite-includes */
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__memory/pointer_traits.h" 3
# 20 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__memory/pointer_traits.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/is_void.h>
#endif /* expanded by -frewrite-includes */
# 20 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__memory/pointer_traits.h" 3
# 21 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__memory/pointer_traits.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/void_t.h>
#endif /* expanded by -frewrite-includes */
# 21 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__memory/pointer_traits.h" 3
# 22 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__memory/pointer_traits.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__utility/declval.h>
#endif /* expanded by -frewrite-includes */
# 22 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__memory/pointer_traits.h" 3
# 23 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__memory/pointer_traits.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <cstddef>
#endif /* expanded by -frewrite-includes */
# 23 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__memory/pointer_traits.h" 3
# 24 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__memory/pointer_traits.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 26 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__memory/pointer_traits.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 27 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__memory/pointer_traits.h" 3
#endif
# 28 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__memory/pointer_traits.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

template <class _Tp, class = void>
struct __has_element_type : false_type {};

template <class _Tp>
struct __has_element_type<_Tp, __void_t<typename _Tp::element_type> > : true_type {};

template <class _Ptr, bool = __has_element_type<_Ptr>::value>
struct __pointer_traits_element_type {};

template <class _Ptr>
struct __pointer_traits_element_type<_Ptr, true>
{
    typedef _LIBCPP_NODEBUG typename _Ptr::element_type type;
};

template <template <class, class...> class _Sp, class _Tp, class ..._Args>
struct __pointer_traits_element_type<_Sp<_Tp, _Args...>, true>
{
    typedef _LIBCPP_NODEBUG typename _Sp<_Tp, _Args...>::element_type type;
};

template <template <class, class...> class _Sp, class _Tp, class ..._Args>
struct __pointer_traits_element_type<_Sp<_Tp, _Args...>, false>
{
    typedef _LIBCPP_NODEBUG _Tp type;
};

template <class _Tp, class = void>
struct __has_difference_type : false_type {};

template <class _Tp>
struct __has_difference_type<_Tp, __void_t<typename _Tp::difference_type> > : true_type {};

template <class _Ptr, bool = __has_difference_type<_Ptr>::value>
struct __pointer_traits_difference_type
{
    typedef _LIBCPP_NODEBUG ptrdiff_t type;
};

template <class _Ptr>
struct __pointer_traits_difference_type<_Ptr, true>
{
    typedef _LIBCPP_NODEBUG typename _Ptr::difference_type type;
};

template <class _Tp, class _Up>
struct __has_rebind
{
private:
    template <class _Xp> static false_type __test(...);
    _LIBCPP_SUPPRESS_DEPRECATED_PUSH
    template <class _Xp> static true_type __test(typename _Xp::template rebind<_Up>* = 0);
    _LIBCPP_SUPPRESS_DEPRECATED_POP
public:
    static const bool value = decltype(__test<_Tp>(0))::value;
};

template <class _Tp, class _Up, bool = __has_rebind<_Tp, _Up>::value>
struct __pointer_traits_rebind
{
#ifndef _LIBCPP_CXX03_LANG
    typedef _LIBCPP_NODEBUG typename _Tp::template rebind<_Up> type;
#else
# 94 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__memory/pointer_traits.h" 3
    typedef _LIBCPP_NODEBUG typename _Tp::template rebind<_Up>::other type;
#endif
# 96 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__memory/pointer_traits.h" 3
};

template <template <class, class...> class _Sp, class _Tp, class ..._Args, class _Up>
struct __pointer_traits_rebind<_Sp<_Tp, _Args...>, _Up, true>
{
#ifndef _LIBCPP_CXX03_LANG
    typedef _LIBCPP_NODEBUG typename _Sp<_Tp, _Args...>::template rebind<_Up> type;
#else
# 104 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__memory/pointer_traits.h" 3
    typedef _LIBCPP_NODEBUG typename _Sp<_Tp, _Args...>::template rebind<_Up>::other type;
#endif
# 106 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__memory/pointer_traits.h" 3
};

template <template <class, class...> class _Sp, class _Tp, class ..._Args, class _Up>
struct __pointer_traits_rebind<_Sp<_Tp, _Args...>, _Up, false>
{
    typedef _Sp<_Up, _Args...> type;
};

template <class _Ptr, class = void>
struct __pointer_traits_impl {};

template <class _Ptr>
struct __pointer_traits_impl<_Ptr, __void_t<typename __pointer_traits_element_type<_Ptr>::type> > {
  typedef _Ptr pointer;
  typedef typename __pointer_traits_element_type<pointer>::type element_type;
  typedef typename __pointer_traits_difference_type<pointer>::type difference_type;

#ifndef _LIBCPP_CXX03_LANG
    template <class _Up> using rebind = typename __pointer_traits_rebind<pointer, _Up>::type;
#else
# 126 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__memory/pointer_traits.h" 3
    template <class _Up> struct rebind
        {typedef typename __pointer_traits_rebind<pointer, _Up>::type other;};
#endif // _LIBCPP_CXX03_LANG
# 129 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__memory/pointer_traits.h" 3

private:
    struct __nat {};
public:
    _LIBCPP_INLINE_VISIBILITY _LIBCPP_CONSTEXPR_SINCE_CXX20
    static pointer pointer_to(__conditional_t<is_void<element_type>::value, __nat, element_type>& __r)
        {return pointer::pointer_to(__r);}
};

template <class _Ptr>
struct _LIBCPP_TEMPLATE_VIS pointer_traits : __pointer_traits_impl<_Ptr> {};

template <class _Tp>
struct _LIBCPP_TEMPLATE_VIS pointer_traits<_Tp*>
{
    typedef _Tp*      pointer;
    typedef _Tp       element_type;
    typedef ptrdiff_t difference_type;

#ifndef _LIBCPP_CXX03_LANG
    template <class _Up> using rebind = _Up*;
#else
# 151 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__memory/pointer_traits.h" 3
    template <class _Up> struct rebind {typedef _Up* other;};
#endif
# 153 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__memory/pointer_traits.h" 3

private:
    struct __nat {};
public:
    _LIBCPP_INLINE_VISIBILITY _LIBCPP_CONSTEXPR_SINCE_CXX20
    static pointer pointer_to(__conditional_t<is_void<element_type>::value, __nat, element_type>& __r) _NOEXCEPT
        {return _VSTD::addressof(__r);}
};

#ifndef _LIBCPP_CXX03_LANG
template <class _From, class _To>
using __rebind_pointer_t = typename pointer_traits<_From>::template rebind<_To>;
#else
# 166 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__memory/pointer_traits.h" 3
template <class _From, class _To>
using __rebind_pointer_t = typename pointer_traits<_From>::template rebind<_To>::other;
#endif
# 169 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__memory/pointer_traits.h" 3

// to_address

template <class _Pointer, class = void>
struct __to_address_helper;

template <class _Tp>
_LIBCPP_INLINE_VISIBILITY _LIBCPP_CONSTEXPR
_Tp* __to_address(_Tp* __p) _NOEXCEPT {
    static_assert(!is_function<_Tp>::value, "_Tp is a function type");
    return __p;
}

template <class _Pointer, class = void>
struct _HasToAddress : false_type {};

template <class _Pointer>
struct _HasToAddress<_Pointer,
    decltype((void)pointer_traits<_Pointer>::to_address(std::declval<const _Pointer&>()))
> : true_type {};

template <class _Pointer, class = void>
struct _HasArrow : false_type {};

template <class _Pointer>
struct _HasArrow<_Pointer,
    decltype((void)std::declval<const _Pointer&>().operator->())
> : true_type {};

template <class _Pointer>
struct _IsFancyPointer {
  static const bool value = _HasArrow<_Pointer>::value || _HasToAddress<_Pointer>::value;
};

// enable_if is needed here to avoid instantiating checks for fancy pointers on raw pointers
template <class _Pointer, class = __enable_if_t<
    _And<is_class<_Pointer>, _IsFancyPointer<_Pointer> >::value
> >
_LIBCPP_INLINE_VISIBILITY _LIBCPP_CONSTEXPR
__decay_t<decltype(__to_address_helper<_Pointer>::__call(std::declval<const _Pointer&>()))>
__to_address(const _Pointer& __p) _NOEXCEPT {
    return __to_address_helper<_Pointer>::__call(__p);
}

template <class _Pointer, class>
struct __to_address_helper {
    _LIBCPP_INLINE_VISIBILITY _LIBCPP_CONSTEXPR
    static decltype(_VSTD::__to_address(std::declval<const _Pointer&>().operator->()))
    __call(const _Pointer& __p) _NOEXCEPT {
        return _VSTD::__to_address(__p.operator->());
    }
};

template <class _Pointer>
struct __to_address_helper<_Pointer, decltype((void)pointer_traits<_Pointer>::to_address(std::declval<const _Pointer&>()))> {
    _LIBCPP_INLINE_VISIBILITY _LIBCPP_CONSTEXPR
    static decltype(pointer_traits<_Pointer>::to_address(std::declval<const _Pointer&>()))
    __call(const _Pointer& __p) _NOEXCEPT {
        return pointer_traits<_Pointer>::to_address(__p);
    }
};

#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 20
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 232 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__memory/pointer_traits.h" 3
template <class _Tp>
inline _LIBCPP_INLINE_VISIBILITY constexpr
auto to_address(_Tp *__p) noexcept {
    return _VSTD::__to_address(__p);
}

template <class _Pointer>
inline _LIBCPP_INLINE_VISIBILITY constexpr
auto to_address(const _Pointer& __p) noexcept -> decltype(std::__to_address(__p)) {
    return _VSTD::__to_address(__p);
}
#endif
# 244 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__memory/pointer_traits.h" 3

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___MEMORY_POINTER_TRAITS_H
# 248 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__memory/pointer_traits.h" 3
#endif /* pointer_traits.h expanded by -frewrite-includes */
# 35 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/concepts.h" 2 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/add_pointer.h>
#endif /* expanded by -frewrite-includes */
# 35 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/concepts.h" 3
# 36 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/concepts.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/common_reference.h>
#endif /* expanded by -frewrite-includes */
# 36 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/concepts.h" 3
# 37 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/concepts.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/is_pointer.h>
#endif /* expanded by -frewrite-includes */
# 37 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/concepts.h" 3
# 38 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/concepts.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/is_reference.h>
#endif /* expanded by -frewrite-includes */
# 38 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/concepts.h" 3
# 39 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/concepts.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/remove_cv.h>
#endif /* expanded by -frewrite-includes */
# 39 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/concepts.h" 3
# 40 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/concepts.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/remove_cvref.h>
#endif /* expanded by -frewrite-includes */
# 40 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/concepts.h" 3
# 41 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/concepts.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__utility/forward.h>
#endif /* expanded by -frewrite-includes */
# 41 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/concepts.h" 3
# 42 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/concepts.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 44 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/concepts.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 45 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/concepts.h" 3
#endif
# 46 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/concepts.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 20
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 50 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/concepts.h" 3

// [iterator.concept.readable]
template<class _In>
concept __indirectly_readable_impl =
  requires(const _In __i) {
    typename iter_value_t<_In>;
    typename iter_reference_t<_In>;
    typename iter_rvalue_reference_t<_In>;
    { *__i } -> same_as<iter_reference_t<_In>>;
    { ranges::iter_move(__i) } -> same_as<iter_rvalue_reference_t<_In>>;
  } &&
  common_reference_with<iter_reference_t<_In>&&, iter_value_t<_In>&> &&
  common_reference_with<iter_reference_t<_In>&&, iter_rvalue_reference_t<_In>&&> &&
  common_reference_with<iter_rvalue_reference_t<_In>&&, const iter_value_t<_In>&>;

template<class _In>
concept indirectly_readable = __indirectly_readable_impl<remove_cvref_t<_In>>;

template<indirectly_readable _Tp>
using iter_common_reference_t = common_reference_t<iter_reference_t<_Tp>, iter_value_t<_Tp>&>;

// [iterator.concept.writable]
template<class _Out, class _Tp>
concept indirectly_writable =
  requires(_Out&& __o, _Tp&& __t) {
    *__o = _VSTD::forward<_Tp>(__t);                        // not required to be equality-preserving
    *_VSTD::forward<_Out>(__o) = _VSTD::forward<_Tp>(__t);  // not required to be equality-preserving
    const_cast<const iter_reference_t<_Out>&&>(*__o) = _VSTD::forward<_Tp>(__t);                       // not required to be equality-preserving
    const_cast<const iter_reference_t<_Out>&&>(*_VSTD::forward<_Out>(__o)) = _VSTD::forward<_Tp>(__t); // not required to be equality-preserving
  };

// [iterator.concept.winc]
template<class _Tp>
concept __integer_like = integral<_Tp> && !same_as<_Tp, bool>;

template<class _Tp>
concept __signed_integer_like = signed_integral<_Tp>;

template<class _Ip>
concept weakly_incrementable =
  // TODO: remove this once the clang bug is fixed (bugs.llvm.org/PR48173).
  !same_as<_Ip, bool> && // Currently, clang does not handle bool correctly.
  movable<_Ip> &&
  requires(_Ip __i) {
    typename iter_difference_t<_Ip>;
    requires __signed_integer_like<iter_difference_t<_Ip>>;
    { ++__i } -> same_as<_Ip&>;   // not required to be equality-preserving
    __i++;                        // not required to be equality-preserving
  };

// [iterator.concept.inc]
template<class _Ip>
concept incrementable =
  regular<_Ip> &&
  weakly_incrementable<_Ip> &&
  requires(_Ip __i) {
    { __i++ } -> same_as<_Ip>;
  };

// [iterator.concept.iterator]
template<class _Ip>
concept input_or_output_iterator =
  requires(_Ip __i) {
    { *__i } -> __can_reference;
  } &&
  weakly_incrementable<_Ip>;

// [iterator.concept.sentinel]
template<class _Sp, class _Ip>
concept sentinel_for =
  semiregular<_Sp> &&
  input_or_output_iterator<_Ip> &&
  __weakly_equality_comparable_with<_Sp, _Ip>;

template<class, class>
inline constexpr bool disable_sized_sentinel_for = false;

template<class _Sp, class _Ip>
concept sized_sentinel_for =
  sentinel_for<_Sp, _Ip> &&
  !disable_sized_sentinel_for<remove_cv_t<_Sp>, remove_cv_t<_Ip>> &&
  requires(const _Ip& __i, const _Sp& __s) {
    { __s - __i } -> same_as<iter_difference_t<_Ip>>;
    { __i - __s } -> same_as<iter_difference_t<_Ip>>;
  };

// [iterator.concept.input]
template<class _Ip>
concept input_iterator =
  input_or_output_iterator<_Ip> &&
  indirectly_readable<_Ip> &&
  requires { typename _ITER_CONCEPT<_Ip>; } &&
  derived_from<_ITER_CONCEPT<_Ip>, input_iterator_tag>;

// [iterator.concept.output]
template<class _Ip, class _Tp>
concept output_iterator =
  input_or_output_iterator<_Ip> &&
  indirectly_writable<_Ip, _Tp> &&
  requires (_Ip __it, _Tp&& __t) {
    *__it++ = _VSTD::forward<_Tp>(__t); // not required to be equality-preserving
  };

// [iterator.concept.forward]
template<class _Ip>
concept forward_iterator =
  input_iterator<_Ip> &&
  derived_from<_ITER_CONCEPT<_Ip>, forward_iterator_tag> &&
  incrementable<_Ip> &&
  sentinel_for<_Ip, _Ip>;

// [iterator.concept.bidir]
template<class _Ip>
concept bidirectional_iterator =
  forward_iterator<_Ip> &&
  derived_from<_ITER_CONCEPT<_Ip>, bidirectional_iterator_tag> &&
  requires(_Ip __i) {
    { --__i } -> same_as<_Ip&>;
    { __i-- } -> same_as<_Ip>;
  };

template<class _Ip>
concept random_access_iterator =
  bidirectional_iterator<_Ip> &&
  derived_from<_ITER_CONCEPT<_Ip>, random_access_iterator_tag> &&
  totally_ordered<_Ip> &&
  sized_sentinel_for<_Ip, _Ip> &&
  requires(_Ip __i, const _Ip __j, const iter_difference_t<_Ip> __n) {
    { __i += __n } -> same_as<_Ip&>;
    { __j +  __n } -> same_as<_Ip>;
    { __n +  __j } -> same_as<_Ip>;
    { __i -= __n } -> same_as<_Ip&>;
    { __j -  __n } -> same_as<_Ip>;
    {  __j[__n]  } -> same_as<iter_reference_t<_Ip>>;
  };

template<class _Ip>
concept contiguous_iterator =
  random_access_iterator<_Ip> &&
  derived_from<_ITER_CONCEPT<_Ip>, contiguous_iterator_tag> &&
  is_lvalue_reference_v<iter_reference_t<_Ip>> &&
  same_as<iter_value_t<_Ip>, remove_cvref_t<iter_reference_t<_Ip>>> &&
  requires(const _Ip& __i) {
    { _VSTD::to_address(__i) } -> same_as<add_pointer_t<iter_reference_t<_Ip>>>;
  };

template<class _Ip>
concept __has_arrow = input_iterator<_Ip> && (is_pointer_v<_Ip> || requires(_Ip __i) { __i.operator->(); });

// [indirectcallable.indirectinvocable]
template<class _Fp, class _It>
concept indirectly_unary_invocable =
  indirectly_readable<_It> &&
  copy_constructible<_Fp> &&
  invocable<_Fp&, iter_value_t<_It>&> &&
  invocable<_Fp&, iter_reference_t<_It>> &&
  invocable<_Fp&, iter_common_reference_t<_It>> &&
  common_reference_with<
    invoke_result_t<_Fp&, iter_value_t<_It>&>,
    invoke_result_t<_Fp&, iter_reference_t<_It>>>;

template<class _Fp, class _It>
concept indirectly_regular_unary_invocable =
  indirectly_readable<_It> &&
  copy_constructible<_Fp> &&
  regular_invocable<_Fp&, iter_value_t<_It>&> &&
  regular_invocable<_Fp&, iter_reference_t<_It>> &&
  regular_invocable<_Fp&, iter_common_reference_t<_It>> &&
  common_reference_with<
    invoke_result_t<_Fp&, iter_value_t<_It>&>,
    invoke_result_t<_Fp&, iter_reference_t<_It>>>;

template<class _Fp, class _It>
concept indirect_unary_predicate =
  indirectly_readable<_It> &&
  copy_constructible<_Fp> &&
  predicate<_Fp&, iter_value_t<_It>&> &&
  predicate<_Fp&, iter_reference_t<_It>> &&
  predicate<_Fp&, iter_common_reference_t<_It>>;

template<class _Fp, class _It1, class _It2>
concept indirect_binary_predicate =
  indirectly_readable<_It1> && indirectly_readable<_It2> &&
  copy_constructible<_Fp> &&
  predicate<_Fp&, iter_value_t<_It1>&, iter_value_t<_It2>&> &&
  predicate<_Fp&, iter_value_t<_It1>&, iter_reference_t<_It2>> &&
  predicate<_Fp&, iter_reference_t<_It1>, iter_value_t<_It2>&> &&
  predicate<_Fp&, iter_reference_t<_It1>, iter_reference_t<_It2>> &&
  predicate<_Fp&, iter_common_reference_t<_It1>, iter_common_reference_t<_It2>>;

template<class _Fp, class _It1, class _It2 = _It1>
concept indirect_equivalence_relation =
  indirectly_readable<_It1> && indirectly_readable<_It2> &&
  copy_constructible<_Fp> &&
  equivalence_relation<_Fp&, iter_value_t<_It1>&, iter_value_t<_It2>&> &&
  equivalence_relation<_Fp&, iter_value_t<_It1>&, iter_reference_t<_It2>> &&
  equivalence_relation<_Fp&, iter_reference_t<_It1>, iter_value_t<_It2>&> &&
  equivalence_relation<_Fp&, iter_reference_t<_It1>, iter_reference_t<_It2>> &&
  equivalence_relation<_Fp&, iter_common_reference_t<_It1>, iter_common_reference_t<_It2>>;

template<class _Fp, class _It1, class _It2 = _It1>
concept indirect_strict_weak_order =
  indirectly_readable<_It1> && indirectly_readable<_It2> &&
  copy_constructible<_Fp> &&
  strict_weak_order<_Fp&, iter_value_t<_It1>&, iter_value_t<_It2>&> &&
  strict_weak_order<_Fp&, iter_value_t<_It1>&, iter_reference_t<_It2>> &&
  strict_weak_order<_Fp&, iter_reference_t<_It1>, iter_value_t<_It2>&> &&
  strict_weak_order<_Fp&, iter_reference_t<_It1>, iter_reference_t<_It2>> &&
  strict_weak_order<_Fp&, iter_common_reference_t<_It1>, iter_common_reference_t<_It2>>;

template<class _Fp, class... _Its>
  requires (indirectly_readable<_Its> && ...) && invocable<_Fp, iter_reference_t<_Its>...>
using indirect_result_t = invoke_result_t<_Fp, iter_reference_t<_Its>...>;

template<class _In, class _Out>
concept indirectly_movable =
  indirectly_readable<_In> &&
  indirectly_writable<_Out, iter_rvalue_reference_t<_In>>;

template<class _In, class _Out>
concept indirectly_movable_storable =
  indirectly_movable<_In, _Out> &&
  indirectly_writable<_Out, iter_value_t<_In>> &&
  movable<iter_value_t<_In>> &&
  constructible_from<iter_value_t<_In>, iter_rvalue_reference_t<_In>> &&
  assignable_from<iter_value_t<_In>&, iter_rvalue_reference_t<_In>>;

template<class _In, class _Out>
concept indirectly_copyable =
  indirectly_readable<_In> &&
  indirectly_writable<_Out, iter_reference_t<_In>>;

template<class _In, class _Out>
concept indirectly_copyable_storable =
  indirectly_copyable<_In, _Out> &&
  indirectly_writable<_Out, iter_value_t<_In>&> &&
  indirectly_writable<_Out, const iter_value_t<_In>&> &&
  indirectly_writable<_Out, iter_value_t<_In>&&> &&
  indirectly_writable<_Out, const iter_value_t<_In>&&> &&
  copyable<iter_value_t<_In>> &&
  constructible_from<iter_value_t<_In>, iter_reference_t<_In>> &&
  assignable_from<iter_value_t<_In>&, iter_reference_t<_In>>;

// Note: indirectly_swappable is located in iter_swap.h to prevent a dependency cycle
// (both iter_swap and indirectly_swappable require indirectly_readable).

#endif // _LIBCPP_STD_VER >= 20
# 297 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/concepts.h" 3

template <class _Tp>
using __has_random_access_iterator_category_or_concept
#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 20
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 301 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/concepts.h" 3
  = integral_constant<bool, random_access_iterator<_Tp>>;
#else   // _LIBCPP_STD_VER < 20
# 303 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/concepts.h" 3
  = __has_random_access_iterator_category<_Tp>;
#endif  // _LIBCPP_STD_VER
# 305 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/concepts.h" 3

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___ITERATOR_CONCEPTS_H
# 309 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/concepts.h" 3
#endif /* concepts.h expanded by -frewrite-includes */
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/advance.h" 2 3
#if 0 /* expanded by -frewrite-includes */
#include <__iterator/incrementable_traits.h>
#endif /* expanded by -frewrite-includes */
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/advance.h" 3
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/advance.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__iterator/iterator_traits.h>
#endif /* expanded by -frewrite-includes */
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/advance.h" 3
# 20 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/advance.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/enable_if.h>
#endif /* expanded by -frewrite-includes */
# 20 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/advance.h" 3
# 21 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/advance.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/is_integral.h>
#endif /* expanded by -frewrite-includes */
# 21 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/advance.h" 3
# 22 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/advance.h" 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* convert_to_integral.h expanded by -frewrite-includes */
#include <__utility/convert_to_integral.h>
#else /* convert_to_integral.h expanded by -frewrite-includes */
# 22 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/advance.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/convert_to_integral.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___UTILITY_CONVERT_TO_INTEGRAL_H
#define _LIBCPP___UTILITY_CONVERT_TO_INTEGRAL_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/convert_to_integral.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/convert_to_integral.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/enable_if.h>
#endif /* expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/convert_to_integral.h" 3
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/convert_to_integral.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/is_enum.h>
#endif /* expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/convert_to_integral.h" 3
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/convert_to_integral.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/is_floating_point.h>
#endif /* expanded by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/convert_to_integral.h" 3
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/convert_to_integral.h" 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* underlying_type.h expanded by -frewrite-includes */
#include <__type_traits/underlying_type.h>
#else /* underlying_type.h expanded by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/convert_to_integral.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/underlying_type.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___TYPE_TRAITS_UNDERLYING_TYPE_H
#define _LIBCPP___TYPE_TRAITS_UNDERLYING_TYPE_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/underlying_type.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/underlying_type.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/is_enum.h>
#endif /* expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/underlying_type.h" 3
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/underlying_type.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/underlying_type.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/underlying_type.h" 3
#endif
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/underlying_type.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

template <class _Tp, bool = is_enum<_Tp>::value>
struct __underlying_type_impl;

template <class _Tp>
struct __underlying_type_impl<_Tp, false> {};

template <class _Tp>
struct __underlying_type_impl<_Tp, true> {
  typedef __underlying_type(_Tp) type;
};

template <class _Tp>
struct underlying_type : __underlying_type_impl<_Tp, is_enum<_Tp>::value> {};

#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 14
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 36 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/underlying_type.h" 3
template <class _Tp>
using underlying_type_t = typename underlying_type<_Tp>::type;
#endif
# 39 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/underlying_type.h" 3

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___TYPE_TRAITS_UNDERLYING_TYPE_H
# 43 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/underlying_type.h" 3
#endif /* underlying_type.h expanded by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/convert_to_integral.h" 2 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/convert_to_integral.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 20 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/convert_to_integral.h" 3
#endif
# 21 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/convert_to_integral.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

inline _LIBCPP_INLINE_VISIBILITY _LIBCPP_CONSTEXPR
int __convert_to_integral(int __val) { return __val; }

inline _LIBCPP_INLINE_VISIBILITY _LIBCPP_CONSTEXPR
unsigned __convert_to_integral(unsigned __val) { return __val; }

inline _LIBCPP_INLINE_VISIBILITY _LIBCPP_CONSTEXPR
long __convert_to_integral(long __val) { return __val; }

inline _LIBCPP_INLINE_VISIBILITY _LIBCPP_CONSTEXPR
unsigned long __convert_to_integral(unsigned long __val) { return __val; }

inline _LIBCPP_INLINE_VISIBILITY _LIBCPP_CONSTEXPR
long long __convert_to_integral(long long __val) { return __val; }

inline _LIBCPP_INLINE_VISIBILITY _LIBCPP_CONSTEXPR
unsigned long long __convert_to_integral(unsigned long long __val) {return __val; }

template<typename _Fp, __enable_if_t<is_floating_point<_Fp>::value, int> = 0>
inline _LIBCPP_INLINE_VISIBILITY _LIBCPP_CONSTEXPR
long long
 __convert_to_integral(_Fp __val) { return __val; }

#ifndef _LIBCPP_HAS_NO_INT128
inline _LIBCPP_INLINE_VISIBILITY _LIBCPP_CONSTEXPR
__int128_t __convert_to_integral(__int128_t __val) { return __val; }

inline _LIBCPP_INLINE_VISIBILITY _LIBCPP_CONSTEXPR
__uint128_t __convert_to_integral(__uint128_t __val) { return __val; }
#endif
# 54 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/convert_to_integral.h" 3

template <class _Tp, bool = is_enum<_Tp>::value>
struct __sfinae_underlying_type
{
    typedef typename underlying_type<_Tp>::type type;
    typedef decltype(((type)1) + 0) __promoted_type;
};

template <class _Tp>
struct __sfinae_underlying_type<_Tp, false> {};

template <class _Tp>
inline _LIBCPP_INLINE_VISIBILITY _LIBCPP_CONSTEXPR
typename __sfinae_underlying_type<_Tp>::__promoted_type
__convert_to_integral(_Tp __val) { return __val; }

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___UTILITY_CONVERT_TO_INTEGRAL_H
# 73 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/convert_to_integral.h" 3
#endif /* convert_to_integral.h expanded by -frewrite-includes */
# 23 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/advance.h" 2 3
#if 0 /* expanded by -frewrite-includes */
#include <__utility/declval.h>
#endif /* expanded by -frewrite-includes */
# 23 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/advance.h" 3
# 24 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/advance.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__utility/move.h>
#endif /* expanded by -frewrite-includes */
# 24 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/advance.h" 3
# 25 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/advance.h" 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* unreachable.h expanded by -frewrite-includes */
#include <__utility/unreachable.h>
#else /* unreachable.h expanded by -frewrite-includes */
# 25 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/advance.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/unreachable.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___UTILITY_UNREACHABLE_H
#define _LIBCPP___UTILITY_UNREACHABLE_H

#if 0 /* expanded by -frewrite-includes */
#include <__assert>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/unreachable.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/unreachable.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/unreachable.h" 3
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/unreachable.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/unreachable.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/unreachable.h" 3
#endif
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/unreachable.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

_LIBCPP_NORETURN _LIBCPP_HIDE_FROM_ABI inline void __libcpp_unreachable() {
    _LIBCPP_ASSERT_UNCATEGORIZED(false, "std::unreachable() was reached");
    __builtin_unreachable();
}

#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 23
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 27 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/unreachable.h" 3

[[noreturn]] _LIBCPP_HIDE_FROM_ABI inline void unreachable() { __libcpp_unreachable(); }

#endif
# 31 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/unreachable.h" 3

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___UTILITY_UNREACHABLE_H
# 35 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/unreachable.h" 3
#endif /* unreachable.h expanded by -frewrite-includes */
# 26 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/advance.h" 2 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* limits expanded by -frewrite-includes */
#include <limits>
#else /* limits expanded by -frewrite-includes */
# 26 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/advance.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/limits" 1 3
// -*- C++ -*-
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP_LIMITS
#define _LIBCPP_LIMITS

/*
    limits synopsis

namespace std
{

template<class T>
class numeric_limits
{
public:
    static constexpr bool is_specialized = false;
    static constexpr T min() noexcept;
    static constexpr T max() noexcept;
    static constexpr T lowest() noexcept;

    static constexpr int  digits = 0;
    static constexpr int  digits10 = 0;
    static constexpr int  max_digits10 = 0;
    static constexpr bool is_signed = false;
    static constexpr bool is_integer = false;
    static constexpr bool is_exact = false;
    static constexpr int  radix = 0;
    static constexpr T epsilon() noexcept;
    static constexpr T round_error() noexcept;

    static constexpr int  min_exponent = 0;
    static constexpr int  min_exponent10 = 0;
    static constexpr int  max_exponent = 0;
    static constexpr int  max_exponent10 = 0;

    static constexpr bool has_infinity = false;
    static constexpr bool has_quiet_NaN = false;
    static constexpr bool has_signaling_NaN = false;
    static constexpr float_denorm_style has_denorm = denorm_absent; // deprecated in C++23
    static constexpr bool has_denorm_loss = false;                  // deprecated in C++23
    static constexpr T infinity() noexcept;
    static constexpr T quiet_NaN() noexcept;
    static constexpr T signaling_NaN() noexcept;
    static constexpr T denorm_min() noexcept;

    static constexpr bool is_iec559 = false;
    static constexpr bool is_bounded = false;
    static constexpr bool is_modulo = false;

    static constexpr bool traps = false;
    static constexpr bool tinyness_before = false;
    static constexpr float_round_style round_style = round_toward_zero;
};

enum float_round_style
{
    round_indeterminate       = -1,
    round_toward_zero         =  0,
    round_to_nearest          =  1,
    round_toward_infinity     =  2,
    round_toward_neg_infinity =  3
};

enum float_denorm_style // deprecated in C++23
{
    denorm_indeterminate = -1,
    denorm_absent = 0,
    denorm_present = 1
};

template<> class numeric_limits<cv bool>;

template<> class numeric_limits<cv char>;
template<> class numeric_limits<cv signed char>;
template<> class numeric_limits<cv unsigned char>;
template<> class numeric_limits<cv wchar_t>;
template<> class numeric_limits<cv char8_t>; // C++20
template<> class numeric_limits<cv char16_t>;
template<> class numeric_limits<cv char32_t>;

template<> class numeric_limits<cv short>;
template<> class numeric_limits<cv int>;
template<> class numeric_limits<cv long>;
template<> class numeric_limits<cv long long>;
template<> class numeric_limits<cv unsigned short>;
template<> class numeric_limits<cv unsigned int>;
template<> class numeric_limits<cv unsigned long>;
template<> class numeric_limits<cv unsigned long long>;

template<> class numeric_limits<cv float>;
template<> class numeric_limits<cv double>;
template<> class numeric_limits<cv long double>;

}  // std

*/

#if 0 /* expanded by -frewrite-includes */
#include <__assert> // all public C++ headers provide the assertion handler
#endif /* expanded by -frewrite-includes */
# 105 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/limits" 3
# 106 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/limits" 3
#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 106 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/limits" 3
# 107 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/limits" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/is_arithmetic.h>
#endif /* expanded by -frewrite-includes */
# 107 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/limits" 3
# 108 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/limits" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/is_signed.h>
#endif /* expanded by -frewrite-includes */
# 108 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/limits" 3
# 109 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/limits" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/remove_cv.h>
#endif /* expanded by -frewrite-includes */
# 109 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/limits" 3
# 110 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/limits" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 112 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/limits" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 113 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/limits" 3
#endif
# 114 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/limits" 3

_LIBCPP_PUSH_MACROS
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* __undef_macros expanded by -frewrite-includes */
#include <__undef_macros>
#else /* __undef_macros expanded by -frewrite-includes */
# 116 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/limits" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__undef_macros" 1 3
// -*- C++ -*-
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifdef min
#  undef min
#endif
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__undef_macros" 3

#ifdef max
#  undef max
#endif
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__undef_macros" 3

#ifdef refresh
#  undef refresh
#endif
# 21 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__undef_macros" 3

#ifdef move
#  undef move
#endif
# 25 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__undef_macros" 3

#ifdef erase
#  undef erase
#endif
# 29 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__undef_macros" 3
#endif /* __undef_macros expanded by -frewrite-includes */
# 117 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/limits" 2 3
#if 0 /* expanded by -frewrite-includes */
#include <version>
#endif /* expanded by -frewrite-includes */
# 117 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/limits" 3
# 118 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/limits" 3


_LIBCPP_BEGIN_NAMESPACE_STD

enum float_round_style
{
    round_indeterminate       = -1,
    round_toward_zero         =  0,
    round_to_nearest          =  1,
    round_toward_infinity     =  2,
    round_toward_neg_infinity =  3
};

enum _LIBCPP_DEPRECATED_IN_CXX23 float_denorm_style
{
    denorm_indeterminate = -1,
    denorm_absent = 0,
    denorm_present = 1
};

template <class _Tp, bool = is_arithmetic<_Tp>::value>
class __libcpp_numeric_limits
{
protected:
    typedef _Tp type;

    static _LIBCPP_CONSTEXPR const  bool is_specialized = false;
    _LIBCPP_INLINE_VISIBILITY static _LIBCPP_CONSTEXPR type min() _NOEXCEPT {return type();}
    _LIBCPP_INLINE_VISIBILITY static _LIBCPP_CONSTEXPR type max() _NOEXCEPT {return type();}
    _LIBCPP_INLINE_VISIBILITY static _LIBCPP_CONSTEXPR type lowest() _NOEXCEPT {return type();}

    static _LIBCPP_CONSTEXPR const int  digits = 0;
    static _LIBCPP_CONSTEXPR const int  digits10 = 0;
    static _LIBCPP_CONSTEXPR const int  max_digits10 = 0;
    static _LIBCPP_CONSTEXPR const bool is_signed = false;
    static _LIBCPP_CONSTEXPR const bool is_integer = false;
    static _LIBCPP_CONSTEXPR const bool is_exact = false;
    static _LIBCPP_CONSTEXPR const int  radix = 0;
    _LIBCPP_INLINE_VISIBILITY static _LIBCPP_CONSTEXPR type epsilon() _NOEXCEPT {return type();}
    _LIBCPP_INLINE_VISIBILITY static _LIBCPP_CONSTEXPR type round_error() _NOEXCEPT {return type();}

    static _LIBCPP_CONSTEXPR const int  min_exponent = 0;
    static _LIBCPP_CONSTEXPR const int  min_exponent10 = 0;
    static _LIBCPP_CONSTEXPR const int  max_exponent = 0;
    static _LIBCPP_CONSTEXPR const int  max_exponent10 = 0;

    static _LIBCPP_CONSTEXPR const bool has_infinity = false;
    static _LIBCPP_CONSTEXPR const bool has_quiet_NaN = false;
    static _LIBCPP_CONSTEXPR const bool has_signaling_NaN = false;
    static _LIBCPP_DEPRECATED_IN_CXX23 _LIBCPP_CONSTEXPR const float_denorm_style has_denorm = denorm_absent;
    static _LIBCPP_DEPRECATED_IN_CXX23 _LIBCPP_CONSTEXPR const bool has_denorm_loss = false;
    _LIBCPP_INLINE_VISIBILITY static _LIBCPP_CONSTEXPR type infinity() _NOEXCEPT {return type();}
    _LIBCPP_INLINE_VISIBILITY static _LIBCPP_CONSTEXPR type quiet_NaN() _NOEXCEPT {return type();}
    _LIBCPP_INLINE_VISIBILITY static _LIBCPP_CONSTEXPR type signaling_NaN() _NOEXCEPT {return type();}
    _LIBCPP_INLINE_VISIBILITY static _LIBCPP_CONSTEXPR type denorm_min() _NOEXCEPT {return type();}

    static _LIBCPP_CONSTEXPR const bool is_iec559 = false;
    static _LIBCPP_CONSTEXPR const bool is_bounded = false;
    static _LIBCPP_CONSTEXPR const bool is_modulo = false;

    static _LIBCPP_CONSTEXPR const bool traps = false;
    static _LIBCPP_CONSTEXPR const bool tinyness_before = false;
    static _LIBCPP_CONSTEXPR const float_round_style round_style = round_toward_zero;
};

template <class _Tp, int __digits, bool _IsSigned>
struct __libcpp_compute_min
{
    static _LIBCPP_CONSTEXPR const _Tp value = _Tp(_Tp(1) << __digits);
};

template <class _Tp, int __digits>
struct __libcpp_compute_min<_Tp, __digits, false>
{
    static _LIBCPP_CONSTEXPR const _Tp value = _Tp(0);
};

template <class _Tp>
class __libcpp_numeric_limits<_Tp, true>
{
protected:
    typedef _Tp type;

    static _LIBCPP_CONSTEXPR const bool is_specialized = true;

    static _LIBCPP_CONSTEXPR const bool is_signed = type(-1) < type(0);
    static _LIBCPP_CONSTEXPR const int  digits = static_cast<int>(sizeof(type) * __CHAR_BIT__ - is_signed);
    static _LIBCPP_CONSTEXPR const int  digits10 = digits * 3 / 10;
    static _LIBCPP_CONSTEXPR const int  max_digits10 = 0;
    static _LIBCPP_CONSTEXPR const type __min = __libcpp_compute_min<type, digits, is_signed>::value;
    static _LIBCPP_CONSTEXPR const type __max = is_signed ? type(type(~0) ^ __min) : type(~0);
    _LIBCPP_INLINE_VISIBILITY static _LIBCPP_CONSTEXPR type min() _NOEXCEPT {return __min;}
    _LIBCPP_INLINE_VISIBILITY static _LIBCPP_CONSTEXPR type max() _NOEXCEPT {return __max;}
    _LIBCPP_INLINE_VISIBILITY static _LIBCPP_CONSTEXPR type lowest() _NOEXCEPT {return min();}

    static _LIBCPP_CONSTEXPR const bool is_integer = true;
    static _LIBCPP_CONSTEXPR const bool is_exact = true;
    static _LIBCPP_CONSTEXPR const int  radix = 2;
    _LIBCPP_INLINE_VISIBILITY static _LIBCPP_CONSTEXPR type epsilon() _NOEXCEPT {return type(0);}
    _LIBCPP_INLINE_VISIBILITY static _LIBCPP_CONSTEXPR type round_error() _NOEXCEPT {return type(0);}

    static _LIBCPP_CONSTEXPR const int  min_exponent = 0;
    static _LIBCPP_CONSTEXPR const int  min_exponent10 = 0;
    static _LIBCPP_CONSTEXPR const int  max_exponent = 0;
    static _LIBCPP_CONSTEXPR const int  max_exponent10 = 0;

    static _LIBCPP_CONSTEXPR const bool has_infinity = false;
    static _LIBCPP_CONSTEXPR const bool has_quiet_NaN = false;
    static _LIBCPP_CONSTEXPR const bool has_signaling_NaN = false;
    static _LIBCPP_DEPRECATED_IN_CXX23 _LIBCPP_CONSTEXPR const float_denorm_style has_denorm = denorm_absent;
    static _LIBCPP_DEPRECATED_IN_CXX23 _LIBCPP_CONSTEXPR const bool has_denorm_loss = false;
    _LIBCPP_INLINE_VISIBILITY static _LIBCPP_CONSTEXPR type infinity() _NOEXCEPT {return type(0);}
    _LIBCPP_INLINE_VISIBILITY static _LIBCPP_CONSTEXPR type quiet_NaN() _NOEXCEPT {return type(0);}
    _LIBCPP_INLINE_VISIBILITY static _LIBCPP_CONSTEXPR type signaling_NaN() _NOEXCEPT {return type(0);}
    _LIBCPP_INLINE_VISIBILITY static _LIBCPP_CONSTEXPR type denorm_min() _NOEXCEPT {return type(0);}

    static _LIBCPP_CONSTEXPR const bool is_iec559 = false;
    static _LIBCPP_CONSTEXPR const bool is_bounded = true;
    static _LIBCPP_CONSTEXPR const bool is_modulo = !_VSTD::is_signed<_Tp>::value;

#if 0 /* disabled by -frewrite-includes */
#if defined(__i386__) || defined(__x86_64__) || defined(__pnacl__) || \
    defined(__wasm__)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 240 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/limits" 3
    static _LIBCPP_CONSTEXPR const bool traps = true;
#else
# 242 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/limits" 3
    static _LIBCPP_CONSTEXPR const bool traps = false;
#endif
# 244 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/limits" 3
    static _LIBCPP_CONSTEXPR const bool tinyness_before = false;
    static _LIBCPP_CONSTEXPR const float_round_style round_style = round_toward_zero;
};

template <>
class __libcpp_numeric_limits<bool, true>
{
protected:
    typedef bool type;

    static _LIBCPP_CONSTEXPR const bool is_specialized = true;

    static _LIBCPP_CONSTEXPR const bool is_signed = false;
    static _LIBCPP_CONSTEXPR const int  digits = 1;
    static _LIBCPP_CONSTEXPR const int  digits10 = 0;
    static _LIBCPP_CONSTEXPR const int  max_digits10 = 0;
    static _LIBCPP_CONSTEXPR const type __min = false;
    static _LIBCPP_CONSTEXPR const type __max = true;
    _LIBCPP_INLINE_VISIBILITY static _LIBCPP_CONSTEXPR type min() _NOEXCEPT {return __min;}
    _LIBCPP_INLINE_VISIBILITY static _LIBCPP_CONSTEXPR type max() _NOEXCEPT {return __max;}
    _LIBCPP_INLINE_VISIBILITY static _LIBCPP_CONSTEXPR type lowest() _NOEXCEPT {return min();}

    static _LIBCPP_CONSTEXPR const bool is_integer = true;
    static _LIBCPP_CONSTEXPR const bool is_exact = true;
    static _LIBCPP_CONSTEXPR const int  radix = 2;
    _LIBCPP_INLINE_VISIBILITY static _LIBCPP_CONSTEXPR type epsilon() _NOEXCEPT {return type(0);}
    _LIBCPP_INLINE_VISIBILITY static _LIBCPP_CONSTEXPR type round_error() _NOEXCEPT {return type(0);}

    static _LIBCPP_CONSTEXPR const int  min_exponent = 0;
    static _LIBCPP_CONSTEXPR const int  min_exponent10 = 0;
    static _LIBCPP_CONSTEXPR const int  max_exponent = 0;
    static _LIBCPP_CONSTEXPR const int  max_exponent10 = 0;

    static _LIBCPP_CONSTEXPR const bool has_infinity = false;
    static _LIBCPP_CONSTEXPR const bool has_quiet_NaN = false;
    static _LIBCPP_CONSTEXPR const bool has_signaling_NaN = false;
    static _LIBCPP_DEPRECATED_IN_CXX23 _LIBCPP_CONSTEXPR const float_denorm_style has_denorm = denorm_absent;
    static _LIBCPP_DEPRECATED_IN_CXX23 _LIBCPP_CONSTEXPR const bool has_denorm_loss = false;
    _LIBCPP_INLINE_VISIBILITY static _LIBCPP_CONSTEXPR type infinity() _NOEXCEPT {return type(0);}
    _LIBCPP_INLINE_VISIBILITY static _LIBCPP_CONSTEXPR type quiet_NaN() _NOEXCEPT {return type(0);}
    _LIBCPP_INLINE_VISIBILITY static _LIBCPP_CONSTEXPR type signaling_NaN() _NOEXCEPT {return type(0);}
    _LIBCPP_INLINE_VISIBILITY static _LIBCPP_CONSTEXPR type denorm_min() _NOEXCEPT {return type(0);}

    static _LIBCPP_CONSTEXPR const bool is_iec559 = false;
    static _LIBCPP_CONSTEXPR const bool is_bounded = true;
    static _LIBCPP_CONSTEXPR const bool is_modulo = false;

    static _LIBCPP_CONSTEXPR const bool traps = false;
    static _LIBCPP_CONSTEXPR const bool tinyness_before = false;
    static _LIBCPP_CONSTEXPR const float_round_style round_style = round_toward_zero;
};

template <>
class __libcpp_numeric_limits<float, true>
{
protected:
    typedef float type;

    static _LIBCPP_CONSTEXPR const bool is_specialized = true;

    static _LIBCPP_CONSTEXPR const bool is_signed = true;
    static _LIBCPP_CONSTEXPR const int  digits = __FLT_MANT_DIG__;
    static _LIBCPP_CONSTEXPR const int  digits10 = __FLT_DIG__;
    static _LIBCPP_CONSTEXPR const int  max_digits10 = 2+(digits * 30103l)/100000l;
    _LIBCPP_INLINE_VISIBILITY static _LIBCPP_CONSTEXPR type min() _NOEXCEPT {return __FLT_MIN__;}
    _LIBCPP_INLINE_VISIBILITY static _LIBCPP_CONSTEXPR type max() _NOEXCEPT {return __FLT_MAX__;}
    _LIBCPP_INLINE_VISIBILITY static _LIBCPP_CONSTEXPR type lowest() _NOEXCEPT {return -max();}

    static _LIBCPP_CONSTEXPR const bool is_integer = false;
    static _LIBCPP_CONSTEXPR const bool is_exact = false;
    static _LIBCPP_CONSTEXPR const int  radix = __FLT_RADIX__;
    _LIBCPP_INLINE_VISIBILITY static _LIBCPP_CONSTEXPR type epsilon() _NOEXCEPT {return __FLT_EPSILON__;}
    _LIBCPP_INLINE_VISIBILITY static _LIBCPP_CONSTEXPR type round_error() _NOEXCEPT {return 0.5F;}

    static _LIBCPP_CONSTEXPR const int  min_exponent = __FLT_MIN_EXP__;
    static _LIBCPP_CONSTEXPR const int  min_exponent10 = __FLT_MIN_10_EXP__;
    static _LIBCPP_CONSTEXPR const int  max_exponent = __FLT_MAX_EXP__;
    static _LIBCPP_CONSTEXPR const int  max_exponent10 = __FLT_MAX_10_EXP__;

    static _LIBCPP_CONSTEXPR const bool has_infinity = true;
    static _LIBCPP_CONSTEXPR const bool has_quiet_NaN = true;
    static _LIBCPP_CONSTEXPR const bool has_signaling_NaN = true;
    static _LIBCPP_DEPRECATED_IN_CXX23 _LIBCPP_CONSTEXPR const float_denorm_style has_denorm = denorm_present;
    static _LIBCPP_DEPRECATED_IN_CXX23 _LIBCPP_CONSTEXPR const bool has_denorm_loss = false;
    _LIBCPP_INLINE_VISIBILITY static _LIBCPP_CONSTEXPR type infinity() _NOEXCEPT {return __builtin_huge_valf();}
    _LIBCPP_INLINE_VISIBILITY static _LIBCPP_CONSTEXPR type quiet_NaN() _NOEXCEPT {return __builtin_nanf("");}
    _LIBCPP_INLINE_VISIBILITY static _LIBCPP_CONSTEXPR type signaling_NaN() _NOEXCEPT {return __builtin_nansf("");}
    _LIBCPP_INLINE_VISIBILITY static _LIBCPP_CONSTEXPR type denorm_min() _NOEXCEPT {return __FLT_DENORM_MIN__;}

    static _LIBCPP_CONSTEXPR const bool is_iec559 = true;
    static _LIBCPP_CONSTEXPR const bool is_bounded = true;
    static _LIBCPP_CONSTEXPR const bool is_modulo = false;

    static _LIBCPP_CONSTEXPR const bool traps = false;
#if 0 /* disabled by -frewrite-includes */
#if (defined(__arm__) || defined(__aarch64__))
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 339 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/limits" 3
    static _LIBCPP_CONSTEXPR const bool tinyness_before = true;
#else
# 341 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/limits" 3
    static _LIBCPP_CONSTEXPR const bool tinyness_before = false;
#endif
# 343 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/limits" 3
    static _LIBCPP_CONSTEXPR const float_round_style round_style = round_to_nearest;
};

template <>
class __libcpp_numeric_limits<double, true>
{
protected:
    typedef double type;

    static _LIBCPP_CONSTEXPR const bool is_specialized = true;

    static _LIBCPP_CONSTEXPR const bool is_signed = true;
    static _LIBCPP_CONSTEXPR const int  digits = __DBL_MANT_DIG__;
    static _LIBCPP_CONSTEXPR const int  digits10 = __DBL_DIG__;
    static _LIBCPP_CONSTEXPR const int  max_digits10 = 2+(digits * 30103l)/100000l;
    _LIBCPP_INLINE_VISIBILITY static _LIBCPP_CONSTEXPR type min() _NOEXCEPT {return __DBL_MIN__;}
    _LIBCPP_INLINE_VISIBILITY static _LIBCPP_CONSTEXPR type max() _NOEXCEPT {return __DBL_MAX__;}
    _LIBCPP_INLINE_VISIBILITY static _LIBCPP_CONSTEXPR type lowest() _NOEXCEPT {return -max();}

    static _LIBCPP_CONSTEXPR const bool is_integer = false;
    static _LIBCPP_CONSTEXPR const bool is_exact = false;
    static _LIBCPP_CONSTEXPR const int  radix = __FLT_RADIX__;
    _LIBCPP_INLINE_VISIBILITY static _LIBCPP_CONSTEXPR type epsilon() _NOEXCEPT {return __DBL_EPSILON__;}
    _LIBCPP_INLINE_VISIBILITY static _LIBCPP_CONSTEXPR type round_error() _NOEXCEPT {return 0.5;}

    static _LIBCPP_CONSTEXPR const int  min_exponent = __DBL_MIN_EXP__;
    static _LIBCPP_CONSTEXPR const int  min_exponent10 = __DBL_MIN_10_EXP__;
    static _LIBCPP_CONSTEXPR const int  max_exponent = __DBL_MAX_EXP__;
    static _LIBCPP_CONSTEXPR const int  max_exponent10 = __DBL_MAX_10_EXP__;

    static _LIBCPP_CONSTEXPR const bool has_infinity = true;
    static _LIBCPP_CONSTEXPR const bool has_quiet_NaN = true;
    static _LIBCPP_CONSTEXPR const bool has_signaling_NaN = true;
    static _LIBCPP_DEPRECATED_IN_CXX23 _LIBCPP_CONSTEXPR const float_denorm_style has_denorm = denorm_present;
    static _LIBCPP_DEPRECATED_IN_CXX23 _LIBCPP_CONSTEXPR const bool has_denorm_loss = false;
    _LIBCPP_INLINE_VISIBILITY static _LIBCPP_CONSTEXPR type infinity() _NOEXCEPT {return __builtin_huge_val();}
    _LIBCPP_INLINE_VISIBILITY static _LIBCPP_CONSTEXPR type quiet_NaN() _NOEXCEPT {return __builtin_nan("");}
    _LIBCPP_INLINE_VISIBILITY static _LIBCPP_CONSTEXPR type signaling_NaN() _NOEXCEPT {return __builtin_nans("");}
    _LIBCPP_INLINE_VISIBILITY static _LIBCPP_CONSTEXPR type denorm_min() _NOEXCEPT {return __DBL_DENORM_MIN__;}

    static _LIBCPP_CONSTEXPR const bool is_iec559 = true;
    static _LIBCPP_CONSTEXPR const bool is_bounded = true;
    static _LIBCPP_CONSTEXPR const bool is_modulo = false;

    static _LIBCPP_CONSTEXPR const bool traps = false;
#if 0 /* disabled by -frewrite-includes */
#if (defined(__arm__) || defined(__aarch64__))
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 389 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/limits" 3
    static _LIBCPP_CONSTEXPR const bool tinyness_before = true;
#else
# 391 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/limits" 3
    static _LIBCPP_CONSTEXPR const bool tinyness_before = false;
#endif
# 393 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/limits" 3
    static _LIBCPP_CONSTEXPR const float_round_style round_style = round_to_nearest;
};

template <>
class __libcpp_numeric_limits<long double, true>
{
protected:
    typedef long double type;

    static _LIBCPP_CONSTEXPR const bool is_specialized = true;

    static _LIBCPP_CONSTEXPR const bool is_signed = true;
    static _LIBCPP_CONSTEXPR const int  digits = __LDBL_MANT_DIG__;
    static _LIBCPP_CONSTEXPR const int  digits10 = __LDBL_DIG__;
    static _LIBCPP_CONSTEXPR const int  max_digits10 = 2+(digits * 30103l)/100000l;
    _LIBCPP_INLINE_VISIBILITY static _LIBCPP_CONSTEXPR type min() _NOEXCEPT {return __LDBL_MIN__;}
    _LIBCPP_INLINE_VISIBILITY static _LIBCPP_CONSTEXPR type max() _NOEXCEPT {return __LDBL_MAX__;}
    _LIBCPP_INLINE_VISIBILITY static _LIBCPP_CONSTEXPR type lowest() _NOEXCEPT {return -max();}

    static _LIBCPP_CONSTEXPR const bool is_integer = false;
    static _LIBCPP_CONSTEXPR const bool is_exact = false;
    static _LIBCPP_CONSTEXPR const int  radix = __FLT_RADIX__;
    _LIBCPP_INLINE_VISIBILITY static _LIBCPP_CONSTEXPR type epsilon() _NOEXCEPT {return __LDBL_EPSILON__;}
    _LIBCPP_INLINE_VISIBILITY static _LIBCPP_CONSTEXPR type round_error() _NOEXCEPT {return 0.5L;}

    static _LIBCPP_CONSTEXPR const int  min_exponent = __LDBL_MIN_EXP__;
    static _LIBCPP_CONSTEXPR const int  min_exponent10 = __LDBL_MIN_10_EXP__;
    static _LIBCPP_CONSTEXPR const int  max_exponent = __LDBL_MAX_EXP__;
    static _LIBCPP_CONSTEXPR const int  max_exponent10 = __LDBL_MAX_10_EXP__;

    static _LIBCPP_CONSTEXPR const bool has_infinity = true;
    static _LIBCPP_CONSTEXPR const bool has_quiet_NaN = true;
    static _LIBCPP_CONSTEXPR const bool has_signaling_NaN = true;
    static _LIBCPP_DEPRECATED_IN_CXX23 _LIBCPP_CONSTEXPR const float_denorm_style has_denorm = denorm_present;
    static _LIBCPP_DEPRECATED_IN_CXX23 _LIBCPP_CONSTEXPR const bool has_denorm_loss = false;
    _LIBCPP_INLINE_VISIBILITY static _LIBCPP_CONSTEXPR type infinity() _NOEXCEPT {return __builtin_huge_vall();}
    _LIBCPP_INLINE_VISIBILITY static _LIBCPP_CONSTEXPR type quiet_NaN() _NOEXCEPT {return __builtin_nanl("");}
    _LIBCPP_INLINE_VISIBILITY static _LIBCPP_CONSTEXPR type signaling_NaN() _NOEXCEPT {return __builtin_nansl("");}
    _LIBCPP_INLINE_VISIBILITY static _LIBCPP_CONSTEXPR type denorm_min() _NOEXCEPT {return __LDBL_DENORM_MIN__;}

#if 0 /* disabled by -frewrite-includes */
#if defined(__powerpc__) && defined(__LONG_DOUBLE_IBM128__)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 434 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/limits" 3
    static _LIBCPP_CONSTEXPR const bool is_iec559 = false;
#else
# 436 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/limits" 3
    static _LIBCPP_CONSTEXPR const bool is_iec559 = true;
#endif
# 438 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/limits" 3
    static _LIBCPP_CONSTEXPR const bool is_bounded = true;
    static _LIBCPP_CONSTEXPR const bool is_modulo = false;

    static _LIBCPP_CONSTEXPR const bool traps = false;
#if 0 /* disabled by -frewrite-includes */
#if (defined(__arm__) || defined(__aarch64__))
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 443 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/limits" 3
    static _LIBCPP_CONSTEXPR const bool tinyness_before = true;
#else
# 445 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/limits" 3
    static _LIBCPP_CONSTEXPR const bool tinyness_before = false;
#endif
# 447 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/limits" 3
    static _LIBCPP_CONSTEXPR const float_round_style round_style = round_to_nearest;
};

template <class _Tp>
class _LIBCPP_TEMPLATE_VIS numeric_limits
    : private __libcpp_numeric_limits<__remove_cv_t<_Tp> >
{
    typedef __libcpp_numeric_limits<__remove_cv_t<_Tp> > __base;
    typedef typename __base::type type;
public:
    static _LIBCPP_CONSTEXPR const bool is_specialized = __base::is_specialized;
    _LIBCPP_INLINE_VISIBILITY static _LIBCPP_CONSTEXPR type min() _NOEXCEPT {return __base::min();}
    _LIBCPP_INLINE_VISIBILITY static _LIBCPP_CONSTEXPR type max() _NOEXCEPT {return __base::max();}
    _LIBCPP_INLINE_VISIBILITY static _LIBCPP_CONSTEXPR type lowest() _NOEXCEPT {return __base::lowest();}

    static _LIBCPP_CONSTEXPR const int  digits = __base::digits;
    static _LIBCPP_CONSTEXPR const int  digits10 = __base::digits10;
    static _LIBCPP_CONSTEXPR const int  max_digits10 = __base::max_digits10;
    static _LIBCPP_CONSTEXPR const bool is_signed = __base::is_signed;
    static _LIBCPP_CONSTEXPR const bool is_integer = __base::is_integer;
    static _LIBCPP_CONSTEXPR const bool is_exact = __base::is_exact;
    static _LIBCPP_CONSTEXPR const int  radix = __base::radix;
    _LIBCPP_INLINE_VISIBILITY static _LIBCPP_CONSTEXPR type epsilon() _NOEXCEPT {return __base::epsilon();}
    _LIBCPP_INLINE_VISIBILITY static _LIBCPP_CONSTEXPR type round_error() _NOEXCEPT {return __base::round_error();}

    static _LIBCPP_CONSTEXPR const int  min_exponent = __base::min_exponent;
    static _LIBCPP_CONSTEXPR const int  min_exponent10 = __base::min_exponent10;
    static _LIBCPP_CONSTEXPR const int  max_exponent = __base::max_exponent;
    static _LIBCPP_CONSTEXPR const int  max_exponent10 = __base::max_exponent10;

    static _LIBCPP_CONSTEXPR const bool has_infinity = __base::has_infinity;
    static _LIBCPP_CONSTEXPR const bool has_quiet_NaN = __base::has_quiet_NaN;
    static _LIBCPP_CONSTEXPR const bool has_signaling_NaN = __base::has_signaling_NaN;
_LIBCPP_SUPPRESS_DEPRECATED_PUSH
    static _LIBCPP_DEPRECATED_IN_CXX23 _LIBCPP_CONSTEXPR const float_denorm_style has_denorm = __base::has_denorm;
    static _LIBCPP_DEPRECATED_IN_CXX23 _LIBCPP_CONSTEXPR const bool has_denorm_loss = __base::has_denorm_loss;
_LIBCPP_SUPPRESS_DEPRECATED_POP
    _LIBCPP_INLINE_VISIBILITY static _LIBCPP_CONSTEXPR type infinity() _NOEXCEPT {return __base::infinity();}
    _LIBCPP_INLINE_VISIBILITY static _LIBCPP_CONSTEXPR type quiet_NaN() _NOEXCEPT {return __base::quiet_NaN();}
    _LIBCPP_INLINE_VISIBILITY static _LIBCPP_CONSTEXPR type signaling_NaN() _NOEXCEPT {return __base::signaling_NaN();}
    _LIBCPP_INLINE_VISIBILITY static _LIBCPP_CONSTEXPR type denorm_min() _NOEXCEPT {return __base::denorm_min();}

    static _LIBCPP_CONSTEXPR const bool is_iec559 = __base::is_iec559;
    static _LIBCPP_CONSTEXPR const bool is_bounded = __base::is_bounded;
    static _LIBCPP_CONSTEXPR const bool is_modulo = __base::is_modulo;

    static _LIBCPP_CONSTEXPR const bool traps = __base::traps;
    static _LIBCPP_CONSTEXPR const bool tinyness_before = __base::tinyness_before;
    static _LIBCPP_CONSTEXPR const float_round_style round_style = __base::round_style;
};

template <class _Tp>
    _LIBCPP_CONSTEXPR const bool numeric_limits<_Tp>::is_specialized;
template <class _Tp>
    _LIBCPP_CONSTEXPR const int numeric_limits<_Tp>::digits;
template <class _Tp>
    _LIBCPP_CONSTEXPR const int numeric_limits<_Tp>::digits10;
template <class _Tp>
    _LIBCPP_CONSTEXPR const int numeric_limits<_Tp>::max_digits10;
template <class _Tp>
    _LIBCPP_CONSTEXPR const bool numeric_limits<_Tp>::is_signed;
template <class _Tp>
    _LIBCPP_CONSTEXPR const bool numeric_limits<_Tp>::is_integer;
template <class _Tp>
    _LIBCPP_CONSTEXPR const bool numeric_limits<_Tp>::is_exact;
template <class _Tp>
    _LIBCPP_CONSTEXPR const int numeric_limits<_Tp>::radix;
template <class _Tp>
    _LIBCPP_CONSTEXPR const int numeric_limits<_Tp>::min_exponent;
template <class _Tp>
    _LIBCPP_CONSTEXPR const int numeric_limits<_Tp>::min_exponent10;
template <class _Tp>
    _LIBCPP_CONSTEXPR const int numeric_limits<_Tp>::max_exponent;
template <class _Tp>
    _LIBCPP_CONSTEXPR const int numeric_limits<_Tp>::max_exponent10;
template <class _Tp>
    _LIBCPP_CONSTEXPR const bool numeric_limits<_Tp>::has_infinity;
template <class _Tp>
    _LIBCPP_CONSTEXPR const bool numeric_limits<_Tp>::has_quiet_NaN;
template <class _Tp>
    _LIBCPP_CONSTEXPR const bool numeric_limits<_Tp>::has_signaling_NaN;
template <class _Tp>
    _LIBCPP_CONSTEXPR const float_denorm_style numeric_limits<_Tp>::has_denorm;
template <class _Tp>
    _LIBCPP_CONSTEXPR const bool numeric_limits<_Tp>::has_denorm_loss;
template <class _Tp>
    _LIBCPP_CONSTEXPR const bool numeric_limits<_Tp>::is_iec559;
template <class _Tp>
    _LIBCPP_CONSTEXPR const bool numeric_limits<_Tp>::is_bounded;
template <class _Tp>
    _LIBCPP_CONSTEXPR const bool numeric_limits<_Tp>::is_modulo;
template <class _Tp>
    _LIBCPP_CONSTEXPR const bool numeric_limits<_Tp>::traps;
template <class _Tp>
    _LIBCPP_CONSTEXPR const bool numeric_limits<_Tp>::tinyness_before;
template <class _Tp>
    _LIBCPP_CONSTEXPR const float_round_style numeric_limits<_Tp>::round_style;

template <class _Tp>
class _LIBCPP_TEMPLATE_VIS numeric_limits<const _Tp>
    : private numeric_limits<_Tp>
{
    typedef numeric_limits<_Tp> __base;
    typedef _Tp type;
public:
    static _LIBCPP_CONSTEXPR const bool is_specialized = __base::is_specialized;
    _LIBCPP_INLINE_VISIBILITY static _LIBCPP_CONSTEXPR type min() _NOEXCEPT {return __base::min();}
    _LIBCPP_INLINE_VISIBILITY static _LIBCPP_CONSTEXPR type max() _NOEXCEPT {return __base::max();}
    _LIBCPP_INLINE_VISIBILITY static _LIBCPP_CONSTEXPR type lowest() _NOEXCEPT {return __base::lowest();}

    static _LIBCPP_CONSTEXPR const int  digits = __base::digits;
    static _LIBCPP_CONSTEXPR const int  digits10 = __base::digits10;
    static _LIBCPP_CONSTEXPR const int  max_digits10 = __base::max_digits10;
    static _LIBCPP_CONSTEXPR const bool is_signed = __base::is_signed;
    static _LIBCPP_CONSTEXPR const bool is_integer = __base::is_integer;
    static _LIBCPP_CONSTEXPR const bool is_exact = __base::is_exact;
    static _LIBCPP_CONSTEXPR const int  radix = __base::radix;
    _LIBCPP_INLINE_VISIBILITY static _LIBCPP_CONSTEXPR type epsilon() _NOEXCEPT {return __base::epsilon();}
    _LIBCPP_INLINE_VISIBILITY static _LIBCPP_CONSTEXPR type round_error() _NOEXCEPT {return __base::round_error();}

    static _LIBCPP_CONSTEXPR const int  min_exponent = __base::min_exponent;
    static _LIBCPP_CONSTEXPR const int  min_exponent10 = __base::min_exponent10;
    static _LIBCPP_CONSTEXPR const int  max_exponent = __base::max_exponent;
    static _LIBCPP_CONSTEXPR const int  max_exponent10 = __base::max_exponent10;

    static _LIBCPP_CONSTEXPR const bool has_infinity = __base::has_infinity;
    static _LIBCPP_CONSTEXPR const bool has_quiet_NaN = __base::has_quiet_NaN;
    static _LIBCPP_CONSTEXPR const bool has_signaling_NaN = __base::has_signaling_NaN;
_LIBCPP_SUPPRESS_DEPRECATED_PUSH
    static _LIBCPP_DEPRECATED_IN_CXX23 _LIBCPP_CONSTEXPR const float_denorm_style has_denorm = __base::has_denorm;
    static _LIBCPP_DEPRECATED_IN_CXX23 _LIBCPP_CONSTEXPR const bool has_denorm_loss = __base::has_denorm_loss;
_LIBCPP_SUPPRESS_DEPRECATED_POP
    _LIBCPP_INLINE_VISIBILITY static _LIBCPP_CONSTEXPR type infinity() _NOEXCEPT {return __base::infinity();}
    _LIBCPP_INLINE_VISIBILITY static _LIBCPP_CONSTEXPR type quiet_NaN() _NOEXCEPT {return __base::quiet_NaN();}
    _LIBCPP_INLINE_VISIBILITY static _LIBCPP_CONSTEXPR type signaling_NaN() _NOEXCEPT {return __base::signaling_NaN();}
    _LIBCPP_INLINE_VISIBILITY static _LIBCPP_CONSTEXPR type denorm_min() _NOEXCEPT {return __base::denorm_min();}

    static _LIBCPP_CONSTEXPR const bool is_iec559 = __base::is_iec559;
    static _LIBCPP_CONSTEXPR const bool is_bounded = __base::is_bounded;
    static _LIBCPP_CONSTEXPR const bool is_modulo = __base::is_modulo;

    static _LIBCPP_CONSTEXPR const bool traps = __base::traps;
    static _LIBCPP_CONSTEXPR const bool tinyness_before = __base::tinyness_before;
    static _LIBCPP_CONSTEXPR const float_round_style round_style = __base::round_style;
};

template <class _Tp>
    _LIBCPP_CONSTEXPR const bool numeric_limits<const _Tp>::is_specialized;
template <class _Tp>
    _LIBCPP_CONSTEXPR const int numeric_limits<const _Tp>::digits;
template <class _Tp>
    _LIBCPP_CONSTEXPR const int numeric_limits<const _Tp>::digits10;
template <class _Tp>
    _LIBCPP_CONSTEXPR const int numeric_limits<const _Tp>::max_digits10;
template <class _Tp>
    _LIBCPP_CONSTEXPR const bool numeric_limits<const _Tp>::is_signed;
template <class _Tp>
    _LIBCPP_CONSTEXPR const bool numeric_limits<const _Tp>::is_integer;
template <class _Tp>
    _LIBCPP_CONSTEXPR const bool numeric_limits<const _Tp>::is_exact;
template <class _Tp>
    _LIBCPP_CONSTEXPR const int numeric_limits<const _Tp>::radix;
template <class _Tp>
    _LIBCPP_CONSTEXPR const int numeric_limits<const _Tp>::min_exponent;
template <class _Tp>
    _LIBCPP_CONSTEXPR const int numeric_limits<const _Tp>::min_exponent10;
template <class _Tp>
    _LIBCPP_CONSTEXPR const int numeric_limits<const _Tp>::max_exponent;
template <class _Tp>
    _LIBCPP_CONSTEXPR const int numeric_limits<const _Tp>::max_exponent10;
template <class _Tp>
    _LIBCPP_CONSTEXPR const bool numeric_limits<const _Tp>::has_infinity;
template <class _Tp>
    _LIBCPP_CONSTEXPR const bool numeric_limits<const _Tp>::has_quiet_NaN;
template <class _Tp>
    _LIBCPP_CONSTEXPR const bool numeric_limits<const _Tp>::has_signaling_NaN;
template <class _Tp>
    _LIBCPP_CONSTEXPR const float_denorm_style numeric_limits<const _Tp>::has_denorm;
template <class _Tp>
    _LIBCPP_CONSTEXPR const bool numeric_limits<const _Tp>::has_denorm_loss;
template <class _Tp>
    _LIBCPP_CONSTEXPR const bool numeric_limits<const _Tp>::is_iec559;
template <class _Tp>
    _LIBCPP_CONSTEXPR const bool numeric_limits<const _Tp>::is_bounded;
template <class _Tp>
    _LIBCPP_CONSTEXPR const bool numeric_limits<const _Tp>::is_modulo;
template <class _Tp>
    _LIBCPP_CONSTEXPR const bool numeric_limits<const _Tp>::traps;
template <class _Tp>
    _LIBCPP_CONSTEXPR const bool numeric_limits<const _Tp>::tinyness_before;
template <class _Tp>
    _LIBCPP_CONSTEXPR const float_round_style numeric_limits<const _Tp>::round_style;

template <class _Tp>
class _LIBCPP_TEMPLATE_VIS numeric_limits<volatile _Tp>
    : private numeric_limits<_Tp>
{
    typedef numeric_limits<_Tp> __base;
    typedef _Tp type;
public:
    static _LIBCPP_CONSTEXPR const bool is_specialized = __base::is_specialized;
    _LIBCPP_INLINE_VISIBILITY static _LIBCPP_CONSTEXPR type min() _NOEXCEPT {return __base::min();}
    _LIBCPP_INLINE_VISIBILITY static _LIBCPP_CONSTEXPR type max() _NOEXCEPT {return __base::max();}
    _LIBCPP_INLINE_VISIBILITY static _LIBCPP_CONSTEXPR type lowest() _NOEXCEPT {return __base::lowest();}

    static _LIBCPP_CONSTEXPR const int  digits = __base::digits;
    static _LIBCPP_CONSTEXPR const int  digits10 = __base::digits10;
    static _LIBCPP_CONSTEXPR const int  max_digits10 = __base::max_digits10;
    static _LIBCPP_CONSTEXPR const bool is_signed = __base::is_signed;
    static _LIBCPP_CONSTEXPR const bool is_integer = __base::is_integer;
    static _LIBCPP_CONSTEXPR const bool is_exact = __base::is_exact;
    static _LIBCPP_CONSTEXPR const int  radix = __base::radix;
    _LIBCPP_INLINE_VISIBILITY static _LIBCPP_CONSTEXPR type epsilon() _NOEXCEPT {return __base::epsilon();}
    _LIBCPP_INLINE_VISIBILITY static _LIBCPP_CONSTEXPR type round_error() _NOEXCEPT {return __base::round_error();}

    static _LIBCPP_CONSTEXPR const int  min_exponent = __base::min_exponent;
    static _LIBCPP_CONSTEXPR const int  min_exponent10 = __base::min_exponent10;
    static _LIBCPP_CONSTEXPR const int  max_exponent = __base::max_exponent;
    static _LIBCPP_CONSTEXPR const int  max_exponent10 = __base::max_exponent10;

    static _LIBCPP_CONSTEXPR const bool has_infinity = __base::has_infinity;
    static _LIBCPP_CONSTEXPR const bool has_quiet_NaN = __base::has_quiet_NaN;
    static _LIBCPP_CONSTEXPR const bool has_signaling_NaN = __base::has_signaling_NaN;
_LIBCPP_SUPPRESS_DEPRECATED_PUSH
    static _LIBCPP_DEPRECATED_IN_CXX23 _LIBCPP_CONSTEXPR const float_denorm_style has_denorm = __base::has_denorm;
    static _LIBCPP_DEPRECATED_IN_CXX23 _LIBCPP_CONSTEXPR const bool has_denorm_loss = __base::has_denorm_loss;
_LIBCPP_SUPPRESS_DEPRECATED_POP
    _LIBCPP_INLINE_VISIBILITY static _LIBCPP_CONSTEXPR type infinity() _NOEXCEPT {return __base::infinity();}
    _LIBCPP_INLINE_VISIBILITY static _LIBCPP_CONSTEXPR type quiet_NaN() _NOEXCEPT {return __base::quiet_NaN();}
    _LIBCPP_INLINE_VISIBILITY static _LIBCPP_CONSTEXPR type signaling_NaN() _NOEXCEPT {return __base::signaling_NaN();}
    _LIBCPP_INLINE_VISIBILITY static _LIBCPP_CONSTEXPR type denorm_min() _NOEXCEPT {return __base::denorm_min();}

    static _LIBCPP_CONSTEXPR const bool is_iec559 = __base::is_iec559;
    static _LIBCPP_CONSTEXPR const bool is_bounded = __base::is_bounded;
    static _LIBCPP_CONSTEXPR const bool is_modulo = __base::is_modulo;

    static _LIBCPP_CONSTEXPR const bool traps = __base::traps;
    static _LIBCPP_CONSTEXPR const bool tinyness_before = __base::tinyness_before;
    static _LIBCPP_CONSTEXPR const float_round_style round_style = __base::round_style;
};

template <class _Tp>
    _LIBCPP_CONSTEXPR const bool numeric_limits<volatile _Tp>::is_specialized;
template <class _Tp>
    _LIBCPP_CONSTEXPR const int numeric_limits<volatile _Tp>::digits;
template <class _Tp>
    _LIBCPP_CONSTEXPR const int numeric_limits<volatile _Tp>::digits10;
template <class _Tp>
    _LIBCPP_CONSTEXPR const int numeric_limits<volatile _Tp>::max_digits10;
template <class _Tp>
    _LIBCPP_CONSTEXPR const bool numeric_limits<volatile _Tp>::is_signed;
template <class _Tp>
    _LIBCPP_CONSTEXPR const bool numeric_limits<volatile _Tp>::is_integer;
template <class _Tp>
    _LIBCPP_CONSTEXPR const bool numeric_limits<volatile _Tp>::is_exact;
template <class _Tp>
    _LIBCPP_CONSTEXPR const int numeric_limits<volatile _Tp>::radix;
template <class _Tp>
    _LIBCPP_CONSTEXPR const int numeric_limits<volatile _Tp>::min_exponent;
template <class _Tp>
    _LIBCPP_CONSTEXPR const int numeric_limits<volatile _Tp>::min_exponent10;
template <class _Tp>
    _LIBCPP_CONSTEXPR const int numeric_limits<volatile _Tp>::max_exponent;
template <class _Tp>
    _LIBCPP_CONSTEXPR const int numeric_limits<volatile _Tp>::max_exponent10;
template <class _Tp>
    _LIBCPP_CONSTEXPR const bool numeric_limits<volatile _Tp>::has_infinity;
template <class _Tp>
    _LIBCPP_CONSTEXPR const bool numeric_limits<volatile _Tp>::has_quiet_NaN;
template <class _Tp>
    _LIBCPP_CONSTEXPR const bool numeric_limits<volatile _Tp>::has_signaling_NaN;
template <class _Tp>
    _LIBCPP_CONSTEXPR const float_denorm_style numeric_limits<volatile _Tp>::has_denorm;
template <class _Tp>
    _LIBCPP_CONSTEXPR const bool numeric_limits<volatile _Tp>::has_denorm_loss;
template <class _Tp>
    _LIBCPP_CONSTEXPR const bool numeric_limits<volatile _Tp>::is_iec559;
template <class _Tp>
    _LIBCPP_CONSTEXPR const bool numeric_limits<volatile _Tp>::is_bounded;
template <class _Tp>
    _LIBCPP_CONSTEXPR const bool numeric_limits<volatile _Tp>::is_modulo;
template <class _Tp>
    _LIBCPP_CONSTEXPR const bool numeric_limits<volatile _Tp>::traps;
template <class _Tp>
    _LIBCPP_CONSTEXPR const bool numeric_limits<volatile _Tp>::tinyness_before;
template <class _Tp>
    _LIBCPP_CONSTEXPR const float_round_style numeric_limits<volatile _Tp>::round_style;

template <class _Tp>
class _LIBCPP_TEMPLATE_VIS numeric_limits<const volatile _Tp>
    : private numeric_limits<_Tp>
{
    typedef numeric_limits<_Tp> __base;
    typedef _Tp type;
public:
    static _LIBCPP_CONSTEXPR const bool is_specialized = __base::is_specialized;
    _LIBCPP_INLINE_VISIBILITY static _LIBCPP_CONSTEXPR type min() _NOEXCEPT {return __base::min();}
    _LIBCPP_INLINE_VISIBILITY static _LIBCPP_CONSTEXPR type max() _NOEXCEPT {return __base::max();}
    _LIBCPP_INLINE_VISIBILITY static _LIBCPP_CONSTEXPR type lowest() _NOEXCEPT {return __base::lowest();}

    static _LIBCPP_CONSTEXPR const int  digits = __base::digits;
    static _LIBCPP_CONSTEXPR const int  digits10 = __base::digits10;
    static _LIBCPP_CONSTEXPR const int  max_digits10 = __base::max_digits10;
    static _LIBCPP_CONSTEXPR const bool is_signed = __base::is_signed;
    static _LIBCPP_CONSTEXPR const bool is_integer = __base::is_integer;
    static _LIBCPP_CONSTEXPR const bool is_exact = __base::is_exact;
    static _LIBCPP_CONSTEXPR const int  radix = __base::radix;
    _LIBCPP_INLINE_VISIBILITY static _LIBCPP_CONSTEXPR type epsilon() _NOEXCEPT {return __base::epsilon();}
    _LIBCPP_INLINE_VISIBILITY static _LIBCPP_CONSTEXPR type round_error() _NOEXCEPT {return __base::round_error();}

    static _LIBCPP_CONSTEXPR const int  min_exponent = __base::min_exponent;
    static _LIBCPP_CONSTEXPR const int  min_exponent10 = __base::min_exponent10;
    static _LIBCPP_CONSTEXPR const int  max_exponent = __base::max_exponent;
    static _LIBCPP_CONSTEXPR const int  max_exponent10 = __base::max_exponent10;

    static _LIBCPP_CONSTEXPR const bool has_infinity = __base::has_infinity;
    static _LIBCPP_CONSTEXPR const bool has_quiet_NaN = __base::has_quiet_NaN;
    static _LIBCPP_CONSTEXPR const bool has_signaling_NaN = __base::has_signaling_NaN;
_LIBCPP_SUPPRESS_DEPRECATED_PUSH
    static _LIBCPP_DEPRECATED_IN_CXX23 _LIBCPP_CONSTEXPR const float_denorm_style has_denorm = __base::has_denorm;
    static _LIBCPP_DEPRECATED_IN_CXX23 _LIBCPP_CONSTEXPR const bool has_denorm_loss = __base::has_denorm_loss;
_LIBCPP_SUPPRESS_DEPRECATED_POP
    _LIBCPP_INLINE_VISIBILITY static _LIBCPP_CONSTEXPR type infinity() _NOEXCEPT {return __base::infinity();}
    _LIBCPP_INLINE_VISIBILITY static _LIBCPP_CONSTEXPR type quiet_NaN() _NOEXCEPT {return __base::quiet_NaN();}
    _LIBCPP_INLINE_VISIBILITY static _LIBCPP_CONSTEXPR type signaling_NaN() _NOEXCEPT {return __base::signaling_NaN();}
    _LIBCPP_INLINE_VISIBILITY static _LIBCPP_CONSTEXPR type denorm_min() _NOEXCEPT {return __base::denorm_min();}

    static _LIBCPP_CONSTEXPR const bool is_iec559 = __base::is_iec559;
    static _LIBCPP_CONSTEXPR const bool is_bounded = __base::is_bounded;
    static _LIBCPP_CONSTEXPR const bool is_modulo = __base::is_modulo;

    static _LIBCPP_CONSTEXPR const bool traps = __base::traps;
    static _LIBCPP_CONSTEXPR const bool tinyness_before = __base::tinyness_before;
    static _LIBCPP_CONSTEXPR const float_round_style round_style = __base::round_style;
};

template <class _Tp>
    _LIBCPP_CONSTEXPR const bool numeric_limits<const volatile _Tp>::is_specialized;
template <class _Tp>
    _LIBCPP_CONSTEXPR const int numeric_limits<const volatile _Tp>::digits;
template <class _Tp>
    _LIBCPP_CONSTEXPR const int numeric_limits<const volatile _Tp>::digits10;
template <class _Tp>
    _LIBCPP_CONSTEXPR const int numeric_limits<const volatile _Tp>::max_digits10;
template <class _Tp>
    _LIBCPP_CONSTEXPR const bool numeric_limits<const volatile _Tp>::is_signed;
template <class _Tp>
    _LIBCPP_CONSTEXPR const bool numeric_limits<const volatile _Tp>::is_integer;
template <class _Tp>
    _LIBCPP_CONSTEXPR const bool numeric_limits<const volatile _Tp>::is_exact;
template <class _Tp>
    _LIBCPP_CONSTEXPR const int numeric_limits<const volatile _Tp>::radix;
template <class _Tp>
    _LIBCPP_CONSTEXPR const int numeric_limits<const volatile _Tp>::min_exponent;
template <class _Tp>
    _LIBCPP_CONSTEXPR const int numeric_limits<const volatile _Tp>::min_exponent10;
template <class _Tp>
    _LIBCPP_CONSTEXPR const int numeric_limits<const volatile _Tp>::max_exponent;
template <class _Tp>
    _LIBCPP_CONSTEXPR const int numeric_limits<const volatile _Tp>::max_exponent10;
template <class _Tp>
    _LIBCPP_CONSTEXPR const bool numeric_limits<const volatile _Tp>::has_infinity;
template <class _Tp>
    _LIBCPP_CONSTEXPR const bool numeric_limits<const volatile _Tp>::has_quiet_NaN;
template <class _Tp>
    _LIBCPP_CONSTEXPR const bool numeric_limits<const volatile _Tp>::has_signaling_NaN;
template <class _Tp>
    _LIBCPP_CONSTEXPR const float_denorm_style numeric_limits<const volatile _Tp>::has_denorm;
template <class _Tp>
    _LIBCPP_CONSTEXPR const bool numeric_limits<const volatile _Tp>::has_denorm_loss;
template <class _Tp>
    _LIBCPP_CONSTEXPR const bool numeric_limits<const volatile _Tp>::is_iec559;
template <class _Tp>
    _LIBCPP_CONSTEXPR const bool numeric_limits<const volatile _Tp>::is_bounded;
template <class _Tp>
    _LIBCPP_CONSTEXPR const bool numeric_limits<const volatile _Tp>::is_modulo;
template <class _Tp>
    _LIBCPP_CONSTEXPR const bool numeric_limits<const volatile _Tp>::traps;
template <class _Tp>
    _LIBCPP_CONSTEXPR const bool numeric_limits<const volatile _Tp>::tinyness_before;
template <class _Tp>
    _LIBCPP_CONSTEXPR const float_round_style numeric_limits<const volatile _Tp>::round_style;

_LIBCPP_END_NAMESPACE_STD

_LIBCPP_POP_MACROS

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_REMOVE_TRANSITIVE_INCLUDES) && _LIBCPP_STD_VER <= 20
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 835 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/limits" 3
#if 0 /* expanded by -frewrite-includes */
#  include <type_traits>
#endif /* expanded by -frewrite-includes */
# 835 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/limits" 3
# 836 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/limits" 3
#endif
# 837 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/limits" 3

#endif // _LIBCPP_LIMITS
# 839 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/limits" 3
#endif /* limits expanded by -frewrite-includes */
# 27 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/advance.h" 2 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 29 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/advance.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 30 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/advance.h" 3
#endif
# 31 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/advance.h" 3

_LIBCPP_PUSH_MACROS
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* __undef_macros expanded by -frewrite-includes */
#include <__undef_macros>
#else /* __undef_macros expanded by -frewrite-includes */
# 33 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/advance.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__undef_macros" 1 3
// -*- C++ -*-
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifdef min
#  undef min
#endif
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__undef_macros" 3

#ifdef max
#  undef max
#endif
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__undef_macros" 3

#ifdef refresh
#  undef refresh
#endif
# 21 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__undef_macros" 3

#ifdef move
#  undef move
#endif
# 25 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__undef_macros" 3

#ifdef erase
#  undef erase
#endif
# 29 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__undef_macros" 3
#endif /* __undef_macros expanded by -frewrite-includes */
# 34 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/advance.h" 2 3

_LIBCPP_BEGIN_NAMESPACE_STD

template <class _InputIter>
_LIBCPP_HIDE_FROM_ABI _LIBCPP_CONSTEXPR_SINCE_CXX17
void __advance(_InputIter& __i, typename iterator_traits<_InputIter>::difference_type __n, input_iterator_tag) {
  for (; __n > 0; --__n)
    ++__i;
}

template <class _BiDirIter>
_LIBCPP_HIDE_FROM_ABI _LIBCPP_CONSTEXPR_SINCE_CXX17
void __advance(_BiDirIter& __i, typename iterator_traits<_BiDirIter>::difference_type __n, bidirectional_iterator_tag) {
  if (__n >= 0)
    for (; __n > 0; --__n)
      ++__i;
  else
    for (; __n < 0; ++__n)
      --__i;
}

template <class _RandIter>
_LIBCPP_HIDE_FROM_ABI _LIBCPP_CONSTEXPR_SINCE_CXX17
void __advance(_RandIter& __i, typename iterator_traits<_RandIter>::difference_type __n, random_access_iterator_tag) {
  __i += __n;
}

template <
    class _InputIter, class _Distance,
    class _IntegralDistance = decltype(_VSTD::__convert_to_integral(std::declval<_Distance>())),
    class = __enable_if_t<is_integral<_IntegralDistance>::value> >
_LIBCPP_HIDE_FROM_ABI _LIBCPP_CONSTEXPR_SINCE_CXX17
void advance(_InputIter& __i, _Distance __orig_n) {
  typedef typename iterator_traits<_InputIter>::difference_type _Difference;
  _Difference __n = static_cast<_Difference>(_VSTD::__convert_to_integral(__orig_n));
  _LIBCPP_ASSERT_UNCATEGORIZED(__n >= 0 || __has_bidirectional_iterator_category<_InputIter>::value,
                               "Attempt to advance(it, n) with negative n on a non-bidirectional iterator");
  _VSTD::__advance(__i, __n, typename iterator_traits<_InputIter>::iterator_category());
}

#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 20
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 75 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/advance.h" 3

// [range.iter.op.advance]

namespace ranges {
namespace __advance {

struct __fn {
private:
  template <class _Ip>
  _LIBCPP_HIDE_FROM_ABI
  static constexpr void __advance_forward(_Ip& __i, iter_difference_t<_Ip> __n) {
    while (__n > 0) {
      --__n;
      ++__i;
    }
  }

  template <class _Ip>
  _LIBCPP_HIDE_FROM_ABI
  static constexpr void __advance_backward(_Ip& __i, iter_difference_t<_Ip> __n) {
    while (__n < 0) {
      ++__n;
      --__i;
    }
  }

public:
  // Preconditions: If `I` does not model `bidirectional_iterator`, `n` is not negative.
  template <input_or_output_iterator _Ip>
  _LIBCPP_HIDE_FROM_ABI
  constexpr void operator()(_Ip& __i, iter_difference_t<_Ip> __n) const {
    _LIBCPP_ASSERT_UNCATEGORIZED(__n >= 0 || bidirectional_iterator<_Ip>,
                                 "If `n < 0`, then `bidirectional_iterator<I>` must be true.");

    // If `I` models `random_access_iterator`, equivalent to `i += n`.
    if constexpr (random_access_iterator<_Ip>) {
      __i += __n;
      return;
    } else if constexpr (bidirectional_iterator<_Ip>) {
      // Otherwise, if `n` is non-negative, increments `i` by `n`.
      __advance_forward(__i, __n);
      // Otherwise, decrements `i` by `-n`.
      __advance_backward(__i, __n);
      return;
    } else {
      // Otherwise, if `n` is non-negative, increments `i` by `n`.
      __advance_forward(__i, __n);
      return;
    }
  }

  // Preconditions: Either `assignable_from<I&, S> || sized_sentinel_for<S, I>` is modeled, or [i, bound_sentinel) denotes a range.
  template <input_or_output_iterator _Ip, sentinel_for<_Ip> _Sp>
  _LIBCPP_HIDE_FROM_ABI constexpr void operator()(_Ip& __i, _Sp __bound_sentinel) const {
    // If `I` and `S` model `assignable_from<I&, S>`, equivalent to `i = std::move(bound_sentinel)`.
    if constexpr (assignable_from<_Ip&, _Sp>) {
      __i = _VSTD::move(__bound_sentinel);
    }
    // Otherwise, if `S` and `I` model `sized_sentinel_for<S, I>`, equivalent to `ranges::advance(i, bound_sentinel - i)`.
    else if constexpr (sized_sentinel_for<_Sp, _Ip>) {
      (*this)(__i, __bound_sentinel - __i);
    }
    // Otherwise, while `bool(i != bound_sentinel)` is true, increments `i`.
    else {
      while (__i != __bound_sentinel) {
        ++__i;
      }
    }
  }

  // Preconditions:
  //   * If `n > 0`, [i, bound_sentinel) denotes a range.
  //   * If `n == 0`, [i, bound_sentinel) or [bound_sentinel, i) denotes a range.
  //   * If `n < 0`, [bound_sentinel, i) denotes a range, `I` models `bidirectional_iterator`, and `I` and `S` model `same_as<I, S>`.
  // Returns: `n - M`, where `M` is the difference between the ending and starting position.
  template <input_or_output_iterator _Ip, sentinel_for<_Ip> _Sp>
  _LIBCPP_HIDE_FROM_ABI constexpr iter_difference_t<_Ip> operator()(_Ip& __i, iter_difference_t<_Ip> __n,
                                                                    _Sp __bound_sentinel) const {
    _LIBCPP_ASSERT_UNCATEGORIZED((__n >= 0) || (bidirectional_iterator<_Ip> && same_as<_Ip, _Sp>),
                                 "If `n < 0`, then `bidirectional_iterator<I> && same_as<I, S>` must be true.");
    // If `S` and `I` model `sized_sentinel_for<S, I>`:
    if constexpr (sized_sentinel_for<_Sp, _Ip>) {
      // If |n| >= |bound_sentinel - i|, equivalent to `ranges::advance(i, bound_sentinel)`.
      // __magnitude_geq(a, b) returns |a| >= |b|, assuming they have the same sign.
      auto __magnitude_geq = [](auto __a, auto __b) {
        return __a == 0 ? __b == 0 :
               __a > 0  ? __a >= __b :
                          __a <= __b;
      };
      if (const auto __m = __bound_sentinel - __i; __magnitude_geq(__n, __m)) {
        (*this)(__i, __bound_sentinel);
        return __n - __m;
      }

      // Otherwise, equivalent to `ranges::advance(i, n)`.
      (*this)(__i, __n);
      return 0;
    } else {
      // Otherwise, if `n` is non-negative, while `bool(i != bound_sentinel)` is true, increments `i` but at
      // most `n` times.
      while (__i != __bound_sentinel && __n > 0) {
        ++__i;
        --__n;
      }

      // Otherwise, while `bool(i != bound_sentinel)` is true, decrements `i` but at most `-n` times.
      if constexpr (bidirectional_iterator<_Ip> && same_as<_Ip, _Sp>) {
        while (__i != __bound_sentinel && __n < 0) {
          --__i;
          ++__n;
        }
      }
      return __n;
    }

    __libcpp_unreachable();
  }
};

} // namespace __advance

inline namespace __cpo {
  inline constexpr auto advance = __advance::__fn{};
} // namespace __cpo
} // namespace ranges

#endif // _LIBCPP_STD_VER >= 20
# 202 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/advance.h" 3

_LIBCPP_END_NAMESPACE_STD

_LIBCPP_POP_MACROS

#endif // _LIBCPP___ITERATOR_ADVANCE_H
# 208 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/advance.h" 3
#endif /* advance.h expanded by -frewrite-includes */
# 681 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/iterator" 2 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* back_insert_iterator.h expanded by -frewrite-includes */
#include <__iterator/back_insert_iterator.h>
#else /* back_insert_iterator.h expanded by -frewrite-includes */
# 681 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/iterator" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/back_insert_iterator.h" 1 3
// -*- C++ -*-
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___ITERATOR_BACK_INSERT_ITERATOR_H
#define _LIBCPP___ITERATOR_BACK_INSERT_ITERATOR_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/back_insert_iterator.h" 3
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/back_insert_iterator.h" 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* iterator.h expanded by -frewrite-includes */
#include <__iterator/iterator.h>
#else /* iterator.h expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/back_insert_iterator.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iterator.h" 1 3
// -*- C++ -*-
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___ITERATOR_ITERATOR_H
#define _LIBCPP___ITERATOR_ITERATOR_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iterator.h" 3
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iterator.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <cstddef>
#endif /* expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iterator.h" 3
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iterator.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iterator.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iterator.h" 3
#endif
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iterator.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

template<class _Category, class _Tp, class _Distance = ptrdiff_t,
         class _Pointer = _Tp*, class _Reference = _Tp&>
struct _LIBCPP_TEMPLATE_VIS _LIBCPP_DEPRECATED_IN_CXX17 iterator
{
    typedef _Tp        value_type;
    typedef _Distance  difference_type;
    typedef _Pointer   pointer;
    typedef _Reference reference;
    typedef _Category  iterator_category;
};

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___ITERATOR_ITERATOR_H
# 36 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iterator.h" 3
#endif /* iterator.h expanded by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/back_insert_iterator.h" 2 3
#if 0 /* expanded by -frewrite-includes */
#include <__iterator/iterator_traits.h>
#endif /* expanded by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/back_insert_iterator.h" 3
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/back_insert_iterator.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__memory/addressof.h>
#endif /* expanded by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/back_insert_iterator.h" 3
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/back_insert_iterator.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__utility/move.h>
#endif /* expanded by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/back_insert_iterator.h" 3
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/back_insert_iterator.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <cstddef>
#endif /* expanded by -frewrite-includes */
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/back_insert_iterator.h" 3
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/back_insert_iterator.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 21 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/back_insert_iterator.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 22 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/back_insert_iterator.h" 3
#endif
# 23 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/back_insert_iterator.h" 3

_LIBCPP_PUSH_MACROS
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* __undef_macros expanded by -frewrite-includes */
#include <__undef_macros>
#else /* __undef_macros expanded by -frewrite-includes */
# 25 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/back_insert_iterator.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__undef_macros" 1 3
// -*- C++ -*-
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifdef min
#  undef min
#endif
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__undef_macros" 3

#ifdef max
#  undef max
#endif
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__undef_macros" 3

#ifdef refresh
#  undef refresh
#endif
# 21 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__undef_macros" 3

#ifdef move
#  undef move
#endif
# 25 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__undef_macros" 3

#ifdef erase
#  undef erase
#endif
# 29 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__undef_macros" 3
#endif /* __undef_macros expanded by -frewrite-includes */
# 26 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/back_insert_iterator.h" 2 3

_LIBCPP_BEGIN_NAMESPACE_STD

_LIBCPP_SUPPRESS_DEPRECATED_PUSH
template <class _Container>
class _LIBCPP_TEMPLATE_VIS back_insert_iterator
#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER <= 14 || !defined(_LIBCPP_ABI_NO_ITERATOR_BASES)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 33 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/back_insert_iterator.h" 3
    : public iterator<output_iterator_tag, void, void, void, void>
#endif
# 35 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/back_insert_iterator.h" 3
{
_LIBCPP_SUPPRESS_DEPRECATED_POP
protected:
    _Container* container;
public:
    typedef output_iterator_tag iterator_category;
    typedef void value_type;
#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 20
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 43 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/back_insert_iterator.h" 3
    typedef ptrdiff_t difference_type;
#else
# 45 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/back_insert_iterator.h" 3
    typedef void difference_type;
#endif
# 47 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/back_insert_iterator.h" 3
    typedef void pointer;
    typedef void reference;
    typedef _Container container_type;

    _LIBCPP_HIDE_FROM_ABI _LIBCPP_CONSTEXPR_SINCE_CXX20 explicit back_insert_iterator(_Container& __x) : container(_VSTD::addressof(__x)) {}
    _LIBCPP_HIDE_FROM_ABI _LIBCPP_CONSTEXPR_SINCE_CXX20 back_insert_iterator& operator=(const typename _Container::value_type& __value)
        {container->push_back(__value); return *this;}
#ifndef _LIBCPP_CXX03_LANG
    _LIBCPP_HIDE_FROM_ABI _LIBCPP_CONSTEXPR_SINCE_CXX20 back_insert_iterator& operator=(typename _Container::value_type&& __value)
        {container->push_back(_VSTD::move(__value)); return *this;}
#endif // _LIBCPP_CXX03_LANG
# 58 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/back_insert_iterator.h" 3
    _LIBCPP_HIDE_FROM_ABI _LIBCPP_CONSTEXPR_SINCE_CXX20 back_insert_iterator& operator*()     {return *this;}
    _LIBCPP_HIDE_FROM_ABI _LIBCPP_CONSTEXPR_SINCE_CXX20 back_insert_iterator& operator++()    {return *this;}
    _LIBCPP_HIDE_FROM_ABI _LIBCPP_CONSTEXPR_SINCE_CXX20 back_insert_iterator  operator++(int) {return *this;}

    _LIBCPP_HIDE_FROM_ABI _LIBCPP_CONSTEXPR_SINCE_CXX20 _Container* __get_container() const { return container; }
};
_LIBCPP_CTAD_SUPPORTED_FOR_TYPE(back_insert_iterator);

template <class _Container>
inline _LIBCPP_HIDE_FROM_ABI _LIBCPP_CONSTEXPR_SINCE_CXX20
back_insert_iterator<_Container>
back_inserter(_Container& __x)
{
    return back_insert_iterator<_Container>(__x);
}

_LIBCPP_END_NAMESPACE_STD

_LIBCPP_POP_MACROS

#endif // _LIBCPP___ITERATOR_BACK_INSERT_ITERATOR_H
# 79 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/back_insert_iterator.h" 3
#endif /* back_insert_iterator.h expanded by -frewrite-includes */
# 682 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/iterator" 2 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* bounded_iter.h expanded by -frewrite-includes */
#include <__iterator/bounded_iter.h>
#else /* bounded_iter.h expanded by -frewrite-includes */
# 682 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/iterator" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/bounded_iter.h" 1 3
// -*- C++ -*-
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___ITERATOR_BOUNDED_ITER_H
#define _LIBCPP___ITERATOR_BOUNDED_ITER_H

#if 0 /* expanded by -frewrite-includes */
#include <__assert>
#endif /* expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/bounded_iter.h" 3
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/bounded_iter.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/bounded_iter.h" 3
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/bounded_iter.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__iterator/iterator_traits.h>
#endif /* expanded by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/bounded_iter.h" 3
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/bounded_iter.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__memory/pointer_traits.h>
#endif /* expanded by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/bounded_iter.h" 3
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/bounded_iter.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/enable_if.h>
#endif /* expanded by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/bounded_iter.h" 3
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/bounded_iter.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/integral_constant.h>
#endif /* expanded by -frewrite-includes */
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/bounded_iter.h" 3
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/bounded_iter.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/is_convertible.h>
#endif /* expanded by -frewrite-includes */
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/bounded_iter.h" 3
# 20 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/bounded_iter.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__utility/move.h>
#endif /* expanded by -frewrite-includes */
# 20 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/bounded_iter.h" 3
# 21 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/bounded_iter.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 23 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/bounded_iter.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 24 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/bounded_iter.h" 3
#endif
# 25 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/bounded_iter.h" 3

_LIBCPP_PUSH_MACROS
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* __undef_macros expanded by -frewrite-includes */
#include <__undef_macros>
#else /* __undef_macros expanded by -frewrite-includes */
# 27 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/bounded_iter.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__undef_macros" 1 3
// -*- C++ -*-
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifdef min
#  undef min
#endif
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__undef_macros" 3

#ifdef max
#  undef max
#endif
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__undef_macros" 3

#ifdef refresh
#  undef refresh
#endif
# 21 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__undef_macros" 3

#ifdef move
#  undef move
#endif
# 25 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__undef_macros" 3

#ifdef erase
#  undef erase
#endif
# 29 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__undef_macros" 3
#endif /* __undef_macros expanded by -frewrite-includes */
# 28 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/bounded_iter.h" 2 3

_LIBCPP_BEGIN_NAMESPACE_STD

// Iterator wrapper that carries the valid range it is allowed to access.
//
// This is a simple iterator wrapper for contiguous iterators that points
// within a [begin, end) range and carries these bounds with it. The iterator
// ensures that it is pointing within that [begin, end) range when it is
// dereferenced.
//
// Arithmetic operations are allowed and the bounds of the resulting iterator
// are not checked. Hence, it is possible to create an iterator pointing outside
// its range, but it is not possible to dereference it.
template <class _Iterator, class = __enable_if_t< __libcpp_is_contiguous_iterator<_Iterator>::value > >
struct __bounded_iter {
  using value_type        = typename iterator_traits<_Iterator>::value_type;
  using difference_type   = typename iterator_traits<_Iterator>::difference_type;
  using pointer           = typename iterator_traits<_Iterator>::pointer;
  using reference         = typename iterator_traits<_Iterator>::reference;
  using iterator_category = typename iterator_traits<_Iterator>::iterator_category;
#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 20
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 49 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/bounded_iter.h" 3
  using iterator_concept = contiguous_iterator_tag;
#endif
# 51 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/bounded_iter.h" 3

  // Create a singular iterator.
  //
  // Such an iterator does not point to any object and is conceptually out of bounds, so it is
  // not dereferenceable. Observing operations like comparison and assignment are valid.
  _LIBCPP_HIDE_FROM_ABI __bounded_iter() = default;

  _LIBCPP_HIDE_FROM_ABI __bounded_iter(__bounded_iter const&) = default;
  _LIBCPP_HIDE_FROM_ABI __bounded_iter(__bounded_iter&&)      = default;

  template <class _OtherIterator, class = __enable_if_t< is_convertible<_OtherIterator, _Iterator>::value > >
  _LIBCPP_HIDE_FROM_ABI _LIBCPP_CONSTEXPR __bounded_iter(__bounded_iter<_OtherIterator> const& __other) _NOEXCEPT
      : __current_(__other.__current_),
        __begin_(__other.__begin_),
        __end_(__other.__end_) {}

  // Assign a bounded iterator to another one, rebinding the bounds of the iterator as well.
  _LIBCPP_HIDE_FROM_ABI __bounded_iter& operator=(__bounded_iter const&) = default;
  _LIBCPP_HIDE_FROM_ABI __bounded_iter& operator=(__bounded_iter&&)      = default;

private:
  // Create an iterator wrapping the given iterator, and whose bounds are described
  // by the provided [begin, end) range.
  //
  // This constructor does not check whether the resulting iterator is within its bounds.
  // However, it does check that the provided [begin, end) range is a valid range (that
  // is, begin <= end).
  //
  // Since it is non-standard for iterators to have this constructor, __bounded_iter must
  // be created via `std::__make_bounded_iter`.
  _LIBCPP_HIDE_FROM_ABI _LIBCPP_CONSTEXPR_SINCE_CXX14 explicit __bounded_iter(
      _Iterator __current, _Iterator __begin, _Iterator __end)
      : __current_(__current), __begin_(__begin), __end_(__end) {
    _LIBCPP_ASSERT_INTERNAL(__begin <= __end, "__bounded_iter(current, begin, end): [begin, end) is not a valid range");
  }

  template <class _It>
  friend _LIBCPP_CONSTEXPR __bounded_iter<_It> __make_bounded_iter(_It, _It, _It);

public:
  // Dereference and indexing operations.
  //
  // These operations check that the iterator is dereferenceable, that is within [begin, end).
  _LIBCPP_HIDE_FROM_ABI _LIBCPP_CONSTEXPR_SINCE_CXX14 reference operator*() const _NOEXCEPT {
    _LIBCPP_ASSERT_VALID_ELEMENT_ACCESS(
        __in_bounds(__current_), "__bounded_iter::operator*: Attempt to dereference an out-of-range iterator");
    return *__current_;
  }

  _LIBCPP_HIDE_FROM_ABI _LIBCPP_CONSTEXPR_SINCE_CXX14 pointer operator->() const _NOEXCEPT {
    _LIBCPP_ASSERT_VALID_ELEMENT_ACCESS(
        __in_bounds(__current_), "__bounded_iter::operator->: Attempt to dereference an out-of-range iterator");
    return std::__to_address(__current_);
  }

  _LIBCPP_HIDE_FROM_ABI _LIBCPP_CONSTEXPR_SINCE_CXX14 reference operator[](difference_type __n) const _NOEXCEPT {
    _LIBCPP_ASSERT_VALID_ELEMENT_ACCESS(
        __in_bounds(__current_ + __n), "__bounded_iter::operator[]: Attempt to index an iterator out-of-range");
    return __current_[__n];
  }

  // Arithmetic operations.
  //
  // These operations do not check that the resulting iterator is within the bounds, since that
  // would make it impossible to create a past-the-end iterator.
  _LIBCPP_HIDE_FROM_ABI _LIBCPP_CONSTEXPR_SINCE_CXX14 __bounded_iter& operator++() _NOEXCEPT {
    ++__current_;
    return *this;
  }
  _LIBCPP_HIDE_FROM_ABI _LIBCPP_CONSTEXPR_SINCE_CXX14 __bounded_iter operator++(int) _NOEXCEPT {
    __bounded_iter __tmp(*this);
    ++*this;
    return __tmp;
  }

  _LIBCPP_HIDE_FROM_ABI _LIBCPP_CONSTEXPR_SINCE_CXX14 __bounded_iter& operator--() _NOEXCEPT {
    --__current_;
    return *this;
  }
  _LIBCPP_HIDE_FROM_ABI _LIBCPP_CONSTEXPR_SINCE_CXX14 __bounded_iter operator--(int) _NOEXCEPT {
    __bounded_iter __tmp(*this);
    --*this;
    return __tmp;
  }

  _LIBCPP_HIDE_FROM_ABI _LIBCPP_CONSTEXPR_SINCE_CXX14 __bounded_iter& operator+=(difference_type __n) _NOEXCEPT {
    __current_ += __n;
    return *this;
  }
  _LIBCPP_HIDE_FROM_ABI _LIBCPP_CONSTEXPR_SINCE_CXX14 friend __bounded_iter
  operator+(__bounded_iter const& __self, difference_type __n) _NOEXCEPT {
    __bounded_iter __tmp(__self);
    __tmp += __n;
    return __tmp;
  }
  _LIBCPP_HIDE_FROM_ABI _LIBCPP_CONSTEXPR_SINCE_CXX14 friend __bounded_iter
  operator+(difference_type __n, __bounded_iter const& __self) _NOEXCEPT {
    __bounded_iter __tmp(__self);
    __tmp += __n;
    return __tmp;
  }

  _LIBCPP_HIDE_FROM_ABI _LIBCPP_CONSTEXPR_SINCE_CXX14 __bounded_iter& operator-=(difference_type __n) _NOEXCEPT {
    __current_ -= __n;
    return *this;
  }
  _LIBCPP_HIDE_FROM_ABI _LIBCPP_CONSTEXPR_SINCE_CXX14 friend __bounded_iter
  operator-(__bounded_iter const& __self, difference_type __n) _NOEXCEPT {
    __bounded_iter __tmp(__self);
    __tmp -= __n;
    return __tmp;
  }
  _LIBCPP_HIDE_FROM_ABI _LIBCPP_CONSTEXPR_SINCE_CXX14 friend difference_type
  operator-(__bounded_iter const& __x, __bounded_iter const& __y) _NOEXCEPT {
    return __x.__current_ - __y.__current_;
  }

  // Comparison operations.
  //
  // These operations do not check whether the iterators are within their bounds.
  // The valid range for each iterator is also not considered as part of the comparison,
  // i.e. two iterators pointing to the same location will be considered equal even
  // if they have different validity ranges.
  _LIBCPP_HIDE_FROM_ABI _LIBCPP_CONSTEXPR friend bool
  operator==(__bounded_iter const& __x, __bounded_iter const& __y) _NOEXCEPT {
    return __x.__current_ == __y.__current_;
  }
  _LIBCPP_HIDE_FROM_ABI _LIBCPP_CONSTEXPR friend bool
  operator!=(__bounded_iter const& __x, __bounded_iter const& __y) _NOEXCEPT {
    return __x.__current_ != __y.__current_;
  }
  _LIBCPP_HIDE_FROM_ABI _LIBCPP_CONSTEXPR friend bool
  operator<(__bounded_iter const& __x, __bounded_iter const& __y) _NOEXCEPT {
    return __x.__current_ < __y.__current_;
  }
  _LIBCPP_HIDE_FROM_ABI _LIBCPP_CONSTEXPR friend bool
  operator>(__bounded_iter const& __x, __bounded_iter const& __y) _NOEXCEPT {
    return __x.__current_ > __y.__current_;
  }
  _LIBCPP_HIDE_FROM_ABI _LIBCPP_CONSTEXPR friend bool
  operator<=(__bounded_iter const& __x, __bounded_iter const& __y) _NOEXCEPT {
    return __x.__current_ <= __y.__current_;
  }
  _LIBCPP_HIDE_FROM_ABI _LIBCPP_CONSTEXPR friend bool
  operator>=(__bounded_iter const& __x, __bounded_iter const& __y) _NOEXCEPT {
    return __x.__current_ >= __y.__current_;
  }

private:
  // Return whether the given iterator is in the bounds of this __bounded_iter.
  _LIBCPP_HIDE_FROM_ABI _LIBCPP_CONSTEXPR bool __in_bounds(_Iterator const& __iter) const {
    return __iter >= __begin_ && __iter < __end_;
  }

  template <class>
  friend struct pointer_traits;
  _Iterator __current_;       // current iterator
  _Iterator __begin_, __end_; // valid range represented as [begin, end)
};

template <class _It>
_LIBCPP_HIDE_FROM_ABI _LIBCPP_CONSTEXPR __bounded_iter<_It> __make_bounded_iter(_It __it, _It __begin, _It __end) {
  return __bounded_iter<_It>(std::move(__it), std::move(__begin), std::move(__end));
}

#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER <= 17
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 217 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/bounded_iter.h" 3
template <class _Iterator>
struct __libcpp_is_contiguous_iterator<__bounded_iter<_Iterator> > : true_type {};
#endif
# 220 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/bounded_iter.h" 3

template <class _Iterator>
struct pointer_traits<__bounded_iter<_Iterator> > {
  using pointer         = __bounded_iter<_Iterator>;
  using element_type    = typename pointer_traits<_Iterator>::element_type;
  using difference_type = typename pointer_traits<_Iterator>::difference_type;

  _LIBCPP_HIDE_FROM_ABI _LIBCPP_CONSTEXPR static element_type* to_address(pointer __it) _NOEXCEPT {
    return std::__to_address(__it.__current_);
  }
};

_LIBCPP_END_NAMESPACE_STD

_LIBCPP_POP_MACROS

#endif // _LIBCPP___ITERATOR_BOUNDED_ITER_H
# 237 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/bounded_iter.h" 3
#endif /* bounded_iter.h expanded by -frewrite-includes */
# 683 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/iterator" 2 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* common_iterator.h expanded by -frewrite-includes */
#include <__iterator/common_iterator.h>
#else /* common_iterator.h expanded by -frewrite-includes */
# 683 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/iterator" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/common_iterator.h" 1 3
// -*- C++ -*-
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___ITERATOR_COMMON_ITERATOR_H
#define _LIBCPP___ITERATOR_COMMON_ITERATOR_H

#if 0 /* expanded by -frewrite-includes */
#include <__assert>
#endif /* expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/common_iterator.h" 3
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/common_iterator.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__concepts/assignable.h>
#endif /* expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/common_iterator.h" 3
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/common_iterator.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__concepts/constructible.h>
#endif /* expanded by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/common_iterator.h" 3
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/common_iterator.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__concepts/convertible_to.h>
#endif /* expanded by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/common_iterator.h" 3
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/common_iterator.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__concepts/copyable.h>
#endif /* expanded by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/common_iterator.h" 3
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/common_iterator.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__concepts/derived_from.h>
#endif /* expanded by -frewrite-includes */
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/common_iterator.h" 3
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/common_iterator.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__concepts/equality_comparable.h>
#endif /* expanded by -frewrite-includes */
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/common_iterator.h" 3
# 20 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/common_iterator.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__concepts/same_as.h>
#endif /* expanded by -frewrite-includes */
# 20 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/common_iterator.h" 3
# 21 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/common_iterator.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 21 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/common_iterator.h" 3
# 22 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/common_iterator.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__iterator/concepts.h>
#endif /* expanded by -frewrite-includes */
# 22 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/common_iterator.h" 3
# 23 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/common_iterator.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__iterator/incrementable_traits.h>
#endif /* expanded by -frewrite-includes */
# 23 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/common_iterator.h" 3
# 24 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/common_iterator.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__iterator/iter_move.h>
#endif /* expanded by -frewrite-includes */
# 24 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/common_iterator.h" 3
# 25 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/common_iterator.h" 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* iter_swap.h expanded by -frewrite-includes */
#include <__iterator/iter_swap.h>
#else /* iter_swap.h expanded by -frewrite-includes */
# 25 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/common_iterator.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iter_swap.h" 1 3
// -*- C++ -*-
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___ITERATOR_ITER_SWAP_H
#define _LIBCPP___ITERATOR_ITER_SWAP_H

#if 0 /* expanded by -frewrite-includes */
#include <__concepts/class_or_enum.h>
#endif /* expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iter_swap.h" 3
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iter_swap.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__concepts/swappable.h>
#endif /* expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iter_swap.h" 3
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iter_swap.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iter_swap.h" 3
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iter_swap.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__iterator/concepts.h>
#endif /* expanded by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iter_swap.h" 3
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iter_swap.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__iterator/iter_move.h>
#endif /* expanded by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iter_swap.h" 3
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iter_swap.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__iterator/iterator_traits.h>
#endif /* expanded by -frewrite-includes */
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iter_swap.h" 3
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iter_swap.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__iterator/readable_traits.h>
#endif /* expanded by -frewrite-includes */
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iter_swap.h" 3
# 20 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iter_swap.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/remove_cvref.h>
#endif /* expanded by -frewrite-includes */
# 20 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iter_swap.h" 3
# 21 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iter_swap.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__utility/declval.h>
#endif /* expanded by -frewrite-includes */
# 21 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iter_swap.h" 3
# 22 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iter_swap.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__utility/forward.h>
#endif /* expanded by -frewrite-includes */
# 22 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iter_swap.h" 3
# 23 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iter_swap.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__utility/move.h>
#endif /* expanded by -frewrite-includes */
# 23 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iter_swap.h" 3
# 24 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iter_swap.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 26 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iter_swap.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 27 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iter_swap.h" 3
#endif
# 28 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iter_swap.h" 3

_LIBCPP_PUSH_MACROS
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* __undef_macros expanded by -frewrite-includes */
#include <__undef_macros>
#else /* __undef_macros expanded by -frewrite-includes */
# 30 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iter_swap.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__undef_macros" 1 3
// -*- C++ -*-
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifdef min
#  undef min
#endif
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__undef_macros" 3

#ifdef max
#  undef max
#endif
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__undef_macros" 3

#ifdef refresh
#  undef refresh
#endif
# 21 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__undef_macros" 3

#ifdef move
#  undef move
#endif
# 25 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__undef_macros" 3

#ifdef erase
#  undef erase
#endif
# 29 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__undef_macros" 3
#endif /* __undef_macros expanded by -frewrite-includes */
# 31 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iter_swap.h" 2 3

_LIBCPP_BEGIN_NAMESPACE_STD

#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 20
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 35 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iter_swap.h" 3

// [iter.cust.swap]

namespace ranges {
namespace __iter_swap {
  template<class _I1, class _I2>
  void iter_swap(_I1, _I2) = delete;

  template<class _T1, class _T2>
  concept __unqualified_iter_swap =
    (__class_or_enum<remove_cvref_t<_T1>> || __class_or_enum<remove_cvref_t<_T2>>) &&
    requires (_T1&& __x, _T2&& __y) {
      // NOLINTNEXTLINE(libcpp-robust-against-adl) iter_swap ADL calls should only be made through ranges::iter_swap
      iter_swap(_VSTD::forward<_T1>(__x), _VSTD::forward<_T2>(__y));
    };

  template<class _T1, class _T2>
  concept __readable_swappable =
    indirectly_readable<_T1> && indirectly_readable<_T2> &&
    swappable_with<iter_reference_t<_T1>, iter_reference_t<_T2>>;


  struct __fn {
    // NOLINTBEGIN(libcpp-robust-against-adl) iter_swap ADL calls should only be made through ranges::iter_swap
    template <class _T1, class _T2>
      requires __unqualified_iter_swap<_T1, _T2>
    _LIBCPP_HIDE_FROM_ABI
    constexpr void operator()(_T1&& __x, _T2&& __y) const
      noexcept(noexcept(iter_swap(_VSTD::forward<_T1>(__x), _VSTD::forward<_T2>(__y))))
    {
      (void)iter_swap(_VSTD::forward<_T1>(__x), _VSTD::forward<_T2>(__y));
    }
    // NOLINTEND(libcpp-robust-against-adl)

    template <class _T1, class _T2>
      requires (!__unqualified_iter_swap<_T1, _T2>) &&
               __readable_swappable<_T1, _T2>
    _LIBCPP_HIDE_FROM_ABI
    constexpr void operator()(_T1&& __x, _T2&& __y) const
      noexcept(noexcept(ranges::swap(*_VSTD::forward<_T1>(__x), *_VSTD::forward<_T2>(__y))))
    {
      ranges::swap(*_VSTD::forward<_T1>(__x), *_VSTD::forward<_T2>(__y));
    }

    template <class _T1, class _T2>
      requires (!__unqualified_iter_swap<_T1, _T2> &&
                !__readable_swappable<_T1, _T2>) &&
               indirectly_movable_storable<_T1, _T2> &&
               indirectly_movable_storable<_T2, _T1>
    _LIBCPP_HIDE_FROM_ABI
    constexpr void operator()(_T1&& __x, _T2&& __y) const
      noexcept(noexcept(iter_value_t<_T2>(ranges::iter_move(__y))) &&
               noexcept(*__y = ranges::iter_move(__x)) &&
               noexcept(*_VSTD::forward<_T1>(__x) = std::declval<iter_value_t<_T2>>()))
    {
      iter_value_t<_T2> __old(ranges::iter_move(__y));
      *__y = ranges::iter_move(__x);
      *_VSTD::forward<_T1>(__x) = _VSTD::move(__old);
    }
  };
} // namespace __iter_swap

inline namespace __cpo {
  inline constexpr auto iter_swap = __iter_swap::__fn{};
} // namespace __cpo
} // namespace ranges

template<class _I1, class _I2 = _I1>
concept indirectly_swappable =
  indirectly_readable<_I1> && indirectly_readable<_I2> &&
  requires(const _I1 __i1, const _I2 __i2) {
    ranges::iter_swap(__i1, __i1);
    ranges::iter_swap(__i2, __i2);
    ranges::iter_swap(__i1, __i2);
    ranges::iter_swap(__i2, __i1);
  };

#endif // _LIBCPP_STD_VER >= 20
# 113 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iter_swap.h" 3

_LIBCPP_END_NAMESPACE_STD

_LIBCPP_POP_MACROS

#endif // _LIBCPP___ITERATOR_ITER_SWAP_H
# 119 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/iter_swap.h" 3
#endif /* iter_swap.h expanded by -frewrite-includes */
# 26 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/common_iterator.h" 2 3
#if 0 /* expanded by -frewrite-includes */
#include <__iterator/iterator_traits.h>
#endif /* expanded by -frewrite-includes */
# 26 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/common_iterator.h" 3
# 27 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/common_iterator.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__iterator/readable_traits.h>
#endif /* expanded by -frewrite-includes */
# 27 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/common_iterator.h" 3
# 28 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/common_iterator.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__memory/addressof.h>
#endif /* expanded by -frewrite-includes */
# 28 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/common_iterator.h" 3
# 29 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/common_iterator.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/is_pointer.h>
#endif /* expanded by -frewrite-includes */
# 29 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/common_iterator.h" 3
# 30 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/common_iterator.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__utility/declval.h>
#endif /* expanded by -frewrite-includes */
# 30 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/common_iterator.h" 3
# 31 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/common_iterator.h" 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* variant expanded by -frewrite-includes */
#include <variant>
#else /* variant expanded by -frewrite-includes */
# 31 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__iterator/common_iterator.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/variant" 1 3
// -*- C++ -*-
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP_VARIANT
#define _LIBCPP_VARIANT

/*
   variant synopsis

namespace std {

  // 20.7.2, class template variant
  template <class... Types>
  class variant {
  public:

    // 20.7.2.1, constructors
    constexpr variant() noexcept(see below);
    constexpr variant(const variant&);
    constexpr variant(variant&&) noexcept(see below);

    template <class T> constexpr variant(T&&) noexcept(see below);

    template <class T, class... Args>
    constexpr explicit variant(in_place_type_t<T>, Args&&...);

    template <class T, class U, class... Args>
    constexpr explicit variant(
        in_place_type_t<T>, initializer_list<U>, Args&&...);

    template <size_t I, class... Args>
    constexpr explicit variant(in_place_index_t<I>, Args&&...);

    template <size_t I, class U, class... Args>
    constexpr explicit variant(
        in_place_index_t<I>, initializer_list<U>, Args&&...);

    // 20.7.2.2, destructor
    ~variant();

    // 20.7.2.3, assignment
    constexpr variant& operator=(const variant&);
    constexpr variant& operator=(variant&&) noexcept(see below);

    template <class T> variant& operator=(T&&) noexcept(see below);

    // 20.7.2.4, modifiers
    template <class T, class... Args>
    T& emplace(Args&&...);

    template <class T, class U, class... Args>
    T& emplace(initializer_list<U>, Args&&...);

    template <size_t I, class... Args>
    variant_alternative_t<I, variant>& emplace(Args&&...);

    template <size_t I, class U, class...  Args>
    variant_alternative_t<I, variant>& emplace(initializer_list<U>, Args&&...);

    // 20.7.2.5, value status
    constexpr bool valueless_by_exception() const noexcept;
    constexpr size_t index() const noexcept;

    // 20.7.2.6, swap
    void swap(variant&) noexcept(see below);
  };

  // 20.7.3, variant helper classes
  template <class T> struct variant_size; // undefined

  template <class T>
  inline constexpr size_t variant_size_v = variant_size<T>::value;

  template <class T> struct variant_size<const T>;
  template <class T> struct variant_size<volatile T>;
  template <class T> struct variant_size<const volatile T>;

  template <class... Types>
  struct variant_size<variant<Types...>>;

  template <size_t I, class T> struct variant_alternative; // undefined

  template <size_t I, class T>
  using variant_alternative_t = typename variant_alternative<I, T>::type;

  template <size_t I, class T> struct variant_alternative<I, const T>;
  template <size_t I, class T> struct variant_alternative<I, volatile T>;
  template <size_t I, class T> struct variant_alternative<I, const volatile T>;

  template <size_t I, class... Types>
  struct variant_alternative<I, variant<Types...>>;

  inline constexpr size_t variant_npos = -1;

  // 20.7.4, value access
  template <class T, class... Types>
  constexpr bool holds_alternative(const variant<Types...>&) noexcept;

  template <size_t I, class... Types>
  constexpr variant_alternative_t<I, variant<Types...>>&
  get(variant<Types...>&);

  template <size_t I, class... Types>
  constexpr variant_alternative_t<I, variant<Types...>>&&
  get(variant<Types...>&&);

  template <size_t I, class... Types>
  constexpr variant_alternative_t<I, variant<Types...>> const&
  get(const variant<Types...>&);

  template <size_t I, class... Types>
  constexpr variant_alternative_t<I, variant<Types...>> const&&
  get(const variant<Types...>&&);

  template <class T, class...  Types>
  constexpr T& get(variant<Types...>&);

  template <class T, class... Types>
  constexpr T&& get(variant<Types...>&&);

  template <class T, class... Types>
  constexpr const T& get(const variant<Types...>&);

  template <class T, class... Types>
  constexpr const T&& get(const variant<Types...>&&);

  template <size_t I, class... Types>
  constexpr add_pointer_t<variant_alternative_t<I, variant<Types...>>>
  get_if(variant<Types...>*) noexcept;

  template <size_t I, class... Types>
  constexpr add_pointer_t<const variant_alternative_t<I, variant<Types...>>>
  get_if(const variant<Types...>*) noexcept;

  template <class T, class... Types>
  constexpr add_pointer_t<T>
  get_if(variant<Types...>*) noexcept;

  template <class T, class... Types>
  constexpr add_pointer_t<const T>
  get_if(const variant<Types...>*) noexcept;

  // 20.7.5, relational operators
  template <class... Types>
  constexpr bool operator==(const variant<Types...>&, const variant<Types...>&);

  template <class... Types>
  constexpr bool operator!=(const variant<Types...>&, const variant<Types...>&);

  template <class... Types>
  constexpr bool operator<(const variant<Types...>&, const variant<Types...>&);

  template <class... Types>
  constexpr bool operator>(const variant<Types...>&, const variant<Types...>&);

  template <class... Types>
  constexpr bool operator<=(const variant<Types...>&, const variant<Types...>&);

  template <class... Types>
  constexpr bool operator>=(const variant<Types...>&, const variant<Types...>&);

  template <class... Types> requires (three_way_comparable<Types> && ...)
  constexpr common_comparison_category_t<compare_three_way_result_t<Types>...>
    operator<=>(const variant<Types...>&, const variant<Types...>&);           // since C++20

  // 20.7.6, visitation
  template <class Visitor, class... Variants>
  constexpr see below visit(Visitor&&, Variants&&...);

  template <class R, class Visitor, class... Variants>
  constexpr R visit(Visitor&&, Variants&&...); // since C++20

  // 20.7.7, class monostate
  struct monostate;

  // 20.7.8, monostate relational operators
  constexpr bool operator==(monostate, monostate) noexcept;
  constexpr bool operator!=(monostate, monostate) noexcept;             // until C++20
  constexpr bool operator<(monostate, monostate) noexcept;              // until C++20
  constexpr bool operator>(monostate, monostate) noexcept;              // until C++20
  constexpr bool operator<=(monostate, monostate) noexcept;             // until C++20
  constexpr bool operator>=(monostate, monostate) noexcept;             // until C++20
  constexpr strong_ordering operator<=>(monostate, monostate) noexcept; // since C++20

  // 20.7.9, specialized algorithms
  template <class... Types>
  void swap(variant<Types...>&, variant<Types...>&) noexcept(see below);

  // 20.7.10, class bad_variant_access
  class bad_variant_access;

  // 20.7.11, hash support
  template <class T> struct hash;
  template <class... Types> struct hash<variant<Types...>>;
  template <> struct hash<monostate>;

} // namespace std

*/

#if 0 /* expanded by -frewrite-includes */
#include <__assert> // all public C++ headers provide the assertion handler
#endif /* expanded by -frewrite-includes */
# 207 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/variant" 3
# 208 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/variant" 3
#if 0 /* expanded by -frewrite-includes */
#include <__availability>
#endif /* expanded by -frewrite-includes */
# 208 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/variant" 3
# 209 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/variant" 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* common_comparison_category.h expanded by -frewrite-includes */
#include <__compare/common_comparison_category.h>
#else /* common_comparison_category.h expanded by -frewrite-includes */
# 209 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/variant" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__compare/common_comparison_category.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___COMPARE_COMMON_COMPARISON_CATEGORY_H
#define _LIBCPP___COMPARE_COMMON_COMPARISON_CATEGORY_H

#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* ordering.h expanded by -frewrite-includes */
#include <__compare/ordering.h>
#else /* ordering.h expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__compare/common_comparison_category.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__compare/ordering.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___COMPARE_ORDERING_H
#define _LIBCPP___COMPARE_ORDERING_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__compare/ordering.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__compare/ordering.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/enable_if.h>
#endif /* expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__compare/ordering.h" 3
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__compare/ordering.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/is_same.h>
#endif /* expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__compare/ordering.h" 3
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__compare/ordering.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__compare/ordering.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__compare/ordering.h" 3
#endif
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__compare/ordering.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 20
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 23 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__compare/ordering.h" 3

// exposition only
enum class _OrdResult : signed char {
  __less = -1,
  __equiv = 0,
  __greater = 1
};

enum class _NCmpResult : signed char {
  __unordered = -127
};

class partial_ordering;
class weak_ordering;
class strong_ordering;

template<class _Tp, class... _Args>
inline constexpr bool __one_of_v = (is_same_v<_Tp, _Args> || ...);

struct _CmpUnspecifiedParam {
  _LIBCPP_HIDE_FROM_ABI constexpr
  _CmpUnspecifiedParam(int _CmpUnspecifiedParam::*) noexcept {}

  template<class _Tp, class = enable_if_t<!__one_of_v<_Tp, int, partial_ordering, weak_ordering, strong_ordering>>>
  _CmpUnspecifiedParam(_Tp) = delete;
};

class partial_ordering {
  using _ValueT = signed char;

  _LIBCPP_HIDE_FROM_ABI
  explicit constexpr partial_ordering(_OrdResult __v) noexcept
      : __value_(_ValueT(__v)) {}

  _LIBCPP_HIDE_FROM_ABI
  explicit constexpr partial_ordering(_NCmpResult __v) noexcept
      : __value_(_ValueT(__v)) {}

  _LIBCPP_HIDE_FROM_ABI
  constexpr bool __is_ordered() const noexcept {
    return __value_ != _ValueT(_NCmpResult::__unordered);
  }
public:
  // valid values
  static const partial_ordering less;
  static const partial_ordering equivalent;
  static const partial_ordering greater;
  static const partial_ordering unordered;

  // comparisons
  _LIBCPP_HIDE_FROM_ABI
  friend constexpr bool operator==(partial_ordering, partial_ordering) noexcept = default;

  _LIBCPP_HIDE_FROM_ABI
  friend constexpr bool operator==(partial_ordering __v, _CmpUnspecifiedParam) noexcept {
    return __v.__is_ordered() && __v.__value_ == 0;
  }

  _LIBCPP_HIDE_FROM_ABI
  friend constexpr bool operator< (partial_ordering __v, _CmpUnspecifiedParam) noexcept {
    return __v.__is_ordered() && __v.__value_ < 0;
  }

  _LIBCPP_HIDE_FROM_ABI
  friend constexpr bool operator<=(partial_ordering __v, _CmpUnspecifiedParam) noexcept  {
    return __v.__is_ordered() && __v.__value_ <= 0;
  }

  _LIBCPP_HIDE_FROM_ABI
  friend constexpr bool operator> (partial_ordering __v, _CmpUnspecifiedParam) noexcept  {
    return __v.__is_ordered() && __v.__value_ > 0;
  }

  _LIBCPP_HIDE_FROM_ABI
  friend constexpr bool operator>=(partial_ordering __v, _CmpUnspecifiedParam) noexcept  {
    return __v.__is_ordered() && __v.__value_ >= 0;
  }

  _LIBCPP_HIDE_FROM_ABI
  friend constexpr bool operator< (_CmpUnspecifiedParam, partial_ordering __v) noexcept  {
    return __v.__is_ordered() && 0 < __v.__value_;
  }

  _LIBCPP_HIDE_FROM_ABI
  friend constexpr bool operator<=(_CmpUnspecifiedParam, partial_ordering __v) noexcept  {
    return __v.__is_ordered() && 0 <= __v.__value_;
  }

  _LIBCPP_HIDE_FROM_ABI
  friend constexpr bool operator> (_CmpUnspecifiedParam, partial_ordering __v) noexcept  {
    return __v.__is_ordered() && 0 > __v.__value_;
  }

  _LIBCPP_HIDE_FROM_ABI
  friend constexpr bool operator>=(_CmpUnspecifiedParam, partial_ordering __v) noexcept  {
    return __v.__is_ordered() && 0 >= __v.__value_;
  }

  _LIBCPP_HIDE_FROM_ABI
  friend constexpr partial_ordering operator<=>(partial_ordering __v, _CmpUnspecifiedParam) noexcept  {
    return __v;
  }

  _LIBCPP_HIDE_FROM_ABI
  friend constexpr partial_ordering operator<=>(_CmpUnspecifiedParam, partial_ordering __v) noexcept  {
    return __v < 0 ? partial_ordering::greater : (__v > 0 ? partial_ordering::less : __v);
  }
private:
  _ValueT __value_;
};

inline constexpr partial_ordering partial_ordering::less(_OrdResult::__less);
inline constexpr partial_ordering partial_ordering::equivalent(_OrdResult::__equiv);
inline constexpr partial_ordering partial_ordering::greater(_OrdResult::__greater);
inline constexpr partial_ordering partial_ordering::unordered(_NCmpResult ::__unordered);

class weak_ordering {
  using _ValueT = signed char;

  _LIBCPP_HIDE_FROM_ABI
  explicit constexpr weak_ordering(_OrdResult __v) noexcept : __value_(_ValueT(__v)) {}

public:
  static const weak_ordering less;
  static const weak_ordering equivalent;
  static const weak_ordering greater;

  _LIBCPP_HIDE_FROM_ABI
  constexpr operator partial_ordering() const noexcept {
    return __value_ == 0 ? partial_ordering::equivalent
        : (__value_ < 0 ? partial_ordering::less : partial_ordering::greater);
  }

  // comparisons
  _LIBCPP_HIDE_FROM_ABI
  friend constexpr bool operator==(weak_ordering, weak_ordering) noexcept = default;

  _LIBCPP_HIDE_FROM_ABI
  friend constexpr bool operator==(weak_ordering __v, _CmpUnspecifiedParam) noexcept {
    return __v.__value_ == 0;
  }

  _LIBCPP_HIDE_FROM_ABI
  friend constexpr bool operator< (weak_ordering __v, _CmpUnspecifiedParam) noexcept {
    return __v.__value_ < 0;
  }

  _LIBCPP_HIDE_FROM_ABI
  friend constexpr bool operator<=(weak_ordering __v, _CmpUnspecifiedParam) noexcept {
    return __v.__value_ <= 0;
  }

  _LIBCPP_HIDE_FROM_ABI
  friend constexpr bool operator> (weak_ordering __v, _CmpUnspecifiedParam) noexcept {
    return __v.__value_ > 0;
  }

  _LIBCPP_HIDE_FROM_ABI
  friend constexpr bool operator>=(weak_ordering __v, _CmpUnspecifiedParam) noexcept {
    return __v.__value_ >= 0;
  }

  _LIBCPP_HIDE_FROM_ABI
  friend constexpr bool operator< (_CmpUnspecifiedParam, weak_ordering __v) noexcept {
    return 0 < __v.__value_;
  }

  _LIBCPP_HIDE_FROM_ABI
  friend constexpr bool operator<=(_CmpUnspecifiedParam, weak_ordering __v) noexcept {
    return 0 <= __v.__value_;
  }

  _LIBCPP_HIDE_FROM_ABI
  friend constexpr bool operator> (_CmpUnspecifiedParam, weak_ordering __v) noexcept {
    return 0 > __v.__value_;
  }

  _LIBCPP_HIDE_FROM_ABI
  friend constexpr bool operator>=(_CmpUnspecifiedParam, weak_ordering __v) noexcept {
    return 0 >= __v.__value_;
  }

  _LIBCPP_HIDE_FROM_ABI
  friend constexpr weak_ordering operator<=>(weak_ordering __v, _CmpUnspecifiedParam) noexcept {
    return __v;
  }

  _LIBCPP_HIDE_FROM_ABI
  friend constexpr weak_ordering operator<=>(_CmpUnspecifiedParam, weak_ordering __v) noexcept {
    return __v < 0 ? weak_ordering::greater : (__v > 0 ? weak_ordering::less : __v);
  }

private:
  _ValueT __value_;
};

inline constexpr weak_ordering weak_ordering::less(_OrdResult::__less);
inline constexpr weak_ordering weak_ordering::equivalent(_OrdResult::__equiv);
inline constexpr weak_ordering weak_ordering::greater(_OrdResult::__greater);

class strong_ordering {
  using _ValueT = signed char;

  _LIBCPP_HIDE_FROM_ABI
  explicit constexpr strong_ordering(_OrdResult __v) noexcept : __value_(_ValueT(__v)) {}

public:
  static const strong_ordering less;
  static const strong_ordering equal;
  static const strong_ordering equivalent;
  static const strong_ordering greater;

  // conversions
  _LIBCPP_HIDE_FROM_ABI
  constexpr operator partial_ordering() const noexcept {
    return __value_ == 0 ? partial_ordering::equivalent
        : (__value_ < 0 ? partial_ordering::less : partial_ordering::greater);
  }

  _LIBCPP_HIDE_FROM_ABI
  constexpr operator weak_ordering() const noexcept {
    return __value_ == 0 ? weak_ordering::equivalent
        : (__value_ < 0 ? weak_ordering::less : weak_ordering::greater);
  }

  // comparisons
  _LIBCPP_HIDE_FROM_ABI
  friend constexpr bool operator==(strong_ordering, strong_ordering) noexcept = default;

  _LIBCPP_HIDE_FROM_ABI
  friend constexpr bool operator==(strong_ordering __v, _CmpUnspecifiedParam) noexcept {
    return __v.__value_ == 0;
  }

  _LIBCPP_HIDE_FROM_ABI
  friend constexpr bool operator< (strong_ordering __v, _CmpUnspecifiedParam) noexcept {
    return __v.__value_ < 0;
  }

  _LIBCPP_HIDE_FROM_ABI
  friend constexpr bool operator<=(strong_ordering __v, _CmpUnspecifiedParam) noexcept {
    return __v.__value_ <= 0;
  }

  _LIBCPP_HIDE_FROM_ABI
  friend constexpr bool operator> (strong_ordering __v, _CmpUnspecifiedParam) noexcept {
    return __v.__value_ > 0;
  }

  _LIBCPP_HIDE_FROM_ABI
  friend constexpr bool operator>=(strong_ordering __v, _CmpUnspecifiedParam) noexcept {
    return __v.__value_ >= 0;
  }

  _LIBCPP_HIDE_FROM_ABI
  friend constexpr bool operator< (_CmpUnspecifiedParam, strong_ordering __v) noexcept {
    return 0 < __v.__value_;
  }

  _LIBCPP_HIDE_FROM_ABI
  friend constexpr bool operator<=(_CmpUnspecifiedParam, strong_ordering __v) noexcept {
    return 0 <= __v.__value_;
  }

  _LIBCPP_HIDE_FROM_ABI
  friend constexpr bool operator> (_CmpUnspecifiedParam, strong_ordering __v) noexcept {
    return 0 > __v.__value_;
  }

  _LIBCPP_HIDE_FROM_ABI
  friend constexpr bool operator>=(_CmpUnspecifiedParam, strong_ordering __v) noexcept {
    return 0 >= __v.__value_;
  }

  _LIBCPP_HIDE_FROM_ABI
  friend constexpr strong_ordering operator<=>(strong_ordering __v, _CmpUnspecifiedParam) noexcept {
    return __v;
  }

  _LIBCPP_HIDE_FROM_ABI
  friend constexpr strong_ordering operator<=>(_CmpUnspecifiedParam, strong_ordering __v) noexcept {
    return __v < 0 ? strong_ordering::greater : (__v > 0 ? strong_ordering::less : __v);
  }

private:
  _ValueT __value_;
};

inline constexpr strong_ordering strong_ordering::less(_OrdResult::__less);
inline constexpr strong_ordering strong_ordering::equal(_OrdResult::__equiv);
inline constexpr strong_ordering strong_ordering::equivalent(_OrdResult::__equiv);
inline constexpr strong_ordering strong_ordering::greater(_OrdResult::__greater);

/// [cmp.categories.pre]/1
/// The types partial_ordering, weak_ordering, and strong_ordering are
/// collectively termed the comparison category types.
template <class _Tp>
concept __comparison_category = __one_of_v<_Tp, partial_ordering, weak_ordering, strong_ordering>;

#endif // _LIBCPP_STD_VER >= 20
# 323 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__compare/ordering.h" 3

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___COMPARE_ORDERING_H
# 327 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__compare/ordering.h" 3
#endif /* ordering.h expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__compare/common_comparison_category.h" 2 3
#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__compare/common_comparison_category.h" 3
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__compare/common_comparison_category.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/is_same.h>
#endif /* expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__compare/common_comparison_category.h" 3
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__compare/common_comparison_category.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <cstddef>
#endif /* expanded by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__compare/common_comparison_category.h" 3
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__compare/common_comparison_category.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__compare/common_comparison_category.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__compare/common_comparison_category.h" 3
#endif
# 20 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__compare/common_comparison_category.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 20
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 24 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__compare/common_comparison_category.h" 3

namespace __comp_detail {

enum _ClassifyCompCategory : unsigned {
  _None,
  _PartialOrd,
  _WeakOrd,
  _StrongOrd,
  _CCC_Size
};

template <class _Tp>
_LIBCPP_HIDE_FROM_ABI
constexpr _ClassifyCompCategory __type_to_enum() noexcept {
  if (is_same_v<_Tp, partial_ordering>)
    return _PartialOrd;
  if (is_same_v<_Tp, weak_ordering>)
    return _WeakOrd;
  if (is_same_v<_Tp, strong_ordering>)
    return _StrongOrd;
  return _None;
}

template <size_t _Size>
_LIBCPP_HIDE_FROM_ABI
constexpr _ClassifyCompCategory
__compute_comp_type(const _ClassifyCompCategory (&__types)[_Size]) {
  int __seen[_CCC_Size] = {};
  for (auto __type : __types)
    ++__seen[__type];
  if (__seen[_None])
    return _None;
  if (__seen[_PartialOrd])
    return _PartialOrd;
  if (__seen[_WeakOrd])
    return _WeakOrd;
  return _StrongOrd;
}

template <class ..._Ts, bool _False = false>
_LIBCPP_HIDE_FROM_ABI
constexpr auto __get_comp_type() {
  using _CCC = _ClassifyCompCategory;
  constexpr _CCC __type_kinds[] = {_StrongOrd, __type_to_enum<_Ts>()...};
  constexpr _CCC __cat = __comp_detail::__compute_comp_type(__type_kinds);
  if constexpr (__cat == _None)
    return void();
  else if constexpr (__cat == _PartialOrd)
    return partial_ordering::equivalent;
  else if constexpr (__cat == _WeakOrd)
    return weak_ordering::equivalent;
  else if constexpr (__cat == _StrongOrd)
    return strong_ordering::equivalent;
  else
    static_assert(_False, "unhandled case");
}
} // namespace __comp_detail

// [cmp.common], common comparison category type
template<class... _Ts>
struct _LIBCPP_TEMPLATE_VIS common_comparison_category {
  using type = decltype(__comp_detail::__get_comp_type<_Ts...>());
};

template<class... _Ts>
using common_comparison_category_t = typename common_comparison_category<_Ts...>::type;

#endif // _LIBCPP_STD_VER >= 20
# 92 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__compare/common_comparison_category.h" 3

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___COMPARE_COMMON_COMPARISON_CATEGORY_H
# 96 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__compare/common_comparison_category.h" 3
#endif /* common_comparison_category.h expanded by -frewrite-includes */
# 210 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/variant" 2 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* compare_three_way_result.h expanded by -frewrite-includes */
#include <__compare/compare_three_way_result.h>
#else /* compare_three_way_result.h expanded by -frewrite-includes */
# 210 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/variant" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__compare/compare_three_way_result.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___COMPARE_COMPARE_THREE_WAY_RESULT_H
#define _LIBCPP___COMPARE_COMPARE_THREE_WAY_RESULT_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__compare/compare_three_way_result.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__compare/compare_three_way_result.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/make_const_lvalue_ref.h>
#endif /* expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__compare/compare_three_way_result.h" 3
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__compare/compare_three_way_result.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__utility/declval.h>
#endif /* expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__compare/compare_three_way_result.h" 3
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__compare/compare_three_way_result.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__compare/compare_three_way_result.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__compare/compare_three_way_result.h" 3
#endif
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__compare/compare_three_way_result.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 20
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 23 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__compare/compare_three_way_result.h" 3

template<class, class, class>
struct _LIBCPP_HIDE_FROM_ABI __compare_three_way_result { };

template<class _Tp, class _Up>
struct _LIBCPP_HIDE_FROM_ABI __compare_three_way_result<_Tp, _Up, decltype(
  std::declval<__make_const_lvalue_ref<_Tp>>() <=> std::declval<__make_const_lvalue_ref<_Up>>(), void()
)> {
    using type = decltype(std::declval<__make_const_lvalue_ref<_Tp>>() <=> std::declval<__make_const_lvalue_ref<_Up>>());
};

template<class _Tp, class _Up = _Tp>
struct _LIBCPP_TEMPLATE_VIS compare_three_way_result : __compare_three_way_result<_Tp, _Up, void> { };

template<class _Tp, class _Up = _Tp>
using compare_three_way_result_t = typename compare_three_way_result<_Tp, _Up>::type;

#endif // _LIBCPP_STD_VER >= 20
# 41 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__compare/compare_three_way_result.h" 3

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___COMPARE_COMPARE_THREE_WAY_RESULT_H
# 45 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__compare/compare_three_way_result.h" 3
#endif /* compare_three_way_result.h expanded by -frewrite-includes */
# 211 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/variant" 2 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* three_way_comparable.h expanded by -frewrite-includes */
#include <__compare/three_way_comparable.h>
#else /* three_way_comparable.h expanded by -frewrite-includes */
# 211 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/variant" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__compare/three_way_comparable.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___COMPARE_THREE_WAY_COMPARABLE_H
#define _LIBCPP___COMPARE_THREE_WAY_COMPARABLE_H

#if 0 /* expanded by -frewrite-includes */
#include <__compare/common_comparison_category.h>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__compare/three_way_comparable.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__compare/three_way_comparable.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__compare/ordering.h>
#endif /* expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__compare/three_way_comparable.h" 3
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__compare/three_way_comparable.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__concepts/common_reference_with.h>
#endif /* expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__compare/three_way_comparable.h" 3
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__compare/three_way_comparable.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__concepts/equality_comparable.h>
#endif /* expanded by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__compare/three_way_comparable.h" 3
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__compare/three_way_comparable.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__concepts/same_as.h>
#endif /* expanded by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__compare/three_way_comparable.h" 3
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__compare/three_way_comparable.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__concepts/totally_ordered.h>
#endif /* expanded by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__compare/three_way_comparable.h" 3
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__compare/three_way_comparable.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__compare/three_way_comparable.h" 3
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__compare/three_way_comparable.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/common_reference.h>
#endif /* expanded by -frewrite-includes */
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__compare/three_way_comparable.h" 3
# 20 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__compare/three_way_comparable.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/make_const_lvalue_ref.h>
#endif /* expanded by -frewrite-includes */
# 20 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__compare/three_way_comparable.h" 3
# 21 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__compare/three_way_comparable.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 23 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__compare/three_way_comparable.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 24 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__compare/three_way_comparable.h" 3
#endif
# 25 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__compare/three_way_comparable.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 20
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 29 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__compare/three_way_comparable.h" 3

template<class _Tp, class _Cat>
concept __compares_as =
  same_as<common_comparison_category_t<_Tp, _Cat>, _Cat>;

template<class _Tp, class _Cat = partial_ordering>
concept three_way_comparable =
  __weakly_equality_comparable_with<_Tp, _Tp> &&
  __partially_ordered_with<_Tp, _Tp> &&
  requires(__make_const_lvalue_ref<_Tp> __a, __make_const_lvalue_ref<_Tp> __b) {
    { __a <=> __b } -> __compares_as<_Cat>;
  };

template<class _Tp, class _Up, class _Cat = partial_ordering>
concept three_way_comparable_with =
  three_way_comparable<_Tp, _Cat> &&
  three_way_comparable<_Up, _Cat> &&
  common_reference_with<__make_const_lvalue_ref<_Tp>, __make_const_lvalue_ref<_Up>> &&
  three_way_comparable<common_reference_t<__make_const_lvalue_ref<_Tp>, __make_const_lvalue_ref<_Up>>, _Cat> &&
  __weakly_equality_comparable_with<_Tp, _Up> &&
  __partially_ordered_with<_Tp, _Up> &&
  requires(__make_const_lvalue_ref<_Tp> __t, __make_const_lvalue_ref<_Up> __u) {
    { __t <=> __u } -> __compares_as<_Cat>;
    { __u <=> __t } -> __compares_as<_Cat>;
  };

#endif // _LIBCPP_STD_VER >= 20
# 56 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__compare/three_way_comparable.h" 3

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___COMPARE_THREE_WAY_COMPARABLE_H
# 60 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__compare/three_way_comparable.h" 3
#endif /* three_way_comparable.h expanded by -frewrite-includes */
# 212 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/variant" 2 3
#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 212 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/variant" 3
# 213 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/variant" 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* exception.h expanded by -frewrite-includes */
#include <__exception/exception.h>
#else /* exception.h expanded by -frewrite-includes */
# 213 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/variant" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__exception/exception.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___EXCEPTION_EXCEPTION_H
#define _LIBCPP___EXCEPTION_EXCEPTION_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__exception/exception.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__exception/exception.h" 3

// <vcruntime_exception.h> defines its own std::exception and std::bad_exception types,
// which we use in order to be ABI-compatible with other STLs on Windows.
#if 0 /* disabled by -frewrite-includes */
#if defined(_LIBCPP_ABI_VCRUNTIME)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__exception/exception.h" 3
#if 0 /* expanded by -frewrite-includes */
#  include <vcruntime_exception.h>
#endif /* expanded by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__exception/exception.h" 3
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__exception/exception.h" 3
#endif
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__exception/exception.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 21 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__exception/exception.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 22 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__exception/exception.h" 3
#endif
# 23 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__exception/exception.h" 3

namespace std { // purposefully not using versioning namespace

#if 0 /* disabled by -frewrite-includes */
#if defined(_LIBCPP_ABI_VCRUNTIME) && (!defined(_HAS_EXCEPTIONS) || _HAS_EXCEPTIONS != 0)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 27 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__exception/exception.h" 3
// The std::exception class was already included above, but we're explicit about this condition here for clarity.

#if 0 /* disabled by -frewrite-includes */
#if 0
#elif defined(_LIBCPP_ABI_VCRUNTIME) && _HAS_EXCEPTIONS == 0
#endif
#endif /* disabled by -frewrite-includes */
#elif 0 /* evaluated by -frewrite-includes */
# 30 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__exception/exception.h" 3
// However, <vcruntime_exception.h> does not define std::exception and std::bad_exception
// when _HAS_EXCEPTIONS == 0.
//
// Since libc++ still wants to provide the std::exception hierarchy even when _HAS_EXCEPTIONS == 0
// (after all those are simply types like any other), we define an ABI-compatible version
// of the VCRuntime std::exception and std::bad_exception types in that mode.

struct __std_exception_data {
  char const* _What;
  bool _DoFree;
};

class exception { // base of all library exceptions
public:
  exception() _NOEXCEPT : __data_() {}

  explicit exception(char const* __message) _NOEXCEPT : __data_() {
    __data_._What   = __message;
    __data_._DoFree = true;
  }

  exception(exception const&) _NOEXCEPT {}

  exception& operator=(exception const&) _NOEXCEPT { return *this; }

  virtual ~exception() _NOEXCEPT {}

  virtual char const* what() const _NOEXCEPT { return __data_._What ? __data_._What : "Unknown exception"; }

private:
  __std_exception_data __data_;
};

class bad_exception : public exception {
public:
  bad_exception() _NOEXCEPT : exception("bad exception") {}
};

#else  // !defined(_LIBCPP_ABI_VCRUNTIME)
# 69 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__exception/exception.h" 3
// On all other platforms, we define our own std::exception and std::bad_exception types
// regardless of whether exceptions are turned on as a language feature.

class _LIBCPP_EXPORTED_FROM_ABI exception {
public:
  _LIBCPP_HIDE_FROM_ABI exception() _NOEXCEPT {}
  _LIBCPP_HIDE_FROM_ABI exception(const exception&) _NOEXCEPT            = default;
  _LIBCPP_HIDE_FROM_ABI exception& operator=(const exception&) _NOEXCEPT = default;

  virtual ~exception() _NOEXCEPT;
  virtual const char* what() const _NOEXCEPT;
};

class _LIBCPP_EXPORTED_FROM_ABI bad_exception : public exception {
public:
  _LIBCPP_HIDE_FROM_ABI bad_exception() _NOEXCEPT {}
  _LIBCPP_HIDE_FROM_ABI bad_exception(const bad_exception&) _NOEXCEPT            = default;
  _LIBCPP_HIDE_FROM_ABI bad_exception& operator=(const bad_exception&) _NOEXCEPT = default;
  ~bad_exception() _NOEXCEPT override;
  const char* what() const _NOEXCEPT override;
};
#endif // !_LIBCPP_ABI_VCRUNTIME
# 91 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__exception/exception.h" 3

} // namespace std

#endif // _LIBCPP___EXCEPTION_EXCEPTION_H
# 95 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__exception/exception.h" 3
#endif /* exception.h expanded by -frewrite-includes */
# 214 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/variant" 2 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* hash.h expanded by -frewrite-includes */
#include <__functional/hash.h>
#else /* hash.h expanded by -frewrite-includes */
# 214 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/variant" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__functional/hash.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___FUNCTIONAL_HASH_H
#define _LIBCPP___FUNCTIONAL_HASH_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__functional/hash.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__functional/hash.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__functional/invoke.h>
#endif /* expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__functional/hash.h" 3
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__functional/hash.h" 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* unary_function.h expanded by -frewrite-includes */
#include <__functional/unary_function.h>
#else /* unary_function.h expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__functional/hash.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__functional/unary_function.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___FUNCTIONAL_UNARY_FUNCTION_H
#define _LIBCPP___FUNCTIONAL_UNARY_FUNCTION_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__functional/unary_function.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__functional/unary_function.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__functional/unary_function.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__functional/unary_function.h" 3
#endif
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__functional/unary_function.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER <= 14 || defined(_LIBCPP_ENABLE_CXX17_REMOVED_UNARY_BINARY_FUNCTION)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 21 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__functional/unary_function.h" 3

template <class _Arg, class _Result>
struct _LIBCPP_TEMPLATE_VIS _LIBCPP_DEPRECATED_IN_CXX11 unary_function
{
    typedef _Arg    argument_type;
    typedef _Result result_type;
};

#endif // _LIBCPP_STD_VER <= 14
# 30 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__functional/unary_function.h" 3

template <class _Arg, class _Result> struct __unary_function_keep_layout_base {
#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER <= 17 || defined(_LIBCPP_ENABLE_CXX20_REMOVED_BINDER_TYPEDEFS)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 33 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__functional/unary_function.h" 3
  using argument_type _LIBCPP_DEPRECATED_IN_CXX17 = _Arg;
  using result_type _LIBCPP_DEPRECATED_IN_CXX17 = _Result;
#endif
# 36 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__functional/unary_function.h" 3
};

#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER <= 14 || defined(_LIBCPP_ENABLE_CXX17_REMOVED_UNARY_BINARY_FUNCTION)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 39 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__functional/unary_function.h" 3
_LIBCPP_DIAGNOSTIC_PUSH
_LIBCPP_CLANG_DIAGNOSTIC_IGNORED("-Wdeprecated-declarations")
template <class _Arg, class _Result>
using __unary_function = unary_function<_Arg, _Result>;
_LIBCPP_DIAGNOSTIC_POP
#else
# 45 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__functional/unary_function.h" 3
template <class _Arg, class _Result>
using __unary_function = __unary_function_keep_layout_base<_Arg, _Result>;
#endif
# 48 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__functional/unary_function.h" 3

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___FUNCTIONAL_UNARY_FUNCTION_H
# 52 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__functional/unary_function.h" 3
#endif /* unary_function.h expanded by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__functional/hash.h" 2 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* hash.h expanded by -frewrite-includes */
#include <__fwd/hash.h>
#else /* hash.h expanded by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__functional/hash.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__fwd/hash.h" 1 3
//===---------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===---------------------------------------------------------------------===//

#ifndef _LIBCPP___FWD_HASH_H
#define _LIBCPP___FWD_HASH_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__fwd/hash.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__fwd/hash.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__fwd/hash.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__fwd/hash.h" 3
#endif
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__fwd/hash.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

template <class>
struct _LIBCPP_TEMPLATE_VIS hash;

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___FWD_HASH_H
# 26 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__fwd/hash.h" 3
#endif /* hash.h expanded by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__functional/hash.h" 2 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* sfinae_helpers.h expanded by -frewrite-includes */
#include <__tuple/sfinae_helpers.h>
#else /* sfinae_helpers.h expanded by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__functional/hash.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/sfinae_helpers.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___TUPLE_SFINAE_HELPERS_H
#define _LIBCPP___TUPLE_SFINAE_HELPERS_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/sfinae_helpers.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/sfinae_helpers.h" 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* tuple.h expanded by -frewrite-includes */
#include <__fwd/tuple.h>
#else /* tuple.h expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/sfinae_helpers.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__fwd/tuple.h" 1 3
//===---------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===---------------------------------------------------------------------===//

#ifndef _LIBCPP___FWD_TUPLE_H
#define _LIBCPP___FWD_TUPLE_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__fwd/tuple.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__fwd/tuple.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__fwd/tuple.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__fwd/tuple.h" 3
#endif
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__fwd/tuple.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

#ifndef _LIBCPP_CXX03_LANG

template <class...>
class _LIBCPP_TEMPLATE_VIS tuple;

#endif // _LIBCPP_CXX03_LANG
# 26 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__fwd/tuple.h" 3

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___FWD_TUPLE_H
# 30 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__fwd/tuple.h" 3
#endif /* tuple.h expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/sfinae_helpers.h" 2 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* make_tuple_types.h expanded by -frewrite-includes */
#include <__tuple/make_tuple_types.h>
#else /* make_tuple_types.h expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/sfinae_helpers.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/make_tuple_types.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___TUPLE_MAKE_TUPLE_TYPES_H
#define _LIBCPP___TUPLE_MAKE_TUPLE_TYPES_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/make_tuple_types.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/make_tuple_types.h" 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* array.h expanded by -frewrite-includes */
#include <__fwd/array.h>
#else /* array.h expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/make_tuple_types.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__fwd/array.h" 1 3
//===---------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===---------------------------------------------------------------------===//

#ifndef _LIBCPP___FWD_ARRAY_H
#define _LIBCPP___FWD_ARRAY_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__fwd/array.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__fwd/array.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <cstddef>
#endif /* expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__fwd/array.h" 3
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__fwd/array.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__fwd/array.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__fwd/array.h" 3
#endif
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__fwd/array.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

template <class _Tp, size_t _Size>
struct _LIBCPP_TEMPLATE_VIS array;

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___FWD_ARRAY_H
# 27 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__fwd/array.h" 3
#endif /* array.h expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/make_tuple_types.h" 2 3
#if 0 /* expanded by -frewrite-includes */
#include <__fwd/tuple.h>
#endif /* expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/make_tuple_types.h" 3
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/make_tuple_types.h" 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* tuple_element.h expanded by -frewrite-includes */
#include <__tuple/tuple_element.h>
#else /* tuple_element.h expanded by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/make_tuple_types.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/tuple_element.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___TUPLE_TUPLE_ELEMENT_H
#define _LIBCPP___TUPLE_TUPLE_ELEMENT_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/tuple_element.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/tuple_element.h" 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* tuple_indices.h expanded by -frewrite-includes */
#include <__tuple/tuple_indices.h>
#else /* tuple_indices.h expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/tuple_element.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/tuple_indices.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___TUPLE_MAKE_TUPLE_INDICES_H
#define _LIBCPP___TUPLE_MAKE_TUPLE_INDICES_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/tuple_indices.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/tuple_indices.h" 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* integer_sequence.h expanded by -frewrite-includes */
#include <__utility/integer_sequence.h>
#else /* integer_sequence.h expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/tuple_indices.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/integer_sequence.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___UTILITY_INTEGER_SEQUENCE_H
#define _LIBCPP___UTILITY_INTEGER_SEQUENCE_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/integer_sequence.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/integer_sequence.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/is_integral.h>
#endif /* expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/integer_sequence.h" 3
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/integer_sequence.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <cstddef>
#endif /* expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/integer_sequence.h" 3
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/integer_sequence.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/integer_sequence.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/integer_sequence.h" 3
#endif
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/integer_sequence.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

template <size_t...> struct __tuple_indices;

template <class _IdxType, _IdxType... _Values>
struct __integer_sequence {
  template <template <class _OIdxType, _OIdxType...> class _ToIndexSeq, class _ToIndexType>
  using __convert = _ToIndexSeq<_ToIndexType, _Values...>;

  template <size_t _Sp>
  using __to_tuple_indices = __tuple_indices<(_Values + _Sp)...>;
};

#if 0 /* disabled by -frewrite-includes */
#if !__has_builtin(__make_integer_seq) || defined(_LIBCPP_TESTING_FALLBACK_MAKE_INTEGER_SEQUENCE)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 34 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/integer_sequence.h" 3

namespace __detail {

template<typename _Tp, size_t ..._Extra> struct __repeat;
template<typename _Tp, _Tp ..._Np, size_t ..._Extra> struct __repeat<__integer_sequence<_Tp, _Np...>, _Extra...> {
  typedef _LIBCPP_NODEBUG __integer_sequence<_Tp,
                           _Np...,
                           sizeof...(_Np) + _Np...,
                           2 * sizeof...(_Np) + _Np...,
                           3 * sizeof...(_Np) + _Np...,
                           4 * sizeof...(_Np) + _Np...,
                           5 * sizeof...(_Np) + _Np...,
                           6 * sizeof...(_Np) + _Np...,
                           7 * sizeof...(_Np) + _Np...,
                           _Extra...> type;
};

template<size_t _Np> struct __parity;
template<size_t _Np> struct __make : __parity<_Np % 8>::template __pmake<_Np> {};

template<> struct __make<0> { typedef __integer_sequence<size_t> type; };
template<> struct __make<1> { typedef __integer_sequence<size_t, 0> type; };
template<> struct __make<2> { typedef __integer_sequence<size_t, 0, 1> type; };
template<> struct __make<3> { typedef __integer_sequence<size_t, 0, 1, 2> type; };
template<> struct __make<4> { typedef __integer_sequence<size_t, 0, 1, 2, 3> type; };
template<> struct __make<5> { typedef __integer_sequence<size_t, 0, 1, 2, 3, 4> type; };
template<> struct __make<6> { typedef __integer_sequence<size_t, 0, 1, 2, 3, 4, 5> type; };
template<> struct __make<7> { typedef __integer_sequence<size_t, 0, 1, 2, 3, 4, 5, 6> type; };

template<> struct __parity<0> { template<size_t _Np> struct __pmake : __repeat<typename __make<_Np / 8>::type> {}; };
template<> struct __parity<1> { template<size_t _Np> struct __pmake : __repeat<typename __make<_Np / 8>::type, _Np - 1> {}; };
template<> struct __parity<2> { template<size_t _Np> struct __pmake : __repeat<typename __make<_Np / 8>::type, _Np - 2, _Np - 1> {}; };
template<> struct __parity<3> { template<size_t _Np> struct __pmake : __repeat<typename __make<_Np / 8>::type, _Np - 3, _Np - 2, _Np - 1> {}; };
template<> struct __parity<4> { template<size_t _Np> struct __pmake : __repeat<typename __make<_Np / 8>::type, _Np - 4, _Np - 3, _Np - 2, _Np - 1> {}; };
template<> struct __parity<5> { template<size_t _Np> struct __pmake : __repeat<typename __make<_Np / 8>::type, _Np - 5, _Np - 4, _Np - 3, _Np - 2, _Np - 1> {}; };
template<> struct __parity<6> { template<size_t _Np> struct __pmake : __repeat<typename __make<_Np / 8>::type, _Np - 6, _Np - 5, _Np - 4, _Np - 3, _Np - 2, _Np - 1> {}; };
template<> struct __parity<7> { template<size_t _Np> struct __pmake : __repeat<typename __make<_Np / 8>::type, _Np - 7, _Np - 6, _Np - 5, _Np - 4, _Np - 3, _Np - 2, _Np - 1> {}; };

} // namespace detail

#endif
# 75 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/integer_sequence.h" 3

#if 0 /* disabled by -frewrite-includes */
#if __has_builtin(__make_integer_seq)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 77 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/integer_sequence.h" 3
template <size_t _Ep, size_t _Sp>
using __make_indices_imp =
    typename __make_integer_seq<__integer_sequence, size_t, _Ep - _Sp>::template
    __to_tuple_indices<_Sp>;
#else
# 82 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/integer_sequence.h" 3
template <size_t _Ep, size_t _Sp>
using __make_indices_imp =
    typename __detail::__make<_Ep - _Sp>::type::template __to_tuple_indices<_Sp>;

#endif
# 87 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/integer_sequence.h" 3

#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 14
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 89 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/integer_sequence.h" 3

template<class _Tp, _Tp... _Ip>
struct _LIBCPP_TEMPLATE_VIS integer_sequence
{
    typedef _Tp value_type;
    static_assert( is_integral<_Tp>::value,
                  "std::integer_sequence can only be instantiated with an integral type" );
    static
    _LIBCPP_INLINE_VISIBILITY
    constexpr
    size_t
    size() noexcept { return sizeof...(_Ip); }
};

template<size_t... _Ip>
    using index_sequence = integer_sequence<size_t, _Ip...>;

#if 0 /* disabled by -frewrite-includes */
#if __has_builtin(__make_integer_seq) && !defined(_LIBCPP_TESTING_FALLBACK_MAKE_INTEGER_SEQUENCE)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 107 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/integer_sequence.h" 3

template <class _Tp, _Tp _Ep>
using __make_integer_sequence _LIBCPP_NODEBUG = __make_integer_seq<integer_sequence, _Tp, _Ep>;

#else
# 112 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/integer_sequence.h" 3

template<typename _Tp, _Tp _Np> using __make_integer_sequence_unchecked _LIBCPP_NODEBUG =
  typename __detail::__make<_Np>::type::template __convert<integer_sequence, _Tp>;

template <class _Tp, _Tp _Ep>
struct __make_integer_sequence_checked
{
    static_assert(is_integral<_Tp>::value,
                  "std::make_integer_sequence can only be instantiated with an integral type" );
    static_assert(0 <= _Ep, "std::make_integer_sequence must have a non-negative sequence length");
    // Workaround GCC bug by preventing bad installations when 0 <= _Ep
    // https://gcc.gnu.org/bugzilla/show_bug.cgi?id=68929
    typedef _LIBCPP_NODEBUG __make_integer_sequence_unchecked<_Tp, 0 <= _Ep ? _Ep : 0> type;
};

template <class _Tp, _Tp _Ep>
using __make_integer_sequence _LIBCPP_NODEBUG = typename __make_integer_sequence_checked<_Tp, _Ep>::type;

#endif
# 131 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/integer_sequence.h" 3

template<class _Tp, _Tp _Np>
    using make_integer_sequence = __make_integer_sequence<_Tp, _Np>;

template<size_t _Np>
    using make_index_sequence = make_integer_sequence<size_t, _Np>;

template<class... _Tp>
    using index_sequence_for = make_index_sequence<sizeof...(_Tp)>;

#if 0 /* disabled by -frewrite-includes */
#  if _LIBCPP_STD_VER >= 20
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 142 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/integer_sequence.h" 3
// Executes __func for every element in an index_sequence.
template <size_t... _Index, class _Function>
_LIBCPP_HIDE_FROM_ABI constexpr void __for_each_index_sequence(index_sequence<_Index...>, _Function __func) {
    (__func.template operator()<_Index>(), ...);
}
#  endif // _LIBCPP_STD_VER >= 20
# 148 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/integer_sequence.h" 3

#endif // _LIBCPP_STD_VER >= 14
# 150 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/integer_sequence.h" 3

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___UTILITY_INTEGER_SEQUENCE_H
# 154 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__utility/integer_sequence.h" 3
#endif /* integer_sequence.h expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/tuple_indices.h" 2 3
#if 0 /* expanded by -frewrite-includes */
#include <cstddef>
#endif /* expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/tuple_indices.h" 3
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/tuple_indices.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/tuple_indices.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/tuple_indices.h" 3
#endif
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/tuple_indices.h" 3

#ifndef _LIBCPP_CXX03_LANG

_LIBCPP_BEGIN_NAMESPACE_STD

template <size_t...> struct __tuple_indices {};

template <size_t _Ep, size_t _Sp = 0>
struct __make_tuple_indices
{
    static_assert(_Sp <= _Ep, "__make_tuple_indices input error");
    typedef __make_indices_imp<_Ep, _Sp> type;
};

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP_CXX03_LANG
# 36 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/tuple_indices.h" 3

#endif // _LIBCPP___TUPLE_MAKE_TUPLE_INDICES_H
# 38 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/tuple_indices.h" 3
#endif /* tuple_indices.h expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/tuple_element.h" 2 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* tuple_types.h expanded by -frewrite-includes */
#include <__tuple/tuple_types.h>
#else /* tuple_types.h expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/tuple_element.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/tuple_types.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___TUPLE_TUPLE_TYPES_H
#define _LIBCPP___TUPLE_TUPLE_TYPES_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/tuple_types.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/tuple_types.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/tuple_types.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/tuple_types.h" 3
#endif
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/tuple_types.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

template <class ..._Tp> struct __tuple_types {};

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___TUPLE_TUPLE_TYPES_H
# 25 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/tuple_types.h" 3
#endif /* tuple_types.h expanded by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/tuple_element.h" 2 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/add_const.h>
#endif /* expanded by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/tuple_element.h" 3
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/tuple_element.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/add_cv.h>
#endif /* expanded by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/tuple_element.h" 3
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/tuple_element.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/add_volatile.h>
#endif /* expanded by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/tuple_element.h" 3
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/tuple_element.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <cstddef>
#endif /* expanded by -frewrite-includes */
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/tuple_element.h" 3
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/tuple_element.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 21 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/tuple_element.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 22 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/tuple_element.h" 3
#endif
# 23 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/tuple_element.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

template <size_t _Ip, class _Tp> struct _LIBCPP_TEMPLATE_VIS tuple_element;

template <size_t _Ip, class _Tp>
struct _LIBCPP_TEMPLATE_VIS tuple_element<_Ip, const _Tp>
{
    typedef _LIBCPP_NODEBUG typename add_const<typename tuple_element<_Ip, _Tp>::type>::type type;
};

template <size_t _Ip, class _Tp>
struct _LIBCPP_TEMPLATE_VIS tuple_element<_Ip, volatile _Tp>
{
    typedef _LIBCPP_NODEBUG typename add_volatile<typename tuple_element<_Ip, _Tp>::type>::type type;
};

template <size_t _Ip, class _Tp>
struct _LIBCPP_TEMPLATE_VIS tuple_element<_Ip, const volatile _Tp>
{
    typedef _LIBCPP_NODEBUG typename add_cv<typename tuple_element<_Ip, _Tp>::type>::type type;
};

#ifndef _LIBCPP_CXX03_LANG

#if 0 /* disabled by -frewrite-includes */
#if !__has_builtin(__type_pack_element)
#endif
#endif /* disabled by -frewrite-includes */
#if 0 /* evaluated by -frewrite-includes */
# 49 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/tuple_element.h" 3

namespace __indexer_detail {

template <size_t _Idx, class _Tp>
struct __indexed { using type _LIBCPP_NODEBUG = _Tp; };

template <class _Types, class _Indexes> struct __indexer;

template <class ..._Types, size_t ..._Idx>
struct __indexer<__tuple_types<_Types...>, __tuple_indices<_Idx...>>
    : __indexed<_Idx, _Types>...
{};

template <size_t _Idx, class _Tp>
__indexed<_Idx, _Tp> __at_index(__indexed<_Idx, _Tp> const&);

} // namespace __indexer_detail

template <size_t _Idx, class ..._Types>
using __type_pack_element _LIBCPP_NODEBUG = typename decltype(
    __indexer_detail::__at_index<_Idx>(
        __indexer_detail::__indexer<
            __tuple_types<_Types...>,
            typename __make_tuple_indices<sizeof...(_Types)>::type
        >{})
  )::type;
#endif
# 76 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/tuple_element.h" 3

template <size_t _Ip, class ..._Types>
struct _LIBCPP_TEMPLATE_VIS tuple_element<_Ip, __tuple_types<_Types...> >
{
    static_assert(_Ip < sizeof...(_Types), "tuple_element index out of range");
    typedef _LIBCPP_NODEBUG __type_pack_element<_Ip, _Types...> type;
};

#if 0 /* disabled by -frewrite-includes */
#if _LIBCPP_STD_VER >= 14
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 85 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/tuple_element.h" 3
template <size_t _Ip, class ..._Tp>
using tuple_element_t _LIBCPP_NODEBUG = typename tuple_element <_Ip, _Tp...>::type;
#endif
# 88 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/tuple_element.h" 3

#endif // _LIBCPP_CXX03_LANG
# 90 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/tuple_element.h" 3

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___TUPLE_TUPLE_ELEMENT_H
# 94 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/tuple_element.h" 3
#endif /* tuple_element.h expanded by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/make_tuple_types.h" 2 3
#if 0 /* expanded by -frewrite-includes */
#include <__tuple/tuple_indices.h>
#endif /* expanded by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/make_tuple_types.h" 3
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/make_tuple_types.h" 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* tuple_size.h expanded by -frewrite-includes */
#include <__tuple/tuple_size.h>
#else /* tuple_size.h expanded by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/make_tuple_types.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/tuple_size.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___TUPLE_TUPLE_SIZE_H
#define _LIBCPP___TUPLE_TUPLE_SIZE_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/tuple_size.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/tuple_size.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__fwd/tuple.h>
#endif /* expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/tuple_size.h" 3
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/tuple_size.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__tuple/tuple_types.h>
#endif /* expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/tuple_size.h" 3
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/tuple_size.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/is_const.h>
#endif /* expanded by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/tuple_size.h" 3
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/tuple_size.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/is_volatile.h>
#endif /* expanded by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/tuple_size.h" 3
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/tuple_size.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <cstddef>
#endif /* expanded by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/tuple_size.h" 3
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/tuple_size.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 20 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/tuple_size.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 21 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/tuple_size.h" 3
#endif
# 22 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/tuple_size.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

template <class _Tp> struct _LIBCPP_TEMPLATE_VIS tuple_size;

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_CXX03_LANG)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 28 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/tuple_size.h" 3
template <class _Tp, class...>
using __enable_if_tuple_size_imp = _Tp;

template <class _Tp>
struct _LIBCPP_TEMPLATE_VIS tuple_size<__enable_if_tuple_size_imp<
    const _Tp,
    __enable_if_t<!is_volatile<_Tp>::value>,
    integral_constant<size_t, sizeof(tuple_size<_Tp>)>>>
    : public integral_constant<size_t, tuple_size<_Tp>::value> {};

template <class _Tp>
struct _LIBCPP_TEMPLATE_VIS tuple_size<__enable_if_tuple_size_imp<
    volatile _Tp,
    __enable_if_t<!is_const<_Tp>::value>,
    integral_constant<size_t, sizeof(tuple_size<_Tp>)>>>
    : public integral_constant<size_t, tuple_size<_Tp>::value> {};

template <class _Tp>
struct _LIBCPP_TEMPLATE_VIS tuple_size<__enable_if_tuple_size_imp<
    const volatile _Tp,
    integral_constant<size_t, sizeof(tuple_size<_Tp>)>>>
    : public integral_constant<size_t, tuple_size<_Tp>::value> {};

#else
# 52 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/tuple_size.h" 3
template <class _Tp> struct _LIBCPP_TEMPLATE_VIS tuple_size<const _Tp> : public tuple_size<_Tp> {};
template <class _Tp> struct _LIBCPP_TEMPLATE_VIS tuple_size<volatile _Tp> : public tuple_size<_Tp> {};
template <class _Tp> struct _LIBCPP_TEMPLATE_VIS tuple_size<const volatile _Tp> : public tuple_size<_Tp> {};
#endif
# 56 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/tuple_size.h" 3

#ifndef _LIBCPP_CXX03_LANG

template <class ..._Tp>
struct _LIBCPP_TEMPLATE_VIS tuple_size<tuple<_Tp...> >
    : public integral_constant<size_t, sizeof...(_Tp)>
{
};

template <class ..._Tp>
struct _LIBCPP_TEMPLATE_VIS tuple_size<__tuple_types<_Tp...> >
    : public integral_constant<size_t, sizeof...(_Tp)>
{
};

#endif // _LIBCPP_CXX03_LANG
# 72 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/tuple_size.h" 3

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___TUPLE_TUPLE_SIZE_H
# 76 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/tuple_size.h" 3
#endif /* tuple_size.h expanded by -frewrite-includes */
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/make_tuple_types.h" 2 3
#if 0 /* expanded by -frewrite-includes */
#include <__tuple/tuple_types.h>
#endif /* expanded by -frewrite-includes */
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/make_tuple_types.h" 3
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/make_tuple_types.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/apply_cv.h>
#endif /* expanded by -frewrite-includes */
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/make_tuple_types.h" 3
# 20 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/make_tuple_types.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/remove_cv.h>
#endif /* expanded by -frewrite-includes */
# 20 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/make_tuple_types.h" 3
# 21 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/make_tuple_types.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/remove_reference.h>
#endif /* expanded by -frewrite-includes */
# 21 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/make_tuple_types.h" 3
# 22 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/make_tuple_types.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <cstddef>
#endif /* expanded by -frewrite-includes */
# 22 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/make_tuple_types.h" 3
# 23 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/make_tuple_types.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 25 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/make_tuple_types.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 26 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/make_tuple_types.h" 3
#endif
# 27 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/make_tuple_types.h" 3

#ifndef _LIBCPP_CXX03_LANG

_LIBCPP_BEGIN_NAMESPACE_STD

// __make_tuple_types<_Tuple<_Types...>, _Ep, _Sp>::type is a
// __tuple_types<_Types...> using only those _Types in the range [_Sp, _Ep).
// _Sp defaults to 0 and _Ep defaults to tuple_size<_Tuple>.  If _Tuple is a
// lvalue_reference type, then __tuple_types<_Types&...> is the result.

template <class _TupleTypes, class _TupleIndices>
struct __make_tuple_types_flat;

template <template <class...> class _Tuple, class ..._Types, size_t ..._Idx>
struct __make_tuple_types_flat<_Tuple<_Types...>, __tuple_indices<_Idx...>> {
  // Specialization for pair, tuple, and __tuple_types
  template <class _Tp>
  using __apply_quals _LIBCPP_NODEBUG = __tuple_types<__apply_cv_t<_Tp, __type_pack_element<_Idx, _Types...>>...>;
};

template <class _Vt, size_t _Np, size_t ..._Idx>
struct __make_tuple_types_flat<array<_Vt, _Np>, __tuple_indices<_Idx...>> {
  template <size_t>
  using __value_type = _Vt;
  template <class _Tp>
  using __apply_quals = __tuple_types<__apply_cv_t<_Tp, __value_type<_Idx>>...>;
};

template <class _Tp, size_t _Ep = tuple_size<__libcpp_remove_reference_t<_Tp> >::value,
          size_t _Sp = 0,
          bool _SameSize = (_Ep == tuple_size<__libcpp_remove_reference_t<_Tp> >::value)>
struct __make_tuple_types
{
    static_assert(_Sp <= _Ep, "__make_tuple_types input error");
    using _RawTp = __remove_cv_t<__libcpp_remove_reference_t<_Tp> >;
    using _Maker = __make_tuple_types_flat<_RawTp, typename __make_tuple_indices<_Ep, _Sp>::type>;
    using type = typename _Maker::template __apply_quals<_Tp>;
};

template <class ..._Types, size_t _Ep>
struct __make_tuple_types<tuple<_Types...>, _Ep, 0, true> {
  typedef _LIBCPP_NODEBUG __tuple_types<_Types...> type;
};

template <class ..._Types, size_t _Ep>
struct __make_tuple_types<__tuple_types<_Types...>, _Ep, 0, true> {
  typedef _LIBCPP_NODEBUG __tuple_types<_Types...> type;
};

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP_CXX03_LANG
# 79 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/make_tuple_types.h" 3

#endif // _LIBCPP___TUPLE_MAKE_TUPLE_TYPES_H
# 81 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/make_tuple_types.h" 3
#endif /* make_tuple_types.h expanded by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/sfinae_helpers.h" 2 3
#if 0 /* expanded by -frewrite-includes */
#include <__tuple/tuple_element.h>
#endif /* expanded by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/sfinae_helpers.h" 3
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/sfinae_helpers.h" 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* tuple_like_ext.h expanded by -frewrite-includes */
#include <__tuple/tuple_like_ext.h>
#else /* tuple_like_ext.h expanded by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/sfinae_helpers.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/tuple_like_ext.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___TUPLE_TUPLE_LIKE_EXT_H
#define _LIBCPP___TUPLE_TUPLE_LIKE_EXT_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/tuple_like_ext.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/tuple_like_ext.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__fwd/array.h>
#endif /* expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/tuple_like_ext.h" 3
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/tuple_like_ext.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__fwd/pair.h>
#endif /* expanded by -frewrite-includes */
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/tuple_like_ext.h" 3
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/tuple_like_ext.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__fwd/tuple.h>
#endif /* expanded by -frewrite-includes */
# 15 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/tuple_like_ext.h" 3
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/tuple_like_ext.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__tuple/tuple_types.h>
#endif /* expanded by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/tuple_like_ext.h" 3
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/tuple_like_ext.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/integral_constant.h>
#endif /* expanded by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/tuple_like_ext.h" 3
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/tuple_like_ext.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <cstddef>
#endif /* expanded by -frewrite-includes */
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/tuple_like_ext.h" 3
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/tuple_like_ext.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 21 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/tuple_like_ext.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#endif /* expanded by -frewrite-includes */
# 22 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/tuple_like_ext.h" 3
#endif
# 23 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/tuple_like_ext.h" 3

_LIBCPP_BEGIN_NAMESPACE_STD

template <class _Tp> struct __tuple_like_ext : false_type {};

template <class _Tp> struct __tuple_like_ext<const _Tp> : public __tuple_like_ext<_Tp> {};
template <class _Tp> struct __tuple_like_ext<volatile _Tp> : public __tuple_like_ext<_Tp> {};
template <class _Tp> struct __tuple_like_ext<const volatile _Tp> : public __tuple_like_ext<_Tp> {};

#ifndef _LIBCPP_CXX03_LANG
template <class... _Tp> struct __tuple_like_ext<tuple<_Tp...> > : true_type {};
#endif
# 35 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/tuple_like_ext.h" 3

template <class _T1, class _T2> struct __tuple_like_ext<pair<_T1, _T2> > : true_type {};

template <class _Tp, size_t _Size> struct __tuple_like_ext<array<_Tp, _Size> > : true_type {};

template <class... _Tp> struct __tuple_like_ext<__tuple_types<_Tp...> > : true_type {};

_LIBCPP_END_NAMESPACE_STD

#endif // _LIBCPP___TUPLE_TUPLE_LIKE_EXT_H
# 45 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/tuple_like_ext.h" 3
#endif /* tuple_like_ext.h expanded by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/sfinae_helpers.h" 2 3
#if 0 /* expanded by -frewrite-includes */
#include <__tuple/tuple_size.h>
#endif /* expanded by -frewrite-includes */
# 17 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/sfinae_helpers.h" 3
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/sfinae_helpers.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__tuple/tuple_types.h>
#endif /* expanded by -frewrite-includes */
# 18 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/sfinae_helpers.h" 3
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/sfinae_helpers.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/enable_if.h>
#endif /* expanded by -frewrite-includes */
# 19 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/sfinae_helpers.h" 3
# 20 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/sfinae_helpers.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/integral_constant.h>
#endif /* expanded by -frewrite-includes */
# 20 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/sfinae_helpers.h" 3
# 21 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/sfinae_helpers.h" 3
#if defined(__CLANG_REWRITTEN_INCLUDES) || defined(__CLANG_REWRITTEN_SYSTEM_INCLUDES) /* is_assignable.h expanded by -frewrite-includes */
#include <__type_traits/is_assignable.h>
#else /* is_assignable.h expanded by -frewrite-includes */
# 21 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__tuple/sfinae_helpers.h" 3
# 1 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_assignable.h" 1 3
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___TYPE_TRAITS_IS_ASSIGNABLE_H
#define _LIBCPP___TYPE_TRAITS_IS_ASSIGNABLE_H

#if 0 /* expanded by -frewrite-includes */
#include <__config>
#endif /* expanded by -frewrite-includes */
# 12 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_assignable.h" 3
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_assignable.h" 3
#if 0 /* expanded by -frewrite-includes */
#include <__type_traits/integral_constant.h>
#endif /* expanded by -frewrite-includes */
# 13 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_assignable.h" 3
# 14 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_assignable.h" 3

#if 0 /* disabled by -frewrite-includes */
#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#endif
#endif /* disabled by -frewrite-includes */
#if 1 /* evaluated by -frewrite-includes */
# 16 "../../prebuilt/third_party/clang/custom/bin/../include/c++/v1/__type_traits/is_assignable.h" 3
#if 0 /* expanded by -frewrite-includes */
#  pragma GCC system_header
#e