/*
 * This Java source file was generated by the Gradle 'init' task.
 */
package dmsdk;
import com.marklogic.client.datamovement.DataMovementManager;
import com.marklogic.client.DatabaseClient;
import com.marklogic.client.DatabaseClientFactory;
import com.marklogic.client.datamovement.QueryBatcher;
import com.marklogic.client.query.QueryManager;
import com.marklogic.client.query.StringQueryDefinition;
import com.marklogic.client.query.StructuredQueryBuilder;
import com.marklogic.client.query.StructuredQueryDefinition;
import com.marklogic.client.datamovement.JobTicket;
import com.marklogic.client.DatabaseClientFactory;
import com.marklogic.client.datamovement.ForestConfiguration;

public class App {

    public static void main(String[] args) {
        System.out.println("ohai");
        new App().doWorkSon ();
        System.out.println("obai");
    }

    public void doWorkSon () {
        DatabaseClientFactory.DigestAuthContext authContext = new DatabaseClientFactory.DigestAuthContext("admin", "chamlin");
        DatabaseClient databaseClient = DatabaseClientFactory.newClient ("xyz.marklogic.com", 8002, "tiered", authContext);
        QueryManager queryMgr = databaseClient.newQueryManager();
        StructuredQueryBuilder sqb = queryMgr.newStructuredQueryBuilder();
        StructuredQueryDefinition query = sqb.directory(true, "/");

        DataMovementManager dataMovementManager = databaseClient.newDataMovementManager();
        ForestConfiguration fconf = dataMovementManager.readForestConfig();
        System.out.println ("fconf: " + fconf.toString());
         QueryBatcher qhb = dataMovementManager.newQueryBatcher(query)
             .withBatchSize(1000)
             .withThreadCount(20)
               .withConsistentSnapshot()
             .onUrisReady(batch -> {
                 for ( String uri : batch.getItems() ) {
                     //if ( uri.endsWith(".txt") ) {
                     //    databaseClient.newDocumentManager().delete(uri);
                     //}
                    System.out.println (uri);
                 }
             })
             .onQueryFailure(queryBatchException -> queryBatchException.printStackTrace());
         JobTicket ticket = dataMovementManager.startJob(qhb);
         qhb.awaitCompletion();
         dataMovementManager.stopJob(ticket);
    }
}


