package dmsdk;

import java.util.ArrayList;
import java.util.Set;
import java.util.TreeSet;
import com.marklogic.client.DatabaseClient;
import com.marklogic.client.DatabaseClientFactory;
import com.marklogic.client.query.StructuredQueryBuilder;
import com.marklogic.client.query.StructuredQueryDefinition;
import com.marklogic.client.datamovement.DataMovementManager;
import com.marklogic.client.datamovement.QueryBatcher;
import com.marklogic.client.datamovement.JobTicket;
import com.marklogic.client.datamovement.Forest;
import com.marklogic.client.datamovement.ForestConfiguration;

public class App
{
    // try forest filtering?, change it to change scenario
    public static final boolean FILTER = false;
    // collection to use as a test query
    public static final String COLL = "/some/test/collection";
    // names of the forests to be excluded
    public static final Set<String> EXCLUSIONS = new TreeSet(); //Set.of("Documents-xxx");
    // connection details
    public static final String HOST = "xyz.marklogic.com";
    public static final int    PORT = 8000;
    public static final String USER = "admin";
    public static final String PWD  = "chamlin";
    public static final String DB   = "tiered";

    // connect to ML, use a simple test query, and use a QueryBatcher (either filtering or not the forests)
    public static void main(String... args)
    {
        final DatabaseClient marklogic = DatabaseClientFactory.newClient(
            HOST, PORT, DB, new DatabaseClientFactory.DigestAuthContext(USER, PWD));
        final DataMovementManager manager = marklogic.newDataMovementManager();
        final StructuredQueryDefinition query = marklogic
            .newQueryManager()
            .newStructuredQueryBuilder()
            .directory(true, "/");
        final ForestConfiguration forests = FILTER
            ? new ForestConfigProxy(manager.readForestConfig(), EXCLUSIONS)
            : manager.readForestConfig();
        final QueryBatcher batcher = manager.newQueryBatcher(query)
            .withForestConfig(forests)
            .withThreadCount(1)
            .onUrisReady(batch -> {
                // just display the number of URIs
                System.out.println(batch.getItems().length + " on " + batch.getForest().getForestName());
                //System.out.println("URIs: " + String.join(", ", batch.getItems()));
            })
            .onQueryFailure(queryBatchException -> queryBatchException.printStackTrace());
        final JobTicket ticket = manager.startJob(batcher);
        batcher.awaitCompletion();
        manager.stopJob(ticket);        
        System.out.println("Bye for now!");
    }

    // proxy over a forest config, filtering forests based on an exclusion list
    public static final class ForestConfigProxy
        implements ForestConfiguration
    {
        private ForestConfiguration proxied;
        private Set<String> exclusions;

        public ForestConfigProxy(ForestConfiguration conf, Set<String> excl) {
            this.proxied = conf;
            this.exclusions = excl;
            this.exclusions.add ("cold-0001");
            this.exclusions.add ("cold-0002");
            this.exclusions.add ("cold-0003");
            this.exclusions.add ("cold-0004");
            this.exclusions.add ("cold-0005");
            this.exclusions.add ("cold-0006");
            this.exclusions.add ("cold-0007");
            this.exclusions.add ("cold-0008");
            this.exclusions.add ("cold-0009");
        }

        public Forest[] listForests() {
            final ArrayList<Forest> res = new ArrayList<Forest>();
            // copy listForests() from proxied into res, except if name is in exclusions
            for ( Forest f : this.proxied.listForests() ) {
                final String name = f.getForestName();
                if ( this.exclusions.contains(name) ) {
                    System.out.println("Discard forest: " + name);
                }
                else {
                    res.add(f);
                    System.out.println("Keep forest: " + name);
                }
            }
            return res.toArray(new Forest[0]);
        }

    }
}


