const PROTO_RELATIVE = '../example';
const PROTO_BUNDLE = 'example_bundle.json';
const GOOGLEAPIS_PATH = '../googleapis';
const GRPC_GATEWAY_PATH = '../grpc-gateway';
const ADAPTER_STAGING = __dirname + '/adapter_work';

const fs = require('fs');
const util = require('util');
const parseArgs = require('minimist');
const path = require('path');
const _ = require('lodash');
const find = require('find');
const pbjs = require("protobufjs/cli/pbjs");
const grpc = require('@grpc/grpc-js');
const protoLoader = require('@grpc/proto-loader');
const { config } = require('process');

const protoroot = path.resolve(PROTO_RELATIVE);
const googleroot = path.resolve(GOOGLEAPIS_PATH);
const gatewayroot = path.resolve(GRPC_GATEWAY_PATH);

function generate_json_bundle( options ) {
  const args = [
    "--target", "json",
    "--path", options.protoroot,
    "--path", googleroot,
    "--path", gatewayroot,
    "--es6"
  ].concat(options.protolist);
  // console.error( util.inspect( args ));
  let result ;
  pbjs.main( args, (err, out) => {
    if( err ) throw err;
    result = out ;
  });
  console.error(`generate_json_bundle result length is ${result.length}`);
  return result ;
}

function save_json_bundle( bundle ){
  const filename = path.resolve( ADAPTER_STAGING, PROTO_BUNDLE );
  fs.writeFileSync( filename, bundle, {mode: 0o664});
  return filename ;
}

// https://www.npmjs.com/package/find
const protolist = find.fileSync(/\.proto$/, protoroot);
const jsonBundle = generate_json_bundle( {protoroot/*: PROTO_RELATIVE*/, protolist} );
const jsonBundleFile = save_json_bundle( jsonBundle );
const bundleDefinition = protoLoader.loadSync( jsonBundleFile, {
  keepCase: true,
  longs: String,
  enums: String,
  defaults: true,
  oneofs: true
} );

function replace_data_array( key, value ){
  if( key === "data" && Array.isArray(value)){
    return { length: value.length };
  }else{
    return value ;
  }
}

//console.log(`packageDefinition is ${util.inspect(packageDefinition, {colors: true, depth: 1})}`);
//console.log(util.inspect(packageDefinition, {colors: false, depth: Infinity}));
//console.log(JSON.stringify(packageDefinition, replace_data_array, 2));
console.log( util.inspect( getAllProps(bundleDefinition))+'\n\n\n');
const bundleDescriptor = grpc.loadPackageDefinition(bundleDefinition);
//console.log(JSON.stringify(protoDescriptor, replace_data_array, 2));
console.log( util.inspect( getAllProps(bundleDescriptor)));
