
trait Tapir {
  implicit def stringToPath(s: String): EndpointInput[Unit] = ???
  def path[T](name: String): EndpointInput[T] = ???
  def stringBody: EndpointIO[String] = ???
}

trait EndpointInput[T] {
  def and[U, TU](other: EndpointInput[U])(implicit concat: ParamConcat.Aux[T, U, TU]): EndpointInput[TU]
}

sealed trait EndpointOutput[T] {
  def and[J, IJ](other: EndpointOutput[J])(implicit concat: ParamConcat.Aux[T, J, IJ]): EndpointOutput[IJ] = ???
}

sealed trait EndpointIO[T] extends EndpointInput[T] with EndpointOutput[T] {
  def and[J, IJ](other: EndpointIO[J])(implicit concat: ParamConcat.Aux[T, J, IJ]): EndpointIO[IJ] = ???
}

trait PartialServerEndpointWithSecurityOutput[ SECURITY_INPUT, PRINCIPAL, INPUT, ERROR_OUTPUT, SECURITY_OUTPUT, OUTPUT, -R, F[_]] 
    extends EndpointInputsOps[SECURITY_INPUT, INPUT, ERROR_OUTPUT, OUTPUT, R]
    with EndpointOutputsOps[SECURITY_INPUT, INPUT, ERROR_OUTPUT, OUTPUT, R]
    { outer =>
  override type EndpointType[_A, _I, _E, _O, -_R] =
    PartialServerEndpointWithSecurityOutput[_A, PRINCIPAL, _I, _E, SECURITY_OUTPUT, _O, _R, F]
}

trait EndpointInputsOps[A, I, E, O, -R] {
  type EndpointType[_A, _I, _E, _O, -_R]

  def get: EndpointType[A, I, E, O, R] = ???
  def in[J, IJ](i: EndpointInput[J])(implicit concat: ParamConcat.Aux[I, J, IJ]): EndpointType[A, IJ, E, O, R] = ???
}

trait EndpointOutputsOps[A, I, E, O, -R] {
  type EndpointType[_A, _I, _E, _O, -_R]
  def out[P, OP](i: EndpointOutput[P])(implicit ts: ParamConcat.Aux[O, P, OP]): EndpointType[A, I, E, OP, R] = ???
}
