package com.example.demo

import org.springframework.boot.autoconfigure.domain.EntityScan
import org.springframework.context.annotation.Configuration
import org.springframework.data.jpa.repository.config.EnableJpaRepositories
import org.springframework.data.jpa.repository.support.JpaRepositoryFactoryBean
import org.springframework.data.repository.Repository

@Configuration(proxyBeanMethods = false)
@EntityScan(basePackageClasses = [JpaRepositoryFactoryBeanImpl::class])
@EnableJpaRepositories(
    basePackageClasses = [JpaRepositoryFactoryBeanImpl::class],
    repositoryFactoryBeanClass = JpaRepositoryFactoryBeanImpl::class,
)
class DataJpaRepositoryConfiguration

class JpaRepositoryFactoryBeanImpl<R, E, I>(repository: Class<R>) : JpaRepositoryFactoryBean<R, E, I>(repository)
    where R : Repository<E, I>, E : Any, I : Any
