//
//  QueueIt.swift
//  queueitexample
//
//  Created by Fever on 3/12/24.
//

import QueueITLibrary

public typealias QueuePassedInfo = QueueITLibrary.QueuePassedInfo
public typealias QueueDisabledInfo = QueueITLibrary.QueueDisabledInfo

public struct QueueItParams {
    public let isActive: Bool
    public let planId: String

    public init(isActive: Bool, planId: String) {
        self.isActive = isActive
        self.planId = planId
    }
}

public protocol QueueITDelegate:
    QueuePassedDelegate,
    QueueViewWillOpenDelegate,
    QueueDisabledDelegate,
    QueueITUnavailableDelegate,
    QueueITErrorDelegate,
    QueueViewClosedDelegate,
    QueueUserExitedDelegate,
    QueueSessionRestartDelegate,
    QueueUrlChangedDelegate,
    QueueViewDidAppearDelegate {}

public class QueueItWrapper {
    private let engine: QueueITEngine

    public init(uiViewController: UIViewController & QueueITDelegate) {
        let engine = QueueITEngine(
            host: uiViewController,
            customerId: Constants.customerId,
            eventOrAliasId: Constants.eventOrAliasId,
            layoutName: "default",
            language: "en"
        )
        engine.queuePassedDelegate = uiViewController
        engine.queueViewWillOpenDelegate = uiViewController
        engine.queueDisabledDelegate = uiViewController
        engine.queueITUnavailableDelegate = uiViewController
        engine.queueErrorDelegate = uiViewController
        engine.queueViewClosedDelegate = uiViewController
        engine.queueUserExitedDelegate = uiViewController
        engine.queueSessionRestartDelegate = uiViewController
        engine.queueUrlChangedDelegate = uiViewController
        engine.queueViewDidAppearDelegate = uiViewController
        self.engine = engine
    }

    public func run() {
        do {
            try engine.run()
        } catch {
            print("QueueIt engine run error: \(error)")
        }
    }
}

private extension QueueItWrapper {
    enum Constants {
//      Add a proper customerId to connect to
        static let customerId = ""
        static let eventOrAliasId = "waitingroom"
    }
}

