//
//  ViewController.swift
//  queueitexample
//
//  Created by Fever on 3/12/24.
//

import UIKit

final class ChildViewController: UIViewController {
    private var queueItWrapper: QueueItWrapper?

    init() {
        super.init(nibName: nil, bundle: nil)
    }

    @available(*, unavailable)
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }

    override func viewDidLoad() {
        super.viewDidLoad()

        view.backgroundColor = .blue

        queueItWrapper = QueueItWrapper(uiViewController: self)
        queueItWrapper?.run()
    }
}

extension ChildViewController: QueueITDelegate {
    func notifyQueueError(_ errorMessage: String, errorCode: Int) {
        print("QueueIt error for plan: \(errorCode), message: \(errorMessage)")
    }

    func notifyUserExited() {
        print("QueueItUIViewController: notifyUserExited")
    }

    func notifyQueueUrlChanged(_ url: String) {
        print("QueueItUIViewController: notifyQueueUrlChanged url: \(url)")
    }

    func notifyQueueViewDidAppear() {
        print("QueueItUIViewController: notifyQueueViewDidAppear")
    }

    func notifyYourTurn(_ queuePassedInfo: QueuePassedInfo?) {
        print("QueueItUIViewController: notifyYourTurn queuePassedInfo: \(queuePassedInfo.debugDescription)")
        view.backgroundColor = .green
    }

    func notifyQueueViewWillOpen() {
        print("QueueItUIViewController: notifyQueueViewWillOpen")
    }

    func notifyQueueDisabled(_ queueDisabledInfo: QueueDisabledInfo?) {
        print("QueueItUIViewController: notifyQueueDisabled info: \(queueDisabledInfo.debugDescription)")
    }

    func notifyQueueITUnavailable(_ errorMessage: String) {
        print("QueueIt unavailable for plan: -> message: \(errorMessage)")
    }

    func notifyViewClosed() {
        print("QueueItUIViewController: notifyViewClosed")
    }

    func notifySessionRestart() {
        print("QueueItUIViewController: notifySessionRestart")
    }
}

class ViewController: UIViewController {

    override func viewDidLoad() {
        super.viewDidLoad()

        // Set up the view
        self.view.backgroundColor = .red

        // Add a button to navigate to the child view controller
        let navigateButton = UIButton(type: .system)
        navigateButton.setTitle("Go to Child", for: .normal)
        navigateButton.setTitleColor(.white, for: .normal)
        navigateButton.backgroundColor = .blue
        navigateButton.layer.cornerRadius = 8
        navigateButton.translatesAutoresizingMaskIntoConstraints = false

        // Add the button to the view
        self.view.addSubview(navigateButton)

        // Set up constraints for the button
        NSLayoutConstraint.activate([
            navigateButton.centerXAnchor.constraint(equalTo: self.view.centerXAnchor),
            navigateButton.centerYAnchor.constraint(equalTo: self.view.centerYAnchor),
            navigateButton.widthAnchor.constraint(equalToConstant: 150),
            navigateButton.heightAnchor.constraint(equalToConstant: 50)
        ])

        // Add the action for the button
        navigateButton.addTarget(self, action: #selector(navigateToChild), for: .touchUpInside)
    }

    @objc func navigateToChild() {
        // Create the child view controller
        let child = ChildViewController()

        // Push it onto the navigation stack
        guard let navigationController = self.navigationController else {
            assertionFailure("Navigation controller should be present!")
            return
        }
        navigationController.pushViewController(child, animated: true)
    }
}
