/*
 * Copyright 2014 JBoss Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.spring.data.jpa.bugs;

import static org.junit.jupiter.api.Assertions.assertEquals;

import java.util.List;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.FilterType;
import org.springframework.context.annotation.Import;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.TestPropertySource;

@SpringBootTest
@TestPropertySource(locations = "classpath:application-test.yml")
@ActiveProfiles("test")
@Import({ OurServiceTest.TestConfiguration.class })
class OurServiceTest {

    @Autowired
    private OurService ourService;
    @Autowired
    private OurEntityRepository ourEntityRepository;

    // Add your tests, using standard JUnit 5.
    @Test
    void test() {
        OurEntity entity1 = new OurEntity();
        entity1.setName("test1");
        entity1.setCommonName("commonName");
        entity1.setOurStatus(OurStatus.STATUS_1);
        ourEntityRepository.save(entity1);


        OurEntity entity2 = new OurEntity();
        entity2.setName("test2");
        entity2.setCommonName("commonName");
        entity2.setOurStatus(OurStatus.STATUS_1);
        ourEntityRepository.save(entity2);

        OurEntity entity3 = new OurEntity();
        entity3.setName("test3");
        entity3.setCommonName("commonName");
        entity3.setOurStatus(OurStatus.STATUS_2);
        ourEntityRepository.save(entity3);

        List<OurEntityPercentageStatus> result = ourService.createPercentageQuery();
        assertEquals(66, result.get(0).getPercentageOut().intValue());
    }

    @ComponentScan(basePackages = "org.spring.data.jpa.bugs",
        excludeFilters = @ComponentScan.Filter(type = FilterType.REGEX, pattern = {
            ".*TestConfiguration"
        }))
    @SpringBootApplication
    static class TestConfiguration {}
}
